<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRoomRate StructType
 * @subpackage Structs
 */
class HotelRoomRate extends AbstractStructBase
{
    /**
     * The RoomNight
     * @var string
     */
    public $RoomNight;
    /**
     * The RoomRate
     * @var float
     */
    public $RoomRate;
    /**
     * Constructor method for HotelRoomRate
     * @uses HotelRoomRate::setRoomNight()
     * @uses HotelRoomRate::setRoomRate()
     * @param string $roomNight
     * @param float $roomRate
     */
    public function __construct($roomNight = null, $roomRate = null)
    {
        $this
            ->setRoomNight($roomNight)
            ->setRoomRate($roomRate);
    }
    /**
     * Get RoomNight value
     * @return string|null
     */
    public function getRoomNight()
    {
        return $this->RoomNight;
    }
    /**
     * Set RoomNight value
     * @param string $roomNight
     * @return \StructType\HotelRoomRate
     */
    public function setRoomNight($roomNight = null)
    {
        // validation for constraint: string
        if (!is_null($roomNight) && !is_string($roomNight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNight, true), gettype($roomNight)), __LINE__);
        }
        $this->RoomNight = $roomNight;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return float|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param float $roomRate
     * @return \StructType\HotelRoomRate
     */
    public function setRoomRate($roomRate = null)
    {
        // validation for constraint: float
        if (!is_null($roomRate) && !(is_float($roomRate) || is_numeric($roomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roomRate, true), gettype($roomRate)), __LINE__);
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRoomRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
