<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRequest StructType
 * @subpackage Structs
 */
class HotelRequest extends CvObject
{
    /**
     * The TravelSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelSurveyDetail[]
     */
    public $TravelSurveyDetail;
    /**
     * The HotelRoomRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelRoomRate[]
     */
    public $HotelRoomRate;
    /**
     * The RequesterId
     * @var string
     */
    public $RequesterId;
    /**
     * The RequesterType
     * @var string
     */
    public $RequesterType;
    /**
     * The RequesterFirstName
     * @var string
     */
    public $RequesterFirstName;
    /**
     * The RequesterLastName
     * @var string
     */
    public $RequesterLastName;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The RoomName
     * @var string
     */
    public $RoomName;
    /**
     * The RoomCode
     * @var string
     */
    public $RoomCode;
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The RoommateRequest
     * @var string
     */
    public $RoommateRequest;
    /**
     * The SpecialNeeds
     * @var string
     */
    public $SpecialNeeds;
    /**
     * The RewardsCode
     * @var string
     */
    public $RewardsCode;
    /**
     * The CheckinDate
     * @var string
     */
    public $CheckinDate;
    /**
     * The CheckoutDate
     * @var string
     */
    public $CheckoutDate;
    /**
     * The Smoking
     * @var bool
     */
    public $Smoking;
    /**
     * The Cancelled
     * @var bool
     */
    public $Cancelled;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The Handicap
     * @var bool
     */
    public $Handicap;
    /**
     * The ShareRoom
     * @var bool
     */
    public $ShareRoom;
    /**
     * The RoommateLeader
     * @var bool
     */
    public $RoommateLeader;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The TotalAmount
     * @var float
     */
    public $TotalAmount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The RoomCharge
     * @var bool
     */
    public $RoomCharge;
    /**
     * The RoomTaxBillingInstructions
     * @var string
     */
    public $RoomTaxBillingInstructions;
    /**
     * The IncidentalBillingInstructions
     * @var string
     */
    public $IncidentalBillingInstructions;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The HotelLastModifiedDate
     * @var string
     */
    public $HotelLastModifiedDate;
    /**
     * The PlannerMemo
     * @var string
     */
    public $PlannerMemo;
    /**
     * The EarliestShoulderDate
     * @var string
     */
    public $EarliestShoulderDate;
    /**
     * The LatestShoulderDate
     * @var string
     */
    public $LatestShoulderDate;
    /**
     * The RoomTaxBillingExceptions
     * @var string
     */
    public $RoomTaxBillingExceptions;
    /**
     * The IncidentalBillingExceptions
     * @var string
     */
    public $IncidentalBillingExceptions;
    /**
     * The HotelAddress1
     * @var string
     */
    public $HotelAddress1;
    /**
     * The HotelAddress2
     * @var string
     */
    public $HotelAddress2;
    /**
     * The HotelAddress3
     * @var string
     */
    public $HotelAddress3;
    /**
     * The HotelCity
     * @var string
     */
    public $HotelCity;
    /**
     * The HotelState
     * @var string
     */
    public $HotelState;
    /**
     * The HotelPostalCode
     * @var string
     */
    public $HotelPostalCode;
    /**
     * The HotelCountry
     * @var string
     */
    public $HotelCountry;
    /**
     * Constructor method for HotelRequest
     * @uses HotelRequest::setTravelSurveyDetail()
     * @uses HotelRequest::setHotelRoomRate()
     * @uses HotelRequest::setRequesterId()
     * @uses HotelRequest::setRequesterType()
     * @uses HotelRequest::setRequesterFirstName()
     * @uses HotelRequest::setRequesterLastName()
     * @uses HotelRequest::setHotelName()
     * @uses HotelRequest::setHotelCode()
     * @uses HotelRequest::setRoomName()
     * @uses HotelRequest::setRoomCode()
     * @uses HotelRequest::setQuantity()
     * @uses HotelRequest::setRoommateRequest()
     * @uses HotelRequest::setSpecialNeeds()
     * @uses HotelRequest::setRewardsCode()
     * @uses HotelRequest::setCheckinDate()
     * @uses HotelRequest::setCheckoutDate()
     * @uses HotelRequest::setSmoking()
     * @uses HotelRequest::setCancelled()
     * @uses HotelRequest::setStatus()
     * @uses HotelRequest::setConfirmationNumber()
     * @uses HotelRequest::setHandicap()
     * @uses HotelRequest::setShareRoom()
     * @uses HotelRequest::setRoommateLeader()
     * @uses HotelRequest::setGender()
     * @uses HotelRequest::setTotalAmount()
     * @uses HotelRequest::setCurrencyCode()
     * @uses HotelRequest::setRoomCharge()
     * @uses HotelRequest::setRoomTaxBillingInstructions()
     * @uses HotelRequest::setIncidentalBillingInstructions()
     * @uses HotelRequest::setLastModifiedBy()
     * @uses HotelRequest::setHotelLastModifiedDate()
     * @uses HotelRequest::setPlannerMemo()
     * @uses HotelRequest::setEarliestShoulderDate()
     * @uses HotelRequest::setLatestShoulderDate()
     * @uses HotelRequest::setRoomTaxBillingExceptions()
     * @uses HotelRequest::setIncidentalBillingExceptions()
     * @uses HotelRequest::setHotelAddress1()
     * @uses HotelRequest::setHotelAddress2()
     * @uses HotelRequest::setHotelAddress3()
     * @uses HotelRequest::setHotelCity()
     * @uses HotelRequest::setHotelState()
     * @uses HotelRequest::setHotelPostalCode()
     * @uses HotelRequest::setHotelCountry()
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @param \StructType\HotelRoomRate[] $hotelRoomRate
     * @param string $requesterId
     * @param string $requesterType
     * @param string $requesterFirstName
     * @param string $requesterLastName
     * @param string $hotelName
     * @param string $hotelCode
     * @param string $roomName
     * @param string $roomCode
     * @param string $quantity
     * @param string $roommateRequest
     * @param string $specialNeeds
     * @param string $rewardsCode
     * @param string $checkinDate
     * @param string $checkoutDate
     * @param bool $smoking
     * @param bool $cancelled
     * @param string $status
     * @param string $confirmationNumber
     * @param bool $handicap
     * @param bool $shareRoom
     * @param bool $roommateLeader
     * @param string $gender
     * @param float $totalAmount
     * @param string $currencyCode
     * @param bool $roomCharge
     * @param string $roomTaxBillingInstructions
     * @param string $incidentalBillingInstructions
     * @param string $lastModifiedBy
     * @param string $hotelLastModifiedDate
     * @param string $plannerMemo
     * @param string $earliestShoulderDate
     * @param string $latestShoulderDate
     * @param string $roomTaxBillingExceptions
     * @param string $incidentalBillingExceptions
     * @param string $hotelAddress1
     * @param string $hotelAddress2
     * @param string $hotelAddress3
     * @param string $hotelCity
     * @param string $hotelState
     * @param string $hotelPostalCode
     * @param string $hotelCountry
     */
    public function __construct(array $travelSurveyDetail = array(), array $hotelRoomRate = array(), $requesterId = null, $requesterType = null, $requesterFirstName = null, $requesterLastName = null, $hotelName = null, $hotelCode = null, $roomName = null, $roomCode = null, $quantity = null, $roommateRequest = null, $specialNeeds = null, $rewardsCode = null, $checkinDate = null, $checkoutDate = null, $smoking = null, $cancelled = null, $status = null, $confirmationNumber = null, $handicap = null, $shareRoom = null, $roommateLeader = null, $gender = null, $totalAmount = null, $currencyCode = null, $roomCharge = null, $roomTaxBillingInstructions = null, $incidentalBillingInstructions = null, $lastModifiedBy = null, $hotelLastModifiedDate = null, $plannerMemo = null, $earliestShoulderDate = null, $latestShoulderDate = null, $roomTaxBillingExceptions = null, $incidentalBillingExceptions = null, $hotelAddress1 = null, $hotelAddress2 = null, $hotelAddress3 = null, $hotelCity = null, $hotelState = null, $hotelPostalCode = null, $hotelCountry = null)
    {
        $this
            ->setTravelSurveyDetail($travelSurveyDetail)
            ->setHotelRoomRate($hotelRoomRate)
            ->setRequesterId($requesterId)
            ->setRequesterType($requesterType)
            ->setRequesterFirstName($requesterFirstName)
            ->setRequesterLastName($requesterLastName)
            ->setHotelName($hotelName)
            ->setHotelCode($hotelCode)
            ->setRoomName($roomName)
            ->setRoomCode($roomCode)
            ->setQuantity($quantity)
            ->setRoommateRequest($roommateRequest)
            ->setSpecialNeeds($specialNeeds)
            ->setRewardsCode($rewardsCode)
            ->setCheckinDate($checkinDate)
            ->setCheckoutDate($checkoutDate)
            ->setSmoking($smoking)
            ->setCancelled($cancelled)
            ->setStatus($status)
            ->setConfirmationNumber($confirmationNumber)
            ->setHandicap($handicap)
            ->setShareRoom($shareRoom)
            ->setRoommateLeader($roommateLeader)
            ->setGender($gender)
            ->setTotalAmount($totalAmount)
            ->setCurrencyCode($currencyCode)
            ->setRoomCharge($roomCharge)
            ->setRoomTaxBillingInstructions($roomTaxBillingInstructions)
            ->setIncidentalBillingInstructions($incidentalBillingInstructions)
            ->setLastModifiedBy($lastModifiedBy)
            ->setHotelLastModifiedDate($hotelLastModifiedDate)
            ->setPlannerMemo($plannerMemo)
            ->setEarliestShoulderDate($earliestShoulderDate)
            ->setLatestShoulderDate($latestShoulderDate)
            ->setRoomTaxBillingExceptions($roomTaxBillingExceptions)
            ->setIncidentalBillingExceptions($incidentalBillingExceptions)
            ->setHotelAddress1($hotelAddress1)
            ->setHotelAddress2($hotelAddress2)
            ->setHotelAddress3($hotelAddress3)
            ->setHotelCity($hotelCity)
            ->setHotelState($hotelState)
            ->setHotelPostalCode($hotelPostalCode)
            ->setHotelCountry($hotelCountry);
    }
    /**
     * Get TravelSurveyDetail value
     * @return \StructType\TravelSurveyDetail[]|null
     */
    public function getTravelSurveyDetail()
    {
        return $this->TravelSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelRequestTravelSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$hotelRequestTravelSurveyDetailItem instanceof \StructType\TravelSurveyDetail) {
                $invalidValues[] = is_object($hotelRequestTravelSurveyDetailItem) ? get_class($hotelRequestTravelSurveyDetailItem) : sprintf('%s(%s)', gettype($hotelRequestTravelSurveyDetailItem), var_export($hotelRequestTravelSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @return \StructType\HotelRequest
     */
    public function setTravelSurveyDetail(array $travelSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($travelSurveyDetailArrayErrorMessage = self::validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail($travelSurveyDetail))) {
            throw new \InvalidArgumentException($travelSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->TravelSurveyDetail = $travelSurveyDetail;
        return $this;
    }
    /**
     * Add item to TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail $item
     * @return \StructType\HotelRequest
     */
    public function addToTravelSurveyDetail(\StructType\TravelSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get HotelRoomRate value
     * @return \StructType\HotelRoomRate[]|null
     */
    public function getHotelRoomRate()
    {
        return $this->HotelRoomRate;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRoomRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRoomRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRoomRateForArrayConstraintsFromSetHotelRoomRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelRequestHotelRoomRateItem) {
            // validation for constraint: itemType
            if (!$hotelRequestHotelRoomRateItem instanceof \StructType\HotelRoomRate) {
                $invalidValues[] = is_object($hotelRequestHotelRoomRateItem) ? get_class($hotelRequestHotelRoomRateItem) : sprintf('%s(%s)', gettype($hotelRequestHotelRoomRateItem), var_export($hotelRequestHotelRoomRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRoomRate property can only contain items of type \StructType\HotelRoomRate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRoomRate value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRoomRate[] $hotelRoomRate
     * @return \StructType\HotelRequest
     */
    public function setHotelRoomRate(array $hotelRoomRate = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRoomRateArrayErrorMessage = self::validateHotelRoomRateForArrayConstraintsFromSetHotelRoomRate($hotelRoomRate))) {
            throw new \InvalidArgumentException($hotelRoomRateArrayErrorMessage, __LINE__);
        }
        $this->HotelRoomRate = $hotelRoomRate;
        return $this;
    }
    /**
     * Add item to HotelRoomRate value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelRoomRate $item
     * @return \StructType\HotelRequest
     */
    public function addToHotelRoomRate(\StructType\HotelRoomRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelRoomRate) {
            throw new \InvalidArgumentException(sprintf('The HotelRoomRate property can only contain items of type \StructType\HotelRoomRate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRoomRate[] = $item;
        return $this;
    }
    /**
     * Get RequesterId value
     * @return string|null
     */
    public function getRequesterId()
    {
        return $this->RequesterId;
    }
    /**
     * Set RequesterId value
     * @param string $requesterId
     * @return \StructType\HotelRequest
     */
    public function setRequesterId($requesterId = null)
    {
        // validation for constraint: string
        if (!is_null($requesterId) && !is_string($requesterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterId, true), gettype($requesterId)), __LINE__);
        }
        $this->RequesterId = $requesterId;
        return $this;
    }
    /**
     * Get RequesterType value
     * @return string|null
     */
    public function getRequesterType()
    {
        return $this->RequesterType;
    }
    /**
     * Set RequesterType value
     * @param string $requesterType
     * @return \StructType\HotelRequest
     */
    public function setRequesterType($requesterType = null)
    {
        // validation for constraint: string
        if (!is_null($requesterType) && !is_string($requesterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterType, true), gettype($requesterType)), __LINE__);
        }
        $this->RequesterType = $requesterType;
        return $this;
    }
    /**
     * Get RequesterFirstName value
     * @return string|null
     */
    public function getRequesterFirstName()
    {
        return $this->RequesterFirstName;
    }
    /**
     * Set RequesterFirstName value
     * @param string $requesterFirstName
     * @return \StructType\HotelRequest
     */
    public function setRequesterFirstName($requesterFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterFirstName) && !is_string($requesterFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterFirstName, true), gettype($requesterFirstName)), __LINE__);
        }
        $this->RequesterFirstName = $requesterFirstName;
        return $this;
    }
    /**
     * Get RequesterLastName value
     * @return string|null
     */
    public function getRequesterLastName()
    {
        return $this->RequesterLastName;
    }
    /**
     * Set RequesterLastName value
     * @param string $requesterLastName
     * @return \StructType\HotelRequest
     */
    public function setRequesterLastName($requesterLastName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterLastName) && !is_string($requesterLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterLastName, true), gettype($requesterLastName)), __LINE__);
        }
        $this->RequesterLastName = $requesterLastName;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelRequest
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelRequest
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get RoomName value
     * @return string|null
     */
    public function getRoomName()
    {
        return $this->RoomName;
    }
    /**
     * Set RoomName value
     * @param string $roomName
     * @return \StructType\HotelRequest
     */
    public function setRoomName($roomName = null)
    {
        // validation for constraint: string
        if (!is_null($roomName) && !is_string($roomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomName, true), gettype($roomName)), __LINE__);
        }
        $this->RoomName = $roomName;
        return $this;
    }
    /**
     * Get RoomCode value
     * @return string|null
     */
    public function getRoomCode()
    {
        return $this->RoomCode;
    }
    /**
     * Set RoomCode value
     * @param string $roomCode
     * @return \StructType\HotelRequest
     */
    public function setRoomCode($roomCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomCode) && !is_string($roomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomCode, true), gettype($roomCode)), __LINE__);
        }
        $this->RoomCode = $roomCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\HotelRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RoommateRequest value
     * @return string|null
     */
    public function getRoommateRequest()
    {
        return $this->RoommateRequest;
    }
    /**
     * Set RoommateRequest value
     * @param string $roommateRequest
     * @return \StructType\HotelRequest
     */
    public function setRoommateRequest($roommateRequest = null)
    {
        // validation for constraint: string
        if (!is_null($roommateRequest) && !is_string($roommateRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roommateRequest, true), gettype($roommateRequest)), __LINE__);
        }
        $this->RoommateRequest = $roommateRequest;
        return $this;
    }
    /**
     * Get SpecialNeeds value
     * @return string|null
     */
    public function getSpecialNeeds()
    {
        return $this->SpecialNeeds;
    }
    /**
     * Set SpecialNeeds value
     * @param string $specialNeeds
     * @return \StructType\HotelRequest
     */
    public function setSpecialNeeds($specialNeeds = null)
    {
        // validation for constraint: string
        if (!is_null($specialNeeds) && !is_string($specialNeeds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialNeeds, true), gettype($specialNeeds)), __LINE__);
        }
        $this->SpecialNeeds = $specialNeeds;
        return $this;
    }
    /**
     * Get RewardsCode value
     * @return string|null
     */
    public function getRewardsCode()
    {
        return $this->RewardsCode;
    }
    /**
     * Set RewardsCode value
     * @param string $rewardsCode
     * @return \StructType\HotelRequest
     */
    public function setRewardsCode($rewardsCode = null)
    {
        // validation for constraint: string
        if (!is_null($rewardsCode) && !is_string($rewardsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardsCode, true), gettype($rewardsCode)), __LINE__);
        }
        $this->RewardsCode = $rewardsCode;
        return $this;
    }
    /**
     * Get CheckinDate value
     * @return string|null
     */
    public function getCheckinDate()
    {
        return $this->CheckinDate;
    }
    /**
     * Set CheckinDate value
     * @param string $checkinDate
     * @return \StructType\HotelRequest
     */
    public function setCheckinDate($checkinDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkinDate) && !is_string($checkinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkinDate, true), gettype($checkinDate)), __LINE__);
        }
        $this->CheckinDate = $checkinDate;
        return $this;
    }
    /**
     * Get CheckoutDate value
     * @return string|null
     */
    public function getCheckoutDate()
    {
        return $this->CheckoutDate;
    }
    /**
     * Set CheckoutDate value
     * @param string $checkoutDate
     * @return \StructType\HotelRequest
     */
    public function setCheckoutDate($checkoutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkoutDate) && !is_string($checkoutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkoutDate, true), gettype($checkoutDate)), __LINE__);
        }
        $this->CheckoutDate = $checkoutDate;
        return $this;
    }
    /**
     * Get Smoking value
     * @return bool|null
     */
    public function getSmoking()
    {
        return $this->Smoking;
    }
    /**
     * Set Smoking value
     * @param bool $smoking
     * @return \StructType\HotelRequest
     */
    public function setSmoking($smoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($smoking) && !is_bool($smoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smoking, true), gettype($smoking)), __LINE__);
        }
        $this->Smoking = $smoking;
        return $this;
    }
    /**
     * Get Cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->Cancelled;
    }
    /**
     * Set Cancelled value
     * @param bool $cancelled
     * @return \StructType\HotelRequest
     */
    public function setCancelled($cancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelled) && !is_bool($cancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelled, true), gettype($cancelled)), __LINE__);
        }
        $this->Cancelled = $cancelled;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\HotelRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\HotelRequest
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get Handicap value
     * @return bool|null
     */
    public function getHandicap()
    {
        return $this->Handicap;
    }
    /**
     * Set Handicap value
     * @param bool $handicap
     * @return \StructType\HotelRequest
     */
    public function setHandicap($handicap = null)
    {
        // validation for constraint: boolean
        if (!is_null($handicap) && !is_bool($handicap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($handicap, true), gettype($handicap)), __LINE__);
        }
        $this->Handicap = $handicap;
        return $this;
    }
    /**
     * Get ShareRoom value
     * @return bool|null
     */
    public function getShareRoom()
    {
        return $this->ShareRoom;
    }
    /**
     * Set ShareRoom value
     * @param bool $shareRoom
     * @return \StructType\HotelRequest
     */
    public function setShareRoom($shareRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($shareRoom) && !is_bool($shareRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shareRoom, true), gettype($shareRoom)), __LINE__);
        }
        $this->ShareRoom = $shareRoom;
        return $this;
    }
    /**
     * Get RoommateLeader value
     * @return bool|null
     */
    public function getRoommateLeader()
    {
        return $this->RoommateLeader;
    }
    /**
     * Set RoommateLeader value
     * @param bool $roommateLeader
     * @return \StructType\HotelRequest
     */
    public function setRoommateLeader($roommateLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($roommateLeader) && !is_bool($roommateLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roommateLeader, true), gettype($roommateLeader)), __LINE__);
        }
        $this->RoommateLeader = $roommateLeader;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\HotelRequest
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\HotelRequest
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\HotelRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get RoomCharge value
     * @return bool|null
     */
    public function getRoomCharge()
    {
        return $this->RoomCharge;
    }
    /**
     * Set RoomCharge value
     * @param bool $roomCharge
     * @return \StructType\HotelRequest
     */
    public function setRoomCharge($roomCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomCharge) && !is_bool($roomCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomCharge, true), gettype($roomCharge)), __LINE__);
        }
        $this->RoomCharge = $roomCharge;
        return $this;
    }
    /**
     * Get RoomTaxBillingInstructions value
     * @return string|null
     */
    public function getRoomTaxBillingInstructions()
    {
        return $this->RoomTaxBillingInstructions;
    }
    /**
     * Set RoomTaxBillingInstructions value
     * @param string $roomTaxBillingInstructions
     * @return \StructType\HotelRequest
     */
    public function setRoomTaxBillingInstructions($roomTaxBillingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($roomTaxBillingInstructions) && !is_string($roomTaxBillingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTaxBillingInstructions, true), gettype($roomTaxBillingInstructions)), __LINE__);
        }
        $this->RoomTaxBillingInstructions = $roomTaxBillingInstructions;
        return $this;
    }
    /**
     * Get IncidentalBillingInstructions value
     * @return string|null
     */
    public function getIncidentalBillingInstructions()
    {
        return $this->IncidentalBillingInstructions;
    }
    /**
     * Set IncidentalBillingInstructions value
     * @param string $incidentalBillingInstructions
     * @return \StructType\HotelRequest
     */
    public function setIncidentalBillingInstructions($incidentalBillingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($incidentalBillingInstructions) && !is_string($incidentalBillingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incidentalBillingInstructions, true), gettype($incidentalBillingInstructions)), __LINE__);
        }
        $this->IncidentalBillingInstructions = $incidentalBillingInstructions;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\HotelRequest
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get HotelLastModifiedDate value
     * @return string|null
     */
    public function getHotelLastModifiedDate()
    {
        return $this->HotelLastModifiedDate;
    }
    /**
     * Set HotelLastModifiedDate value
     * @param string $hotelLastModifiedDate
     * @return \StructType\HotelRequest
     */
    public function setHotelLastModifiedDate($hotelLastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($hotelLastModifiedDate) && !is_string($hotelLastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelLastModifiedDate, true), gettype($hotelLastModifiedDate)), __LINE__);
        }
        $this->HotelLastModifiedDate = $hotelLastModifiedDate;
        return $this;
    }
    /**
     * Get PlannerMemo value
     * @return string|null
     */
    public function getPlannerMemo()
    {
        return $this->PlannerMemo;
    }
    /**
     * Set PlannerMemo value
     * @param string $plannerMemo
     * @return \StructType\HotelRequest
     */
    public function setPlannerMemo($plannerMemo = null)
    {
        // validation for constraint: string
        if (!is_null($plannerMemo) && !is_string($plannerMemo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerMemo, true), gettype($plannerMemo)), __LINE__);
        }
        $this->PlannerMemo = $plannerMemo;
        return $this;
    }
    /**
     * Get EarliestShoulderDate value
     * @return string|null
     */
    public function getEarliestShoulderDate()
    {
        return $this->EarliestShoulderDate;
    }
    /**
     * Set EarliestShoulderDate value
     * @param string $earliestShoulderDate
     * @return \StructType\HotelRequest
     */
    public function setEarliestShoulderDate($earliestShoulderDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestShoulderDate) && !is_string($earliestShoulderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestShoulderDate, true), gettype($earliestShoulderDate)), __LINE__);
        }
        $this->EarliestShoulderDate = $earliestShoulderDate;
        return $this;
    }
    /**
     * Get LatestShoulderDate value
     * @return string|null
     */
    public function getLatestShoulderDate()
    {
        return $this->LatestShoulderDate;
    }
    /**
     * Set LatestShoulderDate value
     * @param string $latestShoulderDate
     * @return \StructType\HotelRequest
     */
    public function setLatestShoulderDate($latestShoulderDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestShoulderDate) && !is_string($latestShoulderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestShoulderDate, true), gettype($latestShoulderDate)), __LINE__);
        }
        $this->LatestShoulderDate = $latestShoulderDate;
        return $this;
    }
    /**
     * Get RoomTaxBillingExceptions value
     * @return string|null
     */
    public function getRoomTaxBillingExceptions()
    {
        return $this->RoomTaxBillingExceptions;
    }
    /**
     * Set RoomTaxBillingExceptions value
     * @param string $roomTaxBillingExceptions
     * @return \StructType\HotelRequest
     */
    public function setRoomTaxBillingExceptions($roomTaxBillingExceptions = null)
    {
        // validation for constraint: string
        if (!is_null($roomTaxBillingExceptions) && !is_string($roomTaxBillingExceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTaxBillingExceptions, true), gettype($roomTaxBillingExceptions)), __LINE__);
        }
        $this->RoomTaxBillingExceptions = $roomTaxBillingExceptions;
        return $this;
    }
    /**
     * Get IncidentalBillingExceptions value
     * @return string|null
     */
    public function getIncidentalBillingExceptions()
    {
        return $this->IncidentalBillingExceptions;
    }
    /**
     * Set IncidentalBillingExceptions value
     * @param string $incidentalBillingExceptions
     * @return \StructType\HotelRequest
     */
    public function setIncidentalBillingExceptions($incidentalBillingExceptions = null)
    {
        // validation for constraint: string
        if (!is_null($incidentalBillingExceptions) && !is_string($incidentalBillingExceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incidentalBillingExceptions, true), gettype($incidentalBillingExceptions)), __LINE__);
        }
        $this->IncidentalBillingExceptions = $incidentalBillingExceptions;
        return $this;
    }
    /**
     * Get HotelAddress1 value
     * @return string|null
     */
    public function getHotelAddress1()
    {
        return $this->HotelAddress1;
    }
    /**
     * Set HotelAddress1 value
     * @param string $hotelAddress1
     * @return \StructType\HotelRequest
     */
    public function setHotelAddress1($hotelAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($hotelAddress1) && !is_string($hotelAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelAddress1, true), gettype($hotelAddress1)), __LINE__);
        }
        $this->HotelAddress1 = $hotelAddress1;
        return $this;
    }
    /**
     * Get HotelAddress2 value
     * @return string|null
     */
    public function getHotelAddress2()
    {
        return $this->HotelAddress2;
    }
    /**
     * Set HotelAddress2 value
     * @param string $hotelAddress2
     * @return \StructType\HotelRequest
     */
    public function setHotelAddress2($hotelAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($hotelAddress2) && !is_string($hotelAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelAddress2, true), gettype($hotelAddress2)), __LINE__);
        }
        $this->HotelAddress2 = $hotelAddress2;
        return $this;
    }
    /**
     * Get HotelAddress3 value
     * @return string|null
     */
    public function getHotelAddress3()
    {
        return $this->HotelAddress3;
    }
    /**
     * Set HotelAddress3 value
     * @param string $hotelAddress3
     * @return \StructType\HotelRequest
     */
    public function setHotelAddress3($hotelAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($hotelAddress3) && !is_string($hotelAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelAddress3, true), gettype($hotelAddress3)), __LINE__);
        }
        $this->HotelAddress3 = $hotelAddress3;
        return $this;
    }
    /**
     * Get HotelCity value
     * @return string|null
     */
    public function getHotelCity()
    {
        return $this->HotelCity;
    }
    /**
     * Set HotelCity value
     * @param string $hotelCity
     * @return \StructType\HotelRequest
     */
    public function setHotelCity($hotelCity = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCity) && !is_string($hotelCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCity, true), gettype($hotelCity)), __LINE__);
        }
        $this->HotelCity = $hotelCity;
        return $this;
    }
    /**
     * Get HotelState value
     * @return string|null
     */
    public function getHotelState()
    {
        return $this->HotelState;
    }
    /**
     * Set HotelState value
     * @param string $hotelState
     * @return \StructType\HotelRequest
     */
    public function setHotelState($hotelState = null)
    {
        // validation for constraint: string
        if (!is_null($hotelState) && !is_string($hotelState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelState, true), gettype($hotelState)), __LINE__);
        }
        $this->HotelState = $hotelState;
        return $this;
    }
    /**
     * Get HotelPostalCode value
     * @return string|null
     */
    public function getHotelPostalCode()
    {
        return $this->HotelPostalCode;
    }
    /**
     * Set HotelPostalCode value
     * @param string $hotelPostalCode
     * @return \StructType\HotelRequest
     */
    public function setHotelPostalCode($hotelPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelPostalCode) && !is_string($hotelPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelPostalCode, true), gettype($hotelPostalCode)), __LINE__);
        }
        $this->HotelPostalCode = $hotelPostalCode;
        return $this;
    }
    /**
     * Get HotelCountry value
     * @return string|null
     */
    public function getHotelCountry()
    {
        return $this->HotelCountry;
    }
    /**
     * Set HotelCountry value
     * @param string $hotelCountry
     * @return \StructType\HotelRequest
     */
    public function setHotelCountry($hotelCountry = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCountry) && !is_string($hotelCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCountry, true), gettype($hotelCountry)), __LINE__);
        }
        $this->HotelCountry = $hotelCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
