<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestDetail StructType
 * @subpackage Structs
 */
class GuestDetail extends AbstractStructBase
{
    /**
     * The EventSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventSurveyDetail[]
     */
    public $EventSurveyDetail;
    /**
     * The GuestId
     * @var string
     */
    public $GuestId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The Address1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * @var string
     */
    public $Address3;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The RegistrationType
     * @var string
     */
    public $RegistrationType;
    /**
     * The RegistrationTypeCode
     * @var string
     */
    public $RegistrationTypeCode;
    /**
     * The Participant
     * @var bool
     */
    public $Participant;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * Constructor method for GuestDetail
     * @uses GuestDetail::setEventSurveyDetail()
     * @uses GuestDetail::setGuestId()
     * @uses GuestDetail::setFirstName()
     * @uses GuestDetail::setMiddleName()
     * @uses GuestDetail::setLastName()
     * @uses GuestDetail::setCompany()
     * @uses GuestDetail::setTitle()
     * @uses GuestDetail::setPhone()
     * @uses GuestDetail::setEmailAddress()
     * @uses GuestDetail::setAddress1()
     * @uses GuestDetail::setAddress2()
     * @uses GuestDetail::setAddress3()
     * @uses GuestDetail::setCity()
     * @uses GuestDetail::setState()
     * @uses GuestDetail::setPostalCode()
     * @uses GuestDetail::setCountry()
     * @uses GuestDetail::setRegistrationType()
     * @uses GuestDetail::setRegistrationTypeCode()
     * @uses GuestDetail::setParticipant()
     * @uses GuestDetail::setCountryCode()
     * @uses GuestDetail::setStateCode()
     * @uses GuestDetail::setConfirmationNumber()
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @param string $guestId
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $company
     * @param string $title
     * @param string $phone
     * @param string $emailAddress
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string $country
     * @param string $registrationType
     * @param string $registrationTypeCode
     * @param bool $participant
     * @param string $countryCode
     * @param string $stateCode
     * @param string $confirmationNumber
     */
    public function __construct(array $eventSurveyDetail = array(), $guestId = null, $firstName = null, $middleName = null, $lastName = null, $company = null, $title = null, $phone = null, $emailAddress = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $state = null, $postalCode = null, $country = null, $registrationType = null, $registrationTypeCode = null, $participant = null, $countryCode = null, $stateCode = null, $confirmationNumber = null)
    {
        $this
            ->setEventSurveyDetail($eventSurveyDetail)
            ->setGuestId($guestId)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setTitle($title)
            ->setPhone($phone)
            ->setEmailAddress($emailAddress)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setRegistrationType($registrationType)
            ->setRegistrationTypeCode($registrationTypeCode)
            ->setParticipant($participant)
            ->setCountryCode($countryCode)
            ->setStateCode($stateCode)
            ->setConfirmationNumber($confirmationNumber);
    }
    /**
     * Get EventSurveyDetail value
     * @return \StructType\EventSurveyDetail[]|null
     */
    public function getEventSurveyDetail()
    {
        return $this->EventSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEventSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestDetailEventSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$guestDetailEventSurveyDetailItem instanceof \StructType\EventSurveyDetail) {
                $invalidValues[] = is_object($guestDetailEventSurveyDetailItem) ? get_class($guestDetailEventSurveyDetailItem) : sprintf('%s(%s)', gettype($guestDetailEventSurveyDetailItem), var_export($guestDetailEventSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail[] $eventSurveyDetail
     * @return \StructType\GuestDetail
     */
    public function setEventSurveyDetail(array $eventSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($eventSurveyDetailArrayErrorMessage = self::validateEventSurveyDetailForArrayConstraintsFromSetEventSurveyDetail($eventSurveyDetail))) {
            throw new \InvalidArgumentException($eventSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->EventSurveyDetail = $eventSurveyDetail;
        return $this;
    }
    /**
     * Add item to EventSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventSurveyDetail $item
     * @return \StructType\GuestDetail
     */
    public function addToEventSurveyDetail(\StructType\EventSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The EventSurveyDetail property can only contain items of type \StructType\EventSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get GuestId value
     * @return string|null
     */
    public function getGuestId()
    {
        return $this->GuestId;
    }
    /**
     * Set GuestId value
     * @param string $guestId
     * @return \StructType\GuestDetail
     */
    public function setGuestId($guestId = null)
    {
        // validation for constraint: string
        if (!is_null($guestId) && !is_string($guestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestId, true), gettype($guestId)), __LINE__);
        }
        $this->GuestId = $guestId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\GuestDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\GuestDetail
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\GuestDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\GuestDetail
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\GuestDetail
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\GuestDetail
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\GuestDetail
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\GuestDetail
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\GuestDetail
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\GuestDetail
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\GuestDetail
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\GuestDetail
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\GuestDetail
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\GuestDetail
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get RegistrationType value
     * @return string|null
     */
    public function getRegistrationType()
    {
        return $this->RegistrationType;
    }
    /**
     * Set RegistrationType value
     * @param string $registrationType
     * @return \StructType\GuestDetail
     */
    public function setRegistrationType($registrationType = null)
    {
        // validation for constraint: string
        if (!is_null($registrationType) && !is_string($registrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationType, true), gettype($registrationType)), __LINE__);
        }
        $this->RegistrationType = $registrationType;
        return $this;
    }
    /**
     * Get RegistrationTypeCode value
     * @return string|null
     */
    public function getRegistrationTypeCode()
    {
        return $this->RegistrationTypeCode;
    }
    /**
     * Set RegistrationTypeCode value
     * @param string $registrationTypeCode
     * @return \StructType\GuestDetail
     */
    public function setRegistrationTypeCode($registrationTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($registrationTypeCode) && !is_string($registrationTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationTypeCode, true), gettype($registrationTypeCode)), __LINE__);
        }
        $this->RegistrationTypeCode = $registrationTypeCode;
        return $this;
    }
    /**
     * Get Participant value
     * @return bool|null
     */
    public function getParticipant()
    {
        return $this->Participant;
    }
    /**
     * Set Participant value
     * @param bool $participant
     * @return \StructType\GuestDetail
     */
    public function setParticipant($participant = null)
    {
        // validation for constraint: boolean
        if (!is_null($participant) && !is_bool($participant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participant, true), gettype($participant)), __LINE__);
        }
        $this->Participant = $participant;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\GuestDetail
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\GuestDetail
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\GuestDetail
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
