<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest StructType
 * @subpackage Structs
 */
class Guest extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The EventID
     * @var string
     */
    public $EventID;
    /**
     * The ContactID
     * @var string
     */
    public $ContactID;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The GuestConfirmationNumber
     * @var string
     */
    public $GuestConfirmationNumber;
    /**
     * The RegistrationID
     * @var string
     */
    public $RegistrationID;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The Nickname
     * @var string
     */
    public $Nickname;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The SocialSecurityNumber
     * @var string
     */
    public $SocialSecurityNumber;
    /**
     * The NationalIdentificationNumber
     * @var string
     */
    public $NationalIdentificationNumber;
    /**
     * The PassportNumber
     * @var string
     */
    public $PassportNumber;
    /**
     * The PassportCountry
     * @var string
     */
    public $PassportCountry;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Designation
     * @var string
     */
    public $Designation;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * The Mobile
     * @var string
     */
    public $Mobile;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The CCEmail
     * @var string
     */
    public $CCEmail;
    /**
     * The Address1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * @var string
     */
    public $Address3;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The RegistrationDate
     * @var string
     */
    public $RegistrationDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The LastOptOutDate
     * @var string
     */
    public $LastOptOutDate;
    /**
     * The OptedOut
     * @var bool
     */
    public $OptedOut;
    /**
     * The Participant
     * @var bool
     */
    public $Participant;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The IsObfuscated
     * @var bool
     */
    public $IsObfuscated;
    /**
     * Constructor method for Guest
     * @uses Guest::setCustomFieldDetail()
     * @uses Guest::setEventID()
     * @uses Guest::setContactID()
     * @uses Guest::setEventTitle()
     * @uses Guest::setEventCode()
     * @uses Guest::setGuestConfirmationNumber()
     * @uses Guest::setRegistrationID()
     * @uses Guest::setFirstName()
     * @uses Guest::setMiddleName()
     * @uses Guest::setLastName()
     * @uses Guest::setNickname()
     * @uses Guest::setGender()
     * @uses Guest::setDateOfBirth()
     * @uses Guest::setSocialSecurityNumber()
     * @uses Guest::setNationalIdentificationNumber()
     * @uses Guest::setPassportNumber()
     * @uses Guest::setPassportCountry()
     * @uses Guest::setCompany()
     * @uses Guest::setDesignation()
     * @uses Guest::setTitle()
     * @uses Guest::setPhone()
     * @uses Guest::setMobile()
     * @uses Guest::setEmail()
     * @uses Guest::setCCEmail()
     * @uses Guest::setAddress1()
     * @uses Guest::setAddress2()
     * @uses Guest::setAddress3()
     * @uses Guest::setCity()
     * @uses Guest::setState()
     * @uses Guest::setRegistrationDate()
     * @uses Guest::setCreatedDate()
     * @uses Guest::setCreatedBy()
     * @uses Guest::setLastModifiedDate()
     * @uses Guest::setLastModifiedBy()
     * @uses Guest::setLastOptOutDate()
     * @uses Guest::setOptedOut()
     * @uses Guest::setParticipant()
     * @uses Guest::setStatus()
     * @uses Guest::setCountry()
     * @uses Guest::setCountryCode()
     * @uses Guest::setPostalCode()
     * @uses Guest::setIsObfuscated()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $eventID
     * @param string $contactID
     * @param string $eventTitle
     * @param string $eventCode
     * @param string $guestConfirmationNumber
     * @param string $registrationID
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $nickname
     * @param string $gender
     * @param string $dateOfBirth
     * @param string $socialSecurityNumber
     * @param string $nationalIdentificationNumber
     * @param string $passportNumber
     * @param string $passportCountry
     * @param string $company
     * @param string $designation
     * @param string $title
     * @param string $phone
     * @param string $mobile
     * @param string $email
     * @param string $cCEmail
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $registrationDate
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     * @param string $lastOptOutDate
     * @param bool $optedOut
     * @param bool $participant
     * @param string $status
     * @param string $country
     * @param string $countryCode
     * @param string $postalCode
     * @param bool $isObfuscated
     */
    public function __construct(array $customFieldDetail = array(), $eventID = null, $contactID = null, $eventTitle = null, $eventCode = null, $guestConfirmationNumber = null, $registrationID = null, $firstName = null, $middleName = null, $lastName = null, $nickname = null, $gender = null, $dateOfBirth = null, $socialSecurityNumber = null, $nationalIdentificationNumber = null, $passportNumber = null, $passportCountry = null, $company = null, $designation = null, $title = null, $phone = null, $mobile = null, $email = null, $cCEmail = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $state = null, $registrationDate = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null, $lastOptOutDate = null, $optedOut = null, $participant = null, $status = null, $country = null, $countryCode = null, $postalCode = null, $isObfuscated = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setEventID($eventID)
            ->setContactID($contactID)
            ->setEventTitle($eventTitle)
            ->setEventCode($eventCode)
            ->setGuestConfirmationNumber($guestConfirmationNumber)
            ->setRegistrationID($registrationID)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setNickname($nickname)
            ->setGender($gender)
            ->setDateOfBirth($dateOfBirth)
            ->setSocialSecurityNumber($socialSecurityNumber)
            ->setNationalIdentificationNumber($nationalIdentificationNumber)
            ->setPassportNumber($passportNumber)
            ->setPassportCountry($passportCountry)
            ->setCompany($company)
            ->setDesignation($designation)
            ->setTitle($title)
            ->setPhone($phone)
            ->setMobile($mobile)
            ->setEmail($email)
            ->setCCEmail($cCEmail)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setState($state)
            ->setRegistrationDate($registrationDate)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastOptOutDate($lastOptOutDate)
            ->setOptedOut($optedOut)
            ->setParticipant($participant)
            ->setStatus($status)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setPostalCode($postalCode)
            ->setIsObfuscated($isObfuscated);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$guestCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($guestCustomFieldDetailItem) ? get_class($guestCustomFieldDetailItem) : sprintf('%s(%s)', gettype($guestCustomFieldDetailItem), var_export($guestCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Guest
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Guest
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get EventID value
     * @return string|null
     */
    public function getEventID()
    {
        return $this->EventID;
    }
    /**
     * Set EventID value
     * @param string $eventID
     * @return \StructType\Guest
     */
    public function setEventID($eventID = null)
    {
        // validation for constraint: string
        if (!is_null($eventID) && !is_string($eventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventID, true), gettype($eventID)), __LINE__);
        }
        $this->EventID = $eventID;
        return $this;
    }
    /**
     * Get ContactID value
     * @return string|null
     */
    public function getContactID()
    {
        return $this->ContactID;
    }
    /**
     * Set ContactID value
     * @param string $contactID
     * @return \StructType\Guest
     */
    public function setContactID($contactID = null)
    {
        // validation for constraint: string
        if (!is_null($contactID) && !is_string($contactID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactID, true), gettype($contactID)), __LINE__);
        }
        $this->ContactID = $contactID;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Guest
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Guest
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get GuestConfirmationNumber value
     * @return string|null
     */
    public function getGuestConfirmationNumber()
    {
        return $this->GuestConfirmationNumber;
    }
    /**
     * Set GuestConfirmationNumber value
     * @param string $guestConfirmationNumber
     * @return \StructType\Guest
     */
    public function setGuestConfirmationNumber($guestConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guestConfirmationNumber) && !is_string($guestConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestConfirmationNumber, true), gettype($guestConfirmationNumber)), __LINE__);
        }
        $this->GuestConfirmationNumber = $guestConfirmationNumber;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return string|null
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param string $registrationID
     * @return \StructType\Guest
     */
    public function setRegistrationID($registrationID = null)
    {
        // validation for constraint: string
        if (!is_null($registrationID) && !is_string($registrationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationID, true), gettype($registrationID)), __LINE__);
        }
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Guest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\Guest
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Guest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Nickname value
     * @return string|null
     */
    public function getNickname()
    {
        return $this->Nickname;
    }
    /**
     * Set Nickname value
     * @param string $nickname
     * @return \StructType\Guest
     */
    public function setNickname($nickname = null)
    {
        // validation for constraint: string
        if (!is_null($nickname) && !is_string($nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickname, true), gettype($nickname)), __LINE__);
        }
        $this->Nickname = $nickname;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\Guest
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Guest
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get SocialSecurityNumber value
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->SocialSecurityNumber;
    }
    /**
     * Set SocialSecurityNumber value
     * @param string $socialSecurityNumber
     * @return \StructType\Guest
     */
    public function setSocialSecurityNumber($socialSecurityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialSecurityNumber) && !is_string($socialSecurityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialSecurityNumber, true), gettype($socialSecurityNumber)), __LINE__);
        }
        $this->SocialSecurityNumber = $socialSecurityNumber;
        return $this;
    }
    /**
     * Get NationalIdentificationNumber value
     * @return string|null
     */
    public function getNationalIdentificationNumber()
    {
        return $this->NationalIdentificationNumber;
    }
    /**
     * Set NationalIdentificationNumber value
     * @param string $nationalIdentificationNumber
     * @return \StructType\Guest
     */
    public function setNationalIdentificationNumber($nationalIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIdentificationNumber) && !is_string($nationalIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalIdentificationNumber, true), gettype($nationalIdentificationNumber)), __LINE__);
        }
        $this->NationalIdentificationNumber = $nationalIdentificationNumber;
        return $this;
    }
    /**
     * Get PassportNumber value
     * @return string|null
     */
    public function getPassportNumber()
    {
        return $this->PassportNumber;
    }
    /**
     * Set PassportNumber value
     * @param string $passportNumber
     * @return \StructType\Guest
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportNumber, true), gettype($passportNumber)), __LINE__);
        }
        $this->PassportNumber = $passportNumber;
        return $this;
    }
    /**
     * Get PassportCountry value
     * @return string|null
     */
    public function getPassportCountry()
    {
        return $this->PassportCountry;
    }
    /**
     * Set PassportCountry value
     * @param string $passportCountry
     * @return \StructType\Guest
     */
    public function setPassportCountry($passportCountry = null)
    {
        // validation for constraint: string
        if (!is_null($passportCountry) && !is_string($passportCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportCountry, true), gettype($passportCountry)), __LINE__);
        }
        $this->PassportCountry = $passportCountry;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Guest
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Designation value
     * @return string|null
     */
    public function getDesignation()
    {
        return $this->Designation;
    }
    /**
     * Set Designation value
     * @param string $designation
     * @return \StructType\Guest
     */
    public function setDesignation($designation = null)
    {
        // validation for constraint: string
        if (!is_null($designation) && !is_string($designation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designation, true), gettype($designation)), __LINE__);
        }
        $this->Designation = $designation;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Guest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Guest
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\Guest
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Guest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get CCEmail value
     * @return string|null
     */
    public function getCCEmail()
    {
        return $this->CCEmail;
    }
    /**
     * Set CCEmail value
     * @param string $cCEmail
     * @return \StructType\Guest
     */
    public function setCCEmail($cCEmail = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmail) && !is_string($cCEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCEmail, true), gettype($cCEmail)), __LINE__);
        }
        $this->CCEmail = $cCEmail;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\Guest
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\Guest
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\Guest
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Guest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Guest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \StructType\Guest
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Guest
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\Guest
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Guest
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\Guest
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get LastOptOutDate value
     * @return string|null
     */
    public function getLastOptOutDate()
    {
        return $this->LastOptOutDate;
    }
    /**
     * Set LastOptOutDate value
     * @param string $lastOptOutDate
     * @return \StructType\Guest
     */
    public function setLastOptOutDate($lastOptOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastOptOutDate) && !is_string($lastOptOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOptOutDate, true), gettype($lastOptOutDate)), __LINE__);
        }
        $this->LastOptOutDate = $lastOptOutDate;
        return $this;
    }
    /**
     * Get OptedOut value
     * @return bool|null
     */
    public function getOptedOut()
    {
        return $this->OptedOut;
    }
    /**
     * Set OptedOut value
     * @param bool $optedOut
     * @return \StructType\Guest
     */
    public function setOptedOut($optedOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($optedOut) && !is_bool($optedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optedOut, true), gettype($optedOut)), __LINE__);
        }
        $this->OptedOut = $optedOut;
        return $this;
    }
    /**
     * Get Participant value
     * @return bool|null
     */
    public function getParticipant()
    {
        return $this->Participant;
    }
    /**
     * Set Participant value
     * @param bool $participant
     * @return \StructType\Guest
     */
    public function setParticipant($participant = null)
    {
        // validation for constraint: boolean
        if (!is_null($participant) && !is_bool($participant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($participant, true), gettype($participant)), __LINE__);
        }
        $this->Participant = $participant;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\Guest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Guest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Guest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Guest
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get IsObfuscated value
     * @return bool|null
     */
    public function getIsObfuscated()
    {
        return $this->IsObfuscated;
    }
    /**
     * Set IsObfuscated value
     * @param bool $isObfuscated
     * @return \StructType\Guest
     */
    public function setIsObfuscated($isObfuscated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObfuscated) && !is_bool($isObfuscated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObfuscated, true), gettype($isObfuscated)), __LINE__);
        }
        $this->IsObfuscated = $isObfuscated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
