<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLCodes StructType
 * @subpackage Structs
 */
class GLCodes extends AbstractStructBase
{
    /**
     * The GLID
     * @var string
     */
    public $GLID;
    /**
     * The GLName
     * @var string
     */
    public $GLName;
    /**
     * The GLCode
     * @var string
     */
    public $GLCode;
    /**
     * The GLDescription
     * @var string
     */
    public $GLDescription;
    /**
     * The GLCodeAllocationPercent
     * @var int
     */
    public $GLCodeAllocationPercent;
    /**
     * Constructor method for GLCodes
     * @uses GLCodes::setGLID()
     * @uses GLCodes::setGLName()
     * @uses GLCodes::setGLCode()
     * @uses GLCodes::setGLDescription()
     * @uses GLCodes::setGLCodeAllocationPercent()
     * @param string $gLID
     * @param string $gLName
     * @param string $gLCode
     * @param string $gLDescription
     * @param int $gLCodeAllocationPercent
     */
    public function __construct($gLID = null, $gLName = null, $gLCode = null, $gLDescription = null, $gLCodeAllocationPercent = null)
    {
        $this
            ->setGLID($gLID)
            ->setGLName($gLName)
            ->setGLCode($gLCode)
            ->setGLDescription($gLDescription)
            ->setGLCodeAllocationPercent($gLCodeAllocationPercent);
    }
    /**
     * Get GLID value
     * @return string|null
     */
    public function getGLID()
    {
        return $this->GLID;
    }
    /**
     * Set GLID value
     * @param string $gLID
     * @return \StructType\GLCodes
     */
    public function setGLID($gLID = null)
    {
        // validation for constraint: string
        if (!is_null($gLID) && !is_string($gLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLID, true), gettype($gLID)), __LINE__);
        }
        $this->GLID = $gLID;
        return $this;
    }
    /**
     * Get GLName value
     * @return string|null
     */
    public function getGLName()
    {
        return $this->GLName;
    }
    /**
     * Set GLName value
     * @param string $gLName
     * @return \StructType\GLCodes
     */
    public function setGLName($gLName = null)
    {
        // validation for constraint: string
        if (!is_null($gLName) && !is_string($gLName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLName, true), gettype($gLName)), __LINE__);
        }
        $this->GLName = $gLName;
        return $this;
    }
    /**
     * Get GLCode value
     * @return string|null
     */
    public function getGLCode()
    {
        return $this->GLCode;
    }
    /**
     * Set GLCode value
     * @param string $gLCode
     * @return \StructType\GLCodes
     */
    public function setGLCode($gLCode = null)
    {
        // validation for constraint: string
        if (!is_null($gLCode) && !is_string($gLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLCode, true), gettype($gLCode)), __LINE__);
        }
        $this->GLCode = $gLCode;
        return $this;
    }
    /**
     * Get GLDescription value
     * @return string|null
     */
    public function getGLDescription()
    {
        return $this->GLDescription;
    }
    /**
     * Set GLDescription value
     * @param string $gLDescription
     * @return \StructType\GLCodes
     */
    public function setGLDescription($gLDescription = null)
    {
        // validation for constraint: string
        if (!is_null($gLDescription) && !is_string($gLDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLDescription, true), gettype($gLDescription)), __LINE__);
        }
        $this->GLDescription = $gLDescription;
        return $this;
    }
    /**
     * Get GLCodeAllocationPercent value
     * @return int|null
     */
    public function getGLCodeAllocationPercent()
    {
        return $this->GLCodeAllocationPercent;
    }
    /**
     * Set GLCodeAllocationPercent value
     * @param int $gLCodeAllocationPercent
     * @return \StructType\GLCodes
     */
    public function setGLCodeAllocationPercent($gLCodeAllocationPercent = null)
    {
        // validation for constraint: int
        if (!is_null($gLCodeAllocationPercent) && !(is_int($gLCodeAllocationPercent) || ctype_digit($gLCodeAllocationPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gLCodeAllocationPercent, true), gettype($gLCodeAllocationPercent)), __LINE__);
        }
        $this->GLCodeAllocationPercent = $gLCodeAllocationPercent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GLCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
