<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightDetail StructType
 * @subpackage Structs
 */
class FlightDetail extends AbstractStructBase
{
    /**
     * The Airline
     * @var string
     */
    public $Airline;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The Origin
     * @var string
     */
    public $Origin;
    /**
     * The OriginCode
     * @var string
     */
    public $OriginCode;
    /**
     * The Destination
     * @var string
     */
    public $Destination;
    /**
     * The DestinationCode
     * @var string
     */
    public $DestinationCode;
    /**
     * The Departing
     * @var string
     */
    public $Departing;
    /**
     * The Arriving
     * @var string
     */
    public $Arriving;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The TicketClass
     * @var string
     */
    public $TicketClass;
    /**
     * The FlightConfirmationNumber
     * @var string
     */
    public $FlightConfirmationNumber;
    /**
     * The FlightGDSRecordLocator
     * @var string
     */
    public $FlightGDSRecordLocator;
    /**
     * Constructor method for FlightDetail
     * @uses FlightDetail::setAirline()
     * @uses FlightDetail::setFlightNumber()
     * @uses FlightDetail::setOrigin()
     * @uses FlightDetail::setOriginCode()
     * @uses FlightDetail::setDestination()
     * @uses FlightDetail::setDestinationCode()
     * @uses FlightDetail::setDeparting()
     * @uses FlightDetail::setArriving()
     * @uses FlightDetail::setSeatNumber()
     * @uses FlightDetail::setTicketClass()
     * @uses FlightDetail::setFlightConfirmationNumber()
     * @uses FlightDetail::setFlightGDSRecordLocator()
     * @param string $airline
     * @param string $flightNumber
     * @param string $origin
     * @param string $originCode
     * @param string $destination
     * @param string $destinationCode
     * @param string $departing
     * @param string $arriving
     * @param string $seatNumber
     * @param string $ticketClass
     * @param string $flightConfirmationNumber
     * @param string $flightGDSRecordLocator
     */
    public function __construct($airline = null, $flightNumber = null, $origin = null, $originCode = null, $destination = null, $destinationCode = null, $departing = null, $arriving = null, $seatNumber = null, $ticketClass = null, $flightConfirmationNumber = null, $flightGDSRecordLocator = null)
    {
        $this
            ->setAirline($airline)
            ->setFlightNumber($flightNumber)
            ->setOrigin($origin)
            ->setOriginCode($originCode)
            ->setDestination($destination)
            ->setDestinationCode($destinationCode)
            ->setDeparting($departing)
            ->setArriving($arriving)
            ->setSeatNumber($seatNumber)
            ->setTicketClass($ticketClass)
            ->setFlightConfirmationNumber($flightConfirmationNumber)
            ->setFlightGDSRecordLocator($flightGDSRecordLocator);
    }
    /**
     * Get Airline value
     * @return string|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param string $airline
     * @return \StructType\FlightDetail
     */
    public function setAirline($airline = null)
    {
        // validation for constraint: string
        if (!is_null($airline) && !is_string($airline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airline, true), gettype($airline)), __LINE__);
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\FlightDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get OriginCode value
     * @return string|null
     */
    public function getOriginCode()
    {
        return $this->OriginCode;
    }
    /**
     * Set OriginCode value
     * @param string $originCode
     * @return \StructType\FlightDetail
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCode, true), gettype($originCode)), __LINE__);
        }
        $this->OriginCode = $originCode;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\FlightDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DestinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }
    /**
     * Set DestinationCode value
     * @param string $destinationCode
     * @return \StructType\FlightDetail
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCode, true), gettype($destinationCode)), __LINE__);
        }
        $this->DestinationCode = $destinationCode;
        return $this;
    }
    /**
     * Get Departing value
     * @return string|null
     */
    public function getDeparting()
    {
        return $this->Departing;
    }
    /**
     * Set Departing value
     * @param string $departing
     * @return \StructType\FlightDetail
     */
    public function setDeparting($departing = null)
    {
        // validation for constraint: string
        if (!is_null($departing) && !is_string($departing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departing, true), gettype($departing)), __LINE__);
        }
        $this->Departing = $departing;
        return $this;
    }
    /**
     * Get Arriving value
     * @return string|null
     */
    public function getArriving()
    {
        return $this->Arriving;
    }
    /**
     * Set Arriving value
     * @param string $arriving
     * @return \StructType\FlightDetail
     */
    public function setArriving($arriving = null)
    {
        // validation for constraint: string
        if (!is_null($arriving) && !is_string($arriving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arriving, true), gettype($arriving)), __LINE__);
        }
        $this->Arriving = $arriving;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\FlightDetail
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get TicketClass value
     * @return string|null
     */
    public function getTicketClass()
    {
        return $this->TicketClass;
    }
    /**
     * Set TicketClass value
     * @param string $ticketClass
     * @return \StructType\FlightDetail
     */
    public function setTicketClass($ticketClass = null)
    {
        // validation for constraint: string
        if (!is_null($ticketClass) && !is_string($ticketClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketClass, true), gettype($ticketClass)), __LINE__);
        }
        $this->TicketClass = $ticketClass;
        return $this;
    }
    /**
     * Get FlightConfirmationNumber value
     * @return string|null
     */
    public function getFlightConfirmationNumber()
    {
        return $this->FlightConfirmationNumber;
    }
    /**
     * Set FlightConfirmationNumber value
     * @param string $flightConfirmationNumber
     * @return \StructType\FlightDetail
     */
    public function setFlightConfirmationNumber($flightConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightConfirmationNumber) && !is_string($flightConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightConfirmationNumber, true), gettype($flightConfirmationNumber)), __LINE__);
        }
        $this->FlightConfirmationNumber = $flightConfirmationNumber;
        return $this;
    }
    /**
     * Get FlightGDSRecordLocator value
     * @return string|null
     */
    public function getFlightGDSRecordLocator()
    {
        return $this->FlightGDSRecordLocator;
    }
    /**
     * Set FlightGDSRecordLocator value
     * @param string $flightGDSRecordLocator
     * @return \StructType\FlightDetail
     */
    public function setFlightGDSRecordLocator($flightGDSRecordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($flightGDSRecordLocator) && !is_string($flightGDSRecordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightGDSRecordLocator, true), gettype($flightGDSRecordLocator)), __LINE__);
        }
        $this->FlightGDSRecordLocator = $flightGDSRecordLocator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
