<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Filter StructType
 * @subpackage Structs
 */
class Filter extends AbstractStructBase
{
    /**
     * The Operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Operator;
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Field;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The ValueArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ValueArray;
    /**
     * Constructor method for Filter
     * @uses Filter::setOperator()
     * @uses Filter::setField()
     * @uses Filter::setValue()
     * @uses Filter::setValueArray()
     * @param string $operator
     * @param string $field
     * @param string $value
     * @param \ArrayType\ArrayOfString $valueArray
     */
    public function __construct($operator = null, $field = null, $value = null, \ArrayType\ArrayOfString $valueArray = null)
    {
        $this
            ->setOperator($operator)
            ->setField($field)
            ->setValue($value)
            ->setValueArray($valueArray);
    }
    /**
     * Get Operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \EnumType\CvSearchOperatorType::valueIsValid()
     * @uses \EnumType\CvSearchOperatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\Filter
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvSearchOperatorType::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvSearchOperatorType', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\CvSearchOperatorType::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get Field value
     * @return string|null
     */
    public function getField()
    {
        return $this->Field;
    }
    /**
     * Set Field value
     * @param string $field
     * @return \StructType\Filter
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field, true), gettype($field)), __LINE__);
        }
        $this->Field = $field;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Filter
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ValueArray value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getValueArray()
    {
        return $this->ValueArray;
    }
    /**
     * Set ValueArray value
     * @param \ArrayType\ArrayOfString $valueArray
     * @return \StructType\Filter
     */
    public function setValueArray(\ArrayType\ArrayOfString $valueArray = null)
    {
        $this->ValueArray = $valueArray;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Filter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
