<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Field StructType
 * @subpackage Structs
 */
class Field extends AbstractStructBase
{
    /**
     * The LookUpDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LookUpDetail[]
     */
    public $LookUpDetail;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The ObjectLocation
     * @var string
     */
    public $ObjectLocation;
    /**
     * The DataType
     * @var string
     */
    public $DataType;
    /**
     * The MaxLength
     * @var int
     */
    public $MaxLength;
    /**
     * The Searchable
     * @var bool
     */
    public $Searchable;
    /**
     * The Required
     * @var bool
     */
    public $Required;
    /**
     * The ReadOnly
     * @var bool
     */
    public $ReadOnly;
    /**
     * The DefaultValue
     * @var string
     */
    public $DefaultValue;
    /**
     * The DefaultSearchValue
     * @var string
     */
    public $DefaultSearchValue;
    /**
     * Constructor method for Field
     * @uses Field::setLookUpDetail()
     * @uses Field::setName()
     * @uses Field::setObjectLocation()
     * @uses Field::setDataType()
     * @uses Field::setMaxLength()
     * @uses Field::setSearchable()
     * @uses Field::setRequired()
     * @uses Field::setReadOnly()
     * @uses Field::setDefaultValue()
     * @uses Field::setDefaultSearchValue()
     * @param \StructType\LookUpDetail[] $lookUpDetail
     * @param string $name
     * @param string $objectLocation
     * @param string $dataType
     * @param int $maxLength
     * @param bool $searchable
     * @param bool $required
     * @param bool $readOnly
     * @param string $defaultValue
     * @param string $defaultSearchValue
     */
    public function __construct(array $lookUpDetail = array(), $name = null, $objectLocation = null, $dataType = null, $maxLength = null, $searchable = null, $required = null, $readOnly = null, $defaultValue = null, $defaultSearchValue = null)
    {
        $this
            ->setLookUpDetail($lookUpDetail)
            ->setName($name)
            ->setObjectLocation($objectLocation)
            ->setDataType($dataType)
            ->setMaxLength($maxLength)
            ->setSearchable($searchable)
            ->setRequired($required)
            ->setReadOnly($readOnly)
            ->setDefaultValue($defaultValue)
            ->setDefaultSearchValue($defaultSearchValue);
    }
    /**
     * Get LookUpDetail value
     * @return \StructType\LookUpDetail[]|null
     */
    public function getLookUpDetail()
    {
        return $this->LookUpDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setLookUpDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLookUpDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLookUpDetailForArrayConstraintsFromSetLookUpDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fieldLookUpDetailItem) {
            // validation for constraint: itemType
            if (!$fieldLookUpDetailItem instanceof \StructType\LookUpDetail) {
                $invalidValues[] = is_object($fieldLookUpDetailItem) ? get_class($fieldLookUpDetailItem) : sprintf('%s(%s)', gettype($fieldLookUpDetailItem), var_export($fieldLookUpDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LookUpDetail property can only contain items of type \StructType\LookUpDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LookUpDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\LookUpDetail[] $lookUpDetail
     * @return \StructType\Field
     */
    public function setLookUpDetail(array $lookUpDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($lookUpDetailArrayErrorMessage = self::validateLookUpDetailForArrayConstraintsFromSetLookUpDetail($lookUpDetail))) {
            throw new \InvalidArgumentException($lookUpDetailArrayErrorMessage, __LINE__);
        }
        $this->LookUpDetail = $lookUpDetail;
        return $this;
    }
    /**
     * Add item to LookUpDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\LookUpDetail $item
     * @return \StructType\Field
     */
    public function addToLookUpDetail(\StructType\LookUpDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LookUpDetail) {
            throw new \InvalidArgumentException(sprintf('The LookUpDetail property can only contain items of type \StructType\LookUpDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LookUpDetail[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Field
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ObjectLocation value
     * @return string|null
     */
    public function getObjectLocation()
    {
        return $this->ObjectLocation;
    }
    /**
     * Set ObjectLocation value
     * @param string $objectLocation
     * @return \StructType\Field
     */
    public function setObjectLocation($objectLocation = null)
    {
        // validation for constraint: string
        if (!is_null($objectLocation) && !is_string($objectLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectLocation, true), gettype($objectLocation)), __LINE__);
        }
        $this->ObjectLocation = $objectLocation;
        return $this;
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param string $dataType
     * @return \StructType\Field
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataType, true), gettype($dataType)), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get MaxLength value
     * @return int|null
     */
    public function getMaxLength()
    {
        return $this->MaxLength;
    }
    /**
     * Set MaxLength value
     * @param int $maxLength
     * @return \StructType\Field
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: int
        if (!is_null($maxLength) && !(is_int($maxLength) || ctype_digit($maxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLength, true), gettype($maxLength)), __LINE__);
        }
        $this->MaxLength = $maxLength;
        return $this;
    }
    /**
     * Get Searchable value
     * @return bool|null
     */
    public function getSearchable()
    {
        return $this->Searchable;
    }
    /**
     * Set Searchable value
     * @param bool $searchable
     * @return \StructType\Field
     */
    public function setSearchable($searchable = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchable) && !is_bool($searchable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchable, true), gettype($searchable)), __LINE__);
        }
        $this->Searchable = $searchable;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Field
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get ReadOnly value
     * @return bool|null
     */
    public function getReadOnly()
    {
        return $this->ReadOnly;
    }
    /**
     * Set ReadOnly value
     * @param bool $readOnly
     * @return \StructType\Field
     */
    public function setReadOnly($readOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($readOnly) && !is_bool($readOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($readOnly, true), gettype($readOnly)), __LINE__);
        }
        $this->ReadOnly = $readOnly;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return string|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param string $defaultValue
     * @return \StructType\Field
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultValue) && !is_string($defaultValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get DefaultSearchValue value
     * @return string|null
     */
    public function getDefaultSearchValue()
    {
        return $this->DefaultSearchValue;
    }
    /**
     * Set DefaultSearchValue value
     * @param string $defaultSearchValue
     * @return \StructType\Field
     */
    public function setDefaultSearchValue($defaultSearchValue = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSearchValue) && !is_string($defaultSearchValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSearchValue, true), gettype($defaultSearchValue)), __LINE__);
        }
        $this->DefaultSearchValue = $defaultSearchValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Field
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
