<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fees StructType
 * @subpackage Structs
 */
class Fees extends AbstractStructBase
{
    /**
     * The GLCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GLCodes[]
     */
    public $GLCodes;
    /**
     * The FeeID
     * @var string
     */
    public $FeeID;
    /**
     * The FeeName
     * @var string
     */
    public $FeeName;
    /**
     * The FeeAmount
     * @var float
     */
    public $FeeAmount;
    /**
     * The ProductID
     * @var string
     */
    public $ProductID;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The GLName
     * @var string
     */
    public $GLName;
    /**
     * The GLDescription
     * @var string
     */
    public $GLDescription;
    /**
     * The GLCode
     * @var string
     */
    public $GLCode;
    /**
     * The GLID
     * @var string
     */
    public $GLID;
    /**
     * Constructor method for Fees
     * @uses Fees::setGLCodes()
     * @uses Fees::setFeeID()
     * @uses Fees::setFeeName()
     * @uses Fees::setFeeAmount()
     * @uses Fees::setProductID()
     * @uses Fees::setProductName()
     * @uses Fees::setActive()
     * @uses Fees::setCreatedDate()
     * @uses Fees::setLastModifiedDate()
     * @uses Fees::setGLName()
     * @uses Fees::setGLDescription()
     * @uses Fees::setGLCode()
     * @uses Fees::setGLID()
     * @param \StructType\GLCodes[] $gLCodes
     * @param string $feeID
     * @param string $feeName
     * @param float $feeAmount
     * @param string $productID
     * @param string $productName
     * @param bool $active
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $gLName
     * @param string $gLDescription
     * @param string $gLCode
     * @param string $gLID
     */
    public function __construct(array $gLCodes = array(), $feeID = null, $feeName = null, $feeAmount = null, $productID = null, $productName = null, $active = null, $createdDate = null, $lastModifiedDate = null, $gLName = null, $gLDescription = null, $gLCode = null, $gLID = null)
    {
        $this
            ->setGLCodes($gLCodes)
            ->setFeeID($feeID)
            ->setFeeName($feeName)
            ->setFeeAmount($feeAmount)
            ->setProductID($productID)
            ->setProductName($productName)
            ->setActive($active)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setGLName($gLName)
            ->setGLDescription($gLDescription)
            ->setGLCode($gLCode)
            ->setGLID($gLID);
    }
    /**
     * Get GLCodes value
     * @return \StructType\GLCodes[]|null
     */
    public function getGLCodes()
    {
        return $this->GLCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setGLCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGLCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGLCodesForArrayConstraintsFromSetGLCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feesGLCodesItem) {
            // validation for constraint: itemType
            if (!$feesGLCodesItem instanceof \StructType\GLCodes) {
                $invalidValues[] = is_object($feesGLCodesItem) ? get_class($feesGLCodesItem) : sprintf('%s(%s)', gettype($feesGLCodesItem), var_export($feesGLCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GLCodes property can only contain items of type \StructType\GLCodes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GLCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GLCodes[] $gLCodes
     * @return \StructType\Fees
     */
    public function setGLCodes(array $gLCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($gLCodesArrayErrorMessage = self::validateGLCodesForArrayConstraintsFromSetGLCodes($gLCodes))) {
            throw new \InvalidArgumentException($gLCodesArrayErrorMessage, __LINE__);
        }
        $this->GLCodes = $gLCodes;
        return $this;
    }
    /**
     * Add item to GLCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GLCodes $item
     * @return \StructType\Fees
     */
    public function addToGLCodes(\StructType\GLCodes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GLCodes) {
            throw new \InvalidArgumentException(sprintf('The GLCodes property can only contain items of type \StructType\GLCodes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GLCodes[] = $item;
        return $this;
    }
    /**
     * Get FeeID value
     * @return string|null
     */
    public function getFeeID()
    {
        return $this->FeeID;
    }
    /**
     * Set FeeID value
     * @param string $feeID
     * @return \StructType\Fees
     */
    public function setFeeID($feeID = null)
    {
        // validation for constraint: string
        if (!is_null($feeID) && !is_string($feeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeID, true), gettype($feeID)), __LINE__);
        }
        $this->FeeID = $feeID;
        return $this;
    }
    /**
     * Get FeeName value
     * @return string|null
     */
    public function getFeeName()
    {
        return $this->FeeName;
    }
    /**
     * Set FeeName value
     * @param string $feeName
     * @return \StructType\Fees
     */
    public function setFeeName($feeName = null)
    {
        // validation for constraint: string
        if (!is_null($feeName) && !is_string($feeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeName, true), gettype($feeName)), __LINE__);
        }
        $this->FeeName = $feeName;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return float|null
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param float $feeAmount
     * @return \StructType\Fees
     */
    public function setFeeAmount($feeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($feeAmount) && !(is_float($feeAmount) || is_numeric($feeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feeAmount, true), gettype($feeAmount)), __LINE__);
        }
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \StructType\Fees
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\Fees
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Fees
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Fees
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Fees
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get GLName value
     * @return string|null
     */
    public function getGLName()
    {
        return $this->GLName;
    }
    /**
     * Set GLName value
     * @param string $gLName
     * @return \StructType\Fees
     */
    public function setGLName($gLName = null)
    {
        // validation for constraint: string
        if (!is_null($gLName) && !is_string($gLName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLName, true), gettype($gLName)), __LINE__);
        }
        $this->GLName = $gLName;
        return $this;
    }
    /**
     * Get GLDescription value
     * @return string|null
     */
    public function getGLDescription()
    {
        return $this->GLDescription;
    }
    /**
     * Set GLDescription value
     * @param string $gLDescription
     * @return \StructType\Fees
     */
    public function setGLDescription($gLDescription = null)
    {
        // validation for constraint: string
        if (!is_null($gLDescription) && !is_string($gLDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLDescription, true), gettype($gLDescription)), __LINE__);
        }
        $this->GLDescription = $gLDescription;
        return $this;
    }
    /**
     * Get GLCode value
     * @return string|null
     */
    public function getGLCode()
    {
        return $this->GLCode;
    }
    /**
     * Set GLCode value
     * @param string $gLCode
     * @return \StructType\Fees
     */
    public function setGLCode($gLCode = null)
    {
        // validation for constraint: string
        if (!is_null($gLCode) && !is_string($gLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLCode, true), gettype($gLCode)), __LINE__);
        }
        $this->GLCode = $gLCode;
        return $this;
    }
    /**
     * Get GLID value
     * @return string|null
     */
    public function getGLID()
    {
        return $this->GLID;
    }
    /**
     * Set GLID value
     * @param string $gLID
     * @return \StructType\Fees
     */
    public function setGLID($gLID = null)
    {
        // validation for constraint: string
        if (!is_null($gLID) && !is_string($gLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLID, true), gettype($gLID)), __LINE__);
        }
        $this->GLID = $gLID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
