<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FAQDetail StructType
 * @subpackage Structs
 */
class FAQDetail extends AbstractStructBase
{
    /**
     * The Question
     * @var string
     */
    public $Question;
    /**
     * The Answer
     * @var string
     */
    public $Answer;
    /**
     * The Sequence
     * @var int
     */
    public $Sequence;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Active
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for FAQDetail
     * @uses FAQDetail::setQuestion()
     * @uses FAQDetail::setAnswer()
     * @uses FAQDetail::setSequence()
     * @uses FAQDetail::setLanguage()
     * @uses FAQDetail::setActive()
     * @param string $question
     * @param string $answer
     * @param int $sequence
     * @param string $language
     * @param bool $active
     */
    public function __construct($question = null, $answer = null, $sequence = null, $language = null, $active = null)
    {
        $this
            ->setQuestion($question)
            ->setAnswer($answer)
            ->setSequence($sequence)
            ->setLanguage($language)
            ->setActive($active);
    }
    /**
     * Get Question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->Question;
    }
    /**
     * Set Question value
     * @param string $question
     * @return \StructType\FAQDetail
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($question, true), gettype($question)), __LINE__);
        }
        $this->Question = $question;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \StructType\FAQDetail
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Get Sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param int $sequence
     * @return \StructType\FAQDetail
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\FAQDetail
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\FAQDetail
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FAQDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
