<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventSurveyDetail StructType
 * @subpackage Structs
 */
class EventSurveyDetail extends AbstractStructBase
{
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventAnswer[]
     */
    public $Answer;
    /**
     * The AnswerText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AnswerText;
    /**
     * The SurveyType
     * @var string
     */
    public $SurveyType;
    /**
     * The QuestionId
     * @var string
     */
    public $QuestionId;
    /**
     * The QuestionCode
     * @var string
     */
    public $QuestionCode;
    /**
     * The QuestionText
     * @var string
     */
    public $QuestionText;
    /**
     * Constructor method for EventSurveyDetail
     * @uses EventSurveyDetail::setAnswer()
     * @uses EventSurveyDetail::setAnswerText()
     * @uses EventSurveyDetail::setSurveyType()
     * @uses EventSurveyDetail::setQuestionId()
     * @uses EventSurveyDetail::setQuestionCode()
     * @uses EventSurveyDetail::setQuestionText()
     * @param \StructType\EventAnswer[] $answer
     * @param string[] $answerText
     * @param string $surveyType
     * @param string $questionId
     * @param string $questionCode
     * @param string $questionText
     */
    public function __construct(array $answer = array(), array $answerText = array(), $surveyType = null, $questionId = null, $questionCode = null, $questionText = null)
    {
        $this
            ->setAnswer($answer)
            ->setAnswerText($answerText)
            ->setSurveyType($surveyType)
            ->setQuestionId($questionId)
            ->setQuestionCode($questionCode)
            ->setQuestionText($questionText);
    }
    /**
     * Get Answer value
     * @return \StructType\EventAnswer[]|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerForArrayConstraintsFromSetAnswer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventSurveyDetailAnswerItem) {
            // validation for constraint: itemType
            if (!$eventSurveyDetailAnswerItem instanceof \StructType\EventAnswer) {
                $invalidValues[] = is_object($eventSurveyDetailAnswerItem) ? get_class($eventSurveyDetailAnswerItem) : sprintf('%s(%s)', gettype($eventSurveyDetailAnswerItem), var_export($eventSurveyDetailAnswerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Answer property can only contain items of type \StructType\EventAnswer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\EventAnswer[] $answer
     * @return \StructType\EventSurveyDetail
     */
    public function setAnswer(array $answer = array())
    {
        // validation for constraint: array
        if ('' !== ($answerArrayErrorMessage = self::validateAnswerForArrayConstraintsFromSetAnswer($answer))) {
            throw new \InvalidArgumentException($answerArrayErrorMessage, __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Add item to Answer value
     * @throws \InvalidArgumentException
     * @param \StructType\EventAnswer $item
     * @return \StructType\EventSurveyDetail
     */
    public function addToAnswer(\StructType\EventAnswer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventAnswer) {
            throw new \InvalidArgumentException(sprintf('The Answer property can only contain items of type \StructType\EventAnswer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Answer[] = $item;
        return $this;
    }
    /**
     * Get AnswerText value
     * @return string[]|null
     */
    public function getAnswerText()
    {
        return $this->AnswerText;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswerText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswerText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerTextForArrayConstraintsFromSetAnswerText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventSurveyDetailAnswerTextItem) {
            // validation for constraint: itemType
            if (!is_string($eventSurveyDetailAnswerTextItem)) {
                $invalidValues[] = is_object($eventSurveyDetailAnswerTextItem) ? get_class($eventSurveyDetailAnswerTextItem) : sprintf('%s(%s)', gettype($eventSurveyDetailAnswerTextItem), var_export($eventSurveyDetailAnswerTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnswerText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnswerText value
     * @throws \InvalidArgumentException
     * @param string[] $answerText
     * @return \StructType\EventSurveyDetail
     */
    public function setAnswerText(array $answerText = array())
    {
        // validation for constraint: array
        if ('' !== ($answerTextArrayErrorMessage = self::validateAnswerTextForArrayConstraintsFromSetAnswerText($answerText))) {
            throw new \InvalidArgumentException($answerTextArrayErrorMessage, __LINE__);
        }
        $this->AnswerText = $answerText;
        return $this;
    }
    /**
     * Add item to AnswerText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\EventSurveyDetail
     */
    public function addToAnswerText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AnswerText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnswerText[] = $item;
        return $this;
    }
    /**
     * Get SurveyType value
     * @return string|null
     */
    public function getSurveyType()
    {
        return $this->SurveyType;
    }
    /**
     * Set SurveyType value
     * @param string $surveyType
     * @return \StructType\EventSurveyDetail
     */
    public function setSurveyType($surveyType = null)
    {
        // validation for constraint: string
        if (!is_null($surveyType) && !is_string($surveyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyType, true), gettype($surveyType)), __LINE__);
        }
        $this->SurveyType = $surveyType;
        return $this;
    }
    /**
     * Get QuestionId value
     * @return string|null
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param string $questionId
     * @return \StructType\EventSurveyDetail
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: string
        if (!is_null($questionId) && !is_string($questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionId, true), gettype($questionId)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\EventSurveyDetail
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\EventSurveyDetail
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventSurveyDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
