<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRoleDetail StructType
 * @subpackage Structs
 */
class EventRoleDetail extends AbstractStructBase
{
    /**
     * The AssigneeID
     * @var string
     */
    public $AssigneeID;
    /**
     * The AssigneeFirstName
     * @var string
     */
    public $AssigneeFirstName;
    /**
     * The AssigneeLastName
     * @var string
     */
    public $AssigneeLastName;
    /**
     * The AssigneeEmailAddress
     * @var string
     */
    public $AssigneeEmailAddress;
    /**
     * The AssignedRole
     * @var string
     */
    public $AssignedRole;
    /**
     * The AssignedBy
     * @var string
     */
    public $AssignedBy;
    /**
     * The AssignedDate
     * @var string
     */
    public $AssignedDate;
    /**
     * The EmailComments
     * @var string
     */
    public $EmailComments;
    /**
     * Constructor method for EventRoleDetail
     * @uses EventRoleDetail::setAssigneeID()
     * @uses EventRoleDetail::setAssigneeFirstName()
     * @uses EventRoleDetail::setAssigneeLastName()
     * @uses EventRoleDetail::setAssigneeEmailAddress()
     * @uses EventRoleDetail::setAssignedRole()
     * @uses EventRoleDetail::setAssignedBy()
     * @uses EventRoleDetail::setAssignedDate()
     * @uses EventRoleDetail::setEmailComments()
     * @param string $assigneeID
     * @param string $assigneeFirstName
     * @param string $assigneeLastName
     * @param string $assigneeEmailAddress
     * @param string $assignedRole
     * @param string $assignedBy
     * @param string $assignedDate
     * @param string $emailComments
     */
    public function __construct($assigneeID = null, $assigneeFirstName = null, $assigneeLastName = null, $assigneeEmailAddress = null, $assignedRole = null, $assignedBy = null, $assignedDate = null, $emailComments = null)
    {
        $this
            ->setAssigneeID($assigneeID)
            ->setAssigneeFirstName($assigneeFirstName)
            ->setAssigneeLastName($assigneeLastName)
            ->setAssigneeEmailAddress($assigneeEmailAddress)
            ->setAssignedRole($assignedRole)
            ->setAssignedBy($assignedBy)
            ->setAssignedDate($assignedDate)
            ->setEmailComments($emailComments);
    }
    /**
     * Get AssigneeID value
     * @return string|null
     */
    public function getAssigneeID()
    {
        return $this->AssigneeID;
    }
    /**
     * Set AssigneeID value
     * @param string $assigneeID
     * @return \StructType\EventRoleDetail
     */
    public function setAssigneeID($assigneeID = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeID) && !is_string($assigneeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeID, true), gettype($assigneeID)), __LINE__);
        }
        $this->AssigneeID = $assigneeID;
        return $this;
    }
    /**
     * Get AssigneeFirstName value
     * @return string|null
     */
    public function getAssigneeFirstName()
    {
        return $this->AssigneeFirstName;
    }
    /**
     * Set AssigneeFirstName value
     * @param string $assigneeFirstName
     * @return \StructType\EventRoleDetail
     */
    public function setAssigneeFirstName($assigneeFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeFirstName) && !is_string($assigneeFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeFirstName, true), gettype($assigneeFirstName)), __LINE__);
        }
        $this->AssigneeFirstName = $assigneeFirstName;
        return $this;
    }
    /**
     * Get AssigneeLastName value
     * @return string|null
     */
    public function getAssigneeLastName()
    {
        return $this->AssigneeLastName;
    }
    /**
     * Set AssigneeLastName value
     * @param string $assigneeLastName
     * @return \StructType\EventRoleDetail
     */
    public function setAssigneeLastName($assigneeLastName = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeLastName) && !is_string($assigneeLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeLastName, true), gettype($assigneeLastName)), __LINE__);
        }
        $this->AssigneeLastName = $assigneeLastName;
        return $this;
    }
    /**
     * Get AssigneeEmailAddress value
     * @return string|null
     */
    public function getAssigneeEmailAddress()
    {
        return $this->AssigneeEmailAddress;
    }
    /**
     * Set AssigneeEmailAddress value
     * @param string $assigneeEmailAddress
     * @return \StructType\EventRoleDetail
     */
    public function setAssigneeEmailAddress($assigneeEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeEmailAddress) && !is_string($assigneeEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeEmailAddress, true), gettype($assigneeEmailAddress)), __LINE__);
        }
        $this->AssigneeEmailAddress = $assigneeEmailAddress;
        return $this;
    }
    /**
     * Get AssignedRole value
     * @return string|null
     */
    public function getAssignedRole()
    {
        return $this->AssignedRole;
    }
    /**
     * Set AssignedRole value
     * @param string $assignedRole
     * @return \StructType\EventRoleDetail
     */
    public function setAssignedRole($assignedRole = null)
    {
        // validation for constraint: string
        if (!is_null($assignedRole) && !is_string($assignedRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedRole, true), gettype($assignedRole)), __LINE__);
        }
        $this->AssignedRole = $assignedRole;
        return $this;
    }
    /**
     * Get AssignedBy value
     * @return string|null
     */
    public function getAssignedBy()
    {
        return $this->AssignedBy;
    }
    /**
     * Set AssignedBy value
     * @param string $assignedBy
     * @return \StructType\EventRoleDetail
     */
    public function setAssignedBy($assignedBy = null)
    {
        // validation for constraint: string
        if (!is_null($assignedBy) && !is_string($assignedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedBy, true), gettype($assignedBy)), __LINE__);
        }
        $this->AssignedBy = $assignedBy;
        return $this;
    }
    /**
     * Get AssignedDate value
     * @return string|null
     */
    public function getAssignedDate()
    {
        return $this->AssignedDate;
    }
    /**
     * Set AssignedDate value
     * @param string $assignedDate
     * @return \StructType\EventRoleDetail
     */
    public function setAssignedDate($assignedDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignedDate) && !is_string($assignedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignedDate, true), gettype($assignedDate)), __LINE__);
        }
        $this->AssignedDate = $assignedDate;
        return $this;
    }
    /**
     * Get EmailComments value
     * @return string|null
     */
    public function getEmailComments()
    {
        return $this->EmailComments;
    }
    /**
     * Set EmailComments value
     * @param string $emailComments
     * @return \StructType\EventRoleDetail
     */
    public function setEmailComments($emailComments = null)
    {
        // validation for constraint: string
        if (!is_null($emailComments) && !is_string($emailComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailComments, true), gettype($emailComments)), __LINE__);
        }
        $this->EmailComments = $emailComments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventRoleDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
