<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRequestInfo StructType
 * @subpackage Structs
 */
class EventRequestInfo extends AbstractStructBase
{
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventCategory
     * @var string
     */
    public $EventCategory;
    /**
     * The EventDescription
     * @var string
     */
    public $EventDescription;
    /**
     * The EventInternalNote
     * @var string
     */
    public $EventInternalNote;
    /**
     * The EventLocation
     * @var string
     */
    public $EventLocation;
    /**
     * The EventAddress1
     * @var string
     */
    public $EventAddress1;
    /**
     * The EventAddress2
     * @var string
     */
    public $EventAddress2;
    /**
     * The EventAddress3
     * @var string
     */
    public $EventAddress3;
    /**
     * The EventCity
     * @var string
     */
    public $EventCity;
    /**
     * The EventState
     * @var string
     */
    public $EventState;
    /**
     * The EventStateCode
     * @var string
     */
    public $EventStateCode;
    /**
     * The EventPostalCode
     * @var string
     */
    public $EventPostalCode;
    /**
     * The EventCountry
     * @var string
     */
    public $EventCountry;
    /**
     * The EventCountryCode
     * @var string
     */
    public $EventCountryCode;
    /**
     * The EventPhone
     * @var string
     */
    public $EventPhone;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The EventRSVPDate
     * @var string
     */
    public $EventRSVPDate;
    /**
     * The EventTimeZone
     * @var string
     */
    public $EventTimeZone;
    /**
     * The EventTimeZoneId
     * @var int
     */
    public $EventTimeZoneId;
    /**
     * The EventCapacity
     * @var int
     */
    public $EventCapacity;
    /**
     * The EstimateAccomodation
     * @var float
     */
    public $EstimateAccomodation;
    /**
     * The EstimateCreativeAndDesign
     * @var float
     */
    public $EstimateCreativeAndDesign;
    /**
     * The EstimateEventProduction
     * @var float
     */
    public $EstimateEventProduction;
    /**
     * The EstimateFoodAndBeverage
     * @var float
     */
    public $EstimateFoodAndBeverage;
    /**
     * The EstimateGroundTransport
     * @var float
     */
    public $EstimateGroundTransport;
    /**
     * The EstimateHotelAndVenueMisc
     * @var float
     */
    public $EstimateHotelAndVenueMisc;
    /**
     * The EstimateManagementFees
     * @var float
     */
    public $EstimateManagementFees;
    /**
     * The EstimateMerchandiseAndGifts
     * @var float
     */
    public $EstimateMerchandiseAndGifts;
    /**
     * The EstimateMiscellaneous
     * @var float
     */
    public $EstimateMiscellaneous;
    /**
     * The EstimatePrintAndWebsites
     * @var float
     */
    public $EstimatePrintAndWebsites;
    /**
     * The EstimateRoomRental
     * @var float
     */
    public $EstimateRoomRental;
    /**
     * The EstimateSetupAndEquipment
     * @var float
     */
    public $EstimateSetupAndEquipment;
    /**
     * The EstimateSiteInspection
     * @var float
     */
    public $EstimateSiteInspection;
    /**
     * The EstimateSpecialEvents
     * @var float
     */
    public $EstimateSpecialEvents;
    /**
     * The EstimateTravel
     * @var float
     */
    public $EstimateTravel;
    /**
     * The StakeholderFirstName
     * @var string
     */
    public $StakeholderFirstName;
    /**
     * The StakeholderLastName
     * @var string
     */
    public $StakeholderLastName;
    /**
     * The StakeholderEmailAddress
     * @var string
     */
    public $StakeholderEmailAddress;
    /**
     * The StakeholderTitle
     * @var string
     */
    public $StakeholderTitle;
    /**
     * The StakeholderCompany
     * @var string
     */
    public $StakeholderCompany;
    /**
     * The StakeholderWorkPhone
     * @var string
     */
    public $StakeholderWorkPhone;
    /**
     * The StakeholderHomePhone
     * @var string
     */
    public $StakeholderHomePhone;
    /**
     * The StakeholderWorkFax
     * @var string
     */
    public $StakeholderWorkFax;
    /**
     * The StakeholderMobilePhone
     * @var string
     */
    public $StakeholderMobilePhone;
    /**
     * The StakeholderAddress1
     * @var string
     */
    public $StakeholderAddress1;
    /**
     * The StakeholderAddress2
     * @var string
     */
    public $StakeholderAddress2;
    /**
     * The StakeholderAddress3
     * @var string
     */
    public $StakeholderAddress3;
    /**
     * The StakeholderCity
     * @var string
     */
    public $StakeholderCity;
    /**
     * The StakeholderState
     * @var string
     */
    public $StakeholderState;
    /**
     * The StakeholderStateCode
     * @var string
     */
    public $StakeholderStateCode;
    /**
     * The StakeholderPostalCode
     * @var string
     */
    public $StakeholderPostalCode;
    /**
     * The StakeholderCountry
     * @var string
     */
    public $StakeholderCountry;
    /**
     * The StakeholderCountryCode
     * @var string
     */
    public $StakeholderCountryCode;
    /**
     * The MaximumEventCapacity
     * @var int
     */
    public $MaximumEventCapacity;
    /**
     * The NumberCancelledRegistrants
     * @var int
     */
    public $NumberCancelledRegistrants;
    /**
     * The NumberDeclinedRegistrants
     * @var int
     */
    public $NumberDeclinedRegistrants;
    /**
     * The NumberParticipants
     * @var int
     */
    public $NumberParticipants;
    /**
     * The NumberRegisteredAttendees
     * @var int
     */
    public $NumberRegisteredAttendees;
    /**
     * The NumberInvited
     * @var int
     */
    public $NumberInvited;
    /**
     * Constructor method for EventRequestInfo
     * @uses EventRequestInfo::setEventTitle()
     * @uses EventRequestInfo::setEventCategory()
     * @uses EventRequestInfo::setEventDescription()
     * @uses EventRequestInfo::setEventInternalNote()
     * @uses EventRequestInfo::setEventLocation()
     * @uses EventRequestInfo::setEventAddress1()
     * @uses EventRequestInfo::setEventAddress2()
     * @uses EventRequestInfo::setEventAddress3()
     * @uses EventRequestInfo::setEventCity()
     * @uses EventRequestInfo::setEventState()
     * @uses EventRequestInfo::setEventStateCode()
     * @uses EventRequestInfo::setEventPostalCode()
     * @uses EventRequestInfo::setEventCountry()
     * @uses EventRequestInfo::setEventCountryCode()
     * @uses EventRequestInfo::setEventPhone()
     * @uses EventRequestInfo::setEventStartDate()
     * @uses EventRequestInfo::setEventEndDate()
     * @uses EventRequestInfo::setEventRSVPDate()
     * @uses EventRequestInfo::setEventTimeZone()
     * @uses EventRequestInfo::setEventTimeZoneId()
     * @uses EventRequestInfo::setEventCapacity()
     * @uses EventRequestInfo::setEstimateAccomodation()
     * @uses EventRequestInfo::setEstimateCreativeAndDesign()
     * @uses EventRequestInfo::setEstimateEventProduction()
     * @uses EventRequestInfo::setEstimateFoodAndBeverage()
     * @uses EventRequestInfo::setEstimateGroundTransport()
     * @uses EventRequestInfo::setEstimateHotelAndVenueMisc()
     * @uses EventRequestInfo::setEstimateManagementFees()
     * @uses EventRequestInfo::setEstimateMerchandiseAndGifts()
     * @uses EventRequestInfo::setEstimateMiscellaneous()
     * @uses EventRequestInfo::setEstimatePrintAndWebsites()
     * @uses EventRequestInfo::setEstimateRoomRental()
     * @uses EventRequestInfo::setEstimateSetupAndEquipment()
     * @uses EventRequestInfo::setEstimateSiteInspection()
     * @uses EventRequestInfo::setEstimateSpecialEvents()
     * @uses EventRequestInfo::setEstimateTravel()
     * @uses EventRequestInfo::setStakeholderFirstName()
     * @uses EventRequestInfo::setStakeholderLastName()
     * @uses EventRequestInfo::setStakeholderEmailAddress()
     * @uses EventRequestInfo::setStakeholderTitle()
     * @uses EventRequestInfo::setStakeholderCompany()
     * @uses EventRequestInfo::setStakeholderWorkPhone()
     * @uses EventRequestInfo::setStakeholderHomePhone()
     * @uses EventRequestInfo::setStakeholderWorkFax()
     * @uses EventRequestInfo::setStakeholderMobilePhone()
     * @uses EventRequestInfo::setStakeholderAddress1()
     * @uses EventRequestInfo::setStakeholderAddress2()
     * @uses EventRequestInfo::setStakeholderAddress3()
     * @uses EventRequestInfo::setStakeholderCity()
     * @uses EventRequestInfo::setStakeholderState()
     * @uses EventRequestInfo::setStakeholderStateCode()
     * @uses EventRequestInfo::setStakeholderPostalCode()
     * @uses EventRequestInfo::setStakeholderCountry()
     * @uses EventRequestInfo::setStakeholderCountryCode()
     * @uses EventRequestInfo::setMaximumEventCapacity()
     * @uses EventRequestInfo::setNumberCancelledRegistrants()
     * @uses EventRequestInfo::setNumberDeclinedRegistrants()
     * @uses EventRequestInfo::setNumberParticipants()
     * @uses EventRequestInfo::setNumberRegisteredAttendees()
     * @uses EventRequestInfo::setNumberInvited()
     * @param string $eventTitle
     * @param string $eventCategory
     * @param string $eventDescription
     * @param string $eventInternalNote
     * @param string $eventLocation
     * @param string $eventAddress1
     * @param string $eventAddress2
     * @param string $eventAddress3
     * @param string $eventCity
     * @param string $eventState
     * @param string $eventStateCode
     * @param string $eventPostalCode
     * @param string $eventCountry
     * @param string $eventCountryCode
     * @param string $eventPhone
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param string $eventRSVPDate
     * @param string $eventTimeZone
     * @param int $eventTimeZoneId
     * @param int $eventCapacity
     * @param float $estimateAccomodation
     * @param float $estimateCreativeAndDesign
     * @param float $estimateEventProduction
     * @param float $estimateFoodAndBeverage
     * @param float $estimateGroundTransport
     * @param float $estimateHotelAndVenueMisc
     * @param float $estimateManagementFees
     * @param float $estimateMerchandiseAndGifts
     * @param float $estimateMiscellaneous
     * @param float $estimatePrintAndWebsites
     * @param float $estimateRoomRental
     * @param float $estimateSetupAndEquipment
     * @param float $estimateSiteInspection
     * @param float $estimateSpecialEvents
     * @param float $estimateTravel
     * @param string $stakeholderFirstName
     * @param string $stakeholderLastName
     * @param string $stakeholderEmailAddress
     * @param string $stakeholderTitle
     * @param string $stakeholderCompany
     * @param string $stakeholderWorkPhone
     * @param string $stakeholderHomePhone
     * @param string $stakeholderWorkFax
     * @param string $stakeholderMobilePhone
     * @param string $stakeholderAddress1
     * @param string $stakeholderAddress2
     * @param string $stakeholderAddress3
     * @param string $stakeholderCity
     * @param string $stakeholderState
     * @param string $stakeholderStateCode
     * @param string $stakeholderPostalCode
     * @param string $stakeholderCountry
     * @param string $stakeholderCountryCode
     * @param int $maximumEventCapacity
     * @param int $numberCancelledRegistrants
     * @param int $numberDeclinedRegistrants
     * @param int $numberParticipants
     * @param int $numberRegisteredAttendees
     * @param int $numberInvited
     */
    public function __construct($eventTitle = null, $eventCategory = null, $eventDescription = null, $eventInternalNote = null, $eventLocation = null, $eventAddress1 = null, $eventAddress2 = null, $eventAddress3 = null, $eventCity = null, $eventState = null, $eventStateCode = null, $eventPostalCode = null, $eventCountry = null, $eventCountryCode = null, $eventPhone = null, $eventStartDate = null, $eventEndDate = null, $eventRSVPDate = null, $eventTimeZone = null, $eventTimeZoneId = null, $eventCapacity = null, $estimateAccomodation = null, $estimateCreativeAndDesign = null, $estimateEventProduction = null, $estimateFoodAndBeverage = null, $estimateGroundTransport = null, $estimateHotelAndVenueMisc = null, $estimateManagementFees = null, $estimateMerchandiseAndGifts = null, $estimateMiscellaneous = null, $estimatePrintAndWebsites = null, $estimateRoomRental = null, $estimateSetupAndEquipment = null, $estimateSiteInspection = null, $estimateSpecialEvents = null, $estimateTravel = null, $stakeholderFirstName = null, $stakeholderLastName = null, $stakeholderEmailAddress = null, $stakeholderTitle = null, $stakeholderCompany = null, $stakeholderWorkPhone = null, $stakeholderHomePhone = null, $stakeholderWorkFax = null, $stakeholderMobilePhone = null, $stakeholderAddress1 = null, $stakeholderAddress2 = null, $stakeholderAddress3 = null, $stakeholderCity = null, $stakeholderState = null, $stakeholderStateCode = null, $stakeholderPostalCode = null, $stakeholderCountry = null, $stakeholderCountryCode = null, $maximumEventCapacity = null, $numberCancelledRegistrants = null, $numberDeclinedRegistrants = null, $numberParticipants = null, $numberRegisteredAttendees = null, $numberInvited = null)
    {
        $this
            ->setEventTitle($eventTitle)
            ->setEventCategory($eventCategory)
            ->setEventDescription($eventDescription)
            ->setEventInternalNote($eventInternalNote)
            ->setEventLocation($eventLocation)
            ->setEventAddress1($eventAddress1)
            ->setEventAddress2($eventAddress2)
            ->setEventAddress3($eventAddress3)
            ->setEventCity($eventCity)
            ->setEventState($eventState)
            ->setEventStateCode($eventStateCode)
            ->setEventPostalCode($eventPostalCode)
            ->setEventCountry($eventCountry)
            ->setEventCountryCode($eventCountryCode)
            ->setEventPhone($eventPhone)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setEventRSVPDate($eventRSVPDate)
            ->setEventTimeZone($eventTimeZone)
            ->setEventTimeZoneId($eventTimeZoneId)
            ->setEventCapacity($eventCapacity)
            ->setEstimateAccomodation($estimateAccomodation)
            ->setEstimateCreativeAndDesign($estimateCreativeAndDesign)
            ->setEstimateEventProduction($estimateEventProduction)
            ->setEstimateFoodAndBeverage($estimateFoodAndBeverage)
            ->setEstimateGroundTransport($estimateGroundTransport)
            ->setEstimateHotelAndVenueMisc($estimateHotelAndVenueMisc)
            ->setEstimateManagementFees($estimateManagementFees)
            ->setEstimateMerchandiseAndGifts($estimateMerchandiseAndGifts)
            ->setEstimateMiscellaneous($estimateMiscellaneous)
            ->setEstimatePrintAndWebsites($estimatePrintAndWebsites)
            ->setEstimateRoomRental($estimateRoomRental)
            ->setEstimateSetupAndEquipment($estimateSetupAndEquipment)
            ->setEstimateSiteInspection($estimateSiteInspection)
            ->setEstimateSpecialEvents($estimateSpecialEvents)
            ->setEstimateTravel($estimateTravel)
            ->setStakeholderFirstName($stakeholderFirstName)
            ->setStakeholderLastName($stakeholderLastName)
            ->setStakeholderEmailAddress($stakeholderEmailAddress)
            ->setStakeholderTitle($stakeholderTitle)
            ->setStakeholderCompany($stakeholderCompany)
            ->setStakeholderWorkPhone($stakeholderWorkPhone)
            ->setStakeholderHomePhone($stakeholderHomePhone)
            ->setStakeholderWorkFax($stakeholderWorkFax)
            ->setStakeholderMobilePhone($stakeholderMobilePhone)
            ->setStakeholderAddress1($stakeholderAddress1)
            ->setStakeholderAddress2($stakeholderAddress2)
            ->setStakeholderAddress3($stakeholderAddress3)
            ->setStakeholderCity($stakeholderCity)
            ->setStakeholderState($stakeholderState)
            ->setStakeholderStateCode($stakeholderStateCode)
            ->setStakeholderPostalCode($stakeholderPostalCode)
            ->setStakeholderCountry($stakeholderCountry)
            ->setStakeholderCountryCode($stakeholderCountryCode)
            ->setMaximumEventCapacity($maximumEventCapacity)
            ->setNumberCancelledRegistrants($numberCancelledRegistrants)
            ->setNumberDeclinedRegistrants($numberDeclinedRegistrants)
            ->setNumberParticipants($numberParticipants)
            ->setNumberRegisteredAttendees($numberRegisteredAttendees)
            ->setNumberInvited($numberInvited);
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\EventRequestInfo
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventCategory value
     * @return string|null
     */
    public function getEventCategory()
    {
        return $this->EventCategory;
    }
    /**
     * Set EventCategory value
     * @param string $eventCategory
     * @return \StructType\EventRequestInfo
     */
    public function setEventCategory($eventCategory = null)
    {
        // validation for constraint: string
        if (!is_null($eventCategory) && !is_string($eventCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCategory, true), gettype($eventCategory)), __LINE__);
        }
        $this->EventCategory = $eventCategory;
        return $this;
    }
    /**
     * Get EventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->EventDescription;
    }
    /**
     * Set EventDescription value
     * @param string $eventDescription
     * @return \StructType\EventRequestInfo
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->EventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get EventInternalNote value
     * @return string|null
     */
    public function getEventInternalNote()
    {
        return $this->EventInternalNote;
    }
    /**
     * Set EventInternalNote value
     * @param string $eventInternalNote
     * @return \StructType\EventRequestInfo
     */
    public function setEventInternalNote($eventInternalNote = null)
    {
        // validation for constraint: string
        if (!is_null($eventInternalNote) && !is_string($eventInternalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventInternalNote, true), gettype($eventInternalNote)), __LINE__);
        }
        $this->EventInternalNote = $eventInternalNote;
        return $this;
    }
    /**
     * Get EventLocation value
     * @return string|null
     */
    public function getEventLocation()
    {
        return $this->EventLocation;
    }
    /**
     * Set EventLocation value
     * @param string $eventLocation
     * @return \StructType\EventRequestInfo
     */
    public function setEventLocation($eventLocation = null)
    {
        // validation for constraint: string
        if (!is_null($eventLocation) && !is_string($eventLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventLocation, true), gettype($eventLocation)), __LINE__);
        }
        $this->EventLocation = $eventLocation;
        return $this;
    }
    /**
     * Get EventAddress1 value
     * @return string|null
     */
    public function getEventAddress1()
    {
        return $this->EventAddress1;
    }
    /**
     * Set EventAddress1 value
     * @param string $eventAddress1
     * @return \StructType\EventRequestInfo
     */
    public function setEventAddress1($eventAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($eventAddress1) && !is_string($eventAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventAddress1, true), gettype($eventAddress1)), __LINE__);
        }
        $this->EventAddress1 = $eventAddress1;
        return $this;
    }
    /**
     * Get EventAddress2 value
     * @return string|null
     */
    public function getEventAddress2()
    {
        return $this->EventAddress2;
    }
    /**
     * Set EventAddress2 value
     * @param string $eventAddress2
     * @return \StructType\EventRequestInfo
     */
    public function setEventAddress2($eventAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($eventAddress2) && !is_string($eventAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventAddress2, true), gettype($eventAddress2)), __LINE__);
        }
        $this->EventAddress2 = $eventAddress2;
        return $this;
    }
    /**
     * Get EventAddress3 value
     * @return string|null
     */
    public function getEventAddress3()
    {
        return $this->EventAddress3;
    }
    /**
     * Set EventAddress3 value
     * @param string $eventAddress3
     * @return \StructType\EventRequestInfo
     */
    public function setEventAddress3($eventAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($eventAddress3) && !is_string($eventAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventAddress3, true), gettype($eventAddress3)), __LINE__);
        }
        $this->EventAddress3 = $eventAddress3;
        return $this;
    }
    /**
     * Get EventCity value
     * @return string|null
     */
    public function getEventCity()
    {
        return $this->EventCity;
    }
    /**
     * Set EventCity value
     * @param string $eventCity
     * @return \StructType\EventRequestInfo
     */
    public function setEventCity($eventCity = null)
    {
        // validation for constraint: string
        if (!is_null($eventCity) && !is_string($eventCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCity, true), gettype($eventCity)), __LINE__);
        }
        $this->EventCity = $eventCity;
        return $this;
    }
    /**
     * Get EventState value
     * @return string|null
     */
    public function getEventState()
    {
        return $this->EventState;
    }
    /**
     * Set EventState value
     * @param string $eventState
     * @return \StructType\EventRequestInfo
     */
    public function setEventState($eventState = null)
    {
        // validation for constraint: string
        if (!is_null($eventState) && !is_string($eventState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventState, true), gettype($eventState)), __LINE__);
        }
        $this->EventState = $eventState;
        return $this;
    }
    /**
     * Get EventStateCode value
     * @return string|null
     */
    public function getEventStateCode()
    {
        return $this->EventStateCode;
    }
    /**
     * Set EventStateCode value
     * @param string $eventStateCode
     * @return \StructType\EventRequestInfo
     */
    public function setEventStateCode($eventStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventStateCode) && !is_string($eventStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStateCode, true), gettype($eventStateCode)), __LINE__);
        }
        $this->EventStateCode = $eventStateCode;
        return $this;
    }
    /**
     * Get EventPostalCode value
     * @return string|null
     */
    public function getEventPostalCode()
    {
        return $this->EventPostalCode;
    }
    /**
     * Set EventPostalCode value
     * @param string $eventPostalCode
     * @return \StructType\EventRequestInfo
     */
    public function setEventPostalCode($eventPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventPostalCode) && !is_string($eventPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventPostalCode, true), gettype($eventPostalCode)), __LINE__);
        }
        $this->EventPostalCode = $eventPostalCode;
        return $this;
    }
    /**
     * Get EventCountry value
     * @return string|null
     */
    public function getEventCountry()
    {
        return $this->EventCountry;
    }
    /**
     * Set EventCountry value
     * @param string $eventCountry
     * @return \StructType\EventRequestInfo
     */
    public function setEventCountry($eventCountry = null)
    {
        // validation for constraint: string
        if (!is_null($eventCountry) && !is_string($eventCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCountry, true), gettype($eventCountry)), __LINE__);
        }
        $this->EventCountry = $eventCountry;
        return $this;
    }
    /**
     * Get EventCountryCode value
     * @return string|null
     */
    public function getEventCountryCode()
    {
        return $this->EventCountryCode;
    }
    /**
     * Set EventCountryCode value
     * @param string $eventCountryCode
     * @return \StructType\EventRequestInfo
     */
    public function setEventCountryCode($eventCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCountryCode) && !is_string($eventCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCountryCode, true), gettype($eventCountryCode)), __LINE__);
        }
        $this->EventCountryCode = $eventCountryCode;
        return $this;
    }
    /**
     * Get EventPhone value
     * @return string|null
     */
    public function getEventPhone()
    {
        return $this->EventPhone;
    }
    /**
     * Set EventPhone value
     * @param string $eventPhone
     * @return \StructType\EventRequestInfo
     */
    public function setEventPhone($eventPhone = null)
    {
        // validation for constraint: string
        if (!is_null($eventPhone) && !is_string($eventPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventPhone, true), gettype($eventPhone)), __LINE__);
        }
        $this->EventPhone = $eventPhone;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\EventRequestInfo
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\EventRequestInfo
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get EventRSVPDate value
     * @return string|null
     */
    public function getEventRSVPDate()
    {
        return $this->EventRSVPDate;
    }
    /**
     * Set EventRSVPDate value
     * @param string $eventRSVPDate
     * @return \StructType\EventRequestInfo
     */
    public function setEventRSVPDate($eventRSVPDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventRSVPDate) && !is_string($eventRSVPDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventRSVPDate, true), gettype($eventRSVPDate)), __LINE__);
        }
        $this->EventRSVPDate = $eventRSVPDate;
        return $this;
    }
    /**
     * Get EventTimeZone value
     * @return string|null
     */
    public function getEventTimeZone()
    {
        return $this->EventTimeZone;
    }
    /**
     * Set EventTimeZone value
     * @param string $eventTimeZone
     * @return \StructType\EventRequestInfo
     */
    public function setEventTimeZone($eventTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($eventTimeZone) && !is_string($eventTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTimeZone, true), gettype($eventTimeZone)), __LINE__);
        }
        $this->EventTimeZone = $eventTimeZone;
        return $this;
    }
    /**
     * Get EventTimeZoneId value
     * @return int|null
     */
    public function getEventTimeZoneId()
    {
        return $this->EventTimeZoneId;
    }
    /**
     * Set EventTimeZoneId value
     * @param int $eventTimeZoneId
     * @return \StructType\EventRequestInfo
     */
    public function setEventTimeZoneId($eventTimeZoneId = null)
    {
        // validation for constraint: int
        if (!is_null($eventTimeZoneId) && !(is_int($eventTimeZoneId) || ctype_digit($eventTimeZoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventTimeZoneId, true), gettype($eventTimeZoneId)), __LINE__);
        }
        $this->EventTimeZoneId = $eventTimeZoneId;
        return $this;
    }
    /**
     * Get EventCapacity value
     * @return int|null
     */
    public function getEventCapacity()
    {
        return $this->EventCapacity;
    }
    /**
     * Set EventCapacity value
     * @param int $eventCapacity
     * @return \StructType\EventRequestInfo
     */
    public function setEventCapacity($eventCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($eventCapacity) && !(is_int($eventCapacity) || ctype_digit($eventCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCapacity, true), gettype($eventCapacity)), __LINE__);
        }
        $this->EventCapacity = $eventCapacity;
        return $this;
    }
    /**
     * Get EstimateAccomodation value
     * @return float|null
     */
    public function getEstimateAccomodation()
    {
        return $this->EstimateAccomodation;
    }
    /**
     * Set EstimateAccomodation value
     * @param float $estimateAccomodation
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateAccomodation($estimateAccomodation = null)
    {
        // validation for constraint: float
        if (!is_null($estimateAccomodation) && !(is_float($estimateAccomodation) || is_numeric($estimateAccomodation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateAccomodation, true), gettype($estimateAccomodation)), __LINE__);
        }
        $this->EstimateAccomodation = $estimateAccomodation;
        return $this;
    }
    /**
     * Get EstimateCreativeAndDesign value
     * @return float|null
     */
    public function getEstimateCreativeAndDesign()
    {
        return $this->EstimateCreativeAndDesign;
    }
    /**
     * Set EstimateCreativeAndDesign value
     * @param float $estimateCreativeAndDesign
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateCreativeAndDesign($estimateCreativeAndDesign = null)
    {
        // validation for constraint: float
        if (!is_null($estimateCreativeAndDesign) && !(is_float($estimateCreativeAndDesign) || is_numeric($estimateCreativeAndDesign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateCreativeAndDesign, true), gettype($estimateCreativeAndDesign)), __LINE__);
        }
        $this->EstimateCreativeAndDesign = $estimateCreativeAndDesign;
        return $this;
    }
    /**
     * Get EstimateEventProduction value
     * @return float|null
     */
    public function getEstimateEventProduction()
    {
        return $this->EstimateEventProduction;
    }
    /**
     * Set EstimateEventProduction value
     * @param float $estimateEventProduction
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateEventProduction($estimateEventProduction = null)
    {
        // validation for constraint: float
        if (!is_null($estimateEventProduction) && !(is_float($estimateEventProduction) || is_numeric($estimateEventProduction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateEventProduction, true), gettype($estimateEventProduction)), __LINE__);
        }
        $this->EstimateEventProduction = $estimateEventProduction;
        return $this;
    }
    /**
     * Get EstimateFoodAndBeverage value
     * @return float|null
     */
    public function getEstimateFoodAndBeverage()
    {
        return $this->EstimateFoodAndBeverage;
    }
    /**
     * Set EstimateFoodAndBeverage value
     * @param float $estimateFoodAndBeverage
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateFoodAndBeverage($estimateFoodAndBeverage = null)
    {
        // validation for constraint: float
        if (!is_null($estimateFoodAndBeverage) && !(is_float($estimateFoodAndBeverage) || is_numeric($estimateFoodAndBeverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateFoodAndBeverage, true), gettype($estimateFoodAndBeverage)), __LINE__);
        }
        $this->EstimateFoodAndBeverage = $estimateFoodAndBeverage;
        return $this;
    }
    /**
     * Get EstimateGroundTransport value
     * @return float|null
     */
    public function getEstimateGroundTransport()
    {
        return $this->EstimateGroundTransport;
    }
    /**
     * Set EstimateGroundTransport value
     * @param float $estimateGroundTransport
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateGroundTransport($estimateGroundTransport = null)
    {
        // validation for constraint: float
        if (!is_null($estimateGroundTransport) && !(is_float($estimateGroundTransport) || is_numeric($estimateGroundTransport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateGroundTransport, true), gettype($estimateGroundTransport)), __LINE__);
        }
        $this->EstimateGroundTransport = $estimateGroundTransport;
        return $this;
    }
    /**
     * Get EstimateHotelAndVenueMisc value
     * @return float|null
     */
    public function getEstimateHotelAndVenueMisc()
    {
        return $this->EstimateHotelAndVenueMisc;
    }
    /**
     * Set EstimateHotelAndVenueMisc value
     * @param float $estimateHotelAndVenueMisc
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateHotelAndVenueMisc($estimateHotelAndVenueMisc = null)
    {
        // validation for constraint: float
        if (!is_null($estimateHotelAndVenueMisc) && !(is_float($estimateHotelAndVenueMisc) || is_numeric($estimateHotelAndVenueMisc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateHotelAndVenueMisc, true), gettype($estimateHotelAndVenueMisc)), __LINE__);
        }
        $this->EstimateHotelAndVenueMisc = $estimateHotelAndVenueMisc;
        return $this;
    }
    /**
     * Get EstimateManagementFees value
     * @return float|null
     */
    public function getEstimateManagementFees()
    {
        return $this->EstimateManagementFees;
    }
    /**
     * Set EstimateManagementFees value
     * @param float $estimateManagementFees
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateManagementFees($estimateManagementFees = null)
    {
        // validation for constraint: float
        if (!is_null($estimateManagementFees) && !(is_float($estimateManagementFees) || is_numeric($estimateManagementFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateManagementFees, true), gettype($estimateManagementFees)), __LINE__);
        }
        $this->EstimateManagementFees = $estimateManagementFees;
        return $this;
    }
    /**
     * Get EstimateMerchandiseAndGifts value
     * @return float|null
     */
    public function getEstimateMerchandiseAndGifts()
    {
        return $this->EstimateMerchandiseAndGifts;
    }
    /**
     * Set EstimateMerchandiseAndGifts value
     * @param float $estimateMerchandiseAndGifts
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateMerchandiseAndGifts($estimateMerchandiseAndGifts = null)
    {
        // validation for constraint: float
        if (!is_null($estimateMerchandiseAndGifts) && !(is_float($estimateMerchandiseAndGifts) || is_numeric($estimateMerchandiseAndGifts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateMerchandiseAndGifts, true), gettype($estimateMerchandiseAndGifts)), __LINE__);
        }
        $this->EstimateMerchandiseAndGifts = $estimateMerchandiseAndGifts;
        return $this;
    }
    /**
     * Get EstimateMiscellaneous value
     * @return float|null
     */
    public function getEstimateMiscellaneous()
    {
        return $this->EstimateMiscellaneous;
    }
    /**
     * Set EstimateMiscellaneous value
     * @param float $estimateMiscellaneous
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateMiscellaneous($estimateMiscellaneous = null)
    {
        // validation for constraint: float
        if (!is_null($estimateMiscellaneous) && !(is_float($estimateMiscellaneous) || is_numeric($estimateMiscellaneous))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateMiscellaneous, true), gettype($estimateMiscellaneous)), __LINE__);
        }
        $this->EstimateMiscellaneous = $estimateMiscellaneous;
        return $this;
    }
    /**
     * Get EstimatePrintAndWebsites value
     * @return float|null
     */
    public function getEstimatePrintAndWebsites()
    {
        return $this->EstimatePrintAndWebsites;
    }
    /**
     * Set EstimatePrintAndWebsites value
     * @param float $estimatePrintAndWebsites
     * @return \StructType\EventRequestInfo
     */
    public function setEstimatePrintAndWebsites($estimatePrintAndWebsites = null)
    {
        // validation for constraint: float
        if (!is_null($estimatePrintAndWebsites) && !(is_float($estimatePrintAndWebsites) || is_numeric($estimatePrintAndWebsites))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatePrintAndWebsites, true), gettype($estimatePrintAndWebsites)), __LINE__);
        }
        $this->EstimatePrintAndWebsites = $estimatePrintAndWebsites;
        return $this;
    }
    /**
     * Get EstimateRoomRental value
     * @return float|null
     */
    public function getEstimateRoomRental()
    {
        return $this->EstimateRoomRental;
    }
    /**
     * Set EstimateRoomRental value
     * @param float $estimateRoomRental
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateRoomRental($estimateRoomRental = null)
    {
        // validation for constraint: float
        if (!is_null($estimateRoomRental) && !(is_float($estimateRoomRental) || is_numeric($estimateRoomRental))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateRoomRental, true), gettype($estimateRoomRental)), __LINE__);
        }
        $this->EstimateRoomRental = $estimateRoomRental;
        return $this;
    }
    /**
     * Get EstimateSetupAndEquipment value
     * @return float|null
     */
    public function getEstimateSetupAndEquipment()
    {
        return $this->EstimateSetupAndEquipment;
    }
    /**
     * Set EstimateSetupAndEquipment value
     * @param float $estimateSetupAndEquipment
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateSetupAndEquipment($estimateSetupAndEquipment = null)
    {
        // validation for constraint: float
        if (!is_null($estimateSetupAndEquipment) && !(is_float($estimateSetupAndEquipment) || is_numeric($estimateSetupAndEquipment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateSetupAndEquipment, true), gettype($estimateSetupAndEquipment)), __LINE__);
        }
        $this->EstimateSetupAndEquipment = $estimateSetupAndEquipment;
        return $this;
    }
    /**
     * Get EstimateSiteInspection value
     * @return float|null
     */
    public function getEstimateSiteInspection()
    {
        return $this->EstimateSiteInspection;
    }
    /**
     * Set EstimateSiteInspection value
     * @param float $estimateSiteInspection
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateSiteInspection($estimateSiteInspection = null)
    {
        // validation for constraint: float
        if (!is_null($estimateSiteInspection) && !(is_float($estimateSiteInspection) || is_numeric($estimateSiteInspection))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateSiteInspection, true), gettype($estimateSiteInspection)), __LINE__);
        }
        $this->EstimateSiteInspection = $estimateSiteInspection;
        return $this;
    }
    /**
     * Get EstimateSpecialEvents value
     * @return float|null
     */
    public function getEstimateSpecialEvents()
    {
        return $this->EstimateSpecialEvents;
    }
    /**
     * Set EstimateSpecialEvents value
     * @param float $estimateSpecialEvents
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateSpecialEvents($estimateSpecialEvents = null)
    {
        // validation for constraint: float
        if (!is_null($estimateSpecialEvents) && !(is_float($estimateSpecialEvents) || is_numeric($estimateSpecialEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateSpecialEvents, true), gettype($estimateSpecialEvents)), __LINE__);
        }
        $this->EstimateSpecialEvents = $estimateSpecialEvents;
        return $this;
    }
    /**
     * Get EstimateTravel value
     * @return float|null
     */
    public function getEstimateTravel()
    {
        return $this->EstimateTravel;
    }
    /**
     * Set EstimateTravel value
     * @param float $estimateTravel
     * @return \StructType\EventRequestInfo
     */
    public function setEstimateTravel($estimateTravel = null)
    {
        // validation for constraint: float
        if (!is_null($estimateTravel) && !(is_float($estimateTravel) || is_numeric($estimateTravel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimateTravel, true), gettype($estimateTravel)), __LINE__);
        }
        $this->EstimateTravel = $estimateTravel;
        return $this;
    }
    /**
     * Get StakeholderFirstName value
     * @return string|null
     */
    public function getStakeholderFirstName()
    {
        return $this->StakeholderFirstName;
    }
    /**
     * Set StakeholderFirstName value
     * @param string $stakeholderFirstName
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderFirstName($stakeholderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderFirstName) && !is_string($stakeholderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderFirstName, true), gettype($stakeholderFirstName)), __LINE__);
        }
        $this->StakeholderFirstName = $stakeholderFirstName;
        return $this;
    }
    /**
     * Get StakeholderLastName value
     * @return string|null
     */
    public function getStakeholderLastName()
    {
        return $this->StakeholderLastName;
    }
    /**
     * Set StakeholderLastName value
     * @param string $stakeholderLastName
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderLastName($stakeholderLastName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderLastName) && !is_string($stakeholderLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderLastName, true), gettype($stakeholderLastName)), __LINE__);
        }
        $this->StakeholderLastName = $stakeholderLastName;
        return $this;
    }
    /**
     * Get StakeholderEmailAddress value
     * @return string|null
     */
    public function getStakeholderEmailAddress()
    {
        return $this->StakeholderEmailAddress;
    }
    /**
     * Set StakeholderEmailAddress value
     * @param string $stakeholderEmailAddress
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderEmailAddress($stakeholderEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderEmailAddress) && !is_string($stakeholderEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderEmailAddress, true), gettype($stakeholderEmailAddress)), __LINE__);
        }
        $this->StakeholderEmailAddress = $stakeholderEmailAddress;
        return $this;
    }
    /**
     * Get StakeholderTitle value
     * @return string|null
     */
    public function getStakeholderTitle()
    {
        return $this->StakeholderTitle;
    }
    /**
     * Set StakeholderTitle value
     * @param string $stakeholderTitle
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderTitle($stakeholderTitle = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderTitle) && !is_string($stakeholderTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderTitle, true), gettype($stakeholderTitle)), __LINE__);
        }
        $this->StakeholderTitle = $stakeholderTitle;
        return $this;
    }
    /**
     * Get StakeholderCompany value
     * @return string|null
     */
    public function getStakeholderCompany()
    {
        return $this->StakeholderCompany;
    }
    /**
     * Set StakeholderCompany value
     * @param string $stakeholderCompany
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderCompany($stakeholderCompany = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCompany) && !is_string($stakeholderCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCompany, true), gettype($stakeholderCompany)), __LINE__);
        }
        $this->StakeholderCompany = $stakeholderCompany;
        return $this;
    }
    /**
     * Get StakeholderWorkPhone value
     * @return string|null
     */
    public function getStakeholderWorkPhone()
    {
        return $this->StakeholderWorkPhone;
    }
    /**
     * Set StakeholderWorkPhone value
     * @param string $stakeholderWorkPhone
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderWorkPhone($stakeholderWorkPhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkPhone) && !is_string($stakeholderWorkPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkPhone, true), gettype($stakeholderWorkPhone)), __LINE__);
        }
        $this->StakeholderWorkPhone = $stakeholderWorkPhone;
        return $this;
    }
    /**
     * Get StakeholderHomePhone value
     * @return string|null
     */
    public function getStakeholderHomePhone()
    {
        return $this->StakeholderHomePhone;
    }
    /**
     * Set StakeholderHomePhone value
     * @param string $stakeholderHomePhone
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderHomePhone($stakeholderHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderHomePhone) && !is_string($stakeholderHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderHomePhone, true), gettype($stakeholderHomePhone)), __LINE__);
        }
        $this->StakeholderHomePhone = $stakeholderHomePhone;
        return $this;
    }
    /**
     * Get StakeholderWorkFax value
     * @return string|null
     */
    public function getStakeholderWorkFax()
    {
        return $this->StakeholderWorkFax;
    }
    /**
     * Set StakeholderWorkFax value
     * @param string $stakeholderWorkFax
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderWorkFax($stakeholderWorkFax = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkFax) && !is_string($stakeholderWorkFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkFax, true), gettype($stakeholderWorkFax)), __LINE__);
        }
        $this->StakeholderWorkFax = $stakeholderWorkFax;
        return $this;
    }
    /**
     * Get StakeholderMobilePhone value
     * @return string|null
     */
    public function getStakeholderMobilePhone()
    {
        return $this->StakeholderMobilePhone;
    }
    /**
     * Set StakeholderMobilePhone value
     * @param string $stakeholderMobilePhone
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderMobilePhone($stakeholderMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderMobilePhone) && !is_string($stakeholderMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderMobilePhone, true), gettype($stakeholderMobilePhone)), __LINE__);
        }
        $this->StakeholderMobilePhone = $stakeholderMobilePhone;
        return $this;
    }
    /**
     * Get StakeholderAddress1 value
     * @return string|null
     */
    public function getStakeholderAddress1()
    {
        return $this->StakeholderAddress1;
    }
    /**
     * Set StakeholderAddress1 value
     * @param string $stakeholderAddress1
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderAddress1($stakeholderAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress1) && !is_string($stakeholderAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress1, true), gettype($stakeholderAddress1)), __LINE__);
        }
        $this->StakeholderAddress1 = $stakeholderAddress1;
        return $this;
    }
    /**
     * Get StakeholderAddress2 value
     * @return string|null
     */
    public function getStakeholderAddress2()
    {
        return $this->StakeholderAddress2;
    }
    /**
     * Set StakeholderAddress2 value
     * @param string $stakeholderAddress2
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderAddress2($stakeholderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress2) && !is_string($stakeholderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress2, true), gettype($stakeholderAddress2)), __LINE__);
        }
        $this->StakeholderAddress2 = $stakeholderAddress2;
        return $this;
    }
    /**
     * Get StakeholderAddress3 value
     * @return string|null
     */
    public function getStakeholderAddress3()
    {
        return $this->StakeholderAddress3;
    }
    /**
     * Set StakeholderAddress3 value
     * @param string $stakeholderAddress3
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderAddress3($stakeholderAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress3) && !is_string($stakeholderAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress3, true), gettype($stakeholderAddress3)), __LINE__);
        }
        $this->StakeholderAddress3 = $stakeholderAddress3;
        return $this;
    }
    /**
     * Get StakeholderCity value
     * @return string|null
     */
    public function getStakeholderCity()
    {
        return $this->StakeholderCity;
    }
    /**
     * Set StakeholderCity value
     * @param string $stakeholderCity
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderCity($stakeholderCity = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCity) && !is_string($stakeholderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCity, true), gettype($stakeholderCity)), __LINE__);
        }
        $this->StakeholderCity = $stakeholderCity;
        return $this;
    }
    /**
     * Get StakeholderState value
     * @return string|null
     */
    public function getStakeholderState()
    {
        return $this->StakeholderState;
    }
    /**
     * Set StakeholderState value
     * @param string $stakeholderState
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderState($stakeholderState = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderState) && !is_string($stakeholderState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderState, true), gettype($stakeholderState)), __LINE__);
        }
        $this->StakeholderState = $stakeholderState;
        return $this;
    }
    /**
     * Get StakeholderStateCode value
     * @return string|null
     */
    public function getStakeholderStateCode()
    {
        return $this->StakeholderStateCode;
    }
    /**
     * Set StakeholderStateCode value
     * @param string $stakeholderStateCode
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderStateCode($stakeholderStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderStateCode) && !is_string($stakeholderStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderStateCode, true), gettype($stakeholderStateCode)), __LINE__);
        }
        $this->StakeholderStateCode = $stakeholderStateCode;
        return $this;
    }
    /**
     * Get StakeholderPostalCode value
     * @return string|null
     */
    public function getStakeholderPostalCode()
    {
        return $this->StakeholderPostalCode;
    }
    /**
     * Set StakeholderPostalCode value
     * @param string $stakeholderPostalCode
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderPostalCode($stakeholderPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderPostalCode) && !is_string($stakeholderPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderPostalCode, true), gettype($stakeholderPostalCode)), __LINE__);
        }
        $this->StakeholderPostalCode = $stakeholderPostalCode;
        return $this;
    }
    /**
     * Get StakeholderCountry value
     * @return string|null
     */
    public function getStakeholderCountry()
    {
        return $this->StakeholderCountry;
    }
    /**
     * Set StakeholderCountry value
     * @param string $stakeholderCountry
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderCountry($stakeholderCountry = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCountry) && !is_string($stakeholderCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCountry, true), gettype($stakeholderCountry)), __LINE__);
        }
        $this->StakeholderCountry = $stakeholderCountry;
        return $this;
    }
    /**
     * Get StakeholderCountryCode value
     * @return string|null
     */
    public function getStakeholderCountryCode()
    {
        return $this->StakeholderCountryCode;
    }
    /**
     * Set StakeholderCountryCode value
     * @param string $stakeholderCountryCode
     * @return \StructType\EventRequestInfo
     */
    public function setStakeholderCountryCode($stakeholderCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCountryCode) && !is_string($stakeholderCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCountryCode, true), gettype($stakeholderCountryCode)), __LINE__);
        }
        $this->StakeholderCountryCode = $stakeholderCountryCode;
        return $this;
    }
    /**
     * Get MaximumEventCapacity value
     * @return int|null
     */
    public function getMaximumEventCapacity()
    {
        return $this->MaximumEventCapacity;
    }
    /**
     * Set MaximumEventCapacity value
     * @param int $maximumEventCapacity
     * @return \StructType\EventRequestInfo
     */
    public function setMaximumEventCapacity($maximumEventCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maximumEventCapacity) && !(is_int($maximumEventCapacity) || ctype_digit($maximumEventCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumEventCapacity, true), gettype($maximumEventCapacity)), __LINE__);
        }
        $this->MaximumEventCapacity = $maximumEventCapacity;
        return $this;
    }
    /**
     * Get NumberCancelledRegistrants value
     * @return int|null
     */
    public function getNumberCancelledRegistrants()
    {
        return $this->NumberCancelledRegistrants;
    }
    /**
     * Set NumberCancelledRegistrants value
     * @param int $numberCancelledRegistrants
     * @return \StructType\EventRequestInfo
     */
    public function setNumberCancelledRegistrants($numberCancelledRegistrants = null)
    {
        // validation for constraint: int
        if (!is_null($numberCancelledRegistrants) && !(is_int($numberCancelledRegistrants) || ctype_digit($numberCancelledRegistrants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberCancelledRegistrants, true), gettype($numberCancelledRegistrants)), __LINE__);
        }
        $this->NumberCancelledRegistrants = $numberCancelledRegistrants;
        return $this;
    }
    /**
     * Get NumberDeclinedRegistrants value
     * @return int|null
     */
    public function getNumberDeclinedRegistrants()
    {
        return $this->NumberDeclinedRegistrants;
    }
    /**
     * Set NumberDeclinedRegistrants value
     * @param int $numberDeclinedRegistrants
     * @return \StructType\EventRequestInfo
     */
    public function setNumberDeclinedRegistrants($numberDeclinedRegistrants = null)
    {
        // validation for constraint: int
        if (!is_null($numberDeclinedRegistrants) && !(is_int($numberDeclinedRegistrants) || ctype_digit($numberDeclinedRegistrants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberDeclinedRegistrants, true), gettype($numberDeclinedRegistrants)), __LINE__);
        }
        $this->NumberDeclinedRegistrants = $numberDeclinedRegistrants;
        return $this;
    }
    /**
     * Get NumberParticipants value
     * @return int|null
     */
    public function getNumberParticipants()
    {
        return $this->NumberParticipants;
    }
    /**
     * Set NumberParticipants value
     * @param int $numberParticipants
     * @return \StructType\EventRequestInfo
     */
    public function setNumberParticipants($numberParticipants = null)
    {
        // validation for constraint: int
        if (!is_null($numberParticipants) && !(is_int($numberParticipants) || ctype_digit($numberParticipants))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberParticipants, true), gettype($numberParticipants)), __LINE__);
        }
        $this->NumberParticipants = $numberParticipants;
        return $this;
    }
    /**
     * Get NumberRegisteredAttendees value
     * @return int|null
     */
    public function getNumberRegisteredAttendees()
    {
        return $this->NumberRegisteredAttendees;
    }
    /**
     * Set NumberRegisteredAttendees value
     * @param int $numberRegisteredAttendees
     * @return \StructType\EventRequestInfo
     */
    public function setNumberRegisteredAttendees($numberRegisteredAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($numberRegisteredAttendees) && !(is_int($numberRegisteredAttendees) || ctype_digit($numberRegisteredAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberRegisteredAttendees, true), gettype($numberRegisteredAttendees)), __LINE__);
        }
        $this->NumberRegisteredAttendees = $numberRegisteredAttendees;
        return $this;
    }
    /**
     * Get NumberInvited value
     * @return int|null
     */
    public function getNumberInvited()
    {
        return $this->NumberInvited;
    }
    /**
     * Set NumberInvited value
     * @param int $numberInvited
     * @return \StructType\EventRequestInfo
     */
    public function setNumberInvited($numberInvited = null)
    {
        // validation for constraint: int
        if (!is_null($numberInvited) && !(is_int($numberInvited) || ctype_digit($numberInvited))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInvited, true), gettype($numberInvited)), __LINE__);
        }
        $this->NumberInvited = $numberInvited;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventRequestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
