<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventQuestion StructType
 * @subpackage Structs
 */
class EventQuestion extends CvObject
{
    /**
     * The AnswerDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnswerDetail[]
     */
    public $AnswerDetail;
    /**
     * The RowDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RowDetail[]
     */
    public $RowDetail;
    /**
     * The QuestionText
     * @var string
     */
    public $QuestionText;
    /**
     * The QuestionCode
     * @var string
     */
    public $QuestionCode;
    /**
     * The SurveyType
     * @var string
     */
    public $SurveyType;
    /**
     * The QuestionType
     * @var string
     */
    public $QuestionType;
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The AllowOther
     * @var bool
     */
    public $AllowOther;
    /**
     * The OtherLabel
     * @var string
     */
    public $OtherLabel;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for EventQuestion
     * @uses EventQuestion::setAnswerDetail()
     * @uses EventQuestion::setRowDetail()
     * @uses EventQuestion::setQuestionText()
     * @uses EventQuestion::setQuestionCode()
     * @uses EventQuestion::setSurveyType()
     * @uses EventQuestion::setQuestionType()
     * @uses EventQuestion::setEventId()
     * @uses EventQuestion::setEventCode()
     * @uses EventQuestion::setEventTitle()
     * @uses EventQuestion::setProductName()
     * @uses EventQuestion::setProductId()
     * @uses EventQuestion::setInternalNote()
     * @uses EventQuestion::setAllowOther()
     * @uses EventQuestion::setOtherLabel()
     * @uses EventQuestion::setLastModifiedDate()
     * @param \StructType\AnswerDetail[] $answerDetail
     * @param \StructType\RowDetail[] $rowDetail
     * @param string $questionText
     * @param string $questionCode
     * @param string $surveyType
     * @param string $questionType
     * @param string $eventId
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $productName
     * @param string $productId
     * @param string $internalNote
     * @param bool $allowOther
     * @param string $otherLabel
     * @param string $lastModifiedDate
     */
    public function __construct(array $answerDetail = array(), array $rowDetail = array(), $questionText = null, $questionCode = null, $surveyType = null, $questionType = null, $eventId = null, $eventCode = null, $eventTitle = null, $productName = null, $productId = null, $internalNote = null, $allowOther = null, $otherLabel = null, $lastModifiedDate = null)
    {
        $this
            ->setAnswerDetail($answerDetail)
            ->setRowDetail($rowDetail)
            ->setQuestionText($questionText)
            ->setQuestionCode($questionCode)
            ->setSurveyType($surveyType)
            ->setQuestionType($questionType)
            ->setEventId($eventId)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setProductName($productName)
            ->setProductId($productId)
            ->setInternalNote($internalNote)
            ->setAllowOther($allowOther)
            ->setOtherLabel($otherLabel)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get AnswerDetail value
     * @return \StructType\AnswerDetail[]|null
     */
    public function getAnswerDetail()
    {
        return $this->AnswerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerDetailForArrayConstraintsFromSetAnswerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventQuestionAnswerDetailItem) {
            // validation for constraint: itemType
            if (!$eventQuestionAnswerDetailItem instanceof \StructType\AnswerDetail) {
                $invalidValues[] = is_object($eventQuestionAnswerDetailItem) ? get_class($eventQuestionAnswerDetailItem) : sprintf('%s(%s)', gettype($eventQuestionAnswerDetailItem), var_export($eventQuestionAnswerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail[] $answerDetail
     * @return \StructType\EventQuestion
     */
    public function setAnswerDetail(array $answerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($answerDetailArrayErrorMessage = self::validateAnswerDetailForArrayConstraintsFromSetAnswerDetail($answerDetail))) {
            throw new \InvalidArgumentException($answerDetailArrayErrorMessage, __LINE__);
        }
        $this->AnswerDetail = $answerDetail;
        return $this;
    }
    /**
     * Add item to AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail $item
     * @return \StructType\EventQuestion
     */
    public function addToAnswerDetail(\StructType\AnswerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnswerDetail) {
            throw new \InvalidArgumentException(sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnswerDetail[] = $item;
        return $this;
    }
    /**
     * Get RowDetail value
     * @return \StructType\RowDetail[]|null
     */
    public function getRowDetail()
    {
        return $this->RowDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRowDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRowDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRowDetailForArrayConstraintsFromSetRowDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventQuestionRowDetailItem) {
            // validation for constraint: itemType
            if (!$eventQuestionRowDetailItem instanceof \StructType\RowDetail) {
                $invalidValues[] = is_object($eventQuestionRowDetailItem) ? get_class($eventQuestionRowDetailItem) : sprintf('%s(%s)', gettype($eventQuestionRowDetailItem), var_export($eventQuestionRowDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RowDetail property can only contain items of type \StructType\RowDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RowDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetail[] $rowDetail
     * @return \StructType\EventQuestion
     */
    public function setRowDetail(array $rowDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($rowDetailArrayErrorMessage = self::validateRowDetailForArrayConstraintsFromSetRowDetail($rowDetail))) {
            throw new \InvalidArgumentException($rowDetailArrayErrorMessage, __LINE__);
        }
        $this->RowDetail = $rowDetail;
        return $this;
    }
    /**
     * Add item to RowDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RowDetail $item
     * @return \StructType\EventQuestion
     */
    public function addToRowDetail(\StructType\RowDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RowDetail) {
            throw new \InvalidArgumentException(sprintf('The RowDetail property can only contain items of type \StructType\RowDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RowDetail[] = $item;
        return $this;
    }
    /**
     * Get QuestionText value
     * @return string|null
     */
    public function getQuestionText()
    {
        return $this->QuestionText;
    }
    /**
     * Set QuestionText value
     * @param string $questionText
     * @return \StructType\EventQuestion
     */
    public function setQuestionText($questionText = null)
    {
        // validation for constraint: string
        if (!is_null($questionText) && !is_string($questionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionText, true), gettype($questionText)), __LINE__);
        }
        $this->QuestionText = $questionText;
        return $this;
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\EventQuestion
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get SurveyType value
     * @return string|null
     */
    public function getSurveyType()
    {
        return $this->SurveyType;
    }
    /**
     * Set SurveyType value
     * @param string $surveyType
     * @return \StructType\EventQuestion
     */
    public function setSurveyType($surveyType = null)
    {
        // validation for constraint: string
        if (!is_null($surveyType) && !is_string($surveyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyType, true), gettype($surveyType)), __LINE__);
        }
        $this->SurveyType = $surveyType;
        return $this;
    }
    /**
     * Get QuestionType value
     * @return string|null
     */
    public function getQuestionType()
    {
        return $this->QuestionType;
    }
    /**
     * Set QuestionType value
     * @param string $questionType
     * @return \StructType\EventQuestion
     */
    public function setQuestionType($questionType = null)
    {
        // validation for constraint: string
        if (!is_null($questionType) && !is_string($questionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionType, true), gettype($questionType)), __LINE__);
        }
        $this->QuestionType = $questionType;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\EventQuestion
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\EventQuestion
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\EventQuestion
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\EventQuestion
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\EventQuestion
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\EventQuestion
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get AllowOther value
     * @return bool|null
     */
    public function getAllowOther()
    {
        return $this->AllowOther;
    }
    /**
     * Set AllowOther value
     * @param bool $allowOther
     * @return \StructType\EventQuestion
     */
    public function setAllowOther($allowOther = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOther) && !is_bool($allowOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOther, true), gettype($allowOther)), __LINE__);
        }
        $this->AllowOther = $allowOther;
        return $this;
    }
    /**
     * Get OtherLabel value
     * @return string|null
     */
    public function getOtherLabel()
    {
        return $this->OtherLabel;
    }
    /**
     * Set OtherLabel value
     * @param string $otherLabel
     * @return \StructType\EventQuestion
     */
    public function setOtherLabel($otherLabel = null)
    {
        // validation for constraint: string
        if (!is_null($otherLabel) && !is_string($otherLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherLabel, true), gettype($otherLabel)), __LINE__);
        }
        $this->OtherLabel = $otherLabel;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\EventQuestion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventQuestion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
