<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventParameters StructType
 * @subpackage Structs
 */
class EventParameters extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Capacity
     * @var int
     */
    public $Capacity;
    /**
     * The LocationName
     * @var string
     */
    public $LocationName;
    /**
     * The Address1
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * @var string
     */
    public $Address3;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * The TimeZoneCode
     * @var string
     */
    public $TimeZoneCode;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * The PlannerFirstName
     * @var string
     */
    public $PlannerFirstName;
    /**
     * The PlannerLastName
     * @var string
     */
    public $PlannerLastName;
    /**
     * The PlannerEmailAddress
     * @var string
     */
    public $PlannerEmailAddress;
    /**
     * The RSVPByDate
     * @var string
     */
    public $RSVPByDate;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The PublishDate
     * @var string
     */
    public $PublishDate;
    /**
     * The ArchiveDate
     * @var string
     */
    public $ArchiveDate;
    /**
     * The PlannerPrefix
     * @var string
     */
    public $PlannerPrefix;
    /**
     * The PlannerCompany
     * @var string
     */
    public $PlannerCompany;
    /**
     * The PlannerTitle
     * @var string
     */
    public $PlannerTitle;
    /**
     * The StakeholderFirstName
     * @var string
     */
    public $StakeholderFirstName;
    /**
     * The StakeholderLastName
     * @var string
     */
    public $StakeholderLastName;
    /**
     * The StakeholderEmailAddress
     * @var string
     */
    public $StakeholderEmailAddress;
    /**
     * The StakeholderTitle
     * @var string
     */
    public $StakeholderTitle;
    /**
     * The StakeholderCompany
     * @var string
     */
    public $StakeholderCompany;
    /**
     * The StakeholderWorkPhone
     * @var string
     */
    public $StakeholderWorkPhone;
    /**
     * The StakeholderHomePhone
     * @var string
     */
    public $StakeholderHomePhone;
    /**
     * The StakeholderWorkFax
     * @var string
     */
    public $StakeholderWorkFax;
    /**
     * The StakeholderMobilePhone
     * @var string
     */
    public $StakeholderMobilePhone;
    /**
     * The StakeholderAddress1
     * @var string
     */
    public $StakeholderAddress1;
    /**
     * The StakeholderAddress2
     * @var string
     */
    public $StakeholderAddress2;
    /**
     * The StakeholderAddress3
     * @var string
     */
    public $StakeholderAddress3;
    /**
     * The StakeholderCity
     * @var string
     */
    public $StakeholderCity;
    /**
     * The StakeholderStateCode
     * @var string
     */
    public $StakeholderStateCode;
    /**
     * The StakeholderPostalCode
     * @var string
     */
    public $StakeholderPostalCode;
    /**
     * The StakeholderCountryCode
     * @var string
     */
    public $StakeholderCountryCode;
    /**
     * Constructor method for EventParameters
     * @uses EventParameters::setCustomFieldDetail()
     * @uses EventParameters::setTitle()
     * @uses EventParameters::setDescription()
     * @uses EventParameters::setCapacity()
     * @uses EventParameters::setLocationName()
     * @uses EventParameters::setAddress1()
     * @uses EventParameters::setAddress2()
     * @uses EventParameters::setAddress3()
     * @uses EventParameters::setCity()
     * @uses EventParameters::setStateCode()
     * @uses EventParameters::setPostalCode()
     * @uses EventParameters::setCountryCode()
     * @uses EventParameters::setPhone()
     * @uses EventParameters::setTimeZoneCode()
     * @uses EventParameters::setStartDate()
     * @uses EventParameters::setEndDate()
     * @uses EventParameters::setPlannerFirstName()
     * @uses EventParameters::setPlannerLastName()
     * @uses EventParameters::setPlannerEmailAddress()
     * @uses EventParameters::setRSVPByDate()
     * @uses EventParameters::setLanguage()
     * @uses EventParameters::setCategory()
     * @uses EventParameters::setInternalNote()
     * @uses EventParameters::setPublishDate()
     * @uses EventParameters::setArchiveDate()
     * @uses EventParameters::setPlannerPrefix()
     * @uses EventParameters::setPlannerCompany()
     * @uses EventParameters::setPlannerTitle()
     * @uses EventParameters::setStakeholderFirstName()
     * @uses EventParameters::setStakeholderLastName()
     * @uses EventParameters::setStakeholderEmailAddress()
     * @uses EventParameters::setStakeholderTitle()
     * @uses EventParameters::setStakeholderCompany()
     * @uses EventParameters::setStakeholderWorkPhone()
     * @uses EventParameters::setStakeholderHomePhone()
     * @uses EventParameters::setStakeholderWorkFax()
     * @uses EventParameters::setStakeholderMobilePhone()
     * @uses EventParameters::setStakeholderAddress1()
     * @uses EventParameters::setStakeholderAddress2()
     * @uses EventParameters::setStakeholderAddress3()
     * @uses EventParameters::setStakeholderCity()
     * @uses EventParameters::setStakeholderStateCode()
     * @uses EventParameters::setStakeholderPostalCode()
     * @uses EventParameters::setStakeholderCountryCode()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param string $title
     * @param string $description
     * @param int $capacity
     * @param string $locationName
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $stateCode
     * @param string $postalCode
     * @param string $countryCode
     * @param string $phone
     * @param string $timeZoneCode
     * @param string $startDate
     * @param string $endDate
     * @param string $plannerFirstName
     * @param string $plannerLastName
     * @param string $plannerEmailAddress
     * @param string $rSVPByDate
     * @param string $language
     * @param string $category
     * @param string $internalNote
     * @param string $publishDate
     * @param string $archiveDate
     * @param string $plannerPrefix
     * @param string $plannerCompany
     * @param string $plannerTitle
     * @param string $stakeholderFirstName
     * @param string $stakeholderLastName
     * @param string $stakeholderEmailAddress
     * @param string $stakeholderTitle
     * @param string $stakeholderCompany
     * @param string $stakeholderWorkPhone
     * @param string $stakeholderHomePhone
     * @param string $stakeholderWorkFax
     * @param string $stakeholderMobilePhone
     * @param string $stakeholderAddress1
     * @param string $stakeholderAddress2
     * @param string $stakeholderAddress3
     * @param string $stakeholderCity
     * @param string $stakeholderStateCode
     * @param string $stakeholderPostalCode
     * @param string $stakeholderCountryCode
     */
    public function __construct(array $customFieldDetail = array(), $title = null, $description = null, $capacity = null, $locationName = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $stateCode = null, $postalCode = null, $countryCode = null, $phone = null, $timeZoneCode = null, $startDate = null, $endDate = null, $plannerFirstName = null, $plannerLastName = null, $plannerEmailAddress = null, $rSVPByDate = null, $language = null, $category = null, $internalNote = null, $publishDate = null, $archiveDate = null, $plannerPrefix = null, $plannerCompany = null, $plannerTitle = null, $stakeholderFirstName = null, $stakeholderLastName = null, $stakeholderEmailAddress = null, $stakeholderTitle = null, $stakeholderCompany = null, $stakeholderWorkPhone = null, $stakeholderHomePhone = null, $stakeholderWorkFax = null, $stakeholderMobilePhone = null, $stakeholderAddress1 = null, $stakeholderAddress2 = null, $stakeholderAddress3 = null, $stakeholderCity = null, $stakeholderStateCode = null, $stakeholderPostalCode = null, $stakeholderCountryCode = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setTitle($title)
            ->setDescription($description)
            ->setCapacity($capacity)
            ->setLocationName($locationName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode)
            ->setPhone($phone)
            ->setTimeZoneCode($timeZoneCode)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPlannerFirstName($plannerFirstName)
            ->setPlannerLastName($plannerLastName)
            ->setPlannerEmailAddress($plannerEmailAddress)
            ->setRSVPByDate($rSVPByDate)
            ->setLanguage($language)
            ->setCategory($category)
            ->setInternalNote($internalNote)
            ->setPublishDate($publishDate)
            ->setArchiveDate($archiveDate)
            ->setPlannerPrefix($plannerPrefix)
            ->setPlannerCompany($plannerCompany)
            ->setPlannerTitle($plannerTitle)
            ->setStakeholderFirstName($stakeholderFirstName)
            ->setStakeholderLastName($stakeholderLastName)
            ->setStakeholderEmailAddress($stakeholderEmailAddress)
            ->setStakeholderTitle($stakeholderTitle)
            ->setStakeholderCompany($stakeholderCompany)
            ->setStakeholderWorkPhone($stakeholderWorkPhone)
            ->setStakeholderHomePhone($stakeholderHomePhone)
            ->setStakeholderWorkFax($stakeholderWorkFax)
            ->setStakeholderMobilePhone($stakeholderMobilePhone)
            ->setStakeholderAddress1($stakeholderAddress1)
            ->setStakeholderAddress2($stakeholderAddress2)
            ->setStakeholderAddress3($stakeholderAddress3)
            ->setStakeholderCity($stakeholderCity)
            ->setStakeholderStateCode($stakeholderStateCode)
            ->setStakeholderPostalCode($stakeholderPostalCode)
            ->setStakeholderCountryCode($stakeholderCountryCode);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventParametersCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$eventParametersCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($eventParametersCustomFieldDetailItem) ? get_class($eventParametersCustomFieldDetailItem) : sprintf('%s(%s)', gettype($eventParametersCustomFieldDetailItem), var_export($eventParametersCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\EventParameters
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\EventParameters
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\EventParameters
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\EventParameters
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\EventParameters
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \StructType\EventParameters
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\EventParameters
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\EventParameters
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\EventParameters
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\EventParameters
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\EventParameters
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\EventParameters
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\EventParameters
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\EventParameters
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return $this->TimeZoneCode;
    }
    /**
     * Set TimeZoneCode value
     * @param string $timeZoneCode
     * @return \StructType\EventParameters
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneCode, true), gettype($timeZoneCode)), __LINE__);
        }
        $this->TimeZoneCode = $timeZoneCode;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\EventParameters
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EventParameters
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get PlannerFirstName value
     * @return string|null
     */
    public function getPlannerFirstName()
    {
        return $this->PlannerFirstName;
    }
    /**
     * Set PlannerFirstName value
     * @param string $plannerFirstName
     * @return \StructType\EventParameters
     */
    public function setPlannerFirstName($plannerFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerFirstName) && !is_string($plannerFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerFirstName, true), gettype($plannerFirstName)), __LINE__);
        }
        $this->PlannerFirstName = $plannerFirstName;
        return $this;
    }
    /**
     * Get PlannerLastName value
     * @return string|null
     */
    public function getPlannerLastName()
    {
        return $this->PlannerLastName;
    }
    /**
     * Set PlannerLastName value
     * @param string $plannerLastName
     * @return \StructType\EventParameters
     */
    public function setPlannerLastName($plannerLastName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerLastName) && !is_string($plannerLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerLastName, true), gettype($plannerLastName)), __LINE__);
        }
        $this->PlannerLastName = $plannerLastName;
        return $this;
    }
    /**
     * Get PlannerEmailAddress value
     * @return string|null
     */
    public function getPlannerEmailAddress()
    {
        return $this->PlannerEmailAddress;
    }
    /**
     * Set PlannerEmailAddress value
     * @param string $plannerEmailAddress
     * @return \StructType\EventParameters
     */
    public function setPlannerEmailAddress($plannerEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($plannerEmailAddress) && !is_string($plannerEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerEmailAddress, true), gettype($plannerEmailAddress)), __LINE__);
        }
        $this->PlannerEmailAddress = $plannerEmailAddress;
        return $this;
    }
    /**
     * Get RSVPByDate value
     * @return string|null
     */
    public function getRSVPByDate()
    {
        return $this->RSVPByDate;
    }
    /**
     * Set RSVPByDate value
     * @param string $rSVPByDate
     * @return \StructType\EventParameters
     */
    public function setRSVPByDate($rSVPByDate = null)
    {
        // validation for constraint: string
        if (!is_null($rSVPByDate) && !is_string($rSVPByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rSVPByDate, true), gettype($rSVPByDate)), __LINE__);
        }
        $this->RSVPByDate = $rSVPByDate;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @uses \EnumType\EventLanguage::valueIsValid()
     * @uses \EnumType\EventLanguage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\EventParameters
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventLanguage::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EventLanguage', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\EventLanguage::getValidValues())), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\EventCategory::valueIsValid()
     * @uses \EnumType\EventCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\EventParameters
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventCategory::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EventCategory', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\EventCategory::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\EventParameters
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get PublishDate value
     * @return string|null
     */
    public function getPublishDate()
    {
        return $this->PublishDate;
    }
    /**
     * Set PublishDate value
     * @param string $publishDate
     * @return \StructType\EventParameters
     */
    public function setPublishDate($publishDate = null)
    {
        // validation for constraint: string
        if (!is_null($publishDate) && !is_string($publishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishDate, true), gettype($publishDate)), __LINE__);
        }
        $this->PublishDate = $publishDate;
        return $this;
    }
    /**
     * Get ArchiveDate value
     * @return string|null
     */
    public function getArchiveDate()
    {
        return $this->ArchiveDate;
    }
    /**
     * Set ArchiveDate value
     * @param string $archiveDate
     * @return \StructType\EventParameters
     */
    public function setArchiveDate($archiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveDate) && !is_string($archiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveDate, true), gettype($archiveDate)), __LINE__);
        }
        $this->ArchiveDate = $archiveDate;
        return $this;
    }
    /**
     * Get PlannerPrefix value
     * @return string|null
     */
    public function getPlannerPrefix()
    {
        return $this->PlannerPrefix;
    }
    /**
     * Set PlannerPrefix value
     * @param string $plannerPrefix
     * @return \StructType\EventParameters
     */
    public function setPlannerPrefix($plannerPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($plannerPrefix) && !is_string($plannerPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerPrefix, true), gettype($plannerPrefix)), __LINE__);
        }
        $this->PlannerPrefix = $plannerPrefix;
        return $this;
    }
    /**
     * Get PlannerCompany value
     * @return string|null
     */
    public function getPlannerCompany()
    {
        return $this->PlannerCompany;
    }
    /**
     * Set PlannerCompany value
     * @param string $plannerCompany
     * @return \StructType\EventParameters
     */
    public function setPlannerCompany($plannerCompany = null)
    {
        // validation for constraint: string
        if (!is_null($plannerCompany) && !is_string($plannerCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerCompany, true), gettype($plannerCompany)), __LINE__);
        }
        $this->PlannerCompany = $plannerCompany;
        return $this;
    }
    /**
     * Get PlannerTitle value
     * @return string|null
     */
    public function getPlannerTitle()
    {
        return $this->PlannerTitle;
    }
    /**
     * Set PlannerTitle value
     * @param string $plannerTitle
     * @return \StructType\EventParameters
     */
    public function setPlannerTitle($plannerTitle = null)
    {
        // validation for constraint: string
        if (!is_null($plannerTitle) && !is_string($plannerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerTitle, true), gettype($plannerTitle)), __LINE__);
        }
        $this->PlannerTitle = $plannerTitle;
        return $this;
    }
    /**
     * Get StakeholderFirstName value
     * @return string|null
     */
    public function getStakeholderFirstName()
    {
        return $this->StakeholderFirstName;
    }
    /**
     * Set StakeholderFirstName value
     * @param string $stakeholderFirstName
     * @return \StructType\EventParameters
     */
    public function setStakeholderFirstName($stakeholderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderFirstName) && !is_string($stakeholderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderFirstName, true), gettype($stakeholderFirstName)), __LINE__);
        }
        $this->StakeholderFirstName = $stakeholderFirstName;
        return $this;
    }
    /**
     * Get StakeholderLastName value
     * @return string|null
     */
    public function getStakeholderLastName()
    {
        return $this->StakeholderLastName;
    }
    /**
     * Set StakeholderLastName value
     * @param string $stakeholderLastName
     * @return \StructType\EventParameters
     */
    public function setStakeholderLastName($stakeholderLastName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderLastName) && !is_string($stakeholderLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderLastName, true), gettype($stakeholderLastName)), __LINE__);
        }
        $this->StakeholderLastName = $stakeholderLastName;
        return $this;
    }
    /**
     * Get StakeholderEmailAddress value
     * @return string|null
     */
    public function getStakeholderEmailAddress()
    {
        return $this->StakeholderEmailAddress;
    }
    /**
     * Set StakeholderEmailAddress value
     * @param string $stakeholderEmailAddress
     * @return \StructType\EventParameters
     */
    public function setStakeholderEmailAddress($stakeholderEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderEmailAddress) && !is_string($stakeholderEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderEmailAddress, true), gettype($stakeholderEmailAddress)), __LINE__);
        }
        $this->StakeholderEmailAddress = $stakeholderEmailAddress;
        return $this;
    }
    /**
     * Get StakeholderTitle value
     * @return string|null
     */
    public function getStakeholderTitle()
    {
        return $this->StakeholderTitle;
    }
    /**
     * Set StakeholderTitle value
     * @param string $stakeholderTitle
     * @return \StructType\EventParameters
     */
    public function setStakeholderTitle($stakeholderTitle = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderTitle) && !is_string($stakeholderTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderTitle, true), gettype($stakeholderTitle)), __LINE__);
        }
        $this->StakeholderTitle = $stakeholderTitle;
        return $this;
    }
    /**
     * Get StakeholderCompany value
     * @return string|null
     */
    public function getStakeholderCompany()
    {
        return $this->StakeholderCompany;
    }
    /**
     * Set StakeholderCompany value
     * @param string $stakeholderCompany
     * @return \StructType\EventParameters
     */
    public function setStakeholderCompany($stakeholderCompany = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCompany) && !is_string($stakeholderCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCompany, true), gettype($stakeholderCompany)), __LINE__);
        }
        $this->StakeholderCompany = $stakeholderCompany;
        return $this;
    }
    /**
     * Get StakeholderWorkPhone value
     * @return string|null
     */
    public function getStakeholderWorkPhone()
    {
        return $this->StakeholderWorkPhone;
    }
    /**
     * Set StakeholderWorkPhone value
     * @param string $stakeholderWorkPhone
     * @return \StructType\EventParameters
     */
    public function setStakeholderWorkPhone($stakeholderWorkPhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkPhone) && !is_string($stakeholderWorkPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkPhone, true), gettype($stakeholderWorkPhone)), __LINE__);
        }
        $this->StakeholderWorkPhone = $stakeholderWorkPhone;
        return $this;
    }
    /**
     * Get StakeholderHomePhone value
     * @return string|null
     */
    public function getStakeholderHomePhone()
    {
        return $this->StakeholderHomePhone;
    }
    /**
     * Set StakeholderHomePhone value
     * @param string $stakeholderHomePhone
     * @return \StructType\EventParameters
     */
    public function setStakeholderHomePhone($stakeholderHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderHomePhone) && !is_string($stakeholderHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderHomePhone, true), gettype($stakeholderHomePhone)), __LINE__);
        }
        $this->StakeholderHomePhone = $stakeholderHomePhone;
        return $this;
    }
    /**
     * Get StakeholderWorkFax value
     * @return string|null
     */
    public function getStakeholderWorkFax()
    {
        return $this->StakeholderWorkFax;
    }
    /**
     * Set StakeholderWorkFax value
     * @param string $stakeholderWorkFax
     * @return \StructType\EventParameters
     */
    public function setStakeholderWorkFax($stakeholderWorkFax = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkFax) && !is_string($stakeholderWorkFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkFax, true), gettype($stakeholderWorkFax)), __LINE__);
        }
        $this->StakeholderWorkFax = $stakeholderWorkFax;
        return $this;
    }
    /**
     * Get StakeholderMobilePhone value
     * @return string|null
     */
    public function getStakeholderMobilePhone()
    {
        return $this->StakeholderMobilePhone;
    }
    /**
     * Set StakeholderMobilePhone value
     * @param string $stakeholderMobilePhone
     * @return \StructType\EventParameters
     */
    public function setStakeholderMobilePhone($stakeholderMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderMobilePhone) && !is_string($stakeholderMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderMobilePhone, true), gettype($stakeholderMobilePhone)), __LINE__);
        }
        $this->StakeholderMobilePhone = $stakeholderMobilePhone;
        return $this;
    }
    /**
     * Get StakeholderAddress1 value
     * @return string|null
     */
    public function getStakeholderAddress1()
    {
        return $this->StakeholderAddress1;
    }
    /**
     * Set StakeholderAddress1 value
     * @param string $stakeholderAddress1
     * @return \StructType\EventParameters
     */
    public function setStakeholderAddress1($stakeholderAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress1) && !is_string($stakeholderAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress1, true), gettype($stakeholderAddress1)), __LINE__);
        }
        $this->StakeholderAddress1 = $stakeholderAddress1;
        return $this;
    }
    /**
     * Get StakeholderAddress2 value
     * @return string|null
     */
    public function getStakeholderAddress2()
    {
        return $this->StakeholderAddress2;
    }
    /**
     * Set StakeholderAddress2 value
     * @param string $stakeholderAddress2
     * @return \StructType\EventParameters
     */
    public function setStakeholderAddress2($stakeholderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress2) && !is_string($stakeholderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress2, true), gettype($stakeholderAddress2)), __LINE__);
        }
        $this->StakeholderAddress2 = $stakeholderAddress2;
        return $this;
    }
    /**
     * Get StakeholderAddress3 value
     * @return string|null
     */
    public function getStakeholderAddress3()
    {
        return $this->StakeholderAddress3;
    }
    /**
     * Set StakeholderAddress3 value
     * @param string $stakeholderAddress3
     * @return \StructType\EventParameters
     */
    public function setStakeholderAddress3($stakeholderAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress3) && !is_string($stakeholderAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress3, true), gettype($stakeholderAddress3)), __LINE__);
        }
        $this->StakeholderAddress3 = $stakeholderAddress3;
        return $this;
    }
    /**
     * Get StakeholderCity value
     * @return string|null
     */
    public function getStakeholderCity()
    {
        return $this->StakeholderCity;
    }
    /**
     * Set StakeholderCity value
     * @param string $stakeholderCity
     * @return \StructType\EventParameters
     */
    public function setStakeholderCity($stakeholderCity = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCity) && !is_string($stakeholderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCity, true), gettype($stakeholderCity)), __LINE__);
        }
        $this->StakeholderCity = $stakeholderCity;
        return $this;
    }
    /**
     * Get StakeholderStateCode value
     * @return string|null
     */
    public function getStakeholderStateCode()
    {
        return $this->StakeholderStateCode;
    }
    /**
     * Set StakeholderStateCode value
     * @param string $stakeholderStateCode
     * @return \StructType\EventParameters
     */
    public function setStakeholderStateCode($stakeholderStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderStateCode) && !is_string($stakeholderStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderStateCode, true), gettype($stakeholderStateCode)), __LINE__);
        }
        $this->StakeholderStateCode = $stakeholderStateCode;
        return $this;
    }
    /**
     * Get StakeholderPostalCode value
     * @return string|null
     */
    public function getStakeholderPostalCode()
    {
        return $this->StakeholderPostalCode;
    }
    /**
     * Set StakeholderPostalCode value
     * @param string $stakeholderPostalCode
     * @return \StructType\EventParameters
     */
    public function setStakeholderPostalCode($stakeholderPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderPostalCode) && !is_string($stakeholderPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderPostalCode, true), gettype($stakeholderPostalCode)), __LINE__);
        }
        $this->StakeholderPostalCode = $stakeholderPostalCode;
        return $this;
    }
    /**
     * Get StakeholderCountryCode value
     * @return string|null
     */
    public function getStakeholderCountryCode()
    {
        return $this->StakeholderCountryCode;
    }
    /**
     * Set StakeholderCountryCode value
     * @param string $stakeholderCountryCode
     * @return \StructType\EventParameters
     */
    public function setStakeholderCountryCode($stakeholderCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCountryCode) && !is_string($stakeholderCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCountryCode, true), gettype($stakeholderCountryCode)), __LINE__);
        }
        $this->StakeholderCountryCode = $stakeholderCountryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
