<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventEmailHistory StructType
 * @subpackage Structs
 */
class EventEmailHistory extends CvObject
{
    /**
     * The EventId
     * @var string
     */
    public $EventId;
    /**
     * The InviteeId
     * @var string
     */
    public $InviteeId;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The TargetList
     * @var string
     */
    public $TargetList;
    /**
     * The EmailSentDate
     * @var string
     */
    public $EmailSentDate;
    /**
     * The EmailStatus
     * @var string
     */
    public $EmailStatus;
    /**
     * The EmailType
     * @var string
     */
    public $EmailType;
    /**
     * The FromEmailAddress
     * @var string
     */
    public $FromEmailAddress;
    /**
     * The ToEmailAddress
     * @var string
     */
    public $ToEmailAddress;
    /**
     * The EmailViewed
     * @var bool
     */
    public $EmailViewed;
    /**
     * The EmailBounced
     * @var bool
     */
    public $EmailBounced;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for EventEmailHistory
     * @uses EventEmailHistory::setEventId()
     * @uses EventEmailHistory::setInviteeId()
     * @uses EventEmailHistory::setContactId()
     * @uses EventEmailHistory::setTargetList()
     * @uses EventEmailHistory::setEmailSentDate()
     * @uses EventEmailHistory::setEmailStatus()
     * @uses EventEmailHistory::setEmailType()
     * @uses EventEmailHistory::setFromEmailAddress()
     * @uses EventEmailHistory::setToEmailAddress()
     * @uses EventEmailHistory::setEmailViewed()
     * @uses EventEmailHistory::setEmailBounced()
     * @uses EventEmailHistory::setLastModifiedDate()
     * @param string $eventId
     * @param string $inviteeId
     * @param string $contactId
     * @param string $targetList
     * @param string $emailSentDate
     * @param string $emailStatus
     * @param string $emailType
     * @param string $fromEmailAddress
     * @param string $toEmailAddress
     * @param bool $emailViewed
     * @param bool $emailBounced
     * @param string $lastModifiedDate
     */
    public function __construct($eventId = null, $inviteeId = null, $contactId = null, $targetList = null, $emailSentDate = null, $emailStatus = null, $emailType = null, $fromEmailAddress = null, $toEmailAddress = null, $emailViewed = null, $emailBounced = null, $lastModifiedDate = null)
    {
        $this
            ->setEventId($eventId)
            ->setInviteeId($inviteeId)
            ->setContactId($contactId)
            ->setTargetList($targetList)
            ->setEmailSentDate($emailSentDate)
            ->setEmailStatus($emailStatus)
            ->setEmailType($emailType)
            ->setFromEmailAddress($fromEmailAddress)
            ->setToEmailAddress($toEmailAddress)
            ->setEmailViewed($emailViewed)
            ->setEmailBounced($emailBounced)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\EventEmailHistory
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get InviteeId value
     * @return string|null
     */
    public function getInviteeId()
    {
        return $this->InviteeId;
    }
    /**
     * Set InviteeId value
     * @param string $inviteeId
     * @return \StructType\EventEmailHistory
     */
    public function setInviteeId($inviteeId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeId) && !is_string($inviteeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeId, true), gettype($inviteeId)), __LINE__);
        }
        $this->InviteeId = $inviteeId;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\EventEmailHistory
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get TargetList value
     * @return string|null
     */
    public function getTargetList()
    {
        return $this->TargetList;
    }
    /**
     * Set TargetList value
     * @param string $targetList
     * @return \StructType\EventEmailHistory
     */
    public function setTargetList($targetList = null)
    {
        // validation for constraint: string
        if (!is_null($targetList) && !is_string($targetList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetList, true), gettype($targetList)), __LINE__);
        }
        $this->TargetList = $targetList;
        return $this;
    }
    /**
     * Get EmailSentDate value
     * @return string|null
     */
    public function getEmailSentDate()
    {
        return $this->EmailSentDate;
    }
    /**
     * Set EmailSentDate value
     * @param string $emailSentDate
     * @return \StructType\EventEmailHistory
     */
    public function setEmailSentDate($emailSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($emailSentDate) && !is_string($emailSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSentDate, true), gettype($emailSentDate)), __LINE__);
        }
        $this->EmailSentDate = $emailSentDate;
        return $this;
    }
    /**
     * Get EmailStatus value
     * @return string|null
     */
    public function getEmailStatus()
    {
        return $this->EmailStatus;
    }
    /**
     * Set EmailStatus value
     * @param string $emailStatus
     * @return \StructType\EventEmailHistory
     */
    public function setEmailStatus($emailStatus = null)
    {
        // validation for constraint: string
        if (!is_null($emailStatus) && !is_string($emailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailStatus, true), gettype($emailStatus)), __LINE__);
        }
        $this->EmailStatus = $emailStatus;
        return $this;
    }
    /**
     * Get EmailType value
     * @return string|null
     */
    public function getEmailType()
    {
        return $this->EmailType;
    }
    /**
     * Set EmailType value
     * @param string $emailType
     * @return \StructType\EventEmailHistory
     */
    public function setEmailType($emailType = null)
    {
        // validation for constraint: string
        if (!is_null($emailType) && !is_string($emailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailType, true), gettype($emailType)), __LINE__);
        }
        $this->EmailType = $emailType;
        return $this;
    }
    /**
     * Get FromEmailAddress value
     * @return string|null
     */
    public function getFromEmailAddress()
    {
        return $this->FromEmailAddress;
    }
    /**
     * Set FromEmailAddress value
     * @param string $fromEmailAddress
     * @return \StructType\EventEmailHistory
     */
    public function setFromEmailAddress($fromEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmailAddress) && !is_string($fromEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmailAddress, true), gettype($fromEmailAddress)), __LINE__);
        }
        $this->FromEmailAddress = $fromEmailAddress;
        return $this;
    }
    /**
     * Get ToEmailAddress value
     * @return string|null
     */
    public function getToEmailAddress()
    {
        return $this->ToEmailAddress;
    }
    /**
     * Set ToEmailAddress value
     * @param string $toEmailAddress
     * @return \StructType\EventEmailHistory
     */
    public function setToEmailAddress($toEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($toEmailAddress) && !is_string($toEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEmailAddress, true), gettype($toEmailAddress)), __LINE__);
        }
        $this->ToEmailAddress = $toEmailAddress;
        return $this;
    }
    /**
     * Get EmailViewed value
     * @return bool|null
     */
    public function getEmailViewed()
    {
        return $this->EmailViewed;
    }
    /**
     * Set EmailViewed value
     * @param bool $emailViewed
     * @return \StructType\EventEmailHistory
     */
    public function setEmailViewed($emailViewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailViewed) && !is_bool($emailViewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailViewed, true), gettype($emailViewed)), __LINE__);
        }
        $this->EmailViewed = $emailViewed;
        return $this;
    }
    /**
     * Get EmailBounced value
     * @return bool|null
     */
    public function getEmailBounced()
    {
        return $this->EmailBounced;
    }
    /**
     * Set EmailBounced value
     * @param bool $emailBounced
     * @return \StructType\EventEmailHistory
     */
    public function setEmailBounced($emailBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailBounced) && !is_bool($emailBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailBounced, true), gettype($emailBounced)), __LINE__);
        }
        $this->EmailBounced = $emailBounced;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\EventEmailHistory
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventEmailHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
