<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventDetail StructType
 * @subpackage Structs
 */
class EventDetail extends CvObject
{
    /**
     * The PlanningStatusHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PlanningStatusHistory[]
     */
    public $PlanningStatusHistory;
    /**
     * The ProcessFormDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProcessFormDetail[]
     */
    public $ProcessFormDetail;
    /**
     * The EventRoleDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventRoleDetail[]
     */
    public $EventRoleDetail;
    /**
     * The FAQDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FAQDetail[]
     */
    public $FAQDetail;
    /**
     * The StaffDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StaffDetail[]
     */
    public $StaffDetail;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Fees[]
     */
    public $Fees;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventDescription
     * @var string
     */
    public $EventDescription;
    /**
     * The EventStatus
     * @var string
     */
    public $EventStatus;
    /**
     * The EventSummaryHeader
     * @var string
     */
    public $EventSummaryHeader;
    /**
     * The PlanningStatus
     * @var string
     */
    public $PlanningStatus;
    /**
     * The TotalInvitedCount
     * @var int
     */
    public $TotalInvitedCount;
    /**
     * The RegisteredAttendeeCount
     * @var int
     */
    public $RegisteredAttendeeCount;
    /**
     * The ParticipantCount
     * @var int
     */
    public $ParticipantCount;
    /**
     * The DeclineeCount
     * @var int
     */
    public $DeclineeCount;
    /**
     * The CancelledCount
     * @var int
     */
    public $CancelledCount;
    /**
     * The RequestID
     * @var string
     */
    public $RequestID;
    /**
     * The RequestName
     * @var string
     */
    public $RequestName;
    /**
     * The RequestStatus
     * @var string
     */
    public $RequestStatus;
    /**
     * The RequestCode
     * @var string
     */
    public $RequestCode;
    /**
     * The RequesterFirstName
     * @var string
     */
    public $RequesterFirstName;
    /**
     * The RequesterLastName
     * @var string
     */
    public $RequesterLastName;
    /**
     * The RequesterID
     * @var string
     */
    public $RequesterID;
    /**
     * The RequestSubmittedDate
     * @var string
     */
    public $RequestSubmittedDate;
    /**
     * Constructor method for EventDetail
     * @uses EventDetail::setPlanningStatusHistory()
     * @uses EventDetail::setProcessFormDetail()
     * @uses EventDetail::setEventRoleDetail()
     * @uses EventDetail::setFAQDetail()
     * @uses EventDetail::setStaffDetail()
     * @uses EventDetail::setFees()
     * @uses EventDetail::setEventCode()
     * @uses EventDetail::setEventTitle()
     * @uses EventDetail::setEventDescription()
     * @uses EventDetail::setEventStatus()
     * @uses EventDetail::setEventSummaryHeader()
     * @uses EventDetail::setPlanningStatus()
     * @uses EventDetail::setTotalInvitedCount()
     * @uses EventDetail::setRegisteredAttendeeCount()
     * @uses EventDetail::setParticipantCount()
     * @uses EventDetail::setDeclineeCount()
     * @uses EventDetail::setCancelledCount()
     * @uses EventDetail::setRequestID()
     * @uses EventDetail::setRequestName()
     * @uses EventDetail::setRequestStatus()
     * @uses EventDetail::setRequestCode()
     * @uses EventDetail::setRequesterFirstName()
     * @uses EventDetail::setRequesterLastName()
     * @uses EventDetail::setRequesterID()
     * @uses EventDetail::setRequestSubmittedDate()
     * @param \StructType\PlanningStatusHistory[] $planningStatusHistory
     * @param \StructType\ProcessFormDetail[] $processFormDetail
     * @param \StructType\EventRoleDetail[] $eventRoleDetail
     * @param \StructType\FAQDetail[] $fAQDetail
     * @param \StructType\StaffDetail[] $staffDetail
     * @param \StructType\Fees[] $fees
     * @param string $eventCode
     * @param string $eventTitle
     * @param string $eventDescription
     * @param string $eventStatus
     * @param string $eventSummaryHeader
     * @param string $planningStatus
     * @param int $totalInvitedCount
     * @param int $registeredAttendeeCount
     * @param int $participantCount
     * @param int $declineeCount
     * @param int $cancelledCount
     * @param string $requestID
     * @param string $requestName
     * @param string $requestStatus
     * @param string $requestCode
     * @param string $requesterFirstName
     * @param string $requesterLastName
     * @param string $requesterID
     * @param string $requestSubmittedDate
     */
    public function __construct(array $planningStatusHistory = array(), array $processFormDetail = array(), array $eventRoleDetail = array(), array $fAQDetail = array(), array $staffDetail = array(), array $fees = array(), $eventCode = null, $eventTitle = null, $eventDescription = null, $eventStatus = null, $eventSummaryHeader = null, $planningStatus = null, $totalInvitedCount = null, $registeredAttendeeCount = null, $participantCount = null, $declineeCount = null, $cancelledCount = null, $requestID = null, $requestName = null, $requestStatus = null, $requestCode = null, $requesterFirstName = null, $requesterLastName = null, $requesterID = null, $requestSubmittedDate = null)
    {
        $this
            ->setPlanningStatusHistory($planningStatusHistory)
            ->setProcessFormDetail($processFormDetail)
            ->setEventRoleDetail($eventRoleDetail)
            ->setFAQDetail($fAQDetail)
            ->setStaffDetail($staffDetail)
            ->setFees($fees)
            ->setEventCode($eventCode)
            ->setEventTitle($eventTitle)
            ->setEventDescription($eventDescription)
            ->setEventStatus($eventStatus)
            ->setEventSummaryHeader($eventSummaryHeader)
            ->setPlanningStatus($planningStatus)
            ->setTotalInvitedCount($totalInvitedCount)
            ->setRegisteredAttendeeCount($registeredAttendeeCount)
            ->setParticipantCount($participantCount)
            ->setDeclineeCount($declineeCount)
            ->setCancelledCount($cancelledCount)
            ->setRequestID($requestID)
            ->setRequestName($requestName)
            ->setRequestStatus($requestStatus)
            ->setRequestCode($requestCode)
            ->setRequesterFirstName($requesterFirstName)
            ->setRequesterLastName($requesterLastName)
            ->setRequesterID($requesterID)
            ->setRequestSubmittedDate($requestSubmittedDate);
    }
    /**
     * Get PlanningStatusHistory value
     * @return \StructType\PlanningStatusHistory[]|null
     */
    public function getPlanningStatusHistory()
    {
        return $this->PlanningStatusHistory;
    }
    /**
     * This method is responsible for validating the values passed to the setPlanningStatusHistory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlanningStatusHistory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlanningStatusHistoryForArrayConstraintsFromSetPlanningStatusHistory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailPlanningStatusHistoryItem) {
            // validation for constraint: itemType
            if (!$eventDetailPlanningStatusHistoryItem instanceof \StructType\PlanningStatusHistory) {
                $invalidValues[] = is_object($eventDetailPlanningStatusHistoryItem) ? get_class($eventDetailPlanningStatusHistoryItem) : sprintf('%s(%s)', gettype($eventDetailPlanningStatusHistoryItem), var_export($eventDetailPlanningStatusHistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PlanningStatusHistory property can only contain items of type \StructType\PlanningStatusHistory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PlanningStatusHistory value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningStatusHistory[] $planningStatusHistory
     * @return \StructType\EventDetail
     */
    public function setPlanningStatusHistory(array $planningStatusHistory = array())
    {
        // validation for constraint: array
        if ('' !== ($planningStatusHistoryArrayErrorMessage = self::validatePlanningStatusHistoryForArrayConstraintsFromSetPlanningStatusHistory($planningStatusHistory))) {
            throw new \InvalidArgumentException($planningStatusHistoryArrayErrorMessage, __LINE__);
        }
        $this->PlanningStatusHistory = $planningStatusHistory;
        return $this;
    }
    /**
     * Add item to PlanningStatusHistory value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningStatusHistory $item
     * @return \StructType\EventDetail
     */
    public function addToPlanningStatusHistory(\StructType\PlanningStatusHistory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningStatusHistory) {
            throw new \InvalidArgumentException(sprintf('The PlanningStatusHistory property can only contain items of type \StructType\PlanningStatusHistory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PlanningStatusHistory[] = $item;
        return $this;
    }
    /**
     * Get ProcessFormDetail value
     * @return \StructType\ProcessFormDetail[]|null
     */
    public function getProcessFormDetail()
    {
        return $this->ProcessFormDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setProcessFormDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcessFormDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcessFormDetailForArrayConstraintsFromSetProcessFormDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailProcessFormDetailItem) {
            // validation for constraint: itemType
            if (!$eventDetailProcessFormDetailItem instanceof \StructType\ProcessFormDetail) {
                $invalidValues[] = is_object($eventDetailProcessFormDetailItem) ? get_class($eventDetailProcessFormDetailItem) : sprintf('%s(%s)', gettype($eventDetailProcessFormDetailItem), var_export($eventDetailProcessFormDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProcessFormDetail property can only contain items of type \StructType\ProcessFormDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProcessFormDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessFormDetail[] $processFormDetail
     * @return \StructType\EventDetail
     */
    public function setProcessFormDetail(array $processFormDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($processFormDetailArrayErrorMessage = self::validateProcessFormDetailForArrayConstraintsFromSetProcessFormDetail($processFormDetail))) {
            throw new \InvalidArgumentException($processFormDetailArrayErrorMessage, __LINE__);
        }
        $this->ProcessFormDetail = $processFormDetail;
        return $this;
    }
    /**
     * Add item to ProcessFormDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProcessFormDetail $item
     * @return \StructType\EventDetail
     */
    public function addToProcessFormDetail(\StructType\ProcessFormDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProcessFormDetail) {
            throw new \InvalidArgumentException(sprintf('The ProcessFormDetail property can only contain items of type \StructType\ProcessFormDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProcessFormDetail[] = $item;
        return $this;
    }
    /**
     * Get EventRoleDetail value
     * @return \StructType\EventRoleDetail[]|null
     */
    public function getEventRoleDetail()
    {
        return $this->EventRoleDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEventRoleDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventRoleDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventRoleDetailForArrayConstraintsFromSetEventRoleDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailEventRoleDetailItem) {
            // validation for constraint: itemType
            if (!$eventDetailEventRoleDetailItem instanceof \StructType\EventRoleDetail) {
                $invalidValues[] = is_object($eventDetailEventRoleDetailItem) ? get_class($eventDetailEventRoleDetailItem) : sprintf('%s(%s)', gettype($eventDetailEventRoleDetailItem), var_export($eventDetailEventRoleDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventRoleDetail property can only contain items of type \StructType\EventRoleDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventRoleDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRoleDetail[] $eventRoleDetail
     * @return \StructType\EventDetail
     */
    public function setEventRoleDetail(array $eventRoleDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($eventRoleDetailArrayErrorMessage = self::validateEventRoleDetailForArrayConstraintsFromSetEventRoleDetail($eventRoleDetail))) {
            throw new \InvalidArgumentException($eventRoleDetailArrayErrorMessage, __LINE__);
        }
        $this->EventRoleDetail = $eventRoleDetail;
        return $this;
    }
    /**
     * Add item to EventRoleDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRoleDetail $item
     * @return \StructType\EventDetail
     */
    public function addToEventRoleDetail(\StructType\EventRoleDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventRoleDetail) {
            throw new \InvalidArgumentException(sprintf('The EventRoleDetail property can only contain items of type \StructType\EventRoleDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventRoleDetail[] = $item;
        return $this;
    }
    /**
     * Get FAQDetail value
     * @return \StructType\FAQDetail[]|null
     */
    public function getFAQDetail()
    {
        return $this->FAQDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFAQDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFAQDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFAQDetailForArrayConstraintsFromSetFAQDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailFAQDetailItem) {
            // validation for constraint: itemType
            if (!$eventDetailFAQDetailItem instanceof \StructType\FAQDetail) {
                $invalidValues[] = is_object($eventDetailFAQDetailItem) ? get_class($eventDetailFAQDetailItem) : sprintf('%s(%s)', gettype($eventDetailFAQDetailItem), var_export($eventDetailFAQDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FAQDetail property can only contain items of type \StructType\FAQDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FAQDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FAQDetail[] $fAQDetail
     * @return \StructType\EventDetail
     */
    public function setFAQDetail(array $fAQDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fAQDetailArrayErrorMessage = self::validateFAQDetailForArrayConstraintsFromSetFAQDetail($fAQDetail))) {
            throw new \InvalidArgumentException($fAQDetailArrayErrorMessage, __LINE__);
        }
        $this->FAQDetail = $fAQDetail;
        return $this;
    }
    /**
     * Add item to FAQDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FAQDetail $item
     * @return \StructType\EventDetail
     */
    public function addToFAQDetail(\StructType\FAQDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FAQDetail) {
            throw new \InvalidArgumentException(sprintf('The FAQDetail property can only contain items of type \StructType\FAQDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FAQDetail[] = $item;
        return $this;
    }
    /**
     * Get StaffDetail value
     * @return \StructType\StaffDetail[]|null
     */
    public function getStaffDetail()
    {
        return $this->StaffDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setStaffDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaffDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStaffDetailForArrayConstraintsFromSetStaffDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailStaffDetailItem) {
            // validation for constraint: itemType
            if (!$eventDetailStaffDetailItem instanceof \StructType\StaffDetail) {
                $invalidValues[] = is_object($eventDetailStaffDetailItem) ? get_class($eventDetailStaffDetailItem) : sprintf('%s(%s)', gettype($eventDetailStaffDetailItem), var_export($eventDetailStaffDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StaffDetail property can only contain items of type \StructType\StaffDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StaffDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StaffDetail[] $staffDetail
     * @return \StructType\EventDetail
     */
    public function setStaffDetail(array $staffDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($staffDetailArrayErrorMessage = self::validateStaffDetailForArrayConstraintsFromSetStaffDetail($staffDetail))) {
            throw new \InvalidArgumentException($staffDetailArrayErrorMessage, __LINE__);
        }
        $this->StaffDetail = $staffDetail;
        return $this;
    }
    /**
     * Add item to StaffDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StaffDetail $item
     * @return \StructType\EventDetail
     */
    public function addToStaffDetail(\StructType\StaffDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StaffDetail) {
            throw new \InvalidArgumentException(sprintf('The StaffDetail property can only contain items of type \StructType\StaffDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StaffDetail[] = $item;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees[]|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * This method is responsible for validating the values passed to the setFees method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFees method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeesForArrayConstraintsFromSetFees(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDetailFeesItem) {
            // validation for constraint: itemType
            if (!$eventDetailFeesItem instanceof \StructType\Fees) {
                $invalidValues[] = is_object($eventDetailFeesItem) ? get_class($eventDetailFeesItem) : sprintf('%s(%s)', gettype($eventDetailFeesItem), var_export($eventDetailFeesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fees property can only contain items of type \StructType\Fees, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fees value
     * @throws \InvalidArgumentException
     * @param \StructType\Fees[] $fees
     * @return \StructType\EventDetail
     */
    public function setFees(array $fees = array())
    {
        // validation for constraint: array
        if ('' !== ($feesArrayErrorMessage = self::validateFeesForArrayConstraintsFromSetFees($fees))) {
            throw new \InvalidArgumentException($feesArrayErrorMessage, __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Add item to Fees value
     * @throws \InvalidArgumentException
     * @param \StructType\Fees $item
     * @return \StructType\EventDetail
     */
    public function addToFees(\StructType\Fees $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Fees) {
            throw new \InvalidArgumentException(sprintf('The Fees property can only contain items of type \StructType\Fees, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fees[] = $item;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\EventDetail
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\EventDetail
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->EventDescription;
    }
    /**
     * Set EventDescription value
     * @param string $eventDescription
     * @return \StructType\EventDetail
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->EventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get EventStatus value
     * @return string|null
     */
    public function getEventStatus()
    {
        return $this->EventStatus;
    }
    /**
     * Set EventStatus value
     * @param string $eventStatus
     * @return \StructType\EventDetail
     */
    public function setEventStatus($eventStatus = null)
    {
        // validation for constraint: string
        if (!is_null($eventStatus) && !is_string($eventStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStatus, true), gettype($eventStatus)), __LINE__);
        }
        $this->EventStatus = $eventStatus;
        return $this;
    }
    /**
     * Get EventSummaryHeader value
     * @return string|null
     */
    public function getEventSummaryHeader()
    {
        return $this->EventSummaryHeader;
    }
    /**
     * Set EventSummaryHeader value
     * @param string $eventSummaryHeader
     * @return \StructType\EventDetail
     */
    public function setEventSummaryHeader($eventSummaryHeader = null)
    {
        // validation for constraint: string
        if (!is_null($eventSummaryHeader) && !is_string($eventSummaryHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSummaryHeader, true), gettype($eventSummaryHeader)), __LINE__);
        }
        $this->EventSummaryHeader = $eventSummaryHeader;
        return $this;
    }
    /**
     * Get PlanningStatus value
     * @return string|null
     */
    public function getPlanningStatus()
    {
        return $this->PlanningStatus;
    }
    /**
     * Set PlanningStatus value
     * @param string $planningStatus
     * @return \StructType\EventDetail
     */
    public function setPlanningStatus($planningStatus = null)
    {
        // validation for constraint: string
        if (!is_null($planningStatus) && !is_string($planningStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planningStatus, true), gettype($planningStatus)), __LINE__);
        }
        $this->PlanningStatus = $planningStatus;
        return $this;
    }
    /**
     * Get TotalInvitedCount value
     * @return int|null
     */
    public function getTotalInvitedCount()
    {
        return $this->TotalInvitedCount;
    }
    /**
     * Set TotalInvitedCount value
     * @param int $totalInvitedCount
     * @return \StructType\EventDetail
     */
    public function setTotalInvitedCount($totalInvitedCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalInvitedCount) && !(is_int($totalInvitedCount) || ctype_digit($totalInvitedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalInvitedCount, true), gettype($totalInvitedCount)), __LINE__);
        }
        $this->TotalInvitedCount = $totalInvitedCount;
        return $this;
    }
    /**
     * Get RegisteredAttendeeCount value
     * @return int|null
     */
    public function getRegisteredAttendeeCount()
    {
        return $this->RegisteredAttendeeCount;
    }
    /**
     * Set RegisteredAttendeeCount value
     * @param int $registeredAttendeeCount
     * @return \StructType\EventDetail
     */
    public function setRegisteredAttendeeCount($registeredAttendeeCount = null)
    {
        // validation for constraint: int
        if (!is_null($registeredAttendeeCount) && !(is_int($registeredAttendeeCount) || ctype_digit($registeredAttendeeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registeredAttendeeCount, true), gettype($registeredAttendeeCount)), __LINE__);
        }
        $this->RegisteredAttendeeCount = $registeredAttendeeCount;
        return $this;
    }
    /**
     * Get ParticipantCount value
     * @return int|null
     */
    public function getParticipantCount()
    {
        return $this->ParticipantCount;
    }
    /**
     * Set ParticipantCount value
     * @param int $participantCount
     * @return \StructType\EventDetail
     */
    public function setParticipantCount($participantCount = null)
    {
        // validation for constraint: int
        if (!is_null($participantCount) && !(is_int($participantCount) || ctype_digit($participantCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($participantCount, true), gettype($participantCount)), __LINE__);
        }
        $this->ParticipantCount = $participantCount;
        return $this;
    }
    /**
     * Get DeclineeCount value
     * @return int|null
     */
    public function getDeclineeCount()
    {
        return $this->DeclineeCount;
    }
    /**
     * Set DeclineeCount value
     * @param int $declineeCount
     * @return \StructType\EventDetail
     */
    public function setDeclineeCount($declineeCount = null)
    {
        // validation for constraint: int
        if (!is_null($declineeCount) && !(is_int($declineeCount) || ctype_digit($declineeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($declineeCount, true), gettype($declineeCount)), __LINE__);
        }
        $this->DeclineeCount = $declineeCount;
        return $this;
    }
    /**
     * Get CancelledCount value
     * @return int|null
     */
    public function getCancelledCount()
    {
        return $this->CancelledCount;
    }
    /**
     * Set CancelledCount value
     * @param int $cancelledCount
     * @return \StructType\EventDetail
     */
    public function setCancelledCount($cancelledCount = null)
    {
        // validation for constraint: int
        if (!is_null($cancelledCount) && !(is_int($cancelledCount) || ctype_digit($cancelledCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancelledCount, true), gettype($cancelledCount)), __LINE__);
        }
        $this->CancelledCount = $cancelledCount;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \StructType\EventDetail
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get RequestName value
     * @return string|null
     */
    public function getRequestName()
    {
        return $this->RequestName;
    }
    /**
     * Set RequestName value
     * @param string $requestName
     * @return \StructType\EventDetail
     */
    public function setRequestName($requestName = null)
    {
        // validation for constraint: string
        if (!is_null($requestName) && !is_string($requestName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestName, true), gettype($requestName)), __LINE__);
        }
        $this->RequestName = $requestName;
        return $this;
    }
    /**
     * Get RequestStatus value
     * @return string|null
     */
    public function getRequestStatus()
    {
        return $this->RequestStatus;
    }
    /**
     * Set RequestStatus value
     * @param string $requestStatus
     * @return \StructType\EventDetail
     */
    public function setRequestStatus($requestStatus = null)
    {
        // validation for constraint: string
        if (!is_null($requestStatus) && !is_string($requestStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestStatus, true), gettype($requestStatus)), __LINE__);
        }
        $this->RequestStatus = $requestStatus;
        return $this;
    }
    /**
     * Get RequestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param string $requestCode
     * @return \StructType\EventDetail
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Get RequesterFirstName value
     * @return string|null
     */
    public function getRequesterFirstName()
    {
        return $this->RequesterFirstName;
    }
    /**
     * Set RequesterFirstName value
     * @param string $requesterFirstName
     * @return \StructType\EventDetail
     */
    public function setRequesterFirstName($requesterFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterFirstName) && !is_string($requesterFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterFirstName, true), gettype($requesterFirstName)), __LINE__);
        }
        $this->RequesterFirstName = $requesterFirstName;
        return $this;
    }
    /**
     * Get RequesterLastName value
     * @return string|null
     */
    public function getRequesterLastName()
    {
        return $this->RequesterLastName;
    }
    /**
     * Set RequesterLastName value
     * @param string $requesterLastName
     * @return \StructType\EventDetail
     */
    public function setRequesterLastName($requesterLastName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterLastName) && !is_string($requesterLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterLastName, true), gettype($requesterLastName)), __LINE__);
        }
        $this->RequesterLastName = $requesterLastName;
        return $this;
    }
    /**
     * Get RequesterID value
     * @return string|null
     */
    public function getRequesterID()
    {
        return $this->RequesterID;
    }
    /**
     * Set RequesterID value
     * @param string $requesterID
     * @return \StructType\EventDetail
     */
    public function setRequesterID($requesterID = null)
    {
        // validation for constraint: string
        if (!is_null($requesterID) && !is_string($requesterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterID, true), gettype($requesterID)), __LINE__);
        }
        $this->RequesterID = $requesterID;
        return $this;
    }
    /**
     * Get RequestSubmittedDate value
     * @return string|null
     */
    public function getRequestSubmittedDate()
    {
        return $this->RequestSubmittedDate;
    }
    /**
     * Set RequestSubmittedDate value
     * @param string $requestSubmittedDate
     * @return \StructType\EventDetail
     */
    public function setRequestSubmittedDate($requestSubmittedDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestSubmittedDate) && !is_string($requestSubmittedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestSubmittedDate, true), gettype($requestSubmittedDate)), __LINE__);
        }
        $this->RequestSubmittedDate = $requestSubmittedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
