<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventAnswer StructType
 * @subpackage Structs
 */
class EventAnswer extends AbstractStructBase
{
    /**
     * The AnswerPart
     * @var string
     */
    public $AnswerPart;
    /**
     * The AnswerColumn
     * @var string
     */
    public $AnswerColumn;
    /**
     * The AnswerText
     * @var string
     */
    public $AnswerText;
    /**
     * The AnswerOther
     * @var string
     */
    public $AnswerOther;
    /**
     * The AnswerComment
     * @var string
     */
    public $AnswerComment;
    /**
     * Constructor method for EventAnswer
     * @uses EventAnswer::setAnswerPart()
     * @uses EventAnswer::setAnswerColumn()
     * @uses EventAnswer::setAnswerText()
     * @uses EventAnswer::setAnswerOther()
     * @uses EventAnswer::setAnswerComment()
     * @param string $answerPart
     * @param string $answerColumn
     * @param string $answerText
     * @param string $answerOther
     * @param string $answerComment
     */
    public function __construct($answerPart = null, $answerColumn = null, $answerText = null, $answerOther = null, $answerComment = null)
    {
        $this
            ->setAnswerPart($answerPart)
            ->setAnswerColumn($answerColumn)
            ->setAnswerText($answerText)
            ->setAnswerOther($answerOther)
            ->setAnswerComment($answerComment);
    }
    /**
     * Get AnswerPart value
     * @return string|null
     */
    public function getAnswerPart()
    {
        return $this->AnswerPart;
    }
    /**
     * Set AnswerPart value
     * @param string $answerPart
     * @return \StructType\EventAnswer
     */
    public function setAnswerPart($answerPart = null)
    {
        // validation for constraint: string
        if (!is_null($answerPart) && !is_string($answerPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerPart, true), gettype($answerPart)), __LINE__);
        }
        $this->AnswerPart = $answerPart;
        return $this;
    }
    /**
     * Get AnswerColumn value
     * @return string|null
     */
    public function getAnswerColumn()
    {
        return $this->AnswerColumn;
    }
    /**
     * Set AnswerColumn value
     * @param string $answerColumn
     * @return \StructType\EventAnswer
     */
    public function setAnswerColumn($answerColumn = null)
    {
        // validation for constraint: string
        if (!is_null($answerColumn) && !is_string($answerColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerColumn, true), gettype($answerColumn)), __LINE__);
        }
        $this->AnswerColumn = $answerColumn;
        return $this;
    }
    /**
     * Get AnswerText value
     * @return string|null
     */
    public function getAnswerText()
    {
        return $this->AnswerText;
    }
    /**
     * Set AnswerText value
     * @param string $answerText
     * @return \StructType\EventAnswer
     */
    public function setAnswerText($answerText = null)
    {
        // validation for constraint: string
        if (!is_null($answerText) && !is_string($answerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerText, true), gettype($answerText)), __LINE__);
        }
        $this->AnswerText = $answerText;
        return $this;
    }
    /**
     * Get AnswerOther value
     * @return string|null
     */
    public function getAnswerOther()
    {
        return $this->AnswerOther;
    }
    /**
     * Set AnswerOther value
     * @param string $answerOther
     * @return \StructType\EventAnswer
     */
    public function setAnswerOther($answerOther = null)
    {
        // validation for constraint: string
        if (!is_null($answerOther) && !is_string($answerOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerOther, true), gettype($answerOther)), __LINE__);
        }
        $this->AnswerOther = $answerOther;
        return $this;
    }
    /**
     * Get AnswerComment value
     * @return string|null
     */
    public function getAnswerComment()
    {
        return $this->AnswerComment;
    }
    /**
     * Set AnswerComment value
     * @param string $answerComment
     * @return \StructType\EventAnswer
     */
    public function setAnswerComment($answerComment = null)
    {
        // validation for constraint: string
        if (!is_null($answerComment) && !is_string($answerComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerComment, true), gettype($answerComment)), __LINE__);
        }
        $this->AnswerComment = $answerComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
