<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Event StructType
 * @subpackage Structs
 */
class Event extends CvObject
{
    /**
     * The ProductDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductDetail[]
     */
    public $ProductDetail;
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The WeblinkDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WeblinkDetail[]
     */
    public $WeblinkDetail;
    /**
     * The DocumentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentDetail[]
     */
    public $DocumentDetail;
    /**
     * The TargetListDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TargetListDetail[]
     */
    public $TargetListDetail;
    /**
     * The EventTitle
     * @var string
     */
    public $EventTitle;
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The EventLaunchDate
     * @var string
     */
    public $EventLaunchDate;
    /**
     * The Timezone
     * @var string
     */
    public $Timezone;
    /**
     * The EventDescription
     * @var string
     */
    public $EventDescription;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * The EventStatus
     * @var string
     */
    public $EventStatus;
    /**
     * The Capacity
     * @var int
     */
    public $Capacity;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The MeetingRequestId
     * @var string
     */
    public $MeetingRequestId;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The PlanningStatus
     * @var string
     */
    public $PlanningStatus;
    /**
     * The Hidden
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Hidden;
    /**
     * The Location
     * @var string
     */
    public $Location;
    /**
     * The StreetAddress1
     * @var string
     */
    public $StreetAddress1;
    /**
     * The StreetAddress2
     * @var string
     */
    public $StreetAddress2;
    /**
     * The StreetAddress3
     * @var string
     */
    public $StreetAddress3;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The State
     * @var string
     */
    public $State;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The PhoneNumber
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PlannerFirstName
     * @var string
     */
    public $PlannerFirstName;
    /**
     * The PlannerLastName
     * @var string
     */
    public $PlannerLastName;
    /**
     * The PlannerEmailAddress
     * @var string
     */
    public $PlannerEmailAddress;
    /**
     * The PlannerPrefix
     * @var string
     */
    public $PlannerPrefix;
    /**
     * The PlannerCompany
     * @var string
     */
    public $PlannerCompany;
    /**
     * The PlannerTitle
     * @var string
     */
    public $PlannerTitle;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The RSVPbyDate
     * @var string
     */
    public $RSVPbyDate;
    /**
     * The ArchiveDate
     * @var string
     */
    public $ArchiveDate;
    /**
     * The ClosedBy
     * @var string
     */
    public $ClosedBy;
    /**
     * The ExternalAuthentication
     * @var bool
     */
    public $ExternalAuthentication;
    /**
     * The StakeholderFirstName
     * @var string
     */
    public $StakeholderFirstName;
    /**
     * The StakeholderLastName
     * @var string
     */
    public $StakeholderLastName;
    /**
     * The StakeholderEmailAddress
     * @var string
     */
    public $StakeholderEmailAddress;
    /**
     * The StakeholderTitle
     * @var string
     */
    public $StakeholderTitle;
    /**
     * The StakeholderCompany
     * @var string
     */
    public $StakeholderCompany;
    /**
     * The StakeholderWorkPhone
     * @var string
     */
    public $StakeholderWorkPhone;
    /**
     * The StakeholderHomePhone
     * @var string
     */
    public $StakeholderHomePhone;
    /**
     * The StakeholderWorkFax
     * @var string
     */
    public $StakeholderWorkFax;
    /**
     * The StakeholderMobilePhone
     * @var string
     */
    public $StakeholderMobilePhone;
    /**
     * The StakeholderAddress1
     * @var string
     */
    public $StakeholderAddress1;
    /**
     * The StakeholderAddress2
     * @var string
     */
    public $StakeholderAddress2;
    /**
     * The StakeholderAddress3
     * @var string
     */
    public $StakeholderAddress3;
    /**
     * The StakeholderCity
     * @var string
     */
    public $StakeholderCity;
    /**
     * The StakeholderStateCode
     * @var string
     */
    public $StakeholderStateCode;
    /**
     * The StakeholderPostalCode
     * @var string
     */
    public $StakeholderPostalCode;
    /**
     * The StakeholderCountryCode
     * @var string
     */
    public $StakeholderCountryCode;
    /**
     * The MerchantAccount
     * @var string
     */
    public $MerchantAccount;
    /**
     * The MerchantAccountId
     * @var string
     */
    public $MerchantAccountId;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The EventCalendarLinkText
     * @var string
     */
    public $EventCalendarLinkText;
    /**
     * The EventCalendarAlternateURL
     * @var string
     */
    public $EventCalendarAlternateURL;
    /**
     * The EventCalendarCompletedURL
     * @var string
     */
    public $EventCalendarCompletedURL;
    /**
     * Constructor method for Event
     * @uses Event::setProductDetail()
     * @uses Event::setCustomFieldDetail()
     * @uses Event::setWeblinkDetail()
     * @uses Event::setDocumentDetail()
     * @uses Event::setTargetListDetail()
     * @uses Event::setEventTitle()
     * @uses Event::setEventCode()
     * @uses Event::setEventStartDate()
     * @uses Event::setEventEndDate()
     * @uses Event::setEventLaunchDate()
     * @uses Event::setTimezone()
     * @uses Event::setEventDescription()
     * @uses Event::setInternalNote()
     * @uses Event::setEventStatus()
     * @uses Event::setCapacity()
     * @uses Event::setCategory()
     * @uses Event::setMeetingRequestId()
     * @uses Event::setCurrency()
     * @uses Event::setPlanningStatus()
     * @uses Event::setHidden()
     * @uses Event::setLocation()
     * @uses Event::setStreetAddress1()
     * @uses Event::setStreetAddress2()
     * @uses Event::setStreetAddress3()
     * @uses Event::setCity()
     * @uses Event::setState()
     * @uses Event::setStateCode()
     * @uses Event::setPostalCode()
     * @uses Event::setCountry()
     * @uses Event::setCountryCode()
     * @uses Event::setPhoneNumber()
     * @uses Event::setPlannerFirstName()
     * @uses Event::setPlannerLastName()
     * @uses Event::setPlannerEmailAddress()
     * @uses Event::setPlannerPrefix()
     * @uses Event::setPlannerCompany()
     * @uses Event::setPlannerTitle()
     * @uses Event::setLastModifiedDate()
     * @uses Event::setRSVPbyDate()
     * @uses Event::setArchiveDate()
     * @uses Event::setClosedBy()
     * @uses Event::setExternalAuthentication()
     * @uses Event::setStakeholderFirstName()
     * @uses Event::setStakeholderLastName()
     * @uses Event::setStakeholderEmailAddress()
     * @uses Event::setStakeholderTitle()
     * @uses Event::setStakeholderCompany()
     * @uses Event::setStakeholderWorkPhone()
     * @uses Event::setStakeholderHomePhone()
     * @uses Event::setStakeholderWorkFax()
     * @uses Event::setStakeholderMobilePhone()
     * @uses Event::setStakeholderAddress1()
     * @uses Event::setStakeholderAddress2()
     * @uses Event::setStakeholderAddress3()
     * @uses Event::setStakeholderCity()
     * @uses Event::setStakeholderStateCode()
     * @uses Event::setStakeholderPostalCode()
     * @uses Event::setStakeholderCountryCode()
     * @uses Event::setMerchantAccount()
     * @uses Event::setMerchantAccountId()
     * @uses Event::setCreatedBy()
     * @uses Event::setEventCalendarLinkText()
     * @uses Event::setEventCalendarAlternateURL()
     * @uses Event::setEventCalendarCompletedURL()
     * @param \StructType\ProductDetail[] $productDetail
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @param \StructType\DocumentDetail[] $documentDetail
     * @param \StructType\TargetListDetail[] $targetListDetail
     * @param string $eventTitle
     * @param string $eventCode
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param string $eventLaunchDate
     * @param string $timezone
     * @param string $eventDescription
     * @param string $internalNote
     * @param string $eventStatus
     * @param int $capacity
     * @param string $category
     * @param string $meetingRequestId
     * @param string $currency
     * @param string $planningStatus
     * @param bool $hidden
     * @param string $location
     * @param string $streetAddress1
     * @param string $streetAddress2
     * @param string $streetAddress3
     * @param string $city
     * @param string $state
     * @param string $stateCode
     * @param string $postalCode
     * @param string $country
     * @param string $countryCode
     * @param string $phoneNumber
     * @param string $plannerFirstName
     * @param string $plannerLastName
     * @param string $plannerEmailAddress
     * @param string $plannerPrefix
     * @param string $plannerCompany
     * @param string $plannerTitle
     * @param string $lastModifiedDate
     * @param string $rSVPbyDate
     * @param string $archiveDate
     * @param string $closedBy
     * @param bool $externalAuthentication
     * @param string $stakeholderFirstName
     * @param string $stakeholderLastName
     * @param string $stakeholderEmailAddress
     * @param string $stakeholderTitle
     * @param string $stakeholderCompany
     * @param string $stakeholderWorkPhone
     * @param string $stakeholderHomePhone
     * @param string $stakeholderWorkFax
     * @param string $stakeholderMobilePhone
     * @param string $stakeholderAddress1
     * @param string $stakeholderAddress2
     * @param string $stakeholderAddress3
     * @param string $stakeholderCity
     * @param string $stakeholderStateCode
     * @param string $stakeholderPostalCode
     * @param string $stakeholderCountryCode
     * @param string $merchantAccount
     * @param string $merchantAccountId
     * @param string $createdBy
     * @param string $eventCalendarLinkText
     * @param string $eventCalendarAlternateURL
     * @param string $eventCalendarCompletedURL
     */
    public function __construct(array $productDetail = array(), array $customFieldDetail = array(), array $weblinkDetail = array(), array $documentDetail = array(), array $targetListDetail = array(), $eventTitle = null, $eventCode = null, $eventStartDate = null, $eventEndDate = null, $eventLaunchDate = null, $timezone = null, $eventDescription = null, $internalNote = null, $eventStatus = null, $capacity = null, $category = null, $meetingRequestId = null, $currency = null, $planningStatus = null, $hidden = false, $location = null, $streetAddress1 = null, $streetAddress2 = null, $streetAddress3 = null, $city = null, $state = null, $stateCode = null, $postalCode = null, $country = null, $countryCode = null, $phoneNumber = null, $plannerFirstName = null, $plannerLastName = null, $plannerEmailAddress = null, $plannerPrefix = null, $plannerCompany = null, $plannerTitle = null, $lastModifiedDate = null, $rSVPbyDate = null, $archiveDate = null, $closedBy = null, $externalAuthentication = null, $stakeholderFirstName = null, $stakeholderLastName = null, $stakeholderEmailAddress = null, $stakeholderTitle = null, $stakeholderCompany = null, $stakeholderWorkPhone = null, $stakeholderHomePhone = null, $stakeholderWorkFax = null, $stakeholderMobilePhone = null, $stakeholderAddress1 = null, $stakeholderAddress2 = null, $stakeholderAddress3 = null, $stakeholderCity = null, $stakeholderStateCode = null, $stakeholderPostalCode = null, $stakeholderCountryCode = null, $merchantAccount = null, $merchantAccountId = null, $createdBy = null, $eventCalendarLinkText = null, $eventCalendarAlternateURL = null, $eventCalendarCompletedURL = null)
    {
        $this
            ->setProductDetail($productDetail)
            ->setCustomFieldDetail($customFieldDetail)
            ->setWeblinkDetail($weblinkDetail)
            ->setDocumentDetail($documentDetail)
            ->setTargetListDetail($targetListDetail)
            ->setEventTitle($eventTitle)
            ->setEventCode($eventCode)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setEventLaunchDate($eventLaunchDate)
            ->setTimezone($timezone)
            ->setEventDescription($eventDescription)
            ->setInternalNote($internalNote)
            ->setEventStatus($eventStatus)
            ->setCapacity($capacity)
            ->setCategory($category)
            ->setMeetingRequestId($meetingRequestId)
            ->setCurrency($currency)
            ->setPlanningStatus($planningStatus)
            ->setHidden($hidden)
            ->setLocation($location)
            ->setStreetAddress1($streetAddress1)
            ->setStreetAddress2($streetAddress2)
            ->setStreetAddress3($streetAddress3)
            ->setCity($city)
            ->setState($state)
            ->setStateCode($stateCode)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setPhoneNumber($phoneNumber)
            ->setPlannerFirstName($plannerFirstName)
            ->setPlannerLastName($plannerLastName)
            ->setPlannerEmailAddress($plannerEmailAddress)
            ->setPlannerPrefix($plannerPrefix)
            ->setPlannerCompany($plannerCompany)
            ->setPlannerTitle($plannerTitle)
            ->setLastModifiedDate($lastModifiedDate)
            ->setRSVPbyDate($rSVPbyDate)
            ->setArchiveDate($archiveDate)
            ->setClosedBy($closedBy)
            ->setExternalAuthentication($externalAuthentication)
            ->setStakeholderFirstName($stakeholderFirstName)
            ->setStakeholderLastName($stakeholderLastName)
            ->setStakeholderEmailAddress($stakeholderEmailAddress)
            ->setStakeholderTitle($stakeholderTitle)
            ->setStakeholderCompany($stakeholderCompany)
            ->setStakeholderWorkPhone($stakeholderWorkPhone)
            ->setStakeholderHomePhone($stakeholderHomePhone)
            ->setStakeholderWorkFax($stakeholderWorkFax)
            ->setStakeholderMobilePhone($stakeholderMobilePhone)
            ->setStakeholderAddress1($stakeholderAddress1)
            ->setStakeholderAddress2($stakeholderAddress2)
            ->setStakeholderAddress3($stakeholderAddress3)
            ->setStakeholderCity($stakeholderCity)
            ->setStakeholderStateCode($stakeholderStateCode)
            ->setStakeholderPostalCode($stakeholderPostalCode)
            ->setStakeholderCountryCode($stakeholderCountryCode)
            ->setMerchantAccount($merchantAccount)
            ->setMerchantAccountId($merchantAccountId)
            ->setCreatedBy($createdBy)
            ->setEventCalendarLinkText($eventCalendarLinkText)
            ->setEventCalendarAlternateURL($eventCalendarAlternateURL)
            ->setEventCalendarCompletedURL($eventCalendarCompletedURL);
    }
    /**
     * Get ProductDetail value
     * @return \StructType\ProductDetail[]|null
     */
    public function getProductDetail()
    {
        return $this->ProductDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setProductDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductDetailForArrayConstraintsFromSetProductDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventProductDetailItem) {
            // validation for constraint: itemType
            if (!$eventProductDetailItem instanceof \StructType\ProductDetail) {
                $invalidValues[] = is_object($eventProductDetailItem) ? get_class($eventProductDetailItem) : sprintf('%s(%s)', gettype($eventProductDetailItem), var_export($eventProductDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductDetail property can only contain items of type \StructType\ProductDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetail[] $productDetail
     * @return \StructType\Event
     */
    public function setProductDetail(array $productDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($productDetailArrayErrorMessage = self::validateProductDetailForArrayConstraintsFromSetProductDetail($productDetail))) {
            throw new \InvalidArgumentException($productDetailArrayErrorMessage, __LINE__);
        }
        $this->ProductDetail = $productDetail;
        return $this;
    }
    /**
     * Add item to ProductDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductDetail $item
     * @return \StructType\Event
     */
    public function addToProductDetail(\StructType\ProductDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductDetail) {
            throw new \InvalidArgumentException(sprintf('The ProductDetail property can only contain items of type \StructType\ProductDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$eventCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($eventCustomFieldDetailItem) ? get_class($eventCustomFieldDetailItem) : sprintf('%s(%s)', gettype($eventCustomFieldDetailItem), var_export($eventCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Event
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Event
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get WeblinkDetail value
     * @return \StructType\WeblinkDetail[]|null
     */
    public function getWeblinkDetail()
    {
        return $this->WeblinkDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setWeblinkDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeblinkDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventWeblinkDetailItem) {
            // validation for constraint: itemType
            if (!$eventWeblinkDetailItem instanceof \StructType\WeblinkDetail) {
                $invalidValues[] = is_object($eventWeblinkDetailItem) ? get_class($eventWeblinkDetailItem) : sprintf('%s(%s)', gettype($eventWeblinkDetailItem), var_export($eventWeblinkDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail[] $weblinkDetail
     * @return \StructType\Event
     */
    public function setWeblinkDetail(array $weblinkDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($weblinkDetailArrayErrorMessage = self::validateWeblinkDetailForArrayConstraintsFromSetWeblinkDetail($weblinkDetail))) {
            throw new \InvalidArgumentException($weblinkDetailArrayErrorMessage, __LINE__);
        }
        $this->WeblinkDetail = $weblinkDetail;
        return $this;
    }
    /**
     * Add item to WeblinkDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\WeblinkDetail $item
     * @return \StructType\Event
     */
    public function addToWeblinkDetail(\StructType\WeblinkDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WeblinkDetail) {
            throw new \InvalidArgumentException(sprintf('The WeblinkDetail property can only contain items of type \StructType\WeblinkDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WeblinkDetail[] = $item;
        return $this;
    }
    /**
     * Get DocumentDetail value
     * @return \StructType\DocumentDetail[]|null
     */
    public function getDocumentDetail()
    {
        return $this->DocumentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentDetailForArrayConstraintsFromSetDocumentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDocumentDetailItem) {
            // validation for constraint: itemType
            if (!$eventDocumentDetailItem instanceof \StructType\DocumentDetail) {
                $invalidValues[] = is_object($eventDocumentDetailItem) ? get_class($eventDocumentDetailItem) : sprintf('%s(%s)', gettype($eventDocumentDetailItem), var_export($eventDocumentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail[] $documentDetail
     * @return \StructType\Event
     */
    public function setDocumentDetail(array $documentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($documentDetailArrayErrorMessage = self::validateDocumentDetailForArrayConstraintsFromSetDocumentDetail($documentDetail))) {
            throw new \InvalidArgumentException($documentDetailArrayErrorMessage, __LINE__);
        }
        $this->DocumentDetail = $documentDetail;
        return $this;
    }
    /**
     * Add item to DocumentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentDetail $item
     * @return \StructType\Event
     */
    public function addToDocumentDetail(\StructType\DocumentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentDetail) {
            throw new \InvalidArgumentException(sprintf('The DocumentDetail property can only contain items of type \StructType\DocumentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentDetail[] = $item;
        return $this;
    }
    /**
     * Get TargetListDetail value
     * @return \StructType\TargetListDetail[]|null
     */
    public function getTargetListDetail()
    {
        return $this->TargetListDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTargetListDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTargetListDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTargetListDetailForArrayConstraintsFromSetTargetListDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventTargetListDetailItem) {
            // validation for constraint: itemType
            if (!$eventTargetListDetailItem instanceof \StructType\TargetListDetail) {
                $invalidValues[] = is_object($eventTargetListDetailItem) ? get_class($eventTargetListDetailItem) : sprintf('%s(%s)', gettype($eventTargetListDetailItem), var_export($eventTargetListDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TargetListDetail property can only contain items of type \StructType\TargetListDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TargetListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetListDetail[] $targetListDetail
     * @return \StructType\Event
     */
    public function setTargetListDetail(array $targetListDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($targetListDetailArrayErrorMessage = self::validateTargetListDetailForArrayConstraintsFromSetTargetListDetail($targetListDetail))) {
            throw new \InvalidArgumentException($targetListDetailArrayErrorMessage, __LINE__);
        }
        $this->TargetListDetail = $targetListDetail;
        return $this;
    }
    /**
     * Add item to TargetListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetListDetail $item
     * @return \StructType\Event
     */
    public function addToTargetListDetail(\StructType\TargetListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TargetListDetail) {
            throw new \InvalidArgumentException(sprintf('The TargetListDetail property can only contain items of type \StructType\TargetListDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TargetListDetail[] = $item;
        return $this;
    }
    /**
     * Get EventTitle value
     * @return string|null
     */
    public function getEventTitle()
    {
        return $this->EventTitle;
    }
    /**
     * Set EventTitle value
     * @param string $eventTitle
     * @return \StructType\Event
     */
    public function setEventTitle($eventTitle = null)
    {
        // validation for constraint: string
        if (!is_null($eventTitle) && !is_string($eventTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTitle, true), gettype($eventTitle)), __LINE__);
        }
        $this->EventTitle = $eventTitle;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\Event
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\Event
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\Event
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get EventLaunchDate value
     * @return string|null
     */
    public function getEventLaunchDate()
    {
        return $this->EventLaunchDate;
    }
    /**
     * Set EventLaunchDate value
     * @param string $eventLaunchDate
     * @return \StructType\Event
     */
    public function setEventLaunchDate($eventLaunchDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventLaunchDate) && !is_string($eventLaunchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventLaunchDate, true), gettype($eventLaunchDate)), __LINE__);
        }
        $this->EventLaunchDate = $eventLaunchDate;
        return $this;
    }
    /**
     * Get Timezone value
     * @return string|null
     */
    public function getTimezone()
    {
        return $this->Timezone;
    }
    /**
     * Set Timezone value
     * @param string $timezone
     * @return \StructType\Event
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timezone, true), gettype($timezone)), __LINE__);
        }
        $this->Timezone = $timezone;
        return $this;
    }
    /**
     * Get EventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->EventDescription;
    }
    /**
     * Set EventDescription value
     * @param string $eventDescription
     * @return \StructType\Event
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->EventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\Event
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Get EventStatus value
     * @return string|null
     */
    public function getEventStatus()
    {
        return $this->EventStatus;
    }
    /**
     * Set EventStatus value
     * @param string $eventStatus
     * @return \StructType\Event
     */
    public function setEventStatus($eventStatus = null)
    {
        // validation for constraint: string
        if (!is_null($eventStatus) && !is_string($eventStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStatus, true), gettype($eventStatus)), __LINE__);
        }
        $this->EventStatus = $eventStatus;
        return $this;
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\Event
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\Event
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get MeetingRequestId value
     * @return string|null
     */
    public function getMeetingRequestId()
    {
        return $this->MeetingRequestId;
    }
    /**
     * Set MeetingRequestId value
     * @param string $meetingRequestId
     * @return \StructType\Event
     */
    public function setMeetingRequestId($meetingRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRequestId) && !is_string($meetingRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRequestId, true), gettype($meetingRequestId)), __LINE__);
        }
        $this->MeetingRequestId = $meetingRequestId;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\Event
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PlanningStatus value
     * @return string|null
     */
    public function getPlanningStatus()
    {
        return $this->PlanningStatus;
    }
    /**
     * Set PlanningStatus value
     * @param string $planningStatus
     * @return \StructType\Event
     */
    public function setPlanningStatus($planningStatus = null)
    {
        // validation for constraint: string
        if (!is_null($planningStatus) && !is_string($planningStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planningStatus, true), gettype($planningStatus)), __LINE__);
        }
        $this->PlanningStatus = $planningStatus;
        return $this;
    }
    /**
     * Get Hidden value
     * @return bool|null
     */
    public function getHidden()
    {
        return $this->Hidden;
    }
    /**
     * Set Hidden value
     * @param bool $hidden
     * @return \StructType\Event
     */
    public function setHidden($hidden = false)
    {
        // validation for constraint: boolean
        if (!is_null($hidden) && !is_bool($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hidden, true), gettype($hidden)), __LINE__);
        }
        $this->Hidden = $hidden;
        return $this;
    }
    /**
     * Get Location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param string $location
     * @return \StructType\Event
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->Location = $location;
        return $this;
    }
    /**
     * Get StreetAddress1 value
     * @return string|null
     */
    public function getStreetAddress1()
    {
        return $this->StreetAddress1;
    }
    /**
     * Set StreetAddress1 value
     * @param string $streetAddress1
     * @return \StructType\Event
     */
    public function setStreetAddress1($streetAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress1) && !is_string($streetAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress1, true), gettype($streetAddress1)), __LINE__);
        }
        $this->StreetAddress1 = $streetAddress1;
        return $this;
    }
    /**
     * Get StreetAddress2 value
     * @return string|null
     */
    public function getStreetAddress2()
    {
        return $this->StreetAddress2;
    }
    /**
     * Set StreetAddress2 value
     * @param string $streetAddress2
     * @return \StructType\Event
     */
    public function setStreetAddress2($streetAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress2) && !is_string($streetAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress2, true), gettype($streetAddress2)), __LINE__);
        }
        $this->StreetAddress2 = $streetAddress2;
        return $this;
    }
    /**
     * Get StreetAddress3 value
     * @return string|null
     */
    public function getStreetAddress3()
    {
        return $this->StreetAddress3;
    }
    /**
     * Set StreetAddress3 value
     * @param string $streetAddress3
     * @return \StructType\Event
     */
    public function setStreetAddress3($streetAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress3) && !is_string($streetAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddress3, true), gettype($streetAddress3)), __LINE__);
        }
        $this->StreetAddress3 = $streetAddress3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Event
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Event
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\Event
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\Event
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Event
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Event
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\Event
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get PlannerFirstName value
     * @return string|null
     */
    public function getPlannerFirstName()
    {
        return $this->PlannerFirstName;
    }
    /**
     * Set PlannerFirstName value
     * @param string $plannerFirstName
     * @return \StructType\Event
     */
    public function setPlannerFirstName($plannerFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerFirstName) && !is_string($plannerFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerFirstName, true), gettype($plannerFirstName)), __LINE__);
        }
        $this->PlannerFirstName = $plannerFirstName;
        return $this;
    }
    /**
     * Get PlannerLastName value
     * @return string|null
     */
    public function getPlannerLastName()
    {
        return $this->PlannerLastName;
    }
    /**
     * Set PlannerLastName value
     * @param string $plannerLastName
     * @return \StructType\Event
     */
    public function setPlannerLastName($plannerLastName = null)
    {
        // validation for constraint: string
        if (!is_null($plannerLastName) && !is_string($plannerLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerLastName, true), gettype($plannerLastName)), __LINE__);
        }
        $this->PlannerLastName = $plannerLastName;
        return $this;
    }
    /**
     * Get PlannerEmailAddress value
     * @return string|null
     */
    public function getPlannerEmailAddress()
    {
        return $this->PlannerEmailAddress;
    }
    /**
     * Set PlannerEmailAddress value
     * @param string $plannerEmailAddress
     * @return \StructType\Event
     */
    public function setPlannerEmailAddress($plannerEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($plannerEmailAddress) && !is_string($plannerEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerEmailAddress, true), gettype($plannerEmailAddress)), __LINE__);
        }
        $this->PlannerEmailAddress = $plannerEmailAddress;
        return $this;
    }
    /**
     * Get PlannerPrefix value
     * @return string|null
     */
    public function getPlannerPrefix()
    {
        return $this->PlannerPrefix;
    }
    /**
     * Set PlannerPrefix value
     * @param string $plannerPrefix
     * @return \StructType\Event
     */
    public function setPlannerPrefix($plannerPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($plannerPrefix) && !is_string($plannerPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerPrefix, true), gettype($plannerPrefix)), __LINE__);
        }
        $this->PlannerPrefix = $plannerPrefix;
        return $this;
    }
    /**
     * Get PlannerCompany value
     * @return string|null
     */
    public function getPlannerCompany()
    {
        return $this->PlannerCompany;
    }
    /**
     * Set PlannerCompany value
     * @param string $plannerCompany
     * @return \StructType\Event
     */
    public function setPlannerCompany($plannerCompany = null)
    {
        // validation for constraint: string
        if (!is_null($plannerCompany) && !is_string($plannerCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerCompany, true), gettype($plannerCompany)), __LINE__);
        }
        $this->PlannerCompany = $plannerCompany;
        return $this;
    }
    /**
     * Get PlannerTitle value
     * @return string|null
     */
    public function getPlannerTitle()
    {
        return $this->PlannerTitle;
    }
    /**
     * Set PlannerTitle value
     * @param string $plannerTitle
     * @return \StructType\Event
     */
    public function setPlannerTitle($plannerTitle = null)
    {
        // validation for constraint: string
        if (!is_null($plannerTitle) && !is_string($plannerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plannerTitle, true), gettype($plannerTitle)), __LINE__);
        }
        $this->PlannerTitle = $plannerTitle;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Event
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get RSVPbyDate value
     * @return string|null
     */
    public function getRSVPbyDate()
    {
        return $this->RSVPbyDate;
    }
    /**
     * Set RSVPbyDate value
     * @param string $rSVPbyDate
     * @return \StructType\Event
     */
    public function setRSVPbyDate($rSVPbyDate = null)
    {
        // validation for constraint: string
        if (!is_null($rSVPbyDate) && !is_string($rSVPbyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rSVPbyDate, true), gettype($rSVPbyDate)), __LINE__);
        }
        $this->RSVPbyDate = $rSVPbyDate;
        return $this;
    }
    /**
     * Get ArchiveDate value
     * @return string|null
     */
    public function getArchiveDate()
    {
        return $this->ArchiveDate;
    }
    /**
     * Set ArchiveDate value
     * @param string $archiveDate
     * @return \StructType\Event
     */
    public function setArchiveDate($archiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveDate) && !is_string($archiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveDate, true), gettype($archiveDate)), __LINE__);
        }
        $this->ArchiveDate = $archiveDate;
        return $this;
    }
    /**
     * Get ClosedBy value
     * @return string|null
     */
    public function getClosedBy()
    {
        return $this->ClosedBy;
    }
    /**
     * Set ClosedBy value
     * @param string $closedBy
     * @return \StructType\Event
     */
    public function setClosedBy($closedBy = null)
    {
        // validation for constraint: string
        if (!is_null($closedBy) && !is_string($closedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closedBy, true), gettype($closedBy)), __LINE__);
        }
        $this->ClosedBy = $closedBy;
        return $this;
    }
    /**
     * Get ExternalAuthentication value
     * @return bool|null
     */
    public function getExternalAuthentication()
    {
        return $this->ExternalAuthentication;
    }
    /**
     * Set ExternalAuthentication value
     * @param bool $externalAuthentication
     * @return \StructType\Event
     */
    public function setExternalAuthentication($externalAuthentication = null)
    {
        // validation for constraint: boolean
        if (!is_null($externalAuthentication) && !is_bool($externalAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($externalAuthentication, true), gettype($externalAuthentication)), __LINE__);
        }
        $this->ExternalAuthentication = $externalAuthentication;
        return $this;
    }
    /**
     * Get StakeholderFirstName value
     * @return string|null
     */
    public function getStakeholderFirstName()
    {
        return $this->StakeholderFirstName;
    }
    /**
     * Set StakeholderFirstName value
     * @param string $stakeholderFirstName
     * @return \StructType\Event
     */
    public function setStakeholderFirstName($stakeholderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderFirstName) && !is_string($stakeholderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderFirstName, true), gettype($stakeholderFirstName)), __LINE__);
        }
        $this->StakeholderFirstName = $stakeholderFirstName;
        return $this;
    }
    /**
     * Get StakeholderLastName value
     * @return string|null
     */
    public function getStakeholderLastName()
    {
        return $this->StakeholderLastName;
    }
    /**
     * Set StakeholderLastName value
     * @param string $stakeholderLastName
     * @return \StructType\Event
     */
    public function setStakeholderLastName($stakeholderLastName = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderLastName) && !is_string($stakeholderLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderLastName, true), gettype($stakeholderLastName)), __LINE__);
        }
        $this->StakeholderLastName = $stakeholderLastName;
        return $this;
    }
    /**
     * Get StakeholderEmailAddress value
     * @return string|null
     */
    public function getStakeholderEmailAddress()
    {
        return $this->StakeholderEmailAddress;
    }
    /**
     * Set StakeholderEmailAddress value
     * @param string $stakeholderEmailAddress
     * @return \StructType\Event
     */
    public function setStakeholderEmailAddress($stakeholderEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderEmailAddress) && !is_string($stakeholderEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderEmailAddress, true), gettype($stakeholderEmailAddress)), __LINE__);
        }
        $this->StakeholderEmailAddress = $stakeholderEmailAddress;
        return $this;
    }
    /**
     * Get StakeholderTitle value
     * @return string|null
     */
    public function getStakeholderTitle()
    {
        return $this->StakeholderTitle;
    }
    /**
     * Set StakeholderTitle value
     * @param string $stakeholderTitle
     * @return \StructType\Event
     */
    public function setStakeholderTitle($stakeholderTitle = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderTitle) && !is_string($stakeholderTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderTitle, true), gettype($stakeholderTitle)), __LINE__);
        }
        $this->StakeholderTitle = $stakeholderTitle;
        return $this;
    }
    /**
     * Get StakeholderCompany value
     * @return string|null
     */
    public function getStakeholderCompany()
    {
        return $this->StakeholderCompany;
    }
    /**
     * Set StakeholderCompany value
     * @param string $stakeholderCompany
     * @return \StructType\Event
     */
    public function setStakeholderCompany($stakeholderCompany = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCompany) && !is_string($stakeholderCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCompany, true), gettype($stakeholderCompany)), __LINE__);
        }
        $this->StakeholderCompany = $stakeholderCompany;
        return $this;
    }
    /**
     * Get StakeholderWorkPhone value
     * @return string|null
     */
    public function getStakeholderWorkPhone()
    {
        return $this->StakeholderWorkPhone;
    }
    /**
     * Set StakeholderWorkPhone value
     * @param string $stakeholderWorkPhone
     * @return \StructType\Event
     */
    public function setStakeholderWorkPhone($stakeholderWorkPhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkPhone) && !is_string($stakeholderWorkPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkPhone, true), gettype($stakeholderWorkPhone)), __LINE__);
        }
        $this->StakeholderWorkPhone = $stakeholderWorkPhone;
        return $this;
    }
    /**
     * Get StakeholderHomePhone value
     * @return string|null
     */
    public function getStakeholderHomePhone()
    {
        return $this->StakeholderHomePhone;
    }
    /**
     * Set StakeholderHomePhone value
     * @param string $stakeholderHomePhone
     * @return \StructType\Event
     */
    public function setStakeholderHomePhone($stakeholderHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderHomePhone) && !is_string($stakeholderHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderHomePhone, true), gettype($stakeholderHomePhone)), __LINE__);
        }
        $this->StakeholderHomePhone = $stakeholderHomePhone;
        return $this;
    }
    /**
     * Get StakeholderWorkFax value
     * @return string|null
     */
    public function getStakeholderWorkFax()
    {
        return $this->StakeholderWorkFax;
    }
    /**
     * Set StakeholderWorkFax value
     * @param string $stakeholderWorkFax
     * @return \StructType\Event
     */
    public function setStakeholderWorkFax($stakeholderWorkFax = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderWorkFax) && !is_string($stakeholderWorkFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderWorkFax, true), gettype($stakeholderWorkFax)), __LINE__);
        }
        $this->StakeholderWorkFax = $stakeholderWorkFax;
        return $this;
    }
    /**
     * Get StakeholderMobilePhone value
     * @return string|null
     */
    public function getStakeholderMobilePhone()
    {
        return $this->StakeholderMobilePhone;
    }
    /**
     * Set StakeholderMobilePhone value
     * @param string $stakeholderMobilePhone
     * @return \StructType\Event
     */
    public function setStakeholderMobilePhone($stakeholderMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderMobilePhone) && !is_string($stakeholderMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderMobilePhone, true), gettype($stakeholderMobilePhone)), __LINE__);
        }
        $this->StakeholderMobilePhone = $stakeholderMobilePhone;
        return $this;
    }
    /**
     * Get StakeholderAddress1 value
     * @return string|null
     */
    public function getStakeholderAddress1()
    {
        return $this->StakeholderAddress1;
    }
    /**
     * Set StakeholderAddress1 value
     * @param string $stakeholderAddress1
     * @return \StructType\Event
     */
    public function setStakeholderAddress1($stakeholderAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress1) && !is_string($stakeholderAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress1, true), gettype($stakeholderAddress1)), __LINE__);
        }
        $this->StakeholderAddress1 = $stakeholderAddress1;
        return $this;
    }
    /**
     * Get StakeholderAddress2 value
     * @return string|null
     */
    public function getStakeholderAddress2()
    {
        return $this->StakeholderAddress2;
    }
    /**
     * Set StakeholderAddress2 value
     * @param string $stakeholderAddress2
     * @return \StructType\Event
     */
    public function setStakeholderAddress2($stakeholderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress2) && !is_string($stakeholderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress2, true), gettype($stakeholderAddress2)), __LINE__);
        }
        $this->StakeholderAddress2 = $stakeholderAddress2;
        return $this;
    }
    /**
     * Get StakeholderAddress3 value
     * @return string|null
     */
    public function getStakeholderAddress3()
    {
        return $this->StakeholderAddress3;
    }
    /**
     * Set StakeholderAddress3 value
     * @param string $stakeholderAddress3
     * @return \StructType\Event
     */
    public function setStakeholderAddress3($stakeholderAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderAddress3) && !is_string($stakeholderAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderAddress3, true), gettype($stakeholderAddress3)), __LINE__);
        }
        $this->StakeholderAddress3 = $stakeholderAddress3;
        return $this;
    }
    /**
     * Get StakeholderCity value
     * @return string|null
     */
    public function getStakeholderCity()
    {
        return $this->StakeholderCity;
    }
    /**
     * Set StakeholderCity value
     * @param string $stakeholderCity
     * @return \StructType\Event
     */
    public function setStakeholderCity($stakeholderCity = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCity) && !is_string($stakeholderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCity, true), gettype($stakeholderCity)), __LINE__);
        }
        $this->StakeholderCity = $stakeholderCity;
        return $this;
    }
    /**
     * Get StakeholderStateCode value
     * @return string|null
     */
    public function getStakeholderStateCode()
    {
        return $this->StakeholderStateCode;
    }
    /**
     * Set StakeholderStateCode value
     * @param string $stakeholderStateCode
     * @return \StructType\Event
     */
    public function setStakeholderStateCode($stakeholderStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderStateCode) && !is_string($stakeholderStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderStateCode, true), gettype($stakeholderStateCode)), __LINE__);
        }
        $this->StakeholderStateCode = $stakeholderStateCode;
        return $this;
    }
    /**
     * Get StakeholderPostalCode value
     * @return string|null
     */
    public function getStakeholderPostalCode()
    {
        return $this->StakeholderPostalCode;
    }
    /**
     * Set StakeholderPostalCode value
     * @param string $stakeholderPostalCode
     * @return \StructType\Event
     */
    public function setStakeholderPostalCode($stakeholderPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderPostalCode) && !is_string($stakeholderPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderPostalCode, true), gettype($stakeholderPostalCode)), __LINE__);
        }
        $this->StakeholderPostalCode = $stakeholderPostalCode;
        return $this;
    }
    /**
     * Get StakeholderCountryCode value
     * @return string|null
     */
    public function getStakeholderCountryCode()
    {
        return $this->StakeholderCountryCode;
    }
    /**
     * Set StakeholderCountryCode value
     * @param string $stakeholderCountryCode
     * @return \StructType\Event
     */
    public function setStakeholderCountryCode($stakeholderCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($stakeholderCountryCode) && !is_string($stakeholderCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stakeholderCountryCode, true), gettype($stakeholderCountryCode)), __LINE__);
        }
        $this->StakeholderCountryCode = $stakeholderCountryCode;
        return $this;
    }
    /**
     * Get MerchantAccount value
     * @return string|null
     */
    public function getMerchantAccount()
    {
        return $this->MerchantAccount;
    }
    /**
     * Set MerchantAccount value
     * @param string $merchantAccount
     * @return \StructType\Event
     */
    public function setMerchantAccount($merchantAccount = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccount) && !is_string($merchantAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccount, true), gettype($merchantAccount)), __LINE__);
        }
        $this->MerchantAccount = $merchantAccount;
        return $this;
    }
    /**
     * Get MerchantAccountId value
     * @return string|null
     */
    public function getMerchantAccountId()
    {
        return $this->MerchantAccountId;
    }
    /**
     * Set MerchantAccountId value
     * @param string $merchantAccountId
     * @return \StructType\Event
     */
    public function setMerchantAccountId($merchantAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountId) && !is_string($merchantAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountId, true), gettype($merchantAccountId)), __LINE__);
        }
        $this->MerchantAccountId = $merchantAccountId;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\Event
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get EventCalendarLinkText value
     * @return string|null
     */
    public function getEventCalendarLinkText()
    {
        return $this->EventCalendarLinkText;
    }
    /**
     * Set EventCalendarLinkText value
     * @param string $eventCalendarLinkText
     * @return \StructType\Event
     */
    public function setEventCalendarLinkText($eventCalendarLinkText = null)
    {
        // validation for constraint: string
        if (!is_null($eventCalendarLinkText) && !is_string($eventCalendarLinkText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCalendarLinkText, true), gettype($eventCalendarLinkText)), __LINE__);
        }
        $this->EventCalendarLinkText = $eventCalendarLinkText;
        return $this;
    }
    /**
     * Get EventCalendarAlternateURL value
     * @return string|null
     */
    public function getEventCalendarAlternateURL()
    {
        return $this->EventCalendarAlternateURL;
    }
    /**
     * Set EventCalendarAlternateURL value
     * @param string $eventCalendarAlternateURL
     * @return \StructType\Event
     */
    public function setEventCalendarAlternateURL($eventCalendarAlternateURL = null)
    {
        // validation for constraint: string
        if (!is_null($eventCalendarAlternateURL) && !is_string($eventCalendarAlternateURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCalendarAlternateURL, true), gettype($eventCalendarAlternateURL)), __LINE__);
        }
        $this->EventCalendarAlternateURL = $eventCalendarAlternateURL;
        return $this;
    }
    /**
     * Get EventCalendarCompletedURL value
     * @return string|null
     */
    public function getEventCalendarCompletedURL()
    {
        return $this->EventCalendarCompletedURL;
    }
    /**
     * Set EventCalendarCompletedURL value
     * @param string $eventCalendarCompletedURL
     * @return \StructType\Event
     */
    public function setEventCalendarCompletedURL($eventCalendarCompletedURL = null)
    {
        // validation for constraint: string
        if (!is_null($eventCalendarCompletedURL) && !is_string($eventCalendarCompletedURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCalendarCompletedURL, true), gettype($eventCalendarCompletedURL)), __LINE__);
        }
        $this->EventCalendarCompletedURL = $eventCalendarCompletedURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Event
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
