<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityCustomField StructType
 * @subpackage Structs
 */
class EntityCustomField extends CvObject
{
    /**
     * The FieldChoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FieldChoice[]
     */
    public $FieldChoices;
    /**
     * The FieldName
     * @var string
     */
    public $FieldName;
    /**
     * The FieldCode
     * @var string
     */
    public $FieldCode;
    /**
     * The HelpText
     * @var string
     */
    public $HelpText;
    /**
     * The FieldType
     * @var string
     */
    public $FieldType;
    /**
     * The AnswerFormat
     * @var string
     */
    public $AnswerFormat;
    /**
     * The MinimumCharacters
     * @var int
     */
    public $MinimumCharacters;
    /**
     * The MaximumCharacters
     * @var int
     */
    public $MaximumCharacters;
    /**
     * The MinimumNumber
     * @var int
     */
    public $MinimumNumber;
    /**
     * The MaximumNumber
     * @var int
     */
    public $MaximumNumber;
    /**
     * The PrepopulateCurrentDate
     * @var bool
     */
    public $PrepopulateCurrentDate;
    /**
     * The EarliestDate
     * @var string
     */
    public $EarliestDate;
    /**
     * The LatestDate
     * @var string
     */
    public $LatestDate;
    /**
     * The DisplayPopUpCalendar
     * @var bool
     */
    public $DisplayPopUpCalendar;
    /**
     * Constructor method for EntityCustomField
     * @uses EntityCustomField::setFieldChoices()
     * @uses EntityCustomField::setFieldName()
     * @uses EntityCustomField::setFieldCode()
     * @uses EntityCustomField::setHelpText()
     * @uses EntityCustomField::setFieldType()
     * @uses EntityCustomField::setAnswerFormat()
     * @uses EntityCustomField::setMinimumCharacters()
     * @uses EntityCustomField::setMaximumCharacters()
     * @uses EntityCustomField::setMinimumNumber()
     * @uses EntityCustomField::setMaximumNumber()
     * @uses EntityCustomField::setPrepopulateCurrentDate()
     * @uses EntityCustomField::setEarliestDate()
     * @uses EntityCustomField::setLatestDate()
     * @uses EntityCustomField::setDisplayPopUpCalendar()
     * @param \StructType\FieldChoice[] $fieldChoices
     * @param string $fieldName
     * @param string $fieldCode
     * @param string $helpText
     * @param string $fieldType
     * @param string $answerFormat
     * @param int $minimumCharacters
     * @param int $maximumCharacters
     * @param int $minimumNumber
     * @param int $maximumNumber
     * @param bool $prepopulateCurrentDate
     * @param string $earliestDate
     * @param string $latestDate
     * @param bool $displayPopUpCalendar
     */
    public function __construct(array $fieldChoices = array(), $fieldName = null, $fieldCode = null, $helpText = null, $fieldType = null, $answerFormat = null, $minimumCharacters = null, $maximumCharacters = null, $minimumNumber = null, $maximumNumber = null, $prepopulateCurrentDate = null, $earliestDate = null, $latestDate = null, $displayPopUpCalendar = null)
    {
        $this
            ->setFieldChoices($fieldChoices)
            ->setFieldName($fieldName)
            ->setFieldCode($fieldCode)
            ->setHelpText($helpText)
            ->setFieldType($fieldType)
            ->setAnswerFormat($answerFormat)
            ->setMinimumCharacters($minimumCharacters)
            ->setMaximumCharacters($maximumCharacters)
            ->setMinimumNumber($minimumNumber)
            ->setMaximumNumber($maximumNumber)
            ->setPrepopulateCurrentDate($prepopulateCurrentDate)
            ->setEarliestDate($earliestDate)
            ->setLatestDate($latestDate)
            ->setDisplayPopUpCalendar($displayPopUpCalendar);
    }
    /**
     * Get FieldChoices value
     * @return \StructType\FieldChoice[]|null
     */
    public function getFieldChoices()
    {
        return $this->FieldChoices;
    }
    /**
     * This method is responsible for validating the values passed to the setFieldChoices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFieldChoices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldChoicesForArrayConstraintsFromSetFieldChoices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $entityCustomFieldFieldChoicesItem) {
            // validation for constraint: itemType
            if (!$entityCustomFieldFieldChoicesItem instanceof \StructType\FieldChoice) {
                $invalidValues[] = is_object($entityCustomFieldFieldChoicesItem) ? get_class($entityCustomFieldFieldChoicesItem) : sprintf('%s(%s)', gettype($entityCustomFieldFieldChoicesItem), var_export($entityCustomFieldFieldChoicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FieldChoices property can only contain items of type \StructType\FieldChoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FieldChoices value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldChoice[] $fieldChoices
     * @return \StructType\EntityCustomField
     */
    public function setFieldChoices(array $fieldChoices = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldChoicesArrayErrorMessage = self::validateFieldChoicesForArrayConstraintsFromSetFieldChoices($fieldChoices))) {
            throw new \InvalidArgumentException($fieldChoicesArrayErrorMessage, __LINE__);
        }
        $this->FieldChoices = $fieldChoices;
        return $this;
    }
    /**
     * Add item to FieldChoices value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldChoice $item
     * @return \StructType\EntityCustomField
     */
    public function addToFieldChoices(\StructType\FieldChoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FieldChoice) {
            throw new \InvalidArgumentException(sprintf('The FieldChoices property can only contain items of type \StructType\FieldChoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FieldChoices[] = $item;
        return $this;
    }
    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @param string $fieldName
     * @return \StructType\EntityCustomField
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Get FieldCode value
     * @return string|null
     */
    public function getFieldCode()
    {
        return $this->FieldCode;
    }
    /**
     * Set FieldCode value
     * @param string $fieldCode
     * @return \StructType\EntityCustomField
     */
    public function setFieldCode($fieldCode = null)
    {
        // validation for constraint: string
        if (!is_null($fieldCode) && !is_string($fieldCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldCode, true), gettype($fieldCode)), __LINE__);
        }
        $this->FieldCode = $fieldCode;
        return $this;
    }
    /**
     * Get HelpText value
     * @return string|null
     */
    public function getHelpText()
    {
        return $this->HelpText;
    }
    /**
     * Set HelpText value
     * @param string $helpText
     * @return \StructType\EntityCustomField
     */
    public function setHelpText($helpText = null)
    {
        // validation for constraint: string
        if (!is_null($helpText) && !is_string($helpText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helpText, true), gettype($helpText)), __LINE__);
        }
        $this->HelpText = $helpText;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @param string $fieldType
     * @return \StructType\EntityCustomField
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: string
        if (!is_null($fieldType) && !is_string($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldType, true), gettype($fieldType)), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get AnswerFormat value
     * @return string|null
     */
    public function getAnswerFormat()
    {
        return $this->AnswerFormat;
    }
    /**
     * Set AnswerFormat value
     * @param string $answerFormat
     * @return \StructType\EntityCustomField
     */
    public function setAnswerFormat($answerFormat = null)
    {
        // validation for constraint: string
        if (!is_null($answerFormat) && !is_string($answerFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answerFormat, true), gettype($answerFormat)), __LINE__);
        }
        $this->AnswerFormat = $answerFormat;
        return $this;
    }
    /**
     * Get MinimumCharacters value
     * @return int|null
     */
    public function getMinimumCharacters()
    {
        return $this->MinimumCharacters;
    }
    /**
     * Set MinimumCharacters value
     * @param int $minimumCharacters
     * @return \StructType\EntityCustomField
     */
    public function setMinimumCharacters($minimumCharacters = null)
    {
        // validation for constraint: int
        if (!is_null($minimumCharacters) && !(is_int($minimumCharacters) || ctype_digit($minimumCharacters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumCharacters, true), gettype($minimumCharacters)), __LINE__);
        }
        $this->MinimumCharacters = $minimumCharacters;
        return $this;
    }
    /**
     * Get MaximumCharacters value
     * @return int|null
     */
    public function getMaximumCharacters()
    {
        return $this->MaximumCharacters;
    }
    /**
     * Set MaximumCharacters value
     * @param int $maximumCharacters
     * @return \StructType\EntityCustomField
     */
    public function setMaximumCharacters($maximumCharacters = null)
    {
        // validation for constraint: int
        if (!is_null($maximumCharacters) && !(is_int($maximumCharacters) || ctype_digit($maximumCharacters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumCharacters, true), gettype($maximumCharacters)), __LINE__);
        }
        $this->MaximumCharacters = $maximumCharacters;
        return $this;
    }
    /**
     * Get MinimumNumber value
     * @return int|null
     */
    public function getMinimumNumber()
    {
        return $this->MinimumNumber;
    }
    /**
     * Set MinimumNumber value
     * @param int $minimumNumber
     * @return \StructType\EntityCustomField
     */
    public function setMinimumNumber($minimumNumber = null)
    {
        // validation for constraint: int
        if (!is_null($minimumNumber) && !(is_int($minimumNumber) || ctype_digit($minimumNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumNumber, true), gettype($minimumNumber)), __LINE__);
        }
        $this->MinimumNumber = $minimumNumber;
        return $this;
    }
    /**
     * Get MaximumNumber value
     * @return int|null
     */
    public function getMaximumNumber()
    {
        return $this->MaximumNumber;
    }
    /**
     * Set MaximumNumber value
     * @param int $maximumNumber
     * @return \StructType\EntityCustomField
     */
    public function setMaximumNumber($maximumNumber = null)
    {
        // validation for constraint: int
        if (!is_null($maximumNumber) && !(is_int($maximumNumber) || ctype_digit($maximumNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumNumber, true), gettype($maximumNumber)), __LINE__);
        }
        $this->MaximumNumber = $maximumNumber;
        return $this;
    }
    /**
     * Get PrepopulateCurrentDate value
     * @return bool|null
     */
    public function getPrepopulateCurrentDate()
    {
        return $this->PrepopulateCurrentDate;
    }
    /**
     * Set PrepopulateCurrentDate value
     * @param bool $prepopulateCurrentDate
     * @return \StructType\EntityCustomField
     */
    public function setPrepopulateCurrentDate($prepopulateCurrentDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepopulateCurrentDate) && !is_bool($prepopulateCurrentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepopulateCurrentDate, true), gettype($prepopulateCurrentDate)), __LINE__);
        }
        $this->PrepopulateCurrentDate = $prepopulateCurrentDate;
        return $this;
    }
    /**
     * Get EarliestDate value
     * @return string|null
     */
    public function getEarliestDate()
    {
        return $this->EarliestDate;
    }
    /**
     * Set EarliestDate value
     * @param string $earliestDate
     * @return \StructType\EntityCustomField
     */
    public function setEarliestDate($earliestDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDate) && !is_string($earliestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestDate, true), gettype($earliestDate)), __LINE__);
        }
        $this->EarliestDate = $earliestDate;
        return $this;
    }
    /**
     * Get LatestDate value
     * @return string|null
     */
    public function getLatestDate()
    {
        return $this->LatestDate;
    }
    /**
     * Set LatestDate value
     * @param string $latestDate
     * @return \StructType\EntityCustomField
     */
    public function setLatestDate($latestDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestDate) && !is_string($latestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDate, true), gettype($latestDate)), __LINE__);
        }
        $this->LatestDate = $latestDate;
        return $this;
    }
    /**
     * Get DisplayPopUpCalendar value
     * @return bool|null
     */
    public function getDisplayPopUpCalendar()
    {
        return $this->DisplayPopUpCalendar;
    }
    /**
     * Set DisplayPopUpCalendar value
     * @param bool $displayPopUpCalendar
     * @return \StructType\EntityCustomField
     */
    public function setDisplayPopUpCalendar($displayPopUpCalendar = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayPopUpCalendar) && !is_bool($displayPopUpCalendar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayPopUpCalendar, true), gettype($displayPopUpCalendar)), __LINE__);
        }
        $this->DisplayPopUpCalendar = $displayPopUpCalendar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
