<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMarketingEmailHistory StructType
 * @subpackage Structs
 */
class EMarketingEmailHistory extends CvObject
{
    /**
     * The CampaignID
     * @var string
     */
    public $CampaignID;
    /**
     * The ContactId
     * @var string
     */
    public $ContactId;
    /**
     * The EmailSentDate
     * @var string
     */
    public $EmailSentDate;
    /**
     * The EmailStatus
     * @var string
     */
    public $EmailStatus;
    /**
     * The FromEmailAddress
     * @var string
     */
    public $FromEmailAddress;
    /**
     * The ToEmailAddress
     * @var string
     */
    public $ToEmailAddress;
    /**
     * The EmailViewed
     * @var bool
     */
    public $EmailViewed;
    /**
     * The EmailBounced
     * @var bool
     */
    public $EmailBounced;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for EMarketingEmailHistory
     * @uses EMarketingEmailHistory::setCampaignID()
     * @uses EMarketingEmailHistory::setContactId()
     * @uses EMarketingEmailHistory::setEmailSentDate()
     * @uses EMarketingEmailHistory::setEmailStatus()
     * @uses EMarketingEmailHistory::setFromEmailAddress()
     * @uses EMarketingEmailHistory::setToEmailAddress()
     * @uses EMarketingEmailHistory::setEmailViewed()
     * @uses EMarketingEmailHistory::setEmailBounced()
     * @uses EMarketingEmailHistory::setLastModifiedDate()
     * @param string $campaignID
     * @param string $contactId
     * @param string $emailSentDate
     * @param string $emailStatus
     * @param string $fromEmailAddress
     * @param string $toEmailAddress
     * @param bool $emailViewed
     * @param bool $emailBounced
     * @param string $lastModifiedDate
     */
    public function __construct($campaignID = null, $contactId = null, $emailSentDate = null, $emailStatus = null, $fromEmailAddress = null, $toEmailAddress = null, $emailViewed = null, $emailBounced = null, $lastModifiedDate = null)
    {
        $this
            ->setCampaignID($campaignID)
            ->setContactId($contactId)
            ->setEmailSentDate($emailSentDate)
            ->setEmailStatus($emailStatus)
            ->setFromEmailAddress($fromEmailAddress)
            ->setToEmailAddress($toEmailAddress)
            ->setEmailViewed($emailViewed)
            ->setEmailBounced($emailBounced)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get CampaignID value
     * @return string|null
     */
    public function getCampaignID()
    {
        return $this->CampaignID;
    }
    /**
     * Set CampaignID value
     * @param string $campaignID
     * @return \StructType\EMarketingEmailHistory
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: string
        if (!is_null($campaignID) && !is_string($campaignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->CampaignID = $campaignID;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\EMarketingEmailHistory
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get EmailSentDate value
     * @return string|null
     */
    public function getEmailSentDate()
    {
        return $this->EmailSentDate;
    }
    /**
     * Set EmailSentDate value
     * @param string $emailSentDate
     * @return \StructType\EMarketingEmailHistory
     */
    public function setEmailSentDate($emailSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($emailSentDate) && !is_string($emailSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSentDate, true), gettype($emailSentDate)), __LINE__);
        }
        $this->EmailSentDate = $emailSentDate;
        return $this;
    }
    /**
     * Get EmailStatus value
     * @return string|null
     */
    public function getEmailStatus()
    {
        return $this->EmailStatus;
    }
    /**
     * Set EmailStatus value
     * @param string $emailStatus
     * @return \StructType\EMarketingEmailHistory
     */
    public function setEmailStatus($emailStatus = null)
    {
        // validation for constraint: string
        if (!is_null($emailStatus) && !is_string($emailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailStatus, true), gettype($emailStatus)), __LINE__);
        }
        $this->EmailStatus = $emailStatus;
        return $this;
    }
    /**
     * Get FromEmailAddress value
     * @return string|null
     */
    public function getFromEmailAddress()
    {
        return $this->FromEmailAddress;
    }
    /**
     * Set FromEmailAddress value
     * @param string $fromEmailAddress
     * @return \StructType\EMarketingEmailHistory
     */
    public function setFromEmailAddress($fromEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromEmailAddress) && !is_string($fromEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEmailAddress, true), gettype($fromEmailAddress)), __LINE__);
        }
        $this->FromEmailAddress = $fromEmailAddress;
        return $this;
    }
    /**
     * Get ToEmailAddress value
     * @return string|null
     */
    public function getToEmailAddress()
    {
        return $this->ToEmailAddress;
    }
    /**
     * Set ToEmailAddress value
     * @param string $toEmailAddress
     * @return \StructType\EMarketingEmailHistory
     */
    public function setToEmailAddress($toEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($toEmailAddress) && !is_string($toEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEmailAddress, true), gettype($toEmailAddress)), __LINE__);
        }
        $this->ToEmailAddress = $toEmailAddress;
        return $this;
    }
    /**
     * Get EmailViewed value
     * @return bool|null
     */
    public function getEmailViewed()
    {
        return $this->EmailViewed;
    }
    /**
     * Set EmailViewed value
     * @param bool $emailViewed
     * @return \StructType\EMarketingEmailHistory
     */
    public function setEmailViewed($emailViewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailViewed) && !is_bool($emailViewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailViewed, true), gettype($emailViewed)), __LINE__);
        }
        $this->EmailViewed = $emailViewed;
        return $this;
    }
    /**
     * Get EmailBounced value
     * @return bool|null
     */
    public function getEmailBounced()
    {
        return $this->EmailBounced;
    }
    /**
     * Set EmailBounced value
     * @param bool $emailBounced
     * @return \StructType\EMarketingEmailHistory
     */
    public function setEmailBounced($emailBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailBounced) && !is_bool($emailBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailBounced, true), gettype($emailBounced)), __LINE__);
        }
        $this->EmailBounced = $emailBounced;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\EMarketingEmailHistory
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EMarketingEmailHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
