<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDetail StructType
 * @subpackage Structs
 */
class DocumentDetail extends AbstractStructBase
{
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The FileType
     * @var string
     */
    public $FileType;
    /**
     * The FileSize
     * @var int
     */
    public $FileSize;
    /**
     * The UploadDate
     * @var string
     */
    public $UploadDate;
    /**
     * The FileDisplay
     * @var bool
     */
    public $FileDisplay;
    /**
     * The FileURL
     * @var string
     */
    public $FileURL;
    /**
     * Constructor method for DocumentDetail
     * @uses DocumentDetail::setFileName()
     * @uses DocumentDetail::setFileType()
     * @uses DocumentDetail::setFileSize()
     * @uses DocumentDetail::setUploadDate()
     * @uses DocumentDetail::setFileDisplay()
     * @uses DocumentDetail::setFileURL()
     * @param string $fileName
     * @param string $fileType
     * @param int $fileSize
     * @param string $uploadDate
     * @param bool $fileDisplay
     * @param string $fileURL
     */
    public function __construct($fileName = null, $fileType = null, $fileSize = null, $uploadDate = null, $fileDisplay = null, $fileURL = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileType($fileType)
            ->setFileSize($fileSize)
            ->setUploadDate($uploadDate)
            ->setFileDisplay($fileDisplay)
            ->setFileURL($fileURL);
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\DocumentDetail
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\DocumentDetail
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\DocumentDetail
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get UploadDate value
     * @return string|null
     */
    public function getUploadDate()
    {
        return $this->UploadDate;
    }
    /**
     * Set UploadDate value
     * @param string $uploadDate
     * @return \StructType\DocumentDetail
     */
    public function setUploadDate($uploadDate = null)
    {
        // validation for constraint: string
        if (!is_null($uploadDate) && !is_string($uploadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadDate, true), gettype($uploadDate)), __LINE__);
        }
        $this->UploadDate = $uploadDate;
        return $this;
    }
    /**
     * Get FileDisplay value
     * @return bool|null
     */
    public function getFileDisplay()
    {
        return $this->FileDisplay;
    }
    /**
     * Set FileDisplay value
     * @param bool $fileDisplay
     * @return \StructType\DocumentDetail
     */
    public function setFileDisplay($fileDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($fileDisplay) && !is_bool($fileDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fileDisplay, true), gettype($fileDisplay)), __LINE__);
        }
        $this->FileDisplay = $fileDisplay;
        return $this;
    }
    /**
     * Get FileURL value
     * @return string|null
     */
    public function getFileURL()
    {
        return $this->FileURL;
    }
    /**
     * Set FileURL value
     * @param string $fileURL
     * @return \StructType\DocumentDetail
     */
    public function setFileURL($fileURL = null)
    {
        // validation for constraint: string
        if (!is_null($fileURL) && !is_string($fileURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileURL, true), gettype($fileURL)), __LINE__);
        }
        $this->FileURL = $fileURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
