<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionListDetail StructType
 * @subpackage Structs
 */
class DistributionListDetail extends CvObject
{
    /**
     * The DistributionListName
     * @var string
     */
    public $DistributionListName;
    /**
     * The Approved
     * @var bool
     */
    public $Approved;
    /**
     * Constructor method for DistributionListDetail
     * @uses DistributionListDetail::setDistributionListName()
     * @uses DistributionListDetail::setApproved()
     * @param string $distributionListName
     * @param bool $approved
     */
    public function __construct($distributionListName = null, $approved = null)
    {
        $this
            ->setDistributionListName($distributionListName)
            ->setApproved($approved);
    }
    /**
     * Get DistributionListName value
     * @return string|null
     */
    public function getDistributionListName()
    {
        return $this->DistributionListName;
    }
    /**
     * Set DistributionListName value
     * @param string $distributionListName
     * @return \StructType\DistributionListDetail
     */
    public function setDistributionListName($distributionListName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionListName) && !is_string($distributionListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionListName, true), gettype($distributionListName)), __LINE__);
        }
        $this->DistributionListName = $distributionListName;
        return $this;
    }
    /**
     * Get Approved value
     * @return bool|null
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param bool $approved
     * @return \StructType\DistributionListDetail
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: boolean
        if (!is_null($approved) && !is_bool($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approved, true), gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributionListDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
