<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionList StructType
 * @subpackage Structs
 */
class DistributionList extends CvObject
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The SecurityType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SecurityType;
    /**
     * The DistributionListName
     * @var string
     */
    public $DistributionListName;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The InternalNote
     * @var string
     */
    public $InternalNote;
    /**
     * Constructor method for DistributionList
     * @uses DistributionList::setActive()
     * @uses DistributionList::setSecurityType()
     * @uses DistributionList::setDistributionListName()
     * @uses DistributionList::setDescription()
     * @uses DistributionList::setInternalNote()
     * @param bool $active
     * @param string $securityType
     * @param string $distributionListName
     * @param string $description
     * @param string $internalNote
     */
    public function __construct($active = null, $securityType = null, $distributionListName = null, $description = null, $internalNote = null)
    {
        $this
            ->setActive($active)
            ->setSecurityType($securityType)
            ->setDistributionListName($distributionListName)
            ->setDescription($description)
            ->setInternalNote($internalNote);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\DistributionList
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get SecurityType value
     * @return string
     */
    public function getSecurityType()
    {
        return $this->SecurityType;
    }
    /**
     * Set SecurityType value
     * @uses \EnumType\DistributionListSecurityType::valueIsValid()
     * @uses \EnumType\DistributionListSecurityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityType
     * @return \StructType\DistributionList
     */
    public function setSecurityType($securityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributionListSecurityType::valueIsValid($securityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistributionListSecurityType', is_array($securityType) ? implode(', ', $securityType) : var_export($securityType, true), implode(', ', \EnumType\DistributionListSecurityType::getValidValues())), __LINE__);
        }
        $this->SecurityType = $securityType;
        return $this;
    }
    /**
     * Get DistributionListName value
     * @return string|null
     */
    public function getDistributionListName()
    {
        return $this->DistributionListName;
    }
    /**
     * Set DistributionListName value
     * @param string $distributionListName
     * @return \StructType\DistributionList
     */
    public function setDistributionListName($distributionListName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionListName) && !is_string($distributionListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionListName, true), gettype($distributionListName)), __LINE__);
        }
        $this->DistributionListName = $distributionListName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DistributionList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get InternalNote value
     * @return string|null
     */
    public function getInternalNote()
    {
        return $this->InternalNote;
    }
    /**
     * Set InternalNote value
     * @param string $internalNote
     * @return \StructType\DistributionList
     */
    public function setInternalNote($internalNote = null)
    {
        // validation for constraint: string
        if (!is_null($internalNote) && !is_string($internalNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalNote, true), gettype($internalNote)), __LINE__);
        }
        $this->InternalNote = $internalNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
