<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionDetail StructType
 * @subpackage Structs
 */
class DistributionDetail extends AbstractStructBase
{
    /**
     * The GLCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GLCodes[]
     */
    public $GLCodes;
    /**
     * The ProductId
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * @var string
     */
    public $ProductName;
    /**
     * The ProductCode
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The OrderPrice
     * @var float
     */
    public $OrderPrice;
    /**
     * The AmountApplied
     * @var float
     */
    public $AmountApplied;
    /**
     * The GLCode
     * @var string
     */
    public $GLCode;
    /**
     * The GLDescription
     * @var string
     */
    public $GLDescription;
    /**
     * The OrderNumber
     * @var string
     */
    public $OrderNumber;
    /**
     * Constructor method for DistributionDetail
     * @uses DistributionDetail::setGLCodes()
     * @uses DistributionDetail::setProductId()
     * @uses DistributionDetail::setProductName()
     * @uses DistributionDetail::setProductCode()
     * @uses DistributionDetail::setProductType()
     * @uses DistributionDetail::setOrderPrice()
     * @uses DistributionDetail::setAmountApplied()
     * @uses DistributionDetail::setGLCode()
     * @uses DistributionDetail::setGLDescription()
     * @uses DistributionDetail::setOrderNumber()
     * @param \StructType\GLCodes[] $gLCodes
     * @param string $productId
     * @param string $productName
     * @param string $productCode
     * @param string $productType
     * @param float $orderPrice
     * @param float $amountApplied
     * @param string $gLCode
     * @param string $gLDescription
     * @param string $orderNumber
     */
    public function __construct(array $gLCodes = array(), $productId = null, $productName = null, $productCode = null, $productType = null, $orderPrice = null, $amountApplied = null, $gLCode = null, $gLDescription = null, $orderNumber = null)
    {
        $this
            ->setGLCodes($gLCodes)
            ->setProductId($productId)
            ->setProductName($productName)
            ->setProductCode($productCode)
            ->setProductType($productType)
            ->setOrderPrice($orderPrice)
            ->setAmountApplied($amountApplied)
            ->setGLCode($gLCode)
            ->setGLDescription($gLDescription)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get GLCodes value
     * @return \StructType\GLCodes[]|null
     */
    public function getGLCodes()
    {
        return $this->GLCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setGLCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGLCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGLCodesForArrayConstraintsFromSetGLCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $distributionDetailGLCodesItem) {
            // validation for constraint: itemType
            if (!$distributionDetailGLCodesItem instanceof \StructType\GLCodes) {
                $invalidValues[] = is_object($distributionDetailGLCodesItem) ? get_class($distributionDetailGLCodesItem) : sprintf('%s(%s)', gettype($distributionDetailGLCodesItem), var_export($distributionDetailGLCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GLCodes property can only contain items of type \StructType\GLCodes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GLCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GLCodes[] $gLCodes
     * @return \StructType\DistributionDetail
     */
    public function setGLCodes(array $gLCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($gLCodesArrayErrorMessage = self::validateGLCodesForArrayConstraintsFromSetGLCodes($gLCodes))) {
            throw new \InvalidArgumentException($gLCodesArrayErrorMessage, __LINE__);
        }
        $this->GLCodes = $gLCodes;
        return $this;
    }
    /**
     * Add item to GLCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\GLCodes $item
     * @return \StructType\DistributionDetail
     */
    public function addToGLCodes(\StructType\GLCodes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GLCodes) {
            throw new \InvalidArgumentException(sprintf('The GLCodes property can only contain items of type \StructType\GLCodes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GLCodes[] = $item;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\DistributionDetail
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\DistributionDetail
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\DistributionDetail
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\DistributionDetail
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get OrderPrice value
     * @return float|null
     */
    public function getOrderPrice()
    {
        return $this->OrderPrice;
    }
    /**
     * Set OrderPrice value
     * @param float $orderPrice
     * @return \StructType\DistributionDetail
     */
    public function setOrderPrice($orderPrice = null)
    {
        // validation for constraint: float
        if (!is_null($orderPrice) && !(is_float($orderPrice) || is_numeric($orderPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderPrice, true), gettype($orderPrice)), __LINE__);
        }
        $this->OrderPrice = $orderPrice;
        return $this;
    }
    /**
     * Get AmountApplied value
     * @return float|null
     */
    public function getAmountApplied()
    {
        return $this->AmountApplied;
    }
    /**
     * Set AmountApplied value
     * @param float $amountApplied
     * @return \StructType\DistributionDetail
     */
    public function setAmountApplied($amountApplied = null)
    {
        // validation for constraint: float
        if (!is_null($amountApplied) && !(is_float($amountApplied) || is_numeric($amountApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountApplied, true), gettype($amountApplied)), __LINE__);
        }
        $this->AmountApplied = $amountApplied;
        return $this;
    }
    /**
     * Get GLCode value
     * @return string|null
     */
    public function getGLCode()
    {
        return $this->GLCode;
    }
    /**
     * Set GLCode value
     * @param string $gLCode
     * @return \StructType\DistributionDetail
     */
    public function setGLCode($gLCode = null)
    {
        // validation for constraint: string
        if (!is_null($gLCode) && !is_string($gLCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLCode, true), gettype($gLCode)), __LINE__);
        }
        $this->GLCode = $gLCode;
        return $this;
    }
    /**
     * Get GLDescription value
     * @return string|null
     */
    public function getGLDescription()
    {
        return $this->GLDescription;
    }
    /**
     * Set GLDescription value
     * @param string $gLDescription
     * @return \StructType\DistributionDetail
     */
    public function setGLDescription($gLDescription = null)
    {
        // validation for constraint: string
        if (!is_null($gLDescription) && !is_string($gLDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gLDescription, true), gettype($gLDescription)), __LINE__);
        }
        $this->GLDescription = $gLDescription;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\DistributionDetail
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
