<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountDetail StructType
 * @subpackage Structs
 */
class DiscountDetail extends AbstractStructBase
{
    /**
     * The DiscountDetailId
     * @var string
     */
    public $DiscountDetailId;
    /**
     * The DiscountCode
     * @var string
     */
    public $DiscountCode;
    /**
     * The DiscountName
     * @var string
     */
    public $DiscountName;
    /**
     * The DiscountType
     * @var string
     */
    public $DiscountType;
    /**
     * The DiscountValue
     * @var float
     */
    public $DiscountValue;
    /**
     * The DiscountAmount
     * @var float
     */
    public $DiscountAmount;
    /**
     * Constructor method for DiscountDetail
     * @uses DiscountDetail::setDiscountDetailId()
     * @uses DiscountDetail::setDiscountCode()
     * @uses DiscountDetail::setDiscountName()
     * @uses DiscountDetail::setDiscountType()
     * @uses DiscountDetail::setDiscountValue()
     * @uses DiscountDetail::setDiscountAmount()
     * @param string $discountDetailId
     * @param string $discountCode
     * @param string $discountName
     * @param string $discountType
     * @param float $discountValue
     * @param float $discountAmount
     */
    public function __construct($discountDetailId = null, $discountCode = null, $discountName = null, $discountType = null, $discountValue = null, $discountAmount = null)
    {
        $this
            ->setDiscountDetailId($discountDetailId)
            ->setDiscountCode($discountCode)
            ->setDiscountName($discountName)
            ->setDiscountType($discountType)
            ->setDiscountValue($discountValue)
            ->setDiscountAmount($discountAmount);
    }
    /**
     * Get DiscountDetailId value
     * @return string|null
     */
    public function getDiscountDetailId()
    {
        return $this->DiscountDetailId;
    }
    /**
     * Set DiscountDetailId value
     * @param string $discountDetailId
     * @return \StructType\DiscountDetail
     */
    public function setDiscountDetailId($discountDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($discountDetailId) && !is_string($discountDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountDetailId, true), gettype($discountDetailId)), __LINE__);
        }
        $this->DiscountDetailId = $discountDetailId;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\DiscountDetail
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountCode, true), gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get DiscountName value
     * @return string|null
     */
    public function getDiscountName()
    {
        return $this->DiscountName;
    }
    /**
     * Set DiscountName value
     * @param string $discountName
     * @return \StructType\DiscountDetail
     */
    public function setDiscountName($discountName = null)
    {
        // validation for constraint: string
        if (!is_null($discountName) && !is_string($discountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountName, true), gettype($discountName)), __LINE__);
        }
        $this->DiscountName = $discountName;
        return $this;
    }
    /**
     * Get DiscountType value
     * @return string|null
     */
    public function getDiscountType()
    {
        return $this->DiscountType;
    }
    /**
     * Set DiscountType value
     * @param string $discountType
     * @return \StructType\DiscountDetail
     */
    public function setDiscountType($discountType = null)
    {
        // validation for constraint: string
        if (!is_null($discountType) && !is_string($discountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountType, true), gettype($discountType)), __LINE__);
        }
        $this->DiscountType = $discountType;
        return $this;
    }
    /**
     * Get DiscountValue value
     * @return float|null
     */
    public function getDiscountValue()
    {
        return $this->DiscountValue;
    }
    /**
     * Set DiscountValue value
     * @param float $discountValue
     * @return \StructType\DiscountDetail
     */
    public function setDiscountValue($discountValue = null)
    {
        // validation for constraint: float
        if (!is_null($discountValue) && !(is_float($discountValue) || is_numeric($discountValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountValue, true), gettype($discountValue)), __LINE__);
        }
        $this->DiscountValue = $discountValue;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \StructType\DiscountDetail
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
