<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescribeGlobalResult StructType
 * Meta informations extracted from the WSDL
 * - type: s1:DescribeGlobalResult
 * @subpackage Structs
 */
class DescribeGlobalResult extends AbstractStructBase
{
    /**
     * The CvObjectTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CvObjectTypes;
    /**
     * The LookUps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLookUp
     */
    public $LookUps;
    /**
     * The MaxAPICalls
     * @var int
     */
    public $MaxAPICalls;
    /**
     * The CurrentAPICalls
     * @var int
     */
    public $CurrentAPICalls;
    /**
     * The MaxBatchSize
     * @var int
     */
    public $MaxBatchSize;
    /**
     * The MaxRecordSet
     * @var int
     */
    public $MaxRecordSet;
    /**
     * Constructor method for DescribeGlobalResult
     * @uses DescribeGlobalResult::setCvObjectTypes()
     * @uses DescribeGlobalResult::setLookUps()
     * @uses DescribeGlobalResult::setMaxAPICalls()
     * @uses DescribeGlobalResult::setCurrentAPICalls()
     * @uses DescribeGlobalResult::setMaxBatchSize()
     * @uses DescribeGlobalResult::setMaxRecordSet()
     * @param string[] $cvObjectTypes
     * @param \ArrayType\ArrayOfLookUp $lookUps
     * @param int $maxAPICalls
     * @param int $currentAPICalls
     * @param int $maxBatchSize
     * @param int $maxRecordSet
     */
    public function __construct(array $cvObjectTypes = array(), \ArrayType\ArrayOfLookUp $lookUps = null, $maxAPICalls = null, $currentAPICalls = null, $maxBatchSize = null, $maxRecordSet = null)
    {
        $this
            ->setCvObjectTypes($cvObjectTypes)
            ->setLookUps($lookUps)
            ->setMaxAPICalls($maxAPICalls)
            ->setCurrentAPICalls($currentAPICalls)
            ->setMaxBatchSize($maxBatchSize)
            ->setMaxRecordSet($maxRecordSet);
    }
    /**
     * Get CvObjectTypes value
     * @return string[]|null
     */
    public function getCvObjectTypes()
    {
        return $this->CvObjectTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setCvObjectTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCvObjectTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCvObjectTypesForArrayConstraintsFromSetCvObjectTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $describeGlobalResultCvObjectTypesItem) {
            // validation for constraint: itemType
            if (!is_string($describeGlobalResultCvObjectTypesItem)) {
                $invalidValues[] = is_object($describeGlobalResultCvObjectTypesItem) ? get_class($describeGlobalResultCvObjectTypesItem) : sprintf('%s(%s)', gettype($describeGlobalResultCvObjectTypesItem), var_export($describeGlobalResultCvObjectTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CvObjectTypes property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CvObjectTypes value
     * @throws \InvalidArgumentException
     * @param string[] $cvObjectTypes
     * @return \StructType\DescribeGlobalResult
     */
    public function setCvObjectTypes(array $cvObjectTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($cvObjectTypesArrayErrorMessage = self::validateCvObjectTypesForArrayConstraintsFromSetCvObjectTypes($cvObjectTypes))) {
            throw new \InvalidArgumentException($cvObjectTypesArrayErrorMessage, __LINE__);
        }
        $this->CvObjectTypes = $cvObjectTypes;
        return $this;
    }
    /**
     * Add item to CvObjectTypes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DescribeGlobalResult
     */
    public function addToCvObjectTypes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CvObjectTypes property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CvObjectTypes[] = $item;
        return $this;
    }
    /**
     * Get LookUps value
     * @return \ArrayType\ArrayOfLookUp|null
     */
    public function getLookUps()
    {
        return $this->LookUps;
    }
    /**
     * Set LookUps value
     * @param \ArrayType\ArrayOfLookUp $lookUps
     * @return \StructType\DescribeGlobalResult
     */
    public function setLookUps(\ArrayType\ArrayOfLookUp $lookUps = null)
    {
        $this->LookUps = $lookUps;
        return $this;
    }
    /**
     * Get MaxAPICalls value
     * @return int|null
     */
    public function getMaxAPICalls()
    {
        return $this->MaxAPICalls;
    }
    /**
     * Set MaxAPICalls value
     * @param int $maxAPICalls
     * @return \StructType\DescribeGlobalResult
     */
    public function setMaxAPICalls($maxAPICalls = null)
    {
        // validation for constraint: int
        if (!is_null($maxAPICalls) && !(is_int($maxAPICalls) || ctype_digit($maxAPICalls))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAPICalls, true), gettype($maxAPICalls)), __LINE__);
        }
        $this->MaxAPICalls = $maxAPICalls;
        return $this;
    }
    /**
     * Get CurrentAPICalls value
     * @return int|null
     */
    public function getCurrentAPICalls()
    {
        return $this->CurrentAPICalls;
    }
    /**
     * Set CurrentAPICalls value
     * @param int $currentAPICalls
     * @return \StructType\DescribeGlobalResult
     */
    public function setCurrentAPICalls($currentAPICalls = null)
    {
        // validation for constraint: int
        if (!is_null($currentAPICalls) && !(is_int($currentAPICalls) || ctype_digit($currentAPICalls))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentAPICalls, true), gettype($currentAPICalls)), __LINE__);
        }
        $this->CurrentAPICalls = $currentAPICalls;
        return $this;
    }
    /**
     * Get MaxBatchSize value
     * @return int|null
     */
    public function getMaxBatchSize()
    {
        return $this->MaxBatchSize;
    }
    /**
     * Set MaxBatchSize value
     * @param int $maxBatchSize
     * @return \StructType\DescribeGlobalResult
     */
    public function setMaxBatchSize($maxBatchSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxBatchSize) && !(is_int($maxBatchSize) || ctype_digit($maxBatchSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBatchSize, true), gettype($maxBatchSize)), __LINE__);
        }
        $this->MaxBatchSize = $maxBatchSize;
        return $this;
    }
    /**
     * Get MaxRecordSet value
     * @return int|null
     */
    public function getMaxRecordSet()
    {
        return $this->MaxRecordSet;
    }
    /**
     * Set MaxRecordSet value
     * @param int $maxRecordSet
     * @return \StructType\DescribeGlobalResult
     */
    public function setMaxRecordSet($maxRecordSet = null)
    {
        // validation for constraint: int
        if (!is_null($maxRecordSet) && !(is_int($maxRecordSet) || ctype_digit($maxRecordSet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRecordSet, true), gettype($maxRecordSet)), __LINE__);
        }
        $this->MaxRecordSet = $maxRecordSet;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DescribeGlobalResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
