<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteApprover StructType
 * @subpackage Structs
 */
class DeleteApprover extends CvObject
{
    /**
     * The Approvers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeleteApprover
     */
    public $Approvers;
    /**
     * The ApproverCategoryID
     * @var string
     */
    public $ApproverCategoryID;
    /**
     * The RequestorSourceValue
     * @var string
     */
    public $RequestorSourceValue;
    /**
     * Constructor method for DeleteApprover
     * @uses DeleteApprover::setApprovers()
     * @uses DeleteApprover::setApproverCategoryID()
     * @uses DeleteApprover::setRequestorSourceValue()
     * @param \ArrayType\ArrayOfDeleteApprover $approvers
     * @param string $approverCategoryID
     * @param string $requestorSourceValue
     */
    public function __construct(\ArrayType\ArrayOfDeleteApprover $approvers = null, $approverCategoryID = null, $requestorSourceValue = null)
    {
        $this
            ->setApprovers($approvers)
            ->setApproverCategoryID($approverCategoryID)
            ->setRequestorSourceValue($requestorSourceValue);
    }
    /**
     * Get Approvers value
     * @return \ArrayType\ArrayOfDeleteApprover|null
     */
    public function getApprovers()
    {
        return $this->Approvers;
    }
    /**
     * Set Approvers value
     * @param \ArrayType\ArrayOfDeleteApprover $approvers
     * @return \StructType\DeleteApprover
     */
    public function setApprovers(\ArrayType\ArrayOfDeleteApprover $approvers = null)
    {
        $this->Approvers = $approvers;
        return $this;
    }
    /**
     * Get ApproverCategoryID value
     * @return string|null
     */
    public function getApproverCategoryID()
    {
        return $this->ApproverCategoryID;
    }
    /**
     * Set ApproverCategoryID value
     * @param string $approverCategoryID
     * @return \StructType\DeleteApprover
     */
    public function setApproverCategoryID($approverCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($approverCategoryID) && !is_string($approverCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approverCategoryID, true), gettype($approverCategoryID)), __LINE__);
        }
        $this->ApproverCategoryID = $approverCategoryID;
        return $this;
    }
    /**
     * Get RequestorSourceValue value
     * @return string|null
     */
    public function getRequestorSourceValue()
    {
        return $this->RequestorSourceValue;
    }
    /**
     * Set RequestorSourceValue value
     * @param string $requestorSourceValue
     * @return \StructType\DeleteApprover
     */
    public function setRequestorSourceValue($requestorSourceValue = null)
    {
        // validation for constraint: string
        if (!is_null($requestorSourceValue) && !is_string($requestorSourceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorSourceValue, true), gettype($requestorSourceValue)), __LINE__);
        }
        $this->RequestorSourceValue = $requestorSourceValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteApprover
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
