<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CvSearch StructType
 * @subpackage Structs
 */
class CvSearch extends AbstractStructBase
{
    /**
     * The SearchType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SearchType;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Filter[]
     */
    public $Filter;
    /**
     * Constructor method for CvSearch
     * @uses CvSearch::setSearchType()
     * @uses CvSearch::setFilter()
     * @param string $searchType
     * @param \StructType\Filter[] $filter
     */
    public function __construct($searchType = null, array $filter = array())
    {
        $this
            ->setSearchType($searchType)
            ->setFilter($filter);
    }
    /**
     * Get SearchType value
     * @return string
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \EnumType\CvSearchType::valueIsValid()
     * @uses \EnumType\CvSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\CvSearch
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvSearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvSearchType', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \EnumType\CvSearchType::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get Filter value
     * @return \StructType\Filter[]|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * This method is responsible for validating the values passed to the setFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilterForArrayConstraintsFromSetFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cvSearchFilterItem) {
            // validation for constraint: itemType
            if (!$cvSearchFilterItem instanceof \StructType\Filter) {
                $invalidValues[] = is_object($cvSearchFilterItem) ? get_class($cvSearchFilterItem) : sprintf('%s(%s)', gettype($cvSearchFilterItem), var_export($cvSearchFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Filter property can only contain items of type \StructType\Filter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Filter value
     * @throws \InvalidArgumentException
     * @param \StructType\Filter[] $filter
     * @return \StructType\CvSearch
     */
    public function setFilter(array $filter = array())
    {
        // validation for constraint: array
        if ('' !== ($filterArrayErrorMessage = self::validateFilterForArrayConstraintsFromSetFilter($filter))) {
            throw new \InvalidArgumentException($filterArrayErrorMessage, __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Add item to Filter value
     * @throws \InvalidArgumentException
     * @param \StructType\Filter $item
     * @return \StructType\CvSearch
     */
    public function addToFilter(\StructType\Filter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Filter) {
            throw new \InvalidArgumentException(sprintf('The Filter property can only contain items of type \StructType\Filter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Filter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CvSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
