<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CvConversionRate StructType
 * @subpackage Structs
 */
class CvConversionRate extends CvObject
{
    /**
     * The ConversionRateId
     * @var string
     */
    public $ConversionRateId;
    /**
     * The BaseCurrencyName
     * @var string
     */
    public $BaseCurrencyName;
    /**
     * The BaseCurrencyCode
     * @var string
     */
    public $BaseCurrencyCode;
    /**
     * The CurrencyName
     * @var string
     */
    public $CurrencyName;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ConversionRate
     * Meta informations extracted from the WSDL
     * - default: -1
     * @var float
     */
    public $ConversionRate;
    /**
     * The Current
     * @var bool
     */
    public $Current;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * Constructor method for CvConversionRate
     * @uses CvConversionRate::setConversionRateId()
     * @uses CvConversionRate::setBaseCurrencyName()
     * @uses CvConversionRate::setBaseCurrencyCode()
     * @uses CvConversionRate::setCurrencyName()
     * @uses CvConversionRate::setCurrencyCode()
     * @uses CvConversionRate::setConversionRate()
     * @uses CvConversionRate::setCurrent()
     * @uses CvConversionRate::setStartDate()
     * @uses CvConversionRate::setEndDate()
     * @uses CvConversionRate::setCreatedDate()
     * @uses CvConversionRate::setLastModifiedDate()
     * @param string $conversionRateId
     * @param string $baseCurrencyName
     * @param string $baseCurrencyCode
     * @param string $currencyName
     * @param string $currencyCode
     * @param float $conversionRate
     * @param bool $current
     * @param string $startDate
     * @param string $endDate
     * @param string $createdDate
     * @param string $lastModifiedDate
     */
    public function __construct($conversionRateId = null, $baseCurrencyName = null, $baseCurrencyCode = null, $currencyName = null, $currencyCode = null, $conversionRate = -1, $current = null, $startDate = null, $endDate = null, $createdDate = null, $lastModifiedDate = null)
    {
        $this
            ->setConversionRateId($conversionRateId)
            ->setBaseCurrencyName($baseCurrencyName)
            ->setBaseCurrencyCode($baseCurrencyCode)
            ->setCurrencyName($currencyName)
            ->setCurrencyCode($currencyCode)
            ->setConversionRate($conversionRate)
            ->setCurrent($current)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate);
    }
    /**
     * Get ConversionRateId value
     * @return string|null
     */
    public function getConversionRateId()
    {
        return $this->ConversionRateId;
    }
    /**
     * Set ConversionRateId value
     * @param string $conversionRateId
     * @return \StructType\CvConversionRate
     */
    public function setConversionRateId($conversionRateId = null)
    {
        // validation for constraint: string
        if (!is_null($conversionRateId) && !is_string($conversionRateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversionRateId, true), gettype($conversionRateId)), __LINE__);
        }
        $this->ConversionRateId = $conversionRateId;
        return $this;
    }
    /**
     * Get BaseCurrencyName value
     * @return string|null
     */
    public function getBaseCurrencyName()
    {
        return $this->BaseCurrencyName;
    }
    /**
     * Set BaseCurrencyName value
     * @param string $baseCurrencyName
     * @return \StructType\CvConversionRate
     */
    public function setBaseCurrencyName($baseCurrencyName = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrencyName) && !is_string($baseCurrencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrencyName, true), gettype($baseCurrencyName)), __LINE__);
        }
        $this->BaseCurrencyName = $baseCurrencyName;
        return $this;
    }
    /**
     * Get BaseCurrencyCode value
     * @return string|null
     */
    public function getBaseCurrencyCode()
    {
        return $this->BaseCurrencyCode;
    }
    /**
     * Set BaseCurrencyCode value
     * @param string $baseCurrencyCode
     * @return \StructType\CvConversionRate
     */
    public function setBaseCurrencyCode($baseCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrencyCode) && !is_string($baseCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrencyCode, true), gettype($baseCurrencyCode)), __LINE__);
        }
        $this->BaseCurrencyCode = $baseCurrencyCode;
        return $this;
    }
    /**
     * Get CurrencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->CurrencyName;
    }
    /**
     * Set CurrencyName value
     * @param string $currencyName
     * @return \StructType\CvConversionRate
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->CurrencyName = $currencyName;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CvConversionRate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return float|null
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param float $conversionRate
     * @return \StructType\CvConversionRate
     */
    public function setConversionRate($conversionRate = -1)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get Current value
     * @return bool|null
     */
    public function getCurrent()
    {
        return $this->Current;
    }
    /**
     * Set Current value
     * @param bool $current
     * @return \StructType\CvConversionRate
     */
    public function setCurrent($current = null)
    {
        // validation for constraint: boolean
        if (!is_null($current) && !is_bool($current)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($current, true), gettype($current)), __LINE__);
        }
        $this->Current = $current;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\CvConversionRate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\CvConversionRate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\CvConversionRate
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\CvConversionRate
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CvConversionRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
