<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CvAnswer StructType
 * @subpackage Structs
 */
class CvAnswer extends CvObject
{
    /**
     * The QuestionCode
     * @var string
     */
    public $QuestionCode;
    /**
     * The QuestionID
     * @var string
     */
    public $QuestionID;
    /**
     * The Answer
     * @var string
     */
    public $Answer;
    /**
     * Constructor method for CvAnswer
     * @uses CvAnswer::setQuestionCode()
     * @uses CvAnswer::setQuestionID()
     * @uses CvAnswer::setAnswer()
     * @param string $questionCode
     * @param string $questionID
     * @param string $answer
     */
    public function __construct($questionCode = null, $questionID = null, $answer = null)
    {
        $this
            ->setQuestionCode($questionCode)
            ->setQuestionID($questionID)
            ->setAnswer($answer);
    }
    /**
     * Get QuestionCode value
     * @return string|null
     */
    public function getQuestionCode()
    {
        return $this->QuestionCode;
    }
    /**
     * Set QuestionCode value
     * @param string $questionCode
     * @return \StructType\CvAnswer
     */
    public function setQuestionCode($questionCode = null)
    {
        // validation for constraint: string
        if (!is_null($questionCode) && !is_string($questionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionCode, true), gettype($questionCode)), __LINE__);
        }
        $this->QuestionCode = $questionCode;
        return $this;
    }
    /**
     * Get QuestionID value
     * @return string|null
     */
    public function getQuestionID()
    {
        return $this->QuestionID;
    }
    /**
     * Set QuestionID value
     * @param string $questionID
     * @return \StructType\CvAnswer
     */
    public function setQuestionID($questionID = null)
    {
        // validation for constraint: string
        if (!is_null($questionID) && !is_string($questionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionID, true), gettype($questionID)), __LINE__);
        }
        $this->QuestionID = $questionID;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \StructType\CvAnswer
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answer, true), gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CvAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
