<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldDetail StructType
 * @subpackage Structs
 */
class CustomFieldDetail extends AbstractStructBase
{
    /**
     * The FieldName
     * @var string
     */
    public $FieldName;
    /**
     * The FieldType
     * @var string
     */
    public $FieldType;
    /**
     * The FieldValue
     * @var string
     */
    public $FieldValue;
    /**
     * The FieldId
     * @var string
     */
    public $FieldId;
    /**
     * Constructor method for CustomFieldDetail
     * @uses CustomFieldDetail::setFieldName()
     * @uses CustomFieldDetail::setFieldType()
     * @uses CustomFieldDetail::setFieldValue()
     * @uses CustomFieldDetail::setFieldId()
     * @param string $fieldName
     * @param string $fieldType
     * @param string $fieldValue
     * @param string $fieldId
     */
    public function __construct($fieldName = null, $fieldType = null, $fieldValue = null, $fieldId = null)
    {
        $this
            ->setFieldName($fieldName)
            ->setFieldType($fieldType)
            ->setFieldValue($fieldValue)
            ->setFieldId($fieldId);
    }
    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @param string $fieldName
     * @return \StructType\CustomFieldDetail
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @param string $fieldType
     * @return \StructType\CustomFieldDetail
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: string
        if (!is_null($fieldType) && !is_string($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldType, true), gettype($fieldType)), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get FieldValue value
     * @return string|null
     */
    public function getFieldValue()
    {
        return $this->FieldValue;
    }
    /**
     * Set FieldValue value
     * @param string $fieldValue
     * @return \StructType\CustomFieldDetail
     */
    public function setFieldValue($fieldValue = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValue) && !is_string($fieldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldValue, true), gettype($fieldValue)), __LINE__);
        }
        $this->FieldValue = $fieldValue;
        return $this;
    }
    /**
     * Get FieldId value
     * @return string|null
     */
    public function getFieldId()
    {
        return $this->FieldId;
    }
    /**
     * Set FieldId value
     * @param string $fieldId
     * @return \StructType\CustomFieldDetail
     */
    public function setFieldId($fieldId = null)
    {
        // validation for constraint: string
        if (!is_null($fieldId) && !is_string($fieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldId, true), gettype($fieldId)), __LINE__);
        }
        $this->FieldId = $fieldId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomFieldDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
