<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomField StructType
 * @subpackage Structs
 */
class CustomField extends AbstractStructBase
{
    /**
     * The AnswerDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnswerDetail[]
     */
    public $AnswerDetail;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The FieldType
     * @var string
     */
    public $FieldType;
    /**
     * The Format
     * @var string
     */
    public $Format;
    /**
     * The SortOrder
     * @var string
     */
    public $SortOrder;
    /**
     * Constructor method for CustomField
     * @uses CustomField::setAnswerDetail()
     * @uses CustomField::setId()
     * @uses CustomField::setName()
     * @uses CustomField::setCategory()
     * @uses CustomField::setFieldType()
     * @uses CustomField::setFormat()
     * @uses CustomField::setSortOrder()
     * @param \StructType\AnswerDetail[] $answerDetail
     * @param string $id
     * @param string $name
     * @param string $category
     * @param string $fieldType
     * @param string $format
     * @param string $sortOrder
     */
    public function __construct(array $answerDetail = array(), $id = null, $name = null, $category = null, $fieldType = null, $format = null, $sortOrder = null)
    {
        $this
            ->setAnswerDetail($answerDetail)
            ->setId($id)
            ->setName($name)
            ->setCategory($category)
            ->setFieldType($fieldType)
            ->setFormat($format)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get AnswerDetail value
     * @return \StructType\AnswerDetail[]|null
     */
    public function getAnswerDetail()
    {
        return $this->AnswerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAnswerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnswerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnswerDetailForArrayConstraintsFromSetAnswerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldAnswerDetailItem) {
            // validation for constraint: itemType
            if (!$customFieldAnswerDetailItem instanceof \StructType\AnswerDetail) {
                $invalidValues[] = is_object($customFieldAnswerDetailItem) ? get_class($customFieldAnswerDetailItem) : sprintf('%s(%s)', gettype($customFieldAnswerDetailItem), var_export($customFieldAnswerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail[] $answerDetail
     * @return \StructType\CustomField
     */
    public function setAnswerDetail(array $answerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($answerDetailArrayErrorMessage = self::validateAnswerDetailForArrayConstraintsFromSetAnswerDetail($answerDetail))) {
            throw new \InvalidArgumentException($answerDetailArrayErrorMessage, __LINE__);
        }
        $this->AnswerDetail = $answerDetail;
        return $this;
    }
    /**
     * Add item to AnswerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AnswerDetail $item
     * @return \StructType\CustomField
     */
    public function addToAnswerDetail(\StructType\AnswerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnswerDetail) {
            throw new \InvalidArgumentException(sprintf('The AnswerDetail property can only contain items of type \StructType\AnswerDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AnswerDetail[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CustomField
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CustomField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\CustomField
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @param string $fieldType
     * @return \StructType\CustomField
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: string
        if (!is_null($fieldType) && !is_string($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldType, true), gettype($fieldType)), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\CustomField
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param string $sortOrder
     * @return \StructType\CustomField
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrder) && !is_string($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
