<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateTransaction StructType
 * @subpackage Structs
 */
class CreateTransaction extends AbstractStructBase
{
    /**
     * The Transactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTransaction
     */
    public $Transactions;
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * Constructor method for CreateTransaction
     * @uses CreateTransaction::setTransactions()
     * @uses CreateTransaction::setEventId()
     * @param \ArrayType\ArrayOfTransaction $transactions
     * @param string $eventId
     */
    public function __construct(\ArrayType\ArrayOfTransaction $transactions = null, $eventId = null)
    {
        $this
            ->setTransactions($transactions)
            ->setEventId($eventId);
    }
    /**
     * Get Transactions value
     * @return \ArrayType\ArrayOfTransaction|null
     */
    public function getTransactions()
    {
        return $this->Transactions;
    }
    /**
     * Set Transactions value
     * @param \ArrayType\ArrayOfTransaction $transactions
     * @return \StructType\CreateTransaction
     */
    public function setTransactions(\ArrayType\ArrayOfTransaction $transactions = null)
    {
        $this->Transactions = $transactions;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\CreateTransaction
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
