<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSurveyAnswer StructType
 * @subpackage Structs
 */
class CreateSurveyAnswer extends AbstractStructBase
{
    /**
     * The RespondentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RespondentStatus;
    /**
     * The SurveyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurveyId;
    /**
     * The CvAnswers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvAnswer
     */
    public $CvAnswers;
    /**
     * Constructor method for CreateSurveyAnswer
     * @uses CreateSurveyAnswer::setRespondentStatus()
     * @uses CreateSurveyAnswer::setSurveyId()
     * @uses CreateSurveyAnswer::setCvAnswers()
     * @param string $respondentStatus
     * @param string $surveyId
     * @param \ArrayType\ArrayOfCvAnswer $cvAnswers
     */
    public function __construct($respondentStatus = null, $surveyId = null, \ArrayType\ArrayOfCvAnswer $cvAnswers = null)
    {
        $this
            ->setRespondentStatus($respondentStatus)
            ->setSurveyId($surveyId)
            ->setCvAnswers($cvAnswers);
    }
    /**
     * Get RespondentStatus value
     * @return string
     */
    public function getRespondentStatus()
    {
        return $this->RespondentStatus;
    }
    /**
     * Set RespondentStatus value
     * @uses \EnumType\RespondentStatus::valueIsValid()
     * @uses \EnumType\RespondentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $respondentStatus
     * @return \StructType\CreateSurveyAnswer
     */
    public function setRespondentStatus($respondentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RespondentStatus::valueIsValid($respondentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RespondentStatus', is_array($respondentStatus) ? implode(', ', $respondentStatus) : var_export($respondentStatus, true), implode(', ', \EnumType\RespondentStatus::getValidValues())), __LINE__);
        }
        $this->RespondentStatus = $respondentStatus;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return string|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param string $surveyId
     * @return \StructType\CreateSurveyAnswer
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: string
        if (!is_null($surveyId) && !is_string($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surveyId, true), gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get CvAnswers value
     * @return \ArrayType\ArrayOfCvAnswer|null
     */
    public function getCvAnswers()
    {
        return $this->CvAnswers;
    }
    /**
     * Set CvAnswers value
     * @param \ArrayType\ArrayOfCvAnswer $cvAnswers
     * @return \StructType\CreateSurveyAnswer
     */
    public function setCvAnswers(\ArrayType\ArrayOfCvAnswer $cvAnswers = null)
    {
        $this->CvAnswers = $cvAnswers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateSurveyAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
