<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSession StructType
 * @subpackage Structs
 */
class CreateSession extends AbstractStructBase
{
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * The sessions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSession
     */
    public $sessions;
    /**
     * Constructor method for CreateSession
     * @uses CreateSession::setEventId()
     * @uses CreateSession::setSessions()
     * @param string $eventId
     * @param \ArrayType\ArrayOfSession $sessions
     */
    public function __construct($eventId = null, \ArrayType\ArrayOfSession $sessions = null)
    {
        $this
            ->setEventId($eventId)
            ->setSessions($sessions);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\CreateSession
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get sessions value
     * @return \ArrayType\ArrayOfSession|null
     */
    public function getSessions()
    {
        return $this->sessions;
    }
    /**
     * Set sessions value
     * @param \ArrayType\ArrayOfSession $sessions
     * @return \StructType\CreateSession
     */
    public function setSessions(\ArrayType\ArrayOfSession $sessions = null)
    {
        $this->sessions = $sessions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateSession
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
