<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRFP StructType
 * @subpackage Structs
 */
class CreateRFP extends AbstractStructBase
{
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The RFPParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRFPParameters
     */
    public $RFPParameters;
    /**
     * Constructor method for CreateRFP
     * @uses CreateRFP::setUserId()
     * @uses CreateRFP::setRFPParameters()
     * @param string $userId
     * @param \ArrayType\ArrayOfRFPParameters $rFPParameters
     */
    public function __construct($userId = null, \ArrayType\ArrayOfRFPParameters $rFPParameters = null)
    {
        $this
            ->setUserId($userId)
            ->setRFPParameters($rFPParameters);
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\CreateRFP
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get RFPParameters value
     * @return \ArrayType\ArrayOfRFPParameters|null
     */
    public function getRFPParameters()
    {
        return $this->RFPParameters;
    }
    /**
     * Set RFPParameters value
     * @param \ArrayType\ArrayOfRFPParameters $rFPParameters
     * @return \StructType\CreateRFP
     */
    public function setRFPParameters(\ArrayType\ArrayOfRFPParameters $rFPParameters = null)
    {
        $this->RFPParameters = $rFPParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateRFP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
