<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePostEventFeedback StructType
 * @subpackage Structs
 */
class CreatePostEventFeedback extends AbstractStructBase
{
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * The CvAnswers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvAnswer
     */
    public $CvAnswers;
    /**
     * Constructor method for CreatePostEventFeedback
     * @uses CreatePostEventFeedback::setEventId()
     * @uses CreatePostEventFeedback::setCvAnswers()
     * @param string $eventId
     * @param \ArrayType\ArrayOfCvAnswer $cvAnswers
     */
    public function __construct($eventId = null, \ArrayType\ArrayOfCvAnswer $cvAnswers = null)
    {
        $this
            ->setEventId($eventId)
            ->setCvAnswers($cvAnswers);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\CreatePostEventFeedback
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get CvAnswers value
     * @return \ArrayType\ArrayOfCvAnswer|null
     */
    public function getCvAnswers()
    {
        return $this->CvAnswers;
    }
    /**
     * Set CvAnswers value
     * @param \ArrayType\ArrayOfCvAnswer $cvAnswers
     * @return \StructType\CreatePostEventFeedback
     */
    public function setCvAnswers(\ArrayType\ArrayOfCvAnswer $cvAnswers = null)
    {
        $this->CvAnswers = $cvAnswers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePostEventFeedback
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
