<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomField StructType
 * @subpackage Structs
 */
class CreateCustomField extends AbstractStructBase
{
    /**
     * The CustomFieldCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomFieldCategory;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEntityCustomField
     */
    public $CustomFields;
    /**
     * Constructor method for CreateCustomField
     * @uses CreateCustomField::setCustomFieldCategory()
     * @uses CreateCustomField::setCustomFields()
     * @param string $customFieldCategory
     * @param \ArrayType\ArrayOfEntityCustomField $customFields
     */
    public function __construct($customFieldCategory = null, \ArrayType\ArrayOfEntityCustomField $customFields = null)
    {
        $this
            ->setCustomFieldCategory($customFieldCategory)
            ->setCustomFields($customFields);
    }
    /**
     * Get CustomFieldCategory value
     * @return string
     */
    public function getCustomFieldCategory()
    {
        return $this->CustomFieldCategory;
    }
    /**
     * Set CustomFieldCategory value
     * @uses \EnumType\CvCustomFieldEntityType::valueIsValid()
     * @uses \EnumType\CvCustomFieldEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customFieldCategory
     * @return \StructType\CreateCustomField
     */
    public function setCustomFieldCategory($customFieldCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CvCustomFieldEntityType::valueIsValid($customFieldCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CvCustomFieldEntityType', is_array($customFieldCategory) ? implode(', ', $customFieldCategory) : var_export($customFieldCategory, true), implode(', ', \EnumType\CvCustomFieldEntityType::getValidValues())), __LINE__);
        }
        $this->CustomFieldCategory = $customFieldCategory;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfEntityCustomField|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfEntityCustomField $customFields
     * @return \StructType\CreateCustomField
     */
    public function setCustomFields(\ArrayType\ArrayOfEntityCustomField $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
