<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostDetail StructType
 * @subpackage Structs
 */
class CostDetail extends AbstractStructBase
{
    /**
     * The TaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxDetail[]
     */
    public $TaxDetail;
    /**
     * The CostDetailId
     * @var string
     */
    public $CostDetailId;
    /**
     * The CostName
     * @var string
     */
    public $CostName;
    /**
     * The Units
     * @var float
     */
    public $Units;
    /**
     * The Cost
     * @var float
     */
    public $Cost;
    /**
     * The Tax
     * @var float
     */
    public $Tax;
    /**
     * The TaxType
     * @var string
     */
    public $TaxType;
    /**
     * The Tax2
     * @var float
     */
    public $Tax2;
    /**
     * The Tax2Type
     * @var string
     */
    public $Tax2Type;
    /**
     * The Tax3
     * @var float
     */
    public $Tax3;
    /**
     * The Tax3Type
     * @var string
     */
    public $Tax3Type;
    /**
     * The Tax4
     * @var float
     */
    public $Tax4;
    /**
     * The Tax4Type
     * @var string
     */
    public $Tax4Type;
    /**
     * The Tax5
     * @var float
     */
    public $Tax5;
    /**
     * The Tax5Type
     * @var string
     */
    public $Tax5Type;
    /**
     * The Gratuity
     * @var float
     */
    public $Gratuity;
    /**
     * The GratuityType
     * @var string
     */
    public $GratuityType;
    /**
     * Constructor method for CostDetail
     * @uses CostDetail::setTaxDetail()
     * @uses CostDetail::setCostDetailId()
     * @uses CostDetail::setCostName()
     * @uses CostDetail::setUnits()
     * @uses CostDetail::setCost()
     * @uses CostDetail::setTax()
     * @uses CostDetail::setTaxType()
     * @uses CostDetail::setTax2()
     * @uses CostDetail::setTax2Type()
     * @uses CostDetail::setTax3()
     * @uses CostDetail::setTax3Type()
     * @uses CostDetail::setTax4()
     * @uses CostDetail::setTax4Type()
     * @uses CostDetail::setTax5()
     * @uses CostDetail::setTax5Type()
     * @uses CostDetail::setGratuity()
     * @uses CostDetail::setGratuityType()
     * @param \StructType\TaxDetail[] $taxDetail
     * @param string $costDetailId
     * @param string $costName
     * @param float $units
     * @param float $cost
     * @param float $tax
     * @param string $taxType
     * @param float $tax2
     * @param string $tax2Type
     * @param float $tax3
     * @param string $tax3Type
     * @param float $tax4
     * @param string $tax4Type
     * @param float $tax5
     * @param string $tax5Type
     * @param float $gratuity
     * @param string $gratuityType
     */
    public function __construct(array $taxDetail = array(), $costDetailId = null, $costName = null, $units = null, $cost = null, $tax = null, $taxType = null, $tax2 = null, $tax2Type = null, $tax3 = null, $tax3Type = null, $tax4 = null, $tax4Type = null, $tax5 = null, $tax5Type = null, $gratuity = null, $gratuityType = null)
    {
        $this
            ->setTaxDetail($taxDetail)
            ->setCostDetailId($costDetailId)
            ->setCostName($costName)
            ->setUnits($units)
            ->setCost($cost)
            ->setTax($tax)
            ->setTaxType($taxType)
            ->setTax2($tax2)
            ->setTax2Type($tax2Type)
            ->setTax3($tax3)
            ->setTax3Type($tax3Type)
            ->setTax4($tax4)
            ->setTax4Type($tax4Type)
            ->setTax5($tax5)
            ->setTax5Type($tax5Type)
            ->setGratuity($gratuity)
            ->setGratuityType($gratuityType);
    }
    /**
     * Get TaxDetail value
     * @return \StructType\TaxDetail[]|null
     */
    public function getTaxDetail()
    {
        return $this->TaxDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxDetailForArrayConstraintsFromSetTaxDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costDetailTaxDetailItem) {
            // validation for constraint: itemType
            if (!$costDetailTaxDetailItem instanceof \StructType\TaxDetail) {
                $invalidValues[] = is_object($costDetailTaxDetailItem) ? get_class($costDetailTaxDetailItem) : sprintf('%s(%s)', gettype($costDetailTaxDetailItem), var_export($costDetailTaxDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail[] $taxDetail
     * @return \StructType\CostDetail
     */
    public function setTaxDetail(array $taxDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($taxDetailArrayErrorMessage = self::validateTaxDetailForArrayConstraintsFromSetTaxDetail($taxDetail))) {
            throw new \InvalidArgumentException($taxDetailArrayErrorMessage, __LINE__);
        }
        $this->TaxDetail = $taxDetail;
        return $this;
    }
    /**
     * Add item to TaxDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxDetail $item
     * @return \StructType\CostDetail
     */
    public function addToTaxDetail(\StructType\TaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxDetail property can only contain items of type \StructType\TaxDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxDetail[] = $item;
        return $this;
    }
    /**
     * Get CostDetailId value
     * @return string|null
     */
    public function getCostDetailId()
    {
        return $this->CostDetailId;
    }
    /**
     * Set CostDetailId value
     * @param string $costDetailId
     * @return \StructType\CostDetail
     */
    public function setCostDetailId($costDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($costDetailId) && !is_string($costDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costDetailId, true), gettype($costDetailId)), __LINE__);
        }
        $this->CostDetailId = $costDetailId;
        return $this;
    }
    /**
     * Get CostName value
     * @return string|null
     */
    public function getCostName()
    {
        return $this->CostName;
    }
    /**
     * Set CostName value
     * @param string $costName
     * @return \StructType\CostDetail
     */
    public function setCostName($costName = null)
    {
        // validation for constraint: string
        if (!is_null($costName) && !is_string($costName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costName, true), gettype($costName)), __LINE__);
        }
        $this->CostName = $costName;
        return $this;
    }
    /**
     * Get Units value
     * @return float|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param float $units
     * @return \StructType\CostDetail
     */
    public function setUnits($units = null)
    {
        // validation for constraint: float
        if (!is_null($units) && !(is_float($units) || is_numeric($units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get Cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \StructType\CostDetail
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get Tax value
     * @return float|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \StructType\CostDetail
     */
    public function setTax($tax = null)
    {
        // validation for constraint: float
        if (!is_null($tax) && !(is_float($tax) || is_numeric($tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \StructType\CostDetail
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get Tax2 value
     * @return float|null
     */
    public function getTax2()
    {
        return $this->Tax2;
    }
    /**
     * Set Tax2 value
     * @param float $tax2
     * @return \StructType\CostDetail
     */
    public function setTax2($tax2 = null)
    {
        // validation for constraint: float
        if (!is_null($tax2) && !(is_float($tax2) || is_numeric($tax2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2, true), gettype($tax2)), __LINE__);
        }
        $this->Tax2 = $tax2;
        return $this;
    }
    /**
     * Get Tax2Type value
     * @return string|null
     */
    public function getTax2Type()
    {
        return $this->Tax2Type;
    }
    /**
     * Set Tax2Type value
     * @param string $tax2Type
     * @return \StructType\CostDetail
     */
    public function setTax2Type($tax2Type = null)
    {
        // validation for constraint: string
        if (!is_null($tax2Type) && !is_string($tax2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax2Type, true), gettype($tax2Type)), __LINE__);
        }
        $this->Tax2Type = $tax2Type;
        return $this;
    }
    /**
     * Get Tax3 value
     * @return float|null
     */
    public function getTax3()
    {
        return $this->Tax3;
    }
    /**
     * Set Tax3 value
     * @param float $tax3
     * @return \StructType\CostDetail
     */
    public function setTax3($tax3 = null)
    {
        // validation for constraint: float
        if (!is_null($tax3) && !(is_float($tax3) || is_numeric($tax3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax3, true), gettype($tax3)), __LINE__);
        }
        $this->Tax3 = $tax3;
        return $this;
    }
    /**
     * Get Tax3Type value
     * @return string|null
     */
    public function getTax3Type()
    {
        return $this->Tax3Type;
    }
    /**
     * Set Tax3Type value
     * @param string $tax3Type
     * @return \StructType\CostDetail
     */
    public function setTax3Type($tax3Type = null)
    {
        // validation for constraint: string
        if (!is_null($tax3Type) && !is_string($tax3Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax3Type, true), gettype($tax3Type)), __LINE__);
        }
        $this->Tax3Type = $tax3Type;
        return $this;
    }
    /**
     * Get Tax4 value
     * @return float|null
     */
    public function getTax4()
    {
        return $this->Tax4;
    }
    /**
     * Set Tax4 value
     * @param float $tax4
     * @return \StructType\CostDetail
     */
    public function setTax4($tax4 = null)
    {
        // validation for constraint: float
        if (!is_null($tax4) && !(is_float($tax4) || is_numeric($tax4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax4, true), gettype($tax4)), __LINE__);
        }
        $this->Tax4 = $tax4;
        return $this;
    }
    /**
     * Get Tax4Type value
     * @return string|null
     */
    public function getTax4Type()
    {
        return $this->Tax4Type;
    }
    /**
     * Set Tax4Type value
     * @param string $tax4Type
     * @return \StructType\CostDetail
     */
    public function setTax4Type($tax4Type = null)
    {
        // validation for constraint: string
        if (!is_null($tax4Type) && !is_string($tax4Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax4Type, true), gettype($tax4Type)), __LINE__);
        }
        $this->Tax4Type = $tax4Type;
        return $this;
    }
    /**
     * Get Tax5 value
     * @return float|null
     */
    public function getTax5()
    {
        return $this->Tax5;
    }
    /**
     * Set Tax5 value
     * @param float $tax5
     * @return \StructType\CostDetail
     */
    public function setTax5($tax5 = null)
    {
        // validation for constraint: float
        if (!is_null($tax5) && !(is_float($tax5) || is_numeric($tax5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax5, true), gettype($tax5)), __LINE__);
        }
        $this->Tax5 = $tax5;
        return $this;
    }
    /**
     * Get Tax5Type value
     * @return string|null
     */
    public function getTax5Type()
    {
        return $this->Tax5Type;
    }
    /**
     * Set Tax5Type value
     * @param string $tax5Type
     * @return \StructType\CostDetail
     */
    public function setTax5Type($tax5Type = null)
    {
        // validation for constraint: string
        if (!is_null($tax5Type) && !is_string($tax5Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax5Type, true), gettype($tax5Type)), __LINE__);
        }
        $this->Tax5Type = $tax5Type;
        return $this;
    }
    /**
     * Get Gratuity value
     * @return float|null
     */
    public function getGratuity()
    {
        return $this->Gratuity;
    }
    /**
     * Set Gratuity value
     * @param float $gratuity
     * @return \StructType\CostDetail
     */
    public function setGratuity($gratuity = null)
    {
        // validation for constraint: float
        if (!is_null($gratuity) && !(is_float($gratuity) || is_numeric($gratuity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gratuity, true), gettype($gratuity)), __LINE__);
        }
        $this->Gratuity = $gratuity;
        return $this;
    }
    /**
     * Get GratuityType value
     * @return string|null
     */
    public function getGratuityType()
    {
        return $this->GratuityType;
    }
    /**
     * Set GratuityType value
     * @param string $gratuityType
     * @return \StructType\CostDetail
     */
    public function setGratuityType($gratuityType = null)
    {
        // validation for constraint: string
        if (!is_null($gratuityType) && !is_string($gratuityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gratuityType, true), gettype($gratuityType)), __LINE__);
        }
        $this->GratuityType = $gratuityType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
