<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyEvent StructType
 * @subpackage Structs
 */
class CopyEvent extends AbstractStructBase
{
    /**
     * The EventId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventId;
    /**
     * The EventParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventParameters
     */
    public $EventParameters;
    /**
     * Constructor method for CopyEvent
     * @uses CopyEvent::setEventId()
     * @uses CopyEvent::setEventParameters()
     * @param string $eventId
     * @param \ArrayType\ArrayOfEventParameters $eventParameters
     */
    public function __construct($eventId = null, \ArrayType\ArrayOfEventParameters $eventParameters = null)
    {
        $this
            ->setEventId($eventId)
            ->setEventParameters($eventParameters);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \StructType\CopyEvent
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventParameters value
     * @return \ArrayType\ArrayOfEventParameters|null
     */
    public function getEventParameters()
    {
        return $this->EventParameters;
    }
    /**
     * Set EventParameters value
     * @param \ArrayType\ArrayOfEventParameters $eventParameters
     * @return \StructType\CopyEvent
     */
    public function setEventParameters(\ArrayType\ArrayOfEventParameters $eventParameters = null)
    {
        $this->EventParameters = $eventParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CopyEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
