<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConventionCenterInformation StructType
 * @subpackage Structs
 */
class ConventionCenterInformation extends AbstractStructBase
{
    /**
     * The IncludeRebates
     * @var bool
     */
    public $IncludeRebates;
    /**
     * The Rebate
     * @var float
     */
    public $Rebate;
    /**
     * The RebateType
     * @var string
     */
    public $RebateType;
    /**
     * The RebatesIncentive
     * @var string
     */
    public $RebatesIncentive;
    /**
     * The RoomRateConfirmed
     * @var bool
     */
    public $RoomRateConfirmed;
    /**
     * The ConfirmationContingencies
     * @var string
     */
    public $ConfirmationContingencies;
    /**
     * The MaxYearlyIncrease
     * @var int
     */
    public $MaxYearlyIncrease;
    /**
     * The RoomRateInfo
     * @var string
     */
    public $RoomRateInfo;
    /**
     * The UnionInfo
     * @var string
     */
    public $UnionInfo;
    /**
     * The ContractorInfo
     * @var string
     */
    public $ContractorInfo;
    /**
     * Constructor method for ConventionCenterInformation
     * @uses ConventionCenterInformation::setIncludeRebates()
     * @uses ConventionCenterInformation::setRebate()
     * @uses ConventionCenterInformation::setRebateType()
     * @uses ConventionCenterInformation::setRebatesIncentive()
     * @uses ConventionCenterInformation::setRoomRateConfirmed()
     * @uses ConventionCenterInformation::setConfirmationContingencies()
     * @uses ConventionCenterInformation::setMaxYearlyIncrease()
     * @uses ConventionCenterInformation::setRoomRateInfo()
     * @uses ConventionCenterInformation::setUnionInfo()
     * @uses ConventionCenterInformation::setContractorInfo()
     * @param bool $includeRebates
     * @param float $rebate
     * @param string $rebateType
     * @param string $rebatesIncentive
     * @param bool $roomRateConfirmed
     * @param string $confirmationContingencies
     * @param int $maxYearlyIncrease
     * @param string $roomRateInfo
     * @param string $unionInfo
     * @param string $contractorInfo
     */
    public function __construct($includeRebates = null, $rebate = null, $rebateType = null, $rebatesIncentive = null, $roomRateConfirmed = null, $confirmationContingencies = null, $maxYearlyIncrease = null, $roomRateInfo = null, $unionInfo = null, $contractorInfo = null)
    {
        $this
            ->setIncludeRebates($includeRebates)
            ->setRebate($rebate)
            ->setRebateType($rebateType)
            ->setRebatesIncentive($rebatesIncentive)
            ->setRoomRateConfirmed($roomRateConfirmed)
            ->setConfirmationContingencies($confirmationContingencies)
            ->setMaxYearlyIncrease($maxYearlyIncrease)
            ->setRoomRateInfo($roomRateInfo)
            ->setUnionInfo($unionInfo)
            ->setContractorInfo($contractorInfo);
    }
    /**
     * Get IncludeRebates value
     * @return bool|null
     */
    public function getIncludeRebates()
    {
        return $this->IncludeRebates;
    }
    /**
     * Set IncludeRebates value
     * @param bool $includeRebates
     * @return \StructType\ConventionCenterInformation
     */
    public function setIncludeRebates($includeRebates = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRebates) && !is_bool($includeRebates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRebates, true), gettype($includeRebates)), __LINE__);
        }
        $this->IncludeRebates = $includeRebates;
        return $this;
    }
    /**
     * Get Rebate value
     * @return float|null
     */
    public function getRebate()
    {
        return $this->Rebate;
    }
    /**
     * Set Rebate value
     * @param float $rebate
     * @return \StructType\ConventionCenterInformation
     */
    public function setRebate($rebate = null)
    {
        // validation for constraint: float
        if (!is_null($rebate) && !(is_float($rebate) || is_numeric($rebate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rebate, true), gettype($rebate)), __LINE__);
        }
        $this->Rebate = $rebate;
        return $this;
    }
    /**
     * Get RebateType value
     * @return string|null
     */
    public function getRebateType()
    {
        return $this->RebateType;
    }
    /**
     * Set RebateType value
     * @param string $rebateType
     * @return \StructType\ConventionCenterInformation
     */
    public function setRebateType($rebateType = null)
    {
        // validation for constraint: string
        if (!is_null($rebateType) && !is_string($rebateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rebateType, true), gettype($rebateType)), __LINE__);
        }
        $this->RebateType = $rebateType;
        return $this;
    }
    /**
     * Get RebatesIncentive value
     * @return string|null
     */
    public function getRebatesIncentive()
    {
        return $this->RebatesIncentive;
    }
    /**
     * Set RebatesIncentive value
     * @param string $rebatesIncentive
     * @return \StructType\ConventionCenterInformation
     */
    public function setRebatesIncentive($rebatesIncentive = null)
    {
        // validation for constraint: string
        if (!is_null($rebatesIncentive) && !is_string($rebatesIncentive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rebatesIncentive, true), gettype($rebatesIncentive)), __LINE__);
        }
        $this->RebatesIncentive = $rebatesIncentive;
        return $this;
    }
    /**
     * Get RoomRateConfirmed value
     * @return bool|null
     */
    public function getRoomRateConfirmed()
    {
        return $this->RoomRateConfirmed;
    }
    /**
     * Set RoomRateConfirmed value
     * @param bool $roomRateConfirmed
     * @return \StructType\ConventionCenterInformation
     */
    public function setRoomRateConfirmed($roomRateConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomRateConfirmed) && !is_bool($roomRateConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roomRateConfirmed, true), gettype($roomRateConfirmed)), __LINE__);
        }
        $this->RoomRateConfirmed = $roomRateConfirmed;
        return $this;
    }
    /**
     * Get ConfirmationContingencies value
     * @return string|null
     */
    public function getConfirmationContingencies()
    {
        return $this->ConfirmationContingencies;
    }
    /**
     * Set ConfirmationContingencies value
     * @param string $confirmationContingencies
     * @return \StructType\ConventionCenterInformation
     */
    public function setConfirmationContingencies($confirmationContingencies = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationContingencies) && !is_string($confirmationContingencies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationContingencies, true), gettype($confirmationContingencies)), __LINE__);
        }
        $this->ConfirmationContingencies = $confirmationContingencies;
        return $this;
    }
    /**
     * Get MaxYearlyIncrease value
     * @return int|null
     */
    public function getMaxYearlyIncrease()
    {
        return $this->MaxYearlyIncrease;
    }
    /**
     * Set MaxYearlyIncrease value
     * @param int $maxYearlyIncrease
     * @return \StructType\ConventionCenterInformation
     */
    public function setMaxYearlyIncrease($maxYearlyIncrease = null)
    {
        // validation for constraint: int
        if (!is_null($maxYearlyIncrease) && !(is_int($maxYearlyIncrease) || ctype_digit($maxYearlyIncrease))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxYearlyIncrease, true), gettype($maxYearlyIncrease)), __LINE__);
        }
        $this->MaxYearlyIncrease = $maxYearlyIncrease;
        return $this;
    }
    /**
     * Get RoomRateInfo value
     * @return string|null
     */
    public function getRoomRateInfo()
    {
        return $this->RoomRateInfo;
    }
    /**
     * Set RoomRateInfo value
     * @param string $roomRateInfo
     * @return \StructType\ConventionCenterInformation
     */
    public function setRoomRateInfo($roomRateInfo = null)
    {
        // validation for constraint: string
        if (!is_null($roomRateInfo) && !is_string($roomRateInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomRateInfo, true), gettype($roomRateInfo)), __LINE__);
        }
        $this->RoomRateInfo = $roomRateInfo;
        return $this;
    }
    /**
     * Get UnionInfo value
     * @return string|null
     */
    public function getUnionInfo()
    {
        return $this->UnionInfo;
    }
    /**
     * Set UnionInfo value
     * @param string $unionInfo
     * @return \StructType\ConventionCenterInformation
     */
    public function setUnionInfo($unionInfo = null)
    {
        // validation for constraint: string
        if (!is_null($unionInfo) && !is_string($unionInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unionInfo, true), gettype($unionInfo)), __LINE__);
        }
        $this->UnionInfo = $unionInfo;
        return $this;
    }
    /**
     * Get ContractorInfo value
     * @return string|null
     */
    public function getContractorInfo()
    {
        return $this->ContractorInfo;
    }
    /**
     * Set ContractorInfo value
     * @param string $contractorInfo
     * @return \StructType\ConventionCenterInformation
     */
    public function setContractorInfo($contractorInfo = null)
    {
        // validation for constraint: string
        if (!is_null($contractorInfo) && !is_string($contractorInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractorInfo, true), gettype($contractorInfo)), __LINE__);
        }
        $this->ContractorInfo = $contractorInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConventionCenterInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
