<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractedDataDetail StructType
 * @subpackage Structs
 */
class ContractedDataDetail extends AbstractStructBase
{
    /**
     * The SleepingRoomDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SleepingRoomDetail[]
     */
    public $SleepingRoomDetail;
    /**
     * The AttachmentDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AttachmentDetail[]
     */
    public $AttachmentDetail;
    /**
     * The VenueCode
     * @var string
     */
    public $VenueCode;
    /**
     * The Contracted
     * @var bool
     */
    public $Contracted;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * @var string
     */
    public $EventEndDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ReferenceId
     * @var string
     */
    public $ReferenceId;
    /**
     * The AdditionalInformation
     * @var string
     */
    public $AdditionalInformation;
    /**
     * The CommissionRate
     * @var int
     */
    public $CommissionRate;
    /**
     * The TotalAttendees
     * @var int
     */
    public $TotalAttendees;
    /**
     * The TotalRoomNights
     * @var int
     */
    public $TotalRoomNights;
    /**
     * The TotalAVCost
     * @var float
     */
    public $TotalAVCost;
    /**
     * The TotalFoodAndBeverageCost
     * @var float
     */
    public $TotalFoodAndBeverageCost;
    /**
     * The TotalFoodAndBeverageMinimum
     * @var float
     */
    public $TotalFoodAndBeverageMinimum;
    /**
     * The Concessions
     * @var string
     */
    public $Concessions;
    /**
     * The TotalContractValue
     * @var float
     */
    public $TotalContractValue;
    /**
     * The TotalMeetingSpaceCost
     * @var float
     */
    public $TotalMeetingSpaceCost;
    /**
     * The BillingContactFirstName
     * @var string
     */
    public $BillingContactFirstName;
    /**
     * The BillingContactLastName
     * @var string
     */
    public $BillingContactLastName;
    /**
     * The BillingContactTitle
     * @var string
     */
    public $BillingContactTitle;
    /**
     * The BillingContactPhoneNumber
     * @var string
     */
    public $BillingContactPhoneNumber;
    /**
     * The BillingContactEmailAddress
     * @var string
     */
    public $BillingContactEmailAddress;
    /**
     * The BillingContactFax
     * @var string
     */
    public $BillingContactFax;
    /**
     * The BillingContactMobilePhone
     * @var string
     */
    public $BillingContactMobilePhone;
    /**
     * The BillingContactOrganization
     * @var string
     */
    public $BillingContactOrganization;
    /**
     * The BillingContactOrganizationWebsite
     * @var string
     */
    public $BillingContactOrganizationWebsite;
    /**
     * The BillingContactAddress1
     * @var string
     */
    public $BillingContactAddress1;
    /**
     * The BillingContactAddress2
     * @var string
     */
    public $BillingContactAddress2;
    /**
     * The BillingContactAddress3
     * @var string
     */
    public $BillingContactAddress3;
    /**
     * The BillingContactCity
     * @var string
     */
    public $BillingContactCity;
    /**
     * The BillingContactState
     * @var string
     */
    public $BillingContactState;
    /**
     * The BillingContactStateCode
     * @var string
     */
    public $BillingContactStateCode;
    /**
     * The BillingContactPostalCode
     * @var string
     */
    public $BillingContactPostalCode;
    /**
     * The BillingContactCountry
     * @var string
     */
    public $BillingContactCountry;
    /**
     * The BillingContactCountryCode
     * @var string
     */
    public $BillingContactCountryCode;
    /**
     * The BillingContactAdditionalInformation
     * @var string
     */
    public $BillingContactAdditionalInformation;
    /**
     * The DateContracted
     * @var string
     */
    public $DateContracted;
    /**
     * Constructor method for ContractedDataDetail
     * @uses ContractedDataDetail::setSleepingRoomDetail()
     * @uses ContractedDataDetail::setAttachmentDetail()
     * @uses ContractedDataDetail::setVenueCode()
     * @uses ContractedDataDetail::setContracted()
     * @uses ContractedDataDetail::setEventStartDate()
     * @uses ContractedDataDetail::setEventEndDate()
     * @uses ContractedDataDetail::setCurrencyCode()
     * @uses ContractedDataDetail::setReferenceId()
     * @uses ContractedDataDetail::setAdditionalInformation()
     * @uses ContractedDataDetail::setCommissionRate()
     * @uses ContractedDataDetail::setTotalAttendees()
     * @uses ContractedDataDetail::setTotalRoomNights()
     * @uses ContractedDataDetail::setTotalAVCost()
     * @uses ContractedDataDetail::setTotalFoodAndBeverageCost()
     * @uses ContractedDataDetail::setTotalFoodAndBeverageMinimum()
     * @uses ContractedDataDetail::setConcessions()
     * @uses ContractedDataDetail::setTotalContractValue()
     * @uses ContractedDataDetail::setTotalMeetingSpaceCost()
     * @uses ContractedDataDetail::setBillingContactFirstName()
     * @uses ContractedDataDetail::setBillingContactLastName()
     * @uses ContractedDataDetail::setBillingContactTitle()
     * @uses ContractedDataDetail::setBillingContactPhoneNumber()
     * @uses ContractedDataDetail::setBillingContactEmailAddress()
     * @uses ContractedDataDetail::setBillingContactFax()
     * @uses ContractedDataDetail::setBillingContactMobilePhone()
     * @uses ContractedDataDetail::setBillingContactOrganization()
     * @uses ContractedDataDetail::setBillingContactOrganizationWebsite()
     * @uses ContractedDataDetail::setBillingContactAddress1()
     * @uses ContractedDataDetail::setBillingContactAddress2()
     * @uses ContractedDataDetail::setBillingContactAddress3()
     * @uses ContractedDataDetail::setBillingContactCity()
     * @uses ContractedDataDetail::setBillingContactState()
     * @uses ContractedDataDetail::setBillingContactStateCode()
     * @uses ContractedDataDetail::setBillingContactPostalCode()
     * @uses ContractedDataDetail::setBillingContactCountry()
     * @uses ContractedDataDetail::setBillingContactCountryCode()
     * @uses ContractedDataDetail::setBillingContactAdditionalInformation()
     * @uses ContractedDataDetail::setDateContracted()
     * @param \StructType\SleepingRoomDetail[] $sleepingRoomDetail
     * @param \StructType\AttachmentDetail[] $attachmentDetail
     * @param string $venueCode
     * @param bool $contracted
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param string $currencyCode
     * @param string $referenceId
     * @param string $additionalInformation
     * @param int $commissionRate
     * @param int $totalAttendees
     * @param int $totalRoomNights
     * @param float $totalAVCost
     * @param float $totalFoodAndBeverageCost
     * @param float $totalFoodAndBeverageMinimum
     * @param string $concessions
     * @param float $totalContractValue
     * @param float $totalMeetingSpaceCost
     * @param string $billingContactFirstName
     * @param string $billingContactLastName
     * @param string $billingContactTitle
     * @param string $billingContactPhoneNumber
     * @param string $billingContactEmailAddress
     * @param string $billingContactFax
     * @param string $billingContactMobilePhone
     * @param string $billingContactOrganization
     * @param string $billingContactOrganizationWebsite
     * @param string $billingContactAddress1
     * @param string $billingContactAddress2
     * @param string $billingContactAddress3
     * @param string $billingContactCity
     * @param string $billingContactState
     * @param string $billingContactStateCode
     * @param string $billingContactPostalCode
     * @param string $billingContactCountry
     * @param string $billingContactCountryCode
     * @param string $billingContactAdditionalInformation
     * @param string $dateContracted
     */
    public function __construct(array $sleepingRoomDetail = array(), array $attachmentDetail = array(), $venueCode = null, $contracted = null, $eventStartDate = null, $eventEndDate = null, $currencyCode = null, $referenceId = null, $additionalInformation = null, $commissionRate = null, $totalAttendees = null, $totalRoomNights = null, $totalAVCost = null, $totalFoodAndBeverageCost = null, $totalFoodAndBeverageMinimum = null, $concessions = null, $totalContractValue = null, $totalMeetingSpaceCost = null, $billingContactFirstName = null, $billingContactLastName = null, $billingContactTitle = null, $billingContactPhoneNumber = null, $billingContactEmailAddress = null, $billingContactFax = null, $billingContactMobilePhone = null, $billingContactOrganization = null, $billingContactOrganizationWebsite = null, $billingContactAddress1 = null, $billingContactAddress2 = null, $billingContactAddress3 = null, $billingContactCity = null, $billingContactState = null, $billingContactStateCode = null, $billingContactPostalCode = null, $billingContactCountry = null, $billingContactCountryCode = null, $billingContactAdditionalInformation = null, $dateContracted = null)
    {
        $this
            ->setSleepingRoomDetail($sleepingRoomDetail)
            ->setAttachmentDetail($attachmentDetail)
            ->setVenueCode($venueCode)
            ->setContracted($contracted)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setCurrencyCode($currencyCode)
            ->setReferenceId($referenceId)
            ->setAdditionalInformation($additionalInformation)
            ->setCommissionRate($commissionRate)
            ->setTotalAttendees($totalAttendees)
            ->setTotalRoomNights($totalRoomNights)
            ->setTotalAVCost($totalAVCost)
            ->setTotalFoodAndBeverageCost($totalFoodAndBeverageCost)
            ->setTotalFoodAndBeverageMinimum($totalFoodAndBeverageMinimum)
            ->setConcessions($concessions)
            ->setTotalContractValue($totalContractValue)
            ->setTotalMeetingSpaceCost($totalMeetingSpaceCost)
            ->setBillingContactFirstName($billingContactFirstName)
            ->setBillingContactLastName($billingContactLastName)
            ->setBillingContactTitle($billingContactTitle)
            ->setBillingContactPhoneNumber($billingContactPhoneNumber)
            ->setBillingContactEmailAddress($billingContactEmailAddress)
            ->setBillingContactFax($billingContactFax)
            ->setBillingContactMobilePhone($billingContactMobilePhone)
            ->setBillingContactOrganization($billingContactOrganization)
            ->setBillingContactOrganizationWebsite($billingContactOrganizationWebsite)
            ->setBillingContactAddress1($billingContactAddress1)
            ->setBillingContactAddress2($billingContactAddress2)
            ->setBillingContactAddress3($billingContactAddress3)
            ->setBillingContactCity($billingContactCity)
            ->setBillingContactState($billingContactState)
            ->setBillingContactStateCode($billingContactStateCode)
            ->setBillingContactPostalCode($billingContactPostalCode)
            ->setBillingContactCountry($billingContactCountry)
            ->setBillingContactCountryCode($billingContactCountryCode)
            ->setBillingContactAdditionalInformation($billingContactAdditionalInformation)
            ->setDateContracted($dateContracted);
    }
    /**
     * Get SleepingRoomDetail value
     * @return \StructType\SleepingRoomDetail[]|null
     */
    public function getSleepingRoomDetail()
    {
        return $this->SleepingRoomDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSleepingRoomDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSleepingRoomDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSleepingRoomDetailForArrayConstraintsFromSetSleepingRoomDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractedDataDetailSleepingRoomDetailItem) {
            // validation for constraint: itemType
            if (!$contractedDataDetailSleepingRoomDetailItem instanceof \StructType\SleepingRoomDetail) {
                $invalidValues[] = is_object($contractedDataDetailSleepingRoomDetailItem) ? get_class($contractedDataDetailSleepingRoomDetailItem) : sprintf('%s(%s)', gettype($contractedDataDetailSleepingRoomDetailItem), var_export($contractedDataDetailSleepingRoomDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SleepingRoomDetail property can only contain items of type \StructType\SleepingRoomDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SleepingRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SleepingRoomDetail[] $sleepingRoomDetail
     * @return \StructType\ContractedDataDetail
     */
    public function setSleepingRoomDetail(array $sleepingRoomDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($sleepingRoomDetailArrayErrorMessage = self::validateSleepingRoomDetailForArrayConstraintsFromSetSleepingRoomDetail($sleepingRoomDetail))) {
            throw new \InvalidArgumentException($sleepingRoomDetailArrayErrorMessage, __LINE__);
        }
        $this->SleepingRoomDetail = $sleepingRoomDetail;
        return $this;
    }
    /**
     * Add item to SleepingRoomDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SleepingRoomDetail $item
     * @return \StructType\ContractedDataDetail
     */
    public function addToSleepingRoomDetail(\StructType\SleepingRoomDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SleepingRoomDetail) {
            throw new \InvalidArgumentException(sprintf('The SleepingRoomDetail property can only contain items of type \StructType\SleepingRoomDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SleepingRoomDetail[] = $item;
        return $this;
    }
    /**
     * Get AttachmentDetail value
     * @return \StructType\AttachmentDetail[]|null
     */
    public function getAttachmentDetail()
    {
        return $this->AttachmentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractedDataDetailAttachmentDetailItem) {
            // validation for constraint: itemType
            if (!$contractedDataDetailAttachmentDetailItem instanceof \StructType\AttachmentDetail) {
                $invalidValues[] = is_object($contractedDataDetailAttachmentDetailItem) ? get_class($contractedDataDetailAttachmentDetailItem) : sprintf('%s(%s)', gettype($contractedDataDetailAttachmentDetailItem), var_export($contractedDataDetailAttachmentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentDetail property can only contain items of type \StructType\AttachmentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentDetail[] $attachmentDetail
     * @return \StructType\ContractedDataDetail
     */
    public function setAttachmentDetail(array $attachmentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentDetailArrayErrorMessage = self::validateAttachmentDetailForArrayConstraintsFromSetAttachmentDetail($attachmentDetail))) {
            throw new \InvalidArgumentException($attachmentDetailArrayErrorMessage, __LINE__);
        }
        $this->AttachmentDetail = $attachmentDetail;
        return $this;
    }
    /**
     * Add item to AttachmentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentDetail $item
     * @return \StructType\ContractedDataDetail
     */
    public function addToAttachmentDetail(\StructType\AttachmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttachmentDetail) {
            throw new \InvalidArgumentException(sprintf('The AttachmentDetail property can only contain items of type \StructType\AttachmentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttachmentDetail[] = $item;
        return $this;
    }
    /**
     * Get VenueCode value
     * @return string|null
     */
    public function getVenueCode()
    {
        return $this->VenueCode;
    }
    /**
     * Set VenueCode value
     * @param string $venueCode
     * @return \StructType\ContractedDataDetail
     */
    public function setVenueCode($venueCode = null)
    {
        // validation for constraint: string
        if (!is_null($venueCode) && !is_string($venueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueCode, true), gettype($venueCode)), __LINE__);
        }
        $this->VenueCode = $venueCode;
        return $this;
    }
    /**
     * Get Contracted value
     * @return bool|null
     */
    public function getContracted()
    {
        return $this->Contracted;
    }
    /**
     * Set Contracted value
     * @param bool $contracted
     * @return \StructType\ContractedDataDetail
     */
    public function setContracted($contracted = null)
    {
        // validation for constraint: boolean
        if (!is_null($contracted) && !is_bool($contracted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contracted, true), gettype($contracted)), __LINE__);
        }
        $this->Contracted = $contracted;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \StructType\ContractedDataDetail
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \StructType\ContractedDataDetail
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ContractedDataDetail
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\ContractedDataDetail
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param string $additionalInformation
     * @return \StructType\ContractedDataDetail
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get CommissionRate value
     * @return int|null
     */
    public function getCommissionRate()
    {
        return $this->CommissionRate;
    }
    /**
     * Set CommissionRate value
     * @param int $commissionRate
     * @return \StructType\ContractedDataDetail
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: int
        if (!is_null($commissionRate) && !(is_int($commissionRate) || ctype_digit($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->CommissionRate = $commissionRate;
        return $this;
    }
    /**
     * Get TotalAttendees value
     * @return int|null
     */
    public function getTotalAttendees()
    {
        return $this->TotalAttendees;
    }
    /**
     * Set TotalAttendees value
     * @param int $totalAttendees
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalAttendees($totalAttendees = null)
    {
        // validation for constraint: int
        if (!is_null($totalAttendees) && !(is_int($totalAttendees) || ctype_digit($totalAttendees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAttendees, true), gettype($totalAttendees)), __LINE__);
        }
        $this->TotalAttendees = $totalAttendees;
        return $this;
    }
    /**
     * Get TotalRoomNights value
     * @return int|null
     */
    public function getTotalRoomNights()
    {
        return $this->TotalRoomNights;
    }
    /**
     * Set TotalRoomNights value
     * @param int $totalRoomNights
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalRoomNights($totalRoomNights = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomNights) && !(is_int($totalRoomNights) || ctype_digit($totalRoomNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomNights, true), gettype($totalRoomNights)), __LINE__);
        }
        $this->TotalRoomNights = $totalRoomNights;
        return $this;
    }
    /**
     * Get TotalAVCost value
     * @return float|null
     */
    public function getTotalAVCost()
    {
        return $this->TotalAVCost;
    }
    /**
     * Set TotalAVCost value
     * @param float $totalAVCost
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalAVCost($totalAVCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalAVCost) && !(is_float($totalAVCost) || is_numeric($totalAVCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAVCost, true), gettype($totalAVCost)), __LINE__);
        }
        $this->TotalAVCost = $totalAVCost;
        return $this;
    }
    /**
     * Get TotalFoodAndBeverageCost value
     * @return float|null
     */
    public function getTotalFoodAndBeverageCost()
    {
        return $this->TotalFoodAndBeverageCost;
    }
    /**
     * Set TotalFoodAndBeverageCost value
     * @param float $totalFoodAndBeverageCost
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalFoodAndBeverageCost($totalFoodAndBeverageCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalFoodAndBeverageCost) && !(is_float($totalFoodAndBeverageCost) || is_numeric($totalFoodAndBeverageCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFoodAndBeverageCost, true), gettype($totalFoodAndBeverageCost)), __LINE__);
        }
        $this->TotalFoodAndBeverageCost = $totalFoodAndBeverageCost;
        return $this;
    }
    /**
     * Get TotalFoodAndBeverageMinimum value
     * @return float|null
     */
    public function getTotalFoodAndBeverageMinimum()
    {
        return $this->TotalFoodAndBeverageMinimum;
    }
    /**
     * Set TotalFoodAndBeverageMinimum value
     * @param float $totalFoodAndBeverageMinimum
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalFoodAndBeverageMinimum($totalFoodAndBeverageMinimum = null)
    {
        // validation for constraint: float
        if (!is_null($totalFoodAndBeverageMinimum) && !(is_float($totalFoodAndBeverageMinimum) || is_numeric($totalFoodAndBeverageMinimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFoodAndBeverageMinimum, true), gettype($totalFoodAndBeverageMinimum)), __LINE__);
        }
        $this->TotalFoodAndBeverageMinimum = $totalFoodAndBeverageMinimum;
        return $this;
    }
    /**
     * Get Concessions value
     * @return string|null
     */
    public function getConcessions()
    {
        return $this->Concessions;
    }
    /**
     * Set Concessions value
     * @param string $concessions
     * @return \StructType\ContractedDataDetail
     */
    public function setConcessions($concessions = null)
    {
        // validation for constraint: string
        if (!is_null($concessions) && !is_string($concessions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($concessions, true), gettype($concessions)), __LINE__);
        }
        $this->Concessions = $concessions;
        return $this;
    }
    /**
     * Get TotalContractValue value
     * @return float|null
     */
    public function getTotalContractValue()
    {
        return $this->TotalContractValue;
    }
    /**
     * Set TotalContractValue value
     * @param float $totalContractValue
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalContractValue($totalContractValue = null)
    {
        // validation for constraint: float
        if (!is_null($totalContractValue) && !(is_float($totalContractValue) || is_numeric($totalContractValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalContractValue, true), gettype($totalContractValue)), __LINE__);
        }
        $this->TotalContractValue = $totalContractValue;
        return $this;
    }
    /**
     * Get TotalMeetingSpaceCost value
     * @return float|null
     */
    public function getTotalMeetingSpaceCost()
    {
        return $this->TotalMeetingSpaceCost;
    }
    /**
     * Set TotalMeetingSpaceCost value
     * @param float $totalMeetingSpaceCost
     * @return \StructType\ContractedDataDetail
     */
    public function setTotalMeetingSpaceCost($totalMeetingSpaceCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalMeetingSpaceCost) && !(is_float($totalMeetingSpaceCost) || is_numeric($totalMeetingSpaceCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMeetingSpaceCost, true), gettype($totalMeetingSpaceCost)), __LINE__);
        }
        $this->TotalMeetingSpaceCost = $totalMeetingSpaceCost;
        return $this;
    }
    /**
     * Get BillingContactFirstName value
     * @return string|null
     */
    public function getBillingContactFirstName()
    {
        return $this->BillingContactFirstName;
    }
    /**
     * Set BillingContactFirstName value
     * @param string $billingContactFirstName
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactFirstName($billingContactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactFirstName) && !is_string($billingContactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactFirstName, true), gettype($billingContactFirstName)), __LINE__);
        }
        $this->BillingContactFirstName = $billingContactFirstName;
        return $this;
    }
    /**
     * Get BillingContactLastName value
     * @return string|null
     */
    public function getBillingContactLastName()
    {
        return $this->BillingContactLastName;
    }
    /**
     * Set BillingContactLastName value
     * @param string $billingContactLastName
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactLastName($billingContactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactLastName) && !is_string($billingContactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactLastName, true), gettype($billingContactLastName)), __LINE__);
        }
        $this->BillingContactLastName = $billingContactLastName;
        return $this;
    }
    /**
     * Get BillingContactTitle value
     * @return string|null
     */
    public function getBillingContactTitle()
    {
        return $this->BillingContactTitle;
    }
    /**
     * Set BillingContactTitle value
     * @param string $billingContactTitle
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactTitle($billingContactTitle = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactTitle) && !is_string($billingContactTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactTitle, true), gettype($billingContactTitle)), __LINE__);
        }
        $this->BillingContactTitle = $billingContactTitle;
        return $this;
    }
    /**
     * Get BillingContactPhoneNumber value
     * @return string|null
     */
    public function getBillingContactPhoneNumber()
    {
        return $this->BillingContactPhoneNumber;
    }
    /**
     * Set BillingContactPhoneNumber value
     * @param string $billingContactPhoneNumber
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactPhoneNumber($billingContactPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactPhoneNumber) && !is_string($billingContactPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactPhoneNumber, true), gettype($billingContactPhoneNumber)), __LINE__);
        }
        $this->BillingContactPhoneNumber = $billingContactPhoneNumber;
        return $this;
    }
    /**
     * Get BillingContactEmailAddress value
     * @return string|null
     */
    public function getBillingContactEmailAddress()
    {
        return $this->BillingContactEmailAddress;
    }
    /**
     * Set BillingContactEmailAddress value
     * @param string $billingContactEmailAddress
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactEmailAddress($billingContactEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactEmailAddress) && !is_string($billingContactEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactEmailAddress, true), gettype($billingContactEmailAddress)), __LINE__);
        }
        $this->BillingContactEmailAddress = $billingContactEmailAddress;
        return $this;
    }
    /**
     * Get BillingContactFax value
     * @return string|null
     */
    public function getBillingContactFax()
    {
        return $this->BillingContactFax;
    }
    /**
     * Set BillingContactFax value
     * @param string $billingContactFax
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactFax($billingContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactFax) && !is_string($billingContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactFax, true), gettype($billingContactFax)), __LINE__);
        }
        $this->BillingContactFax = $billingContactFax;
        return $this;
    }
    /**
     * Get BillingContactMobilePhone value
     * @return string|null
     */
    public function getBillingContactMobilePhone()
    {
        return $this->BillingContactMobilePhone;
    }
    /**
     * Set BillingContactMobilePhone value
     * @param string $billingContactMobilePhone
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactMobilePhone($billingContactMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactMobilePhone) && !is_string($billingContactMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactMobilePhone, true), gettype($billingContactMobilePhone)), __LINE__);
        }
        $this->BillingContactMobilePhone = $billingContactMobilePhone;
        return $this;
    }
    /**
     * Get BillingContactOrganization value
     * @return string|null
     */
    public function getBillingContactOrganization()
    {
        return $this->BillingContactOrganization;
    }
    /**
     * Set BillingContactOrganization value
     * @param string $billingContactOrganization
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactOrganization($billingContactOrganization = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactOrganization) && !is_string($billingContactOrganization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactOrganization, true), gettype($billingContactOrganization)), __LINE__);
        }
        $this->BillingContactOrganization = $billingContactOrganization;
        return $this;
    }
    /**
     * Get BillingContactOrganizationWebsite value
     * @return string|null
     */
    public function getBillingContactOrganizationWebsite()
    {
        return $this->BillingContactOrganizationWebsite;
    }
    /**
     * Set BillingContactOrganizationWebsite value
     * @param string $billingContactOrganizationWebsite
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactOrganizationWebsite($billingContactOrganizationWebsite = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactOrganizationWebsite) && !is_string($billingContactOrganizationWebsite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactOrganizationWebsite, true), gettype($billingContactOrganizationWebsite)), __LINE__);
        }
        $this->BillingContactOrganizationWebsite = $billingContactOrganizationWebsite;
        return $this;
    }
    /**
     * Get BillingContactAddress1 value
     * @return string|null
     */
    public function getBillingContactAddress1()
    {
        return $this->BillingContactAddress1;
    }
    /**
     * Set BillingContactAddress1 value
     * @param string $billingContactAddress1
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactAddress1($billingContactAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactAddress1) && !is_string($billingContactAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactAddress1, true), gettype($billingContactAddress1)), __LINE__);
        }
        $this->BillingContactAddress1 = $billingContactAddress1;
        return $this;
    }
    /**
     * Get BillingContactAddress2 value
     * @return string|null
     */
    public function getBillingContactAddress2()
    {
        return $this->BillingContactAddress2;
    }
    /**
     * Set BillingContactAddress2 value
     * @param string $billingContactAddress2
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactAddress2($billingContactAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactAddress2) && !is_string($billingContactAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactAddress2, true), gettype($billingContactAddress2)), __LINE__);
        }
        $this->BillingContactAddress2 = $billingContactAddress2;
        return $this;
    }
    /**
     * Get BillingContactAddress3 value
     * @return string|null
     */
    public function getBillingContactAddress3()
    {
        return $this->BillingContactAddress3;
    }
    /**
     * Set BillingContactAddress3 value
     * @param string $billingContactAddress3
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactAddress3($billingContactAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactAddress3) && !is_string($billingContactAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactAddress3, true), gettype($billingContactAddress3)), __LINE__);
        }
        $this->BillingContactAddress3 = $billingContactAddress3;
        return $this;
    }
    /**
     * Get BillingContactCity value
     * @return string|null
     */
    public function getBillingContactCity()
    {
        return $this->BillingContactCity;
    }
    /**
     * Set BillingContactCity value
     * @param string $billingContactCity
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactCity($billingContactCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactCity) && !is_string($billingContactCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactCity, true), gettype($billingContactCity)), __LINE__);
        }
        $this->BillingContactCity = $billingContactCity;
        return $this;
    }
    /**
     * Get BillingContactState value
     * @return string|null
     */
    public function getBillingContactState()
    {
        return $this->BillingContactState;
    }
    /**
     * Set BillingContactState value
     * @param string $billingContactState
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactState($billingContactState = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactState) && !is_string($billingContactState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactState, true), gettype($billingContactState)), __LINE__);
        }
        $this->BillingContactState = $billingContactState;
        return $this;
    }
    /**
     * Get BillingContactStateCode value
     * @return string|null
     */
    public function getBillingContactStateCode()
    {
        return $this->BillingContactStateCode;
    }
    /**
     * Set BillingContactStateCode value
     * @param string $billingContactStateCode
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactStateCode($billingContactStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactStateCode) && !is_string($billingContactStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactStateCode, true), gettype($billingContactStateCode)), __LINE__);
        }
        $this->BillingContactStateCode = $billingContactStateCode;
        return $this;
    }
    /**
     * Get BillingContactPostalCode value
     * @return string|null
     */
    public function getBillingContactPostalCode()
    {
        return $this->BillingContactPostalCode;
    }
    /**
     * Set BillingContactPostalCode value
     * @param string $billingContactPostalCode
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactPostalCode($billingContactPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactPostalCode) && !is_string($billingContactPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactPostalCode, true), gettype($billingContactPostalCode)), __LINE__);
        }
        $this->BillingContactPostalCode = $billingContactPostalCode;
        return $this;
    }
    /**
     * Get BillingContactCountry value
     * @return string|null
     */
    public function getBillingContactCountry()
    {
        return $this->BillingContactCountry;
    }
    /**
     * Set BillingContactCountry value
     * @param string $billingContactCountry
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactCountry($billingContactCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactCountry) && !is_string($billingContactCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactCountry, true), gettype($billingContactCountry)), __LINE__);
        }
        $this->BillingContactCountry = $billingContactCountry;
        return $this;
    }
    /**
     * Get BillingContactCountryCode value
     * @return string|null
     */
    public function getBillingContactCountryCode()
    {
        return $this->BillingContactCountryCode;
    }
    /**
     * Set BillingContactCountryCode value
     * @param string $billingContactCountryCode
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactCountryCode($billingContactCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactCountryCode) && !is_string($billingContactCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactCountryCode, true), gettype($billingContactCountryCode)), __LINE__);
        }
        $this->BillingContactCountryCode = $billingContactCountryCode;
        return $this;
    }
    /**
     * Get BillingContactAdditionalInformation value
     * @return string|null
     */
    public function getBillingContactAdditionalInformation()
    {
        return $this->BillingContactAdditionalInformation;
    }
    /**
     * Set BillingContactAdditionalInformation value
     * @param string $billingContactAdditionalInformation
     * @return \StructType\ContractedDataDetail
     */
    public function setBillingContactAdditionalInformation($billingContactAdditionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($billingContactAdditionalInformation) && !is_string($billingContactAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingContactAdditionalInformation, true), gettype($billingContactAdditionalInformation)), __LINE__);
        }
        $this->BillingContactAdditionalInformation = $billingContactAdditionalInformation;
        return $this;
    }
    /**
     * Get DateContracted value
     * @return string|null
     */
    public function getDateContracted()
    {
        return $this->DateContracted;
    }
    /**
     * Set DateContracted value
     * @param string $dateContracted
     * @return \StructType\ContractedDataDetail
     */
    public function setDateContracted($dateContracted = null)
    {
        // validation for constraint: string
        if (!is_null($dateContracted) && !is_string($dateContracted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateContracted, true), gettype($dateContracted)), __LINE__);
        }
        $this->DateContracted = $dateContracted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractedDataDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
