<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactGroupDetail StructType
 * @subpackage Structs
 */
class ContactGroupDetail extends AbstractStructBase
{
    /**
     * The GroupName
     * @var string
     */
    public $GroupName;
    /**
     * The GroupId
     * @var string
     */
    public $GroupId;
    /**
     * Constructor method for ContactGroupDetail
     * @uses ContactGroupDetail::setGroupName()
     * @uses ContactGroupDetail::setGroupId()
     * @param string $groupName
     * @param string $groupId
     */
    public function __construct($groupName = null, $groupId = null)
    {
        $this
            ->setGroupName($groupName)
            ->setGroupId($groupId);
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\ContactGroupDetail
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Get GroupId value
     * @return string|null
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param string $groupId
     * @return \StructType\ContactGroupDetail
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactGroupDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
