<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactGroup StructType
 * @subpackage Structs
 */
class ContactGroup extends CvObject
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The ShortDescription
     * @var string
     */
    public $ShortDescription;
    /**
     * The GroupType
     * @var string
     */
    public $GroupType;
    /**
     * Constructor method for ContactGroup
     * @uses ContactGroup::setName()
     * @uses ContactGroup::setShortDescription()
     * @uses ContactGroup::setGroupType()
     * @param string $name
     * @param string $shortDescription
     * @param string $groupType
     */
    public function __construct($name = null, $shortDescription = null, $groupType = null)
    {
        $this
            ->setName($name)
            ->setShortDescription($shortDescription)
            ->setGroupType($groupType);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ContactGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param string $shortDescription
     * @return \StructType\ContactGroup
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get GroupType value
     * @return string|null
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @param string $groupType
     * @return \StructType\ContactGroup
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: string
        if (!is_null($groupType) && !is_string($groupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupType, true), gettype($groupType)), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
