<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends CvObject
{
    /**
     * The CustomFieldDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomFieldDetail[]
     */
    public $CustomFieldDetail;
    /**
     * The ContactGroupDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactGroupDetail[]
     */
    public $ContactGroupDetail;
    /**
     * The DistributionListDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DistributionListDetail[]
     */
    public $DistributionListDetail;
    /**
     * The SourceId
     * @var string
     */
    public $SourceId;
    /**
     * The FirstName
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * @var string
     */
    public $LastName;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The CCEmailAddress
     * @var string
     */
    public $CCEmailAddress;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $Active;
    /**
     * The Company
     * @var string
     */
    public $Company;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The ContactType
     * @var string
     */
    public $ContactType;
    /**
     * The ContactTypeCode
     * @var string
     */
    public $ContactTypeCode;
    /**
     * The Salutation
     * @var string
     */
    public $Salutation;
    /**
     * The Nickname
     * @var string
     */
    public $Nickname;
    /**
     * The MiddleName
     * @var string
     */
    public $MiddleName;
    /**
     * The Designation
     * @var string
     */
    public $Designation;
    /**
     * The ExcludedFromEmail
     * @var bool
     */
    public $ExcludedFromEmail;
    /**
     * The LastOptOutBy
     * @var string
     */
    public $LastOptOutBy;
    /**
     * The LastOptOutDate
     * @var string
     */
    public $LastOptOutDate;
    /**
     * The CreatedDate
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedBy
     * @var string
     */
    public $CreatedBy;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The EmailAddressStatus
     * @var string
     */
    public $EmailAddressStatus;
    /**
     * The LogDate
     * @var string
     */
    public $LogDate;
    /**
     * The LogReason
     * @var string
     */
    public $LogReason;
    /**
     * The LogResponse
     * @var string
     */
    public $LogResponse;
    /**
     * The PrimaryAddressType
     * @var string
     */
    public $PrimaryAddressType;
    /**
     * The HomeAddress1
     * @var string
     */
    public $HomeAddress1;
    /**
     * The HomeAddress2
     * @var string
     */
    public $HomeAddress2;
    /**
     * The HomeAddress3
     * @var string
     */
    public $HomeAddress3;
    /**
     * The HomeCity
     * @var string
     */
    public $HomeCity;
    /**
     * The HomeState
     * @var string
     */
    public $HomeState;
    /**
     * The HomeStateCode
     * @var string
     */
    public $HomeStateCode;
    /**
     * The HomePostalCode
     * @var string
     */
    public $HomePostalCode;
    /**
     * The HomeCountry
     * @var string
     */
    public $HomeCountry;
    /**
     * The HomeCountryCode
     * @var string
     */
    public $HomeCountryCode;
    /**
     * The HomePhone
     * @var string
     */
    public $HomePhone;
    /**
     * The HomeFax
     * @var string
     */
    public $HomeFax;
    /**
     * The WorkAddress1
     * @var string
     */
    public $WorkAddress1;
    /**
     * The WorkAddress2
     * @var string
     */
    public $WorkAddress2;
    /**
     * The WorkAddress3
     * @var string
     */
    public $WorkAddress3;
    /**
     * The WorkCity
     * @var string
     */
    public $WorkCity;
    /**
     * The WorkState
     * @var string
     */
    public $WorkState;
    /**
     * The WorkStateCode
     * @var string
     */
    public $WorkStateCode;
    /**
     * The WorkPostalCode
     * @var string
     */
    public $WorkPostalCode;
    /**
     * The WorkCountry
     * @var string
     */
    public $WorkCountry;
    /**
     * The WorkCountryCode
     * @var string
     */
    public $WorkCountryCode;
    /**
     * The WorkPhone
     * @var string
     */
    public $WorkPhone;
    /**
     * The WorkFax
     * @var string
     */
    public $WorkFax;
    /**
     * The MobilePhone
     * @var string
     */
    public $MobilePhone;
    /**
     * The Pager
     * @var string
     */
    public $Pager;
    /**
     * The SMTPCode
     * @var string
     */
    public $SMTPCode;
    /**
     * The MembershipCode
     * @var string
     */
    public $MembershipCode;
    /**
     * The JoinDate
     * @var string
     */
    public $JoinDate;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The LastRenewalDate
     * @var string
     */
    public $LastRenewalDate;
    /**
     * The FacebookURL
     * @var string
     */
    public $FacebookURL;
    /**
     * The TwitterURL
     * @var string
     */
    public $TwitterURL;
    /**
     * The LinkedInURL
     * @var string
     */
    public $LinkedInURL;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The SocialSecurityNumber
     * @var string
     */
    public $SocialSecurityNumber;
    /**
     * The NationalIdentificationNumber
     * @var string
     */
    public $NationalIdentificationNumber;
    /**
     * The PassportNumber
     * @var string
     */
    public $PassportNumber;
    /**
     * The PassportCountry
     * @var string
     */
    public $PassportCountry;
    /**
     * The PassportCountryCode
     * @var string
     */
    public $PassportCountryCode;
    /**
     * The ActivityId
     * @var string
     */
    public $ActivityId;
    /**
     * The ParentContactId
     * @var string
     */
    public $ParentContactId;
    /**
     * The OptedIn
     * @var bool
     */
    public $OptedIn;
    /**
     * The ImageURL
     * @var string
     */
    public $ImageURL;
    /**
     * The IsCreatedViaTestReg
     * @var bool
     */
    public $IsCreatedViaTestReg;
    /**
     * The IsObfuscated
     * @var bool
     */
    public $IsObfuscated;
    /**
     * Constructor method for Contact
     * @uses Contact::setCustomFieldDetail()
     * @uses Contact::setContactGroupDetail()
     * @uses Contact::setDistributionListDetail()
     * @uses Contact::setSourceId()
     * @uses Contact::setFirstName()
     * @uses Contact::setLastName()
     * @uses Contact::setEmailAddress()
     * @uses Contact::setCCEmailAddress()
     * @uses Contact::setActive()
     * @uses Contact::setCompany()
     * @uses Contact::setTitle()
     * @uses Contact::setContactType()
     * @uses Contact::setContactTypeCode()
     * @uses Contact::setSalutation()
     * @uses Contact::setNickname()
     * @uses Contact::setMiddleName()
     * @uses Contact::setDesignation()
     * @uses Contact::setExcludedFromEmail()
     * @uses Contact::setLastOptOutBy()
     * @uses Contact::setLastOptOutDate()
     * @uses Contact::setCreatedDate()
     * @uses Contact::setCreatedBy()
     * @uses Contact::setLastModifiedDate()
     * @uses Contact::setLastModifiedBy()
     * @uses Contact::setEmailAddressStatus()
     * @uses Contact::setLogDate()
     * @uses Contact::setLogReason()
     * @uses Contact::setLogResponse()
     * @uses Contact::setPrimaryAddressType()
     * @uses Contact::setHomeAddress1()
     * @uses Contact::setHomeAddress2()
     * @uses Contact::setHomeAddress3()
     * @uses Contact::setHomeCity()
     * @uses Contact::setHomeState()
     * @uses Contact::setHomeStateCode()
     * @uses Contact::setHomePostalCode()
     * @uses Contact::setHomeCountry()
     * @uses Contact::setHomeCountryCode()
     * @uses Contact::setHomePhone()
     * @uses Contact::setHomeFax()
     * @uses Contact::setWorkAddress1()
     * @uses Contact::setWorkAddress2()
     * @uses Contact::setWorkAddress3()
     * @uses Contact::setWorkCity()
     * @uses Contact::setWorkState()
     * @uses Contact::setWorkStateCode()
     * @uses Contact::setWorkPostalCode()
     * @uses Contact::setWorkCountry()
     * @uses Contact::setWorkCountryCode()
     * @uses Contact::setWorkPhone()
     * @uses Contact::setWorkFax()
     * @uses Contact::setMobilePhone()
     * @uses Contact::setPager()
     * @uses Contact::setSMTPCode()
     * @uses Contact::setMembershipCode()
     * @uses Contact::setJoinDate()
     * @uses Contact::setExpirationDate()
     * @uses Contact::setLastRenewalDate()
     * @uses Contact::setFacebookURL()
     * @uses Contact::setTwitterURL()
     * @uses Contact::setLinkedInURL()
     * @uses Contact::setGender()
     * @uses Contact::setDateOfBirth()
     * @uses Contact::setSocialSecurityNumber()
     * @uses Contact::setNationalIdentificationNumber()
     * @uses Contact::setPassportNumber()
     * @uses Contact::setPassportCountry()
     * @uses Contact::setPassportCountryCode()
     * @uses Contact::setActivityId()
     * @uses Contact::setParentContactId()
     * @uses Contact::setOptedIn()
     * @uses Contact::setImageURL()
     * @uses Contact::setIsCreatedViaTestReg()
     * @uses Contact::setIsObfuscated()
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @param \StructType\ContactGroupDetail[] $contactGroupDetail
     * @param \StructType\DistributionListDetail[] $distributionListDetail
     * @param string $sourceId
     * @param string $firstName
     * @param string $lastName
     * @param string $emailAddress
     * @param string $cCEmailAddress
     * @param bool $active
     * @param string $company
     * @param string $title
     * @param string $contactType
     * @param string $contactTypeCode
     * @param string $salutation
     * @param string $nickname
     * @param string $middleName
     * @param string $designation
     * @param bool $excludedFromEmail
     * @param string $lastOptOutBy
     * @param string $lastOptOutDate
     * @param string $createdDate
     * @param string $createdBy
     * @param string $lastModifiedDate
     * @param string $lastModifiedBy
     * @param string $emailAddressStatus
     * @param string $logDate
     * @param string $logReason
     * @param string $logResponse
     * @param string $primaryAddressType
     * @param string $homeAddress1
     * @param string $homeAddress2
     * @param string $homeAddress3
     * @param string $homeCity
     * @param string $homeState
     * @param string $homeStateCode
     * @param string $homePostalCode
     * @param string $homeCountry
     * @param string $homeCountryCode
     * @param string $homePhone
     * @param string $homeFax
     * @param string $workAddress1
     * @param string $workAddress2
     * @param string $workAddress3
     * @param string $workCity
     * @param string $workState
     * @param string $workStateCode
     * @param string $workPostalCode
     * @param string $workCountry
     * @param string $workCountryCode
     * @param string $workPhone
     * @param string $workFax
     * @param string $mobilePhone
     * @param string $pager
     * @param string $sMTPCode
     * @param string $membershipCode
     * @param string $joinDate
     * @param string $expirationDate
     * @param string $lastRenewalDate
     * @param string $facebookURL
     * @param string $twitterURL
     * @param string $linkedInURL
     * @param string $gender
     * @param string $dateOfBirth
     * @param string $socialSecurityNumber
     * @param string $nationalIdentificationNumber
     * @param string $passportNumber
     * @param string $passportCountry
     * @param string $passportCountryCode
     * @param string $activityId
     * @param string $parentContactId
     * @param bool $optedIn
     * @param string $imageURL
     * @param bool $isCreatedViaTestReg
     * @param bool $isObfuscated
     */
    public function __construct(array $customFieldDetail = array(), array $contactGroupDetail = array(), array $distributionListDetail = array(), $sourceId = null, $firstName = null, $lastName = null, $emailAddress = null, $cCEmailAddress = null, $active = true, $company = null, $title = null, $contactType = null, $contactTypeCode = null, $salutation = null, $nickname = null, $middleName = null, $designation = null, $excludedFromEmail = null, $lastOptOutBy = null, $lastOptOutDate = null, $createdDate = null, $createdBy = null, $lastModifiedDate = null, $lastModifiedBy = null, $emailAddressStatus = null, $logDate = null, $logReason = null, $logResponse = null, $primaryAddressType = null, $homeAddress1 = null, $homeAddress2 = null, $homeAddress3 = null, $homeCity = null, $homeState = null, $homeStateCode = null, $homePostalCode = null, $homeCountry = null, $homeCountryCode = null, $homePhone = null, $homeFax = null, $workAddress1 = null, $workAddress2 = null, $workAddress3 = null, $workCity = null, $workState = null, $workStateCode = null, $workPostalCode = null, $workCountry = null, $workCountryCode = null, $workPhone = null, $workFax = null, $mobilePhone = null, $pager = null, $sMTPCode = null, $membershipCode = null, $joinDate = null, $expirationDate = null, $lastRenewalDate = null, $facebookURL = null, $twitterURL = null, $linkedInURL = null, $gender = null, $dateOfBirth = null, $socialSecurityNumber = null, $nationalIdentificationNumber = null, $passportNumber = null, $passportCountry = null, $passportCountryCode = null, $activityId = null, $parentContactId = null, $optedIn = null, $imageURL = null, $isCreatedViaTestReg = null, $isObfuscated = null)
    {
        $this
            ->setCustomFieldDetail($customFieldDetail)
            ->setContactGroupDetail($contactGroupDetail)
            ->setDistributionListDetail($distributionListDetail)
            ->setSourceId($sourceId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailAddress($emailAddress)
            ->setCCEmailAddress($cCEmailAddress)
            ->setActive($active)
            ->setCompany($company)
            ->setTitle($title)
            ->setContactType($contactType)
            ->setContactTypeCode($contactTypeCode)
            ->setSalutation($salutation)
            ->setNickname($nickname)
            ->setMiddleName($middleName)
            ->setDesignation($designation)
            ->setExcludedFromEmail($excludedFromEmail)
            ->setLastOptOutBy($lastOptOutBy)
            ->setLastOptOutDate($lastOptOutDate)
            ->setCreatedDate($createdDate)
            ->setCreatedBy($createdBy)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setEmailAddressStatus($emailAddressStatus)
            ->setLogDate($logDate)
            ->setLogReason($logReason)
            ->setLogResponse($logResponse)
            ->setPrimaryAddressType($primaryAddressType)
            ->setHomeAddress1($homeAddress1)
            ->setHomeAddress2($homeAddress2)
            ->setHomeAddress3($homeAddress3)
            ->setHomeCity($homeCity)
            ->setHomeState($homeState)
            ->setHomeStateCode($homeStateCode)
            ->setHomePostalCode($homePostalCode)
            ->setHomeCountry($homeCountry)
            ->setHomeCountryCode($homeCountryCode)
            ->setHomePhone($homePhone)
            ->setHomeFax($homeFax)
            ->setWorkAddress1($workAddress1)
            ->setWorkAddress2($workAddress2)
            ->setWorkAddress3($workAddress3)
            ->setWorkCity($workCity)
            ->setWorkState($workState)
            ->setWorkStateCode($workStateCode)
            ->setWorkPostalCode($workPostalCode)
            ->setWorkCountry($workCountry)
            ->setWorkCountryCode($workCountryCode)
            ->setWorkPhone($workPhone)
            ->setWorkFax($workFax)
            ->setMobilePhone($mobilePhone)
            ->setPager($pager)
            ->setSMTPCode($sMTPCode)
            ->setMembershipCode($membershipCode)
            ->setJoinDate($joinDate)
            ->setExpirationDate($expirationDate)
            ->setLastRenewalDate($lastRenewalDate)
            ->setFacebookURL($facebookURL)
            ->setTwitterURL($twitterURL)
            ->setLinkedInURL($linkedInURL)
            ->setGender($gender)
            ->setDateOfBirth($dateOfBirth)
            ->setSocialSecurityNumber($socialSecurityNumber)
            ->setNationalIdentificationNumber($nationalIdentificationNumber)
            ->setPassportNumber($passportNumber)
            ->setPassportCountry($passportCountry)
            ->setPassportCountryCode($passportCountryCode)
            ->setActivityId($activityId)
            ->setParentContactId($parentContactId)
            ->setOptedIn($optedIn)
            ->setImageURL($imageURL)
            ->setIsCreatedViaTestReg($isCreatedViaTestReg)
            ->setIsObfuscated($isObfuscated);
    }
    /**
     * Get CustomFieldDetail value
     * @return \StructType\CustomFieldDetail[]|null
     */
    public function getCustomFieldDetail()
    {
        return $this->CustomFieldDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomFieldDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomFieldDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactCustomFieldDetailItem) {
            // validation for constraint: itemType
            if (!$contactCustomFieldDetailItem instanceof \StructType\CustomFieldDetail) {
                $invalidValues[] = is_object($contactCustomFieldDetailItem) ? get_class($contactCustomFieldDetailItem) : sprintf('%s(%s)', gettype($contactCustomFieldDetailItem), var_export($contactCustomFieldDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail[] $customFieldDetail
     * @return \StructType\Contact
     */
    public function setCustomFieldDetail(array $customFieldDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldDetailArrayErrorMessage = self::validateCustomFieldDetailForArrayConstraintsFromSetCustomFieldDetail($customFieldDetail))) {
            throw new \InvalidArgumentException($customFieldDetailArrayErrorMessage, __LINE__);
        }
        $this->CustomFieldDetail = $customFieldDetail;
        return $this;
    }
    /**
     * Add item to CustomFieldDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldDetail $item
     * @return \StructType\Contact
     */
    public function addToCustomFieldDetail(\StructType\CustomFieldDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldDetail) {
            throw new \InvalidArgumentException(sprintf('The CustomFieldDetail property can only contain items of type \StructType\CustomFieldDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomFieldDetail[] = $item;
        return $this;
    }
    /**
     * Get ContactGroupDetail value
     * @return \StructType\ContactGroupDetail[]|null
     */
    public function getContactGroupDetail()
    {
        return $this->ContactGroupDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setContactGroupDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactGroupDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactGroupDetailForArrayConstraintsFromSetContactGroupDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactContactGroupDetailItem) {
            // validation for constraint: itemType
            if (!$contactContactGroupDetailItem instanceof \StructType\ContactGroupDetail) {
                $invalidValues[] = is_object($contactContactGroupDetailItem) ? get_class($contactContactGroupDetailItem) : sprintf('%s(%s)', gettype($contactContactGroupDetailItem), var_export($contactContactGroupDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactGroupDetail property can only contain items of type \StructType\ContactGroupDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactGroupDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactGroupDetail[] $contactGroupDetail
     * @return \StructType\Contact
     */
    public function setContactGroupDetail(array $contactGroupDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($contactGroupDetailArrayErrorMessage = self::validateContactGroupDetailForArrayConstraintsFromSetContactGroupDetail($contactGroupDetail))) {
            throw new \InvalidArgumentException($contactGroupDetailArrayErrorMessage, __LINE__);
        }
        $this->ContactGroupDetail = $contactGroupDetail;
        return $this;
    }
    /**
     * Add item to ContactGroupDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactGroupDetail $item
     * @return \StructType\Contact
     */
    public function addToContactGroupDetail(\StructType\ContactGroupDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactGroupDetail) {
            throw new \InvalidArgumentException(sprintf('The ContactGroupDetail property can only contain items of type \StructType\ContactGroupDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactGroupDetail[] = $item;
        return $this;
    }
    /**
     * Get DistributionListDetail value
     * @return \StructType\DistributionListDetail[]|null
     */
    public function getDistributionListDetail()
    {
        return $this->DistributionListDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setDistributionListDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistributionListDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistributionListDetailForArrayConstraintsFromSetDistributionListDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactDistributionListDetailItem) {
            // validation for constraint: itemType
            if (!$contactDistributionListDetailItem instanceof \StructType\DistributionListDetail) {
                $invalidValues[] = is_object($contactDistributionListDetailItem) ? get_class($contactDistributionListDetailItem) : sprintf('%s(%s)', gettype($contactDistributionListDetailItem), var_export($contactDistributionListDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistributionListDetail property can only contain items of type \StructType\DistributionListDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistributionListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionListDetail[] $distributionListDetail
     * @return \StructType\Contact
     */
    public function setDistributionListDetail(array $distributionListDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($distributionListDetailArrayErrorMessage = self::validateDistributionListDetailForArrayConstraintsFromSetDistributionListDetail($distributionListDetail))) {
            throw new \InvalidArgumentException($distributionListDetailArrayErrorMessage, __LINE__);
        }
        $this->DistributionListDetail = $distributionListDetail;
        return $this;
    }
    /**
     * Add item to DistributionListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionListDetail $item
     * @return \StructType\Contact
     */
    public function addToDistributionListDetail(\StructType\DistributionListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributionListDetail) {
            throw new \InvalidArgumentException(sprintf('The DistributionListDetail property can only contain items of type \StructType\DistributionListDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistributionListDetail[] = $item;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \StructType\Contact
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Contact
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Contact
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\Contact
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CCEmailAddress value
     * @return string|null
     */
    public function getCCEmailAddress()
    {
        return $this->CCEmailAddress;
    }
    /**
     * Set CCEmailAddress value
     * @param string $cCEmailAddress
     * @return \StructType\Contact
     */
    public function setCCEmailAddress($cCEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmailAddress) && !is_string($cCEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCEmailAddress, true), gettype($cCEmailAddress)), __LINE__);
        }
        $this->CCEmailAddress = $cCEmailAddress;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Contact
     */
    public function setActive($active = true)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\Contact
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Contact
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param string $contactType
     * @return \StructType\Contact
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: string
        if (!is_null($contactType) && !is_string($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactType, true), gettype($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get ContactTypeCode value
     * @return string|null
     */
    public function getContactTypeCode()
    {
        return $this->ContactTypeCode;
    }
    /**
     * Set ContactTypeCode value
     * @param string $contactTypeCode
     * @return \StructType\Contact
     */
    public function setContactTypeCode($contactTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeCode) && !is_string($contactTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeCode, true), gettype($contactTypeCode)), __LINE__);
        }
        $this->ContactTypeCode = $contactTypeCode;
        return $this;
    }
    /**
     * Get Salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }
    /**
     * Set Salutation value
     * @param string $salutation
     * @return \StructType\Contact
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->Salutation = $salutation;
        return $this;
    }
    /**
     * Get Nickname value
     * @return string|null
     */
    public function getNickname()
    {
        return $this->Nickname;
    }
    /**
     * Set Nickname value
     * @param string $nickname
     * @return \StructType\Contact
     */
    public function setNickname($nickname = null)
    {
        // validation for constraint: string
        if (!is_null($nickname) && !is_string($nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickname, true), gettype($nickname)), __LINE__);
        }
        $this->Nickname = $nickname;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\Contact
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get Designation value
     * @return string|null
     */
    public function getDesignation()
    {
        return $this->Designation;
    }
    /**
     * Set Designation value
     * @param string $designation
     * @return \StructType\Contact
     */
    public function setDesignation($designation = null)
    {
        // validation for constraint: string
        if (!is_null($designation) && !is_string($designation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designation, true), gettype($designation)), __LINE__);
        }
        $this->Designation = $designation;
        return $this;
    }
    /**
     * Get ExcludedFromEmail value
     * @return bool|null
     */
    public function getExcludedFromEmail()
    {
        return $this->ExcludedFromEmail;
    }
    /**
     * Set ExcludedFromEmail value
     * @param bool $excludedFromEmail
     * @return \StructType\Contact
     */
    public function setExcludedFromEmail($excludedFromEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludedFromEmail) && !is_bool($excludedFromEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludedFromEmail, true), gettype($excludedFromEmail)), __LINE__);
        }
        $this->ExcludedFromEmail = $excludedFromEmail;
        return $this;
    }
    /**
     * Get LastOptOutBy value
     * @return string|null
     */
    public function getLastOptOutBy()
    {
        return $this->LastOptOutBy;
    }
    /**
     * Set LastOptOutBy value
     * @param string $lastOptOutBy
     * @return \StructType\Contact
     */
    public function setLastOptOutBy($lastOptOutBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastOptOutBy) && !is_string($lastOptOutBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOptOutBy, true), gettype($lastOptOutBy)), __LINE__);
        }
        $this->LastOptOutBy = $lastOptOutBy;
        return $this;
    }
    /**
     * Get LastOptOutDate value
     * @return string|null
     */
    public function getLastOptOutDate()
    {
        return $this->LastOptOutDate;
    }
    /**
     * Set LastOptOutDate value
     * @param string $lastOptOutDate
     * @return \StructType\Contact
     */
    public function setLastOptOutDate($lastOptOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastOptOutDate) && !is_string($lastOptOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOptOutDate, true), gettype($lastOptOutDate)), __LINE__);
        }
        $this->LastOptOutDate = $lastOptOutDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Contact
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\Contact
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdBy, true), gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Contact
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\Contact
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get EmailAddressStatus value
     * @return string|null
     */
    public function getEmailAddressStatus()
    {
        return $this->EmailAddressStatus;
    }
    /**
     * Set EmailAddressStatus value
     * @param string $emailAddressStatus
     * @return \StructType\Contact
     */
    public function setEmailAddressStatus($emailAddressStatus = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddressStatus) && !is_string($emailAddressStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddressStatus, true), gettype($emailAddressStatus)), __LINE__);
        }
        $this->EmailAddressStatus = $emailAddressStatus;
        return $this;
    }
    /**
     * Get LogDate value
     * @return string|null
     */
    public function getLogDate()
    {
        return $this->LogDate;
    }
    /**
     * Set LogDate value
     * @param string $logDate
     * @return \StructType\Contact
     */
    public function setLogDate($logDate = null)
    {
        // validation for constraint: string
        if (!is_null($logDate) && !is_string($logDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logDate, true), gettype($logDate)), __LINE__);
        }
        $this->LogDate = $logDate;
        return $this;
    }
    /**
     * Get LogReason value
     * @return string|null
     */
    public function getLogReason()
    {
        return $this->LogReason;
    }
    /**
     * Set LogReason value
     * @param string $logReason
     * @return \StructType\Contact
     */
    public function setLogReason($logReason = null)
    {
        // validation for constraint: string
        if (!is_null($logReason) && !is_string($logReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logReason, true), gettype($logReason)), __LINE__);
        }
        $this->LogReason = $logReason;
        return $this;
    }
    /**
     * Get LogResponse value
     * @return string|null
     */
    public function getLogResponse()
    {
        return $this->LogResponse;
    }
    /**
     * Set LogResponse value
     * @param string $logResponse
     * @return \StructType\Contact
     */
    public function setLogResponse($logResponse = null)
    {
        // validation for constraint: string
        if (!is_null($logResponse) && !is_string($logResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logResponse, true), gettype($logResponse)), __LINE__);
        }
        $this->LogResponse = $logResponse;
        return $this;
    }
    /**
     * Get PrimaryAddressType value
     * @return string|null
     */
    public function getPrimaryAddressType()
    {
        return $this->PrimaryAddressType;
    }
    /**
     * Set PrimaryAddressType value
     * @uses \EnumType\PrimaryAddressType::valueIsValid()
     * @uses \EnumType\PrimaryAddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $primaryAddressType
     * @return \StructType\Contact
     */
    public function setPrimaryAddressType($primaryAddressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrimaryAddressType::valueIsValid($primaryAddressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrimaryAddressType', is_array($primaryAddressType) ? implode(', ', $primaryAddressType) : var_export($primaryAddressType, true), implode(', ', \EnumType\PrimaryAddressType::getValidValues())), __LINE__);
        }
        $this->PrimaryAddressType = $primaryAddressType;
        return $this;
    }
    /**
     * Get HomeAddress1 value
     * @return string|null
     */
    public function getHomeAddress1()
    {
        return $this->HomeAddress1;
    }
    /**
     * Set HomeAddress1 value
     * @param string $homeAddress1
     * @return \StructType\Contact
     */
    public function setHomeAddress1($homeAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($homeAddress1) && !is_string($homeAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeAddress1, true), gettype($homeAddress1)), __LINE__);
        }
        $this->HomeAddress1 = $homeAddress1;
        return $this;
    }
    /**
     * Get HomeAddress2 value
     * @return string|null
     */
    public function getHomeAddress2()
    {
        return $this->HomeAddress2;
    }
    /**
     * Set HomeAddress2 value
     * @param string $homeAddress2
     * @return \StructType\Contact
     */
    public function setHomeAddress2($homeAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($homeAddress2) && !is_string($homeAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeAddress2, true), gettype($homeAddress2)), __LINE__);
        }
        $this->HomeAddress2 = $homeAddress2;
        return $this;
    }
    /**
     * Get HomeAddress3 value
     * @return string|null
     */
    public function getHomeAddress3()
    {
        return $this->HomeAddress3;
    }
    /**
     * Set HomeAddress3 value
     * @param string $homeAddress3
     * @return \StructType\Contact
     */
    public function setHomeAddress3($homeAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($homeAddress3) && !is_string($homeAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeAddress3, true), gettype($homeAddress3)), __LINE__);
        }
        $this->HomeAddress3 = $homeAddress3;
        return $this;
    }
    /**
     * Get HomeCity value
     * @return string|null
     */
    public function getHomeCity()
    {
        return $this->HomeCity;
    }
    /**
     * Set HomeCity value
     * @param string $homeCity
     * @return \StructType\Contact
     */
    public function setHomeCity($homeCity = null)
    {
        // validation for constraint: string
        if (!is_null($homeCity) && !is_string($homeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCity, true), gettype($homeCity)), __LINE__);
        }
        $this->HomeCity = $homeCity;
        return $this;
    }
    /**
     * Get HomeState value
     * @return string|null
     */
    public function getHomeState()
    {
        return $this->HomeState;
    }
    /**
     * Set HomeState value
     * @param string $homeState
     * @return \StructType\Contact
     */
    public function setHomeState($homeState = null)
    {
        // validation for constraint: string
        if (!is_null($homeState) && !is_string($homeState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeState, true), gettype($homeState)), __LINE__);
        }
        $this->HomeState = $homeState;
        return $this;
    }
    /**
     * Get HomeStateCode value
     * @return string|null
     */
    public function getHomeStateCode()
    {
        return $this->HomeStateCode;
    }
    /**
     * Set HomeStateCode value
     * @param string $homeStateCode
     * @return \StructType\Contact
     */
    public function setHomeStateCode($homeStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($homeStateCode) && !is_string($homeStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeStateCode, true), gettype($homeStateCode)), __LINE__);
        }
        $this->HomeStateCode = $homeStateCode;
        return $this;
    }
    /**
     * Get HomePostalCode value
     * @return string|null
     */
    public function getHomePostalCode()
    {
        return $this->HomePostalCode;
    }
    /**
     * Set HomePostalCode value
     * @param string $homePostalCode
     * @return \StructType\Contact
     */
    public function setHomePostalCode($homePostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($homePostalCode) && !is_string($homePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePostalCode, true), gettype($homePostalCode)), __LINE__);
        }
        $this->HomePostalCode = $homePostalCode;
        return $this;
    }
    /**
     * Get HomeCountry value
     * @return string|null
     */
    public function getHomeCountry()
    {
        return $this->HomeCountry;
    }
    /**
     * Set HomeCountry value
     * @param string $homeCountry
     * @return \StructType\Contact
     */
    public function setHomeCountry($homeCountry = null)
    {
        // validation for constraint: string
        if (!is_null($homeCountry) && !is_string($homeCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCountry, true), gettype($homeCountry)), __LINE__);
        }
        $this->HomeCountry = $homeCountry;
        return $this;
    }
    /**
     * Get HomeCountryCode value
     * @return string|null
     */
    public function getHomeCountryCode()
    {
        return $this->HomeCountryCode;
    }
    /**
     * Set HomeCountryCode value
     * @param string $homeCountryCode
     * @return \StructType\Contact
     */
    public function setHomeCountryCode($homeCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($homeCountryCode) && !is_string($homeCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCountryCode, true), gettype($homeCountryCode)), __LINE__);
        }
        $this->HomeCountryCode = $homeCountryCode;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \StructType\Contact
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get HomeFax value
     * @return string|null
     */
    public function getHomeFax()
    {
        return $this->HomeFax;
    }
    /**
     * Set HomeFax value
     * @param string $homeFax
     * @return \StructType\Contact
     */
    public function setHomeFax($homeFax = null)
    {
        // validation for constraint: string
        if (!is_null($homeFax) && !is_string($homeFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeFax, true), gettype($homeFax)), __LINE__);
        }
        $this->HomeFax = $homeFax;
        return $this;
    }
    /**
     * Get WorkAddress1 value
     * @return string|null
     */
    public function getWorkAddress1()
    {
        return $this->WorkAddress1;
    }
    /**
     * Set WorkAddress1 value
     * @param string $workAddress1
     * @return \StructType\Contact
     */
    public function setWorkAddress1($workAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($workAddress1) && !is_string($workAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workAddress1, true), gettype($workAddress1)), __LINE__);
        }
        $this->WorkAddress1 = $workAddress1;
        return $this;
    }
    /**
     * Get WorkAddress2 value
     * @return string|null
     */
    public function getWorkAddress2()
    {
        return $this->WorkAddress2;
    }
    /**
     * Set WorkAddress2 value
     * @param string $workAddress2
     * @return \StructType\Contact
     */
    public function setWorkAddress2($workAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($workAddress2) && !is_string($workAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workAddress2, true), gettype($workAddress2)), __LINE__);
        }
        $this->WorkAddress2 = $workAddress2;
        return $this;
    }
    /**
     * Get WorkAddress3 value
     * @return string|null
     */
    public function getWorkAddress3()
    {
        return $this->WorkAddress3;
    }
    /**
     * Set WorkAddress3 value
     * @param string $workAddress3
     * @return \StructType\Contact
     */
    public function setWorkAddress3($workAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($workAddress3) && !is_string($workAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workAddress3, true), gettype($workAddress3)), __LINE__);
        }
        $this->WorkAddress3 = $workAddress3;
        return $this;
    }
    /**
     * Get WorkCity value
     * @return string|null
     */
    public function getWorkCity()
    {
        return $this->WorkCity;
    }
    /**
     * Set WorkCity value
     * @param string $workCity
     * @return \StructType\Contact
     */
    public function setWorkCity($workCity = null)
    {
        // validation for constraint: string
        if (!is_null($workCity) && !is_string($workCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workCity, true), gettype($workCity)), __LINE__);
        }
        $this->WorkCity = $workCity;
        return $this;
    }
    /**
     * Get WorkState value
     * @return string|null
     */
    public function getWorkState()
    {
        return $this->WorkState;
    }
    /**
     * Set WorkState value
     * @param string $workState
     * @return \StructType\Contact
     */
    public function setWorkState($workState = null)
    {
        // validation for constraint: string
        if (!is_null($workState) && !is_string($workState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workState, true), gettype($workState)), __LINE__);
        }
        $this->WorkState = $workState;
        return $this;
    }
    /**
     * Get WorkStateCode value
     * @return string|null
     */
    public function getWorkStateCode()
    {
        return $this->WorkStateCode;
    }
    /**
     * Set WorkStateCode value
     * @param string $workStateCode
     * @return \StructType\Contact
     */
    public function setWorkStateCode($workStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($workStateCode) && !is_string($workStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workStateCode, true), gettype($workStateCode)), __LINE__);
        }
        $this->WorkStateCode = $workStateCode;
        return $this;
    }
    /**
     * Get WorkPostalCode value
     * @return string|null
     */
    public function getWorkPostalCode()
    {
        return $this->WorkPostalCode;
    }
    /**
     * Set WorkPostalCode value
     * @param string $workPostalCode
     * @return \StructType\Contact
     */
    public function setWorkPostalCode($workPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($workPostalCode) && !is_string($workPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPostalCode, true), gettype($workPostalCode)), __LINE__);
        }
        $this->WorkPostalCode = $workPostalCode;
        return $this;
    }
    /**
     * Get WorkCountry value
     * @return string|null
     */
    public function getWorkCountry()
    {
        return $this->WorkCountry;
    }
    /**
     * Set WorkCountry value
     * @param string $workCountry
     * @return \StructType\Contact
     */
    public function setWorkCountry($workCountry = null)
    {
        // validation for constraint: string
        if (!is_null($workCountry) && !is_string($workCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workCountry, true), gettype($workCountry)), __LINE__);
        }
        $this->WorkCountry = $workCountry;
        return $this;
    }
    /**
     * Get WorkCountryCode value
     * @return string|null
     */
    public function getWorkCountryCode()
    {
        return $this->WorkCountryCode;
    }
    /**
     * Set WorkCountryCode value
     * @param string $workCountryCode
     * @return \StructType\Contact
     */
    public function setWorkCountryCode($workCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($workCountryCode) && !is_string($workCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workCountryCode, true), gettype($workCountryCode)), __LINE__);
        }
        $this->WorkCountryCode = $workCountryCode;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \StructType\Contact
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get WorkFax value
     * @return string|null
     */
    public function getWorkFax()
    {
        return $this->WorkFax;
    }
    /**
     * Set WorkFax value
     * @param string $workFax
     * @return \StructType\Contact
     */
    public function setWorkFax($workFax = null)
    {
        // validation for constraint: string
        if (!is_null($workFax) && !is_string($workFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workFax, true), gettype($workFax)), __LINE__);
        }
        $this->WorkFax = $workFax;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\Contact
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get Pager value
     * @return string|null
     */
    public function getPager()
    {
        return $this->Pager;
    }
    /**
     * Set Pager value
     * @param string $pager
     * @return \StructType\Contact
     */
    public function setPager($pager = null)
    {
        // validation for constraint: string
        if (!is_null($pager) && !is_string($pager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pager, true), gettype($pager)), __LINE__);
        }
        $this->Pager = $pager;
        return $this;
    }
    /**
     * Get SMTPCode value
     * @return string|null
     */
    public function getSMTPCode()
    {
        return $this->SMTPCode;
    }
    /**
     * Set SMTPCode value
     * @param string $sMTPCode
     * @return \StructType\Contact
     */
    public function setSMTPCode($sMTPCode = null)
    {
        // validation for constraint: string
        if (!is_null($sMTPCode) && !is_string($sMTPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sMTPCode, true), gettype($sMTPCode)), __LINE__);
        }
        $this->SMTPCode = $sMTPCode;
        return $this;
    }
    /**
     * Get MembershipCode value
     * @return string|null
     */
    public function getMembershipCode()
    {
        return $this->MembershipCode;
    }
    /**
     * Set MembershipCode value
     * @param string $membershipCode
     * @return \StructType\Contact
     */
    public function setMembershipCode($membershipCode = null)
    {
        // validation for constraint: string
        if (!is_null($membershipCode) && !is_string($membershipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipCode, true), gettype($membershipCode)), __LINE__);
        }
        $this->MembershipCode = $membershipCode;
        return $this;
    }
    /**
     * Get JoinDate value
     * @return string|null
     */
    public function getJoinDate()
    {
        return $this->JoinDate;
    }
    /**
     * Set JoinDate value
     * @param string $joinDate
     * @return \StructType\Contact
     */
    public function setJoinDate($joinDate = null)
    {
        // validation for constraint: string
        if (!is_null($joinDate) && !is_string($joinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($joinDate, true), gettype($joinDate)), __LINE__);
        }
        $this->JoinDate = $joinDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Contact
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get LastRenewalDate value
     * @return string|null
     */
    public function getLastRenewalDate()
    {
        return $this->LastRenewalDate;
    }
    /**
     * Set LastRenewalDate value
     * @param string $lastRenewalDate
     * @return \StructType\Contact
     */
    public function setLastRenewalDate($lastRenewalDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastRenewalDate) && !is_string($lastRenewalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRenewalDate, true), gettype($lastRenewalDate)), __LINE__);
        }
        $this->LastRenewalDate = $lastRenewalDate;
        return $this;
    }
    /**
     * Get FacebookURL value
     * @return string|null
     */
    public function getFacebookURL()
    {
        return $this->FacebookURL;
    }
    /**
     * Set FacebookURL value
     * @param string $facebookURL
     * @return \StructType\Contact
     */
    public function setFacebookURL($facebookURL = null)
    {
        // validation for constraint: string
        if (!is_null($facebookURL) && !is_string($facebookURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facebookURL, true), gettype($facebookURL)), __LINE__);
        }
        $this->FacebookURL = $facebookURL;
        return $this;
    }
    /**
     * Get TwitterURL value
     * @return string|null
     */
    public function getTwitterURL()
    {
        return $this->TwitterURL;
    }
    /**
     * Set TwitterURL value
     * @param string $twitterURL
     * @return \StructType\Contact
     */
    public function setTwitterURL($twitterURL = null)
    {
        // validation for constraint: string
        if (!is_null($twitterURL) && !is_string($twitterURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($twitterURL, true), gettype($twitterURL)), __LINE__);
        }
        $this->TwitterURL = $twitterURL;
        return $this;
    }
    /**
     * Get LinkedInURL value
     * @return string|null
     */
    public function getLinkedInURL()
    {
        return $this->LinkedInURL;
    }
    /**
     * Set LinkedInURL value
     * @param string $linkedInURL
     * @return \StructType\Contact
     */
    public function setLinkedInURL($linkedInURL = null)
    {
        // validation for constraint: string
        if (!is_null($linkedInURL) && !is_string($linkedInURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedInURL, true), gettype($linkedInURL)), __LINE__);
        }
        $this->LinkedInURL = $linkedInURL;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\Contact
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Contact
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get SocialSecurityNumber value
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->SocialSecurityNumber;
    }
    /**
     * Set SocialSecurityNumber value
     * @param string $socialSecurityNumber
     * @return \StructType\Contact
     */
    public function setSocialSecurityNumber($socialSecurityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($socialSecurityNumber) && !is_string($socialSecurityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialSecurityNumber, true), gettype($socialSecurityNumber)), __LINE__);
        }
        $this->SocialSecurityNumber = $socialSecurityNumber;
        return $this;
    }
    /**
     * Get NationalIdentificationNumber value
     * @return string|null
     */
    public function getNationalIdentificationNumber()
    {
        return $this->NationalIdentificationNumber;
    }
    /**
     * Set NationalIdentificationNumber value
     * @param string $nationalIdentificationNumber
     * @return \StructType\Contact
     */
    public function setNationalIdentificationNumber($nationalIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIdentificationNumber) && !is_string($nationalIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalIdentificationNumber, true), gettype($nationalIdentificationNumber)), __LINE__);
        }
        $this->NationalIdentificationNumber = $nationalIdentificationNumber;
        return $this;
    }
    /**
     * Get PassportNumber value
     * @return string|null
     */
    public function getPassportNumber()
    {
        return $this->PassportNumber;
    }
    /**
     * Set PassportNumber value
     * @param string $passportNumber
     * @return \StructType\Contact
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportNumber, true), gettype($passportNumber)), __LINE__);
        }
        $this->PassportNumber = $passportNumber;
        return $this;
    }
    /**
     * Get PassportCountry value
     * @return string|null
     */
    public function getPassportCountry()
    {
        return $this->PassportCountry;
    }
    /**
     * Set PassportCountry value
     * @param string $passportCountry
     * @return \StructType\Contact
     */
    public function setPassportCountry($passportCountry = null)
    {
        // validation for constraint: string
        if (!is_null($passportCountry) && !is_string($passportCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportCountry, true), gettype($passportCountry)), __LINE__);
        }
        $this->PassportCountry = $passportCountry;
        return $this;
    }
    /**
     * Get PassportCountryCode value
     * @return string|null
     */
    public function getPassportCountryCode()
    {
        return $this->PassportCountryCode;
    }
    /**
     * Set PassportCountryCode value
     * @param string $passportCountryCode
     * @return \StructType\Contact
     */
    public function setPassportCountryCode($passportCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($passportCountryCode) && !is_string($passportCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportCountryCode, true), gettype($passportCountryCode)), __LINE__);
        }
        $this->PassportCountryCode = $passportCountryCode;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return \StructType\Contact
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get ParentContactId value
     * @return string|null
     */
    public function getParentContactId()
    {
        return $this->ParentContactId;
    }
    /**
     * Set ParentContactId value
     * @param string $parentContactId
     * @return \StructType\Contact
     */
    public function setParentContactId($parentContactId = null)
    {
        // validation for constraint: string
        if (!is_null($parentContactId) && !is_string($parentContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentContactId, true), gettype($parentContactId)), __LINE__);
        }
        $this->ParentContactId = $parentContactId;
        return $this;
    }
    /**
     * Get OptedIn value
     * @return bool|null
     */
    public function getOptedIn()
    {
        return $this->OptedIn;
    }
    /**
     * Set OptedIn value
     * @param bool $optedIn
     * @return \StructType\Contact
     */
    public function setOptedIn($optedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($optedIn) && !is_bool($optedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optedIn, true), gettype($optedIn)), __LINE__);
        }
        $this->OptedIn = $optedIn;
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \StructType\Contact
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageURL, true), gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get IsCreatedViaTestReg value
     * @return bool|null
     */
    public function getIsCreatedViaTestReg()
    {
        return $this->IsCreatedViaTestReg;
    }
    /**
     * Set IsCreatedViaTestReg value
     * @param bool $isCreatedViaTestReg
     * @return \StructType\Contact
     */
    public function setIsCreatedViaTestReg($isCreatedViaTestReg = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreatedViaTestReg) && !is_bool($isCreatedViaTestReg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCreatedViaTestReg, true), gettype($isCreatedViaTestReg)), __LINE__);
        }
        $this->IsCreatedViaTestReg = $isCreatedViaTestReg;
        return $this;
    }
    /**
     * Get IsObfuscated value
     * @return bool|null
     */
    public function getIsObfuscated()
    {
        return $this->IsObfuscated;
    }
    /**
     * Set IsObfuscated value
     * @param bool $isObfuscated
     * @return \StructType\Contact
     */
    public function setIsObfuscated($isObfuscated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObfuscated) && !is_bool($isObfuscated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObfuscated, true), gettype($isObfuscated)), __LINE__);
        }
        $this->IsObfuscated = $isObfuscated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
