<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientDefinedDetail StructType
 * @subpackage Structs
 */
class ClientDefinedDetail extends AbstractStructBase
{
    /**
     * The FieldName
     * @var string
     */
    public $FieldName;
    /**
     * The FieldType
     * @var string
     */
    public $FieldType;
    /**
     * The FieldValueDetail
     * @var string
     */
    public $FieldValueDetail;
    /**
     * Constructor method for ClientDefinedDetail
     * @uses ClientDefinedDetail::setFieldName()
     * @uses ClientDefinedDetail::setFieldType()
     * @uses ClientDefinedDetail::setFieldValueDetail()
     * @param string $fieldName
     * @param string $fieldType
     * @param string $fieldValueDetail
     */
    public function __construct($fieldName = null, $fieldType = null, $fieldValueDetail = null)
    {
        $this
            ->setFieldName($fieldName)
            ->setFieldType($fieldType)
            ->setFieldValueDetail($fieldValueDetail);
    }
    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @param string $fieldName
     * @return \StructType\ClientDefinedDetail
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Get FieldType value
     * @return string|null
     */
    public function getFieldType()
    {
        return $this->FieldType;
    }
    /**
     * Set FieldType value
     * @param string $fieldType
     * @return \StructType\ClientDefinedDetail
     */
    public function setFieldType($fieldType = null)
    {
        // validation for constraint: string
        if (!is_null($fieldType) && !is_string($fieldType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldType, true), gettype($fieldType)), __LINE__);
        }
        $this->FieldType = $fieldType;
        return $this;
    }
    /**
     * Get FieldValueDetail value
     * @return string|null
     */
    public function getFieldValueDetail()
    {
        return $this->FieldValueDetail;
    }
    /**
     * Set FieldValueDetail value
     * @param string $fieldValueDetail
     * @return \StructType\ClientDefinedDetail
     */
    public function setFieldValueDetail($fieldValueDetail = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValueDetail) && !is_string($fieldValueDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldValueDetail, true), gettype($fieldValueDetail)), __LINE__);
        }
        $this->FieldValueDetail = $fieldValueDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientDefinedDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
