<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckIn StructType
 * @subpackage Structs
 */
class CheckIn extends AbstractStructBase
{
    /**
     * The AttendeeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AttendeeType;
    /**
     * The UndoCheckIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UndoCheckIn;
    /**
     * The SendPlannerAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendPlannerAlert;
    /**
     * The CvObjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCvObject
     */
    public $CvObjects;
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductId;
    /**
     * Constructor method for CheckIn
     * @uses CheckIn::setAttendeeType()
     * @uses CheckIn::setUndoCheckIn()
     * @uses CheckIn::setSendPlannerAlert()
     * @uses CheckIn::setCvObjects()
     * @uses CheckIn::setProductId()
     * @param string $attendeeType
     * @param bool $undoCheckIn
     * @param bool $sendPlannerAlert
     * @param \ArrayType\ArrayOfCvObject $cvObjects
     * @param string $productId
     */
    public function __construct($attendeeType = null, $undoCheckIn = null, $sendPlannerAlert = null, \ArrayType\ArrayOfCvObject $cvObjects = null, $productId = null)
    {
        $this
            ->setAttendeeType($attendeeType)
            ->setUndoCheckIn($undoCheckIn)
            ->setSendPlannerAlert($sendPlannerAlert)
            ->setCvObjects($cvObjects)
            ->setProductId($productId);
    }
    /**
     * Get AttendeeType value
     * @return string
     */
    public function getAttendeeType()
    {
        return $this->AttendeeType;
    }
    /**
     * Set AttendeeType value
     * @uses \EnumType\AttendeeType::valueIsValid()
     * @uses \EnumType\AttendeeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attendeeType
     * @return \StructType\CheckIn
     */
    public function setAttendeeType($attendeeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AttendeeType::valueIsValid($attendeeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AttendeeType', is_array($attendeeType) ? implode(', ', $attendeeType) : var_export($attendeeType, true), implode(', ', \EnumType\AttendeeType::getValidValues())), __LINE__);
        }
        $this->AttendeeType = $attendeeType;
        return $this;
    }
    /**
     * Get UndoCheckIn value
     * @return bool
     */
    public function getUndoCheckIn()
    {
        return $this->UndoCheckIn;
    }
    /**
     * Set UndoCheckIn value
     * @param bool $undoCheckIn
     * @return \StructType\CheckIn
     */
    public function setUndoCheckIn($undoCheckIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($undoCheckIn) && !is_bool($undoCheckIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($undoCheckIn, true), gettype($undoCheckIn)), __LINE__);
        }
        $this->UndoCheckIn = $undoCheckIn;
        return $this;
    }
    /**
     * Get SendPlannerAlert value
     * @return bool
     */
    public function getSendPlannerAlert()
    {
        return $this->SendPlannerAlert;
    }
    /**
     * Set SendPlannerAlert value
     * @param bool $sendPlannerAlert
     * @return \StructType\CheckIn
     */
    public function setSendPlannerAlert($sendPlannerAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendPlannerAlert) && !is_bool($sendPlannerAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendPlannerAlert, true), gettype($sendPlannerAlert)), __LINE__);
        }
        $this->SendPlannerAlert = $sendPlannerAlert;
        return $this;
    }
    /**
     * Get CvObjects value
     * @return \ArrayType\ArrayOfCvObject|null
     */
    public function getCvObjects()
    {
        return $this->CvObjects;
    }
    /**
     * Set CvObjects value
     * @param \ArrayType\ArrayOfCvObject $cvObjects
     * @return \StructType\CheckIn
     */
    public function setCvObjects(\ArrayType\ArrayOfCvObject $cvObjects = null)
    {
        $this->CvObjects = $cvObjects;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\CheckIn
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckIn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
