<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryDetail StructType
 * @subpackage Structs
 */
class CategoryDetail extends AbstractStructBase
{
    /**
     * The AmountDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AmountDetail[]
     */
    public $AmountDetail;
    /**
     * The CategoryName
     * @var string
     */
    public $CategoryName;
    /**
     * The HighLevelEstimate
     * @var float
     */
    public $HighLevelEstimate;
    /**
     * Constructor method for CategoryDetail
     * @uses CategoryDetail::setAmountDetail()
     * @uses CategoryDetail::setCategoryName()
     * @uses CategoryDetail::setHighLevelEstimate()
     * @param \StructType\AmountDetail[] $amountDetail
     * @param string $categoryName
     * @param float $highLevelEstimate
     */
    public function __construct(array $amountDetail = array(), $categoryName = null, $highLevelEstimate = null)
    {
        $this
            ->setAmountDetail($amountDetail)
            ->setCategoryName($categoryName)
            ->setHighLevelEstimate($highLevelEstimate);
    }
    /**
     * Get AmountDetail value
     * @return \StructType\AmountDetail[]|null
     */
    public function getAmountDetail()
    {
        return $this->AmountDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAmountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmountDetailForArrayConstraintsFromSetAmountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryDetailAmountDetailItem) {
            // validation for constraint: itemType
            if (!$categoryDetailAmountDetailItem instanceof \StructType\AmountDetail) {
                $invalidValues[] = is_object($categoryDetailAmountDetailItem) ? get_class($categoryDetailAmountDetailItem) : sprintf('%s(%s)', gettype($categoryDetailAmountDetailItem), var_export($categoryDetailAmountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AmountDetail property can only contain items of type \StructType\AmountDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AmountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountDetail[] $amountDetail
     * @return \StructType\CategoryDetail
     */
    public function setAmountDetail(array $amountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($amountDetailArrayErrorMessage = self::validateAmountDetailForArrayConstraintsFromSetAmountDetail($amountDetail))) {
            throw new \InvalidArgumentException($amountDetailArrayErrorMessage, __LINE__);
        }
        $this->AmountDetail = $amountDetail;
        return $this;
    }
    /**
     * Add item to AmountDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountDetail $item
     * @return \StructType\CategoryDetail
     */
    public function addToAmountDetail(\StructType\AmountDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmountDetail) {
            throw new \InvalidArgumentException(sprintf('The AmountDetail property can only contain items of type \StructType\AmountDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AmountDetail[] = $item;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\CategoryDetail
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get HighLevelEstimate value
     * @return float|null
     */
    public function getHighLevelEstimate()
    {
        return $this->HighLevelEstimate;
    }
    /**
     * Set HighLevelEstimate value
     * @param float $highLevelEstimate
     * @return \StructType\CategoryDetail
     */
    public function setHighLevelEstimate($highLevelEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($highLevelEstimate) && !(is_float($highLevelEstimate) || is_numeric($highLevelEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($highLevelEstimate, true), gettype($highLevelEstimate)), __LINE__);
        }
        $this->HighLevelEstimate = $highLevelEstimate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
