<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarRequest StructType
 * @subpackage Structs
 */
class CarRequest extends AbstractStructBase
{
    /**
     * The TravelSurveyDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelSurveyDetail[]
     */
    public $TravelSurveyDetail;
    /**
     * The RequestId
     * @var string
     */
    public $RequestId;
    /**
     * The RequesterId
     * @var string
     */
    public $RequesterId;
    /**
     * The RequesterType
     * @var string
     */
    public $RequesterType;
    /**
     * The RequesterFirstName
     * @var string
     */
    public $RequesterFirstName;
    /**
     * The RequesterLastName
     * @var string
     */
    public $RequesterLastName;
    /**
     * The PickUpDate
     * @var string
     */
    public $PickUpDate;
    /**
     * The PickUpTime
     * @var string
     */
    public $PickUpTime;
    /**
     * The DropOffDate
     * @var string
     */
    public $DropOffDate;
    /**
     * The DropOffTime
     * @var string
     */
    public $DropOffTime;
    /**
     * The RentalCarType
     * @var string
     */
    public $RentalCarType;
    /**
     * The RentalCarCompany
     * @var string
     */
    public $RentalCarCompany;
    /**
     * The RewardsCode
     * @var string
     */
    public $RewardsCode;
    /**
     * The Cancelled
     * @var bool
     */
    public $Cancelled;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ConfirmationNumber
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The LastModifiedBy
     * @var string
     */
    public $LastModifiedBy;
    /**
     * The CarLastModifiedDate
     * @var string
     */
    public $CarLastModifiedDate;
    /**
     * Constructor method for CarRequest
     * @uses CarRequest::setTravelSurveyDetail()
     * @uses CarRequest::setRequestId()
     * @uses CarRequest::setRequesterId()
     * @uses CarRequest::setRequesterType()
     * @uses CarRequest::setRequesterFirstName()
     * @uses CarRequest::setRequesterLastName()
     * @uses CarRequest::setPickUpDate()
     * @uses CarRequest::setPickUpTime()
     * @uses CarRequest::setDropOffDate()
     * @uses CarRequest::setDropOffTime()
     * @uses CarRequest::setRentalCarType()
     * @uses CarRequest::setRentalCarCompany()
     * @uses CarRequest::setRewardsCode()
     * @uses CarRequest::setCancelled()
     * @uses CarRequest::setStatus()
     * @uses CarRequest::setConfirmationNumber()
     * @uses CarRequest::setLastModifiedBy()
     * @uses CarRequest::setCarLastModifiedDate()
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @param string $requestId
     * @param string $requesterId
     * @param string $requesterType
     * @param string $requesterFirstName
     * @param string $requesterLastName
     * @param string $pickUpDate
     * @param string $pickUpTime
     * @param string $dropOffDate
     * @param string $dropOffTime
     * @param string $rentalCarType
     * @param string $rentalCarCompany
     * @param string $rewardsCode
     * @param bool $cancelled
     * @param string $status
     * @param string $confirmationNumber
     * @param string $lastModifiedBy
     * @param string $carLastModifiedDate
     */
    public function __construct(array $travelSurveyDetail = array(), $requestId = null, $requesterId = null, $requesterType = null, $requesterFirstName = null, $requesterLastName = null, $pickUpDate = null, $pickUpTime = null, $dropOffDate = null, $dropOffTime = null, $rentalCarType = null, $rentalCarCompany = null, $rewardsCode = null, $cancelled = null, $status = null, $confirmationNumber = null, $lastModifiedBy = null, $carLastModifiedDate = null)
    {
        $this
            ->setTravelSurveyDetail($travelSurveyDetail)
            ->setRequestId($requestId)
            ->setRequesterId($requesterId)
            ->setRequesterType($requesterType)
            ->setRequesterFirstName($requesterFirstName)
            ->setRequesterLastName($requesterLastName)
            ->setPickUpDate($pickUpDate)
            ->setPickUpTime($pickUpTime)
            ->setDropOffDate($dropOffDate)
            ->setDropOffTime($dropOffTime)
            ->setRentalCarType($rentalCarType)
            ->setRentalCarCompany($rentalCarCompany)
            ->setRewardsCode($rewardsCode)
            ->setCancelled($cancelled)
            ->setStatus($status)
            ->setConfirmationNumber($confirmationNumber)
            ->setLastModifiedBy($lastModifiedBy)
            ->setCarLastModifiedDate($carLastModifiedDate);
    }
    /**
     * Get TravelSurveyDetail value
     * @return \StructType\TravelSurveyDetail[]|null
     */
    public function getTravelSurveyDetail()
    {
        return $this->TravelSurveyDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelSurveyDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelSurveyDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carRequestTravelSurveyDetailItem) {
            // validation for constraint: itemType
            if (!$carRequestTravelSurveyDetailItem instanceof \StructType\TravelSurveyDetail) {
                $invalidValues[] = is_object($carRequestTravelSurveyDetailItem) ? get_class($carRequestTravelSurveyDetailItem) : sprintf('%s(%s)', gettype($carRequestTravelSurveyDetailItem), var_export($carRequestTravelSurveyDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail[] $travelSurveyDetail
     * @return \StructType\CarRequest
     */
    public function setTravelSurveyDetail(array $travelSurveyDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($travelSurveyDetailArrayErrorMessage = self::validateTravelSurveyDetailForArrayConstraintsFromSetTravelSurveyDetail($travelSurveyDetail))) {
            throw new \InvalidArgumentException($travelSurveyDetailArrayErrorMessage, __LINE__);
        }
        $this->TravelSurveyDetail = $travelSurveyDetail;
        return $this;
    }
    /**
     * Add item to TravelSurveyDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelSurveyDetail $item
     * @return \StructType\CarRequest
     */
    public function addToTravelSurveyDetail(\StructType\TravelSurveyDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelSurveyDetail) {
            throw new \InvalidArgumentException(sprintf('The TravelSurveyDetail property can only contain items of type \StructType\TravelSurveyDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelSurveyDetail[] = $item;
        return $this;
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\CarRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get RequesterId value
     * @return string|null
     */
    public function getRequesterId()
    {
        return $this->RequesterId;
    }
    /**
     * Set RequesterId value
     * @param string $requesterId
     * @return \StructType\CarRequest
     */
    public function setRequesterId($requesterId = null)
    {
        // validation for constraint: string
        if (!is_null($requesterId) && !is_string($requesterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterId, true), gettype($requesterId)), __LINE__);
        }
        $this->RequesterId = $requesterId;
        return $this;
    }
    /**
     * Get RequesterType value
     * @return string|null
     */
    public function getRequesterType()
    {
        return $this->RequesterType;
    }
    /**
     * Set RequesterType value
     * @param string $requesterType
     * @return \StructType\CarRequest
     */
    public function setRequesterType($requesterType = null)
    {
        // validation for constraint: string
        if (!is_null($requesterType) && !is_string($requesterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterType, true), gettype($requesterType)), __LINE__);
        }
        $this->RequesterType = $requesterType;
        return $this;
    }
    /**
     * Get RequesterFirstName value
     * @return string|null
     */
    public function getRequesterFirstName()
    {
        return $this->RequesterFirstName;
    }
    /**
     * Set RequesterFirstName value
     * @param string $requesterFirstName
     * @return \StructType\CarRequest
     */
    public function setRequesterFirstName($requesterFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterFirstName) && !is_string($requesterFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterFirstName, true), gettype($requesterFirstName)), __LINE__);
        }
        $this->RequesterFirstName = $requesterFirstName;
        return $this;
    }
    /**
     * Get RequesterLastName value
     * @return string|null
     */
    public function getRequesterLastName()
    {
        return $this->RequesterLastName;
    }
    /**
     * Set RequesterLastName value
     * @param string $requesterLastName
     * @return \StructType\CarRequest
     */
    public function setRequesterLastName($requesterLastName = null)
    {
        // validation for constraint: string
        if (!is_null($requesterLastName) && !is_string($requesterLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterLastName, true), gettype($requesterLastName)), __LINE__);
        }
        $this->RequesterLastName = $requesterLastName;
        return $this;
    }
    /**
     * Get PickUpDate value
     * @return string|null
     */
    public function getPickUpDate()
    {
        return $this->PickUpDate;
    }
    /**
     * Set PickUpDate value
     * @param string $pickUpDate
     * @return \StructType\CarRequest
     */
    public function setPickUpDate($pickUpDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDate) && !is_string($pickUpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDate, true), gettype($pickUpDate)), __LINE__);
        }
        $this->PickUpDate = $pickUpDate;
        return $this;
    }
    /**
     * Get PickUpTime value
     * @return string|null
     */
    public function getPickUpTime()
    {
        return $this->PickUpTime;
    }
    /**
     * Set PickUpTime value
     * @param string $pickUpTime
     * @return \StructType\CarRequest
     */
    public function setPickUpTime($pickUpTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpTime) && !is_string($pickUpTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpTime, true), gettype($pickUpTime)), __LINE__);
        }
        $this->PickUpTime = $pickUpTime;
        return $this;
    }
    /**
     * Get DropOffDate value
     * @return string|null
     */
    public function getDropOffDate()
    {
        return $this->DropOffDate;
    }
    /**
     * Set DropOffDate value
     * @param string $dropOffDate
     * @return \StructType\CarRequest
     */
    public function setDropOffDate($dropOffDate = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffDate) && !is_string($dropOffDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffDate, true), gettype($dropOffDate)), __LINE__);
        }
        $this->DropOffDate = $dropOffDate;
        return $this;
    }
    /**
     * Get DropOffTime value
     * @return string|null
     */
    public function getDropOffTime()
    {
        return $this->DropOffTime;
    }
    /**
     * Set DropOffTime value
     * @param string $dropOffTime
     * @return \StructType\CarRequest
     */
    public function setDropOffTime($dropOffTime = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffTime) && !is_string($dropOffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffTime, true), gettype($dropOffTime)), __LINE__);
        }
        $this->DropOffTime = $dropOffTime;
        return $this;
    }
    /**
     * Get RentalCarType value
     * @return string|null
     */
    public function getRentalCarType()
    {
        return $this->RentalCarType;
    }
    /**
     * Set RentalCarType value
     * @param string $rentalCarType
     * @return \StructType\CarRequest
     */
    public function setRentalCarType($rentalCarType = null)
    {
        // validation for constraint: string
        if (!is_null($rentalCarType) && !is_string($rentalCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rentalCarType, true), gettype($rentalCarType)), __LINE__);
        }
        $this->RentalCarType = $rentalCarType;
        return $this;
    }
    /**
     * Get RentalCarCompany value
     * @return string|null
     */
    public function getRentalCarCompany()
    {
        return $this->RentalCarCompany;
    }
    /**
     * Set RentalCarCompany value
     * @param string $rentalCarCompany
     * @return \StructType\CarRequest
     */
    public function setRentalCarCompany($rentalCarCompany = null)
    {
        // validation for constraint: string
        if (!is_null($rentalCarCompany) && !is_string($rentalCarCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rentalCarCompany, true), gettype($rentalCarCompany)), __LINE__);
        }
        $this->RentalCarCompany = $rentalCarCompany;
        return $this;
    }
    /**
     * Get RewardsCode value
     * @return string|null
     */
    public function getRewardsCode()
    {
        return $this->RewardsCode;
    }
    /**
     * Set RewardsCode value
     * @param string $rewardsCode
     * @return \StructType\CarRequest
     */
    public function setRewardsCode($rewardsCode = null)
    {
        // validation for constraint: string
        if (!is_null($rewardsCode) && !is_string($rewardsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rewardsCode, true), gettype($rewardsCode)), __LINE__);
        }
        $this->RewardsCode = $rewardsCode;
        return $this;
    }
    /**
     * Get Cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->Cancelled;
    }
    /**
     * Set Cancelled value
     * @param bool $cancelled
     * @return \StructType\CarRequest
     */
    public function setCancelled($cancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelled) && !is_bool($cancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelled, true), gettype($cancelled)), __LINE__);
        }
        $this->Cancelled = $cancelled;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\CarRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\CarRequest
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->LastModifiedBy;
    }
    /**
     * Set LastModifiedBy value
     * @param string $lastModifiedBy
     * @return \StructType\CarRequest
     */
    public function setLastModifiedBy($lastModifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedBy) && !is_string($lastModifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedBy, true), gettype($lastModifiedBy)), __LINE__);
        }
        $this->LastModifiedBy = $lastModifiedBy;
        return $this;
    }
    /**
     * Get CarLastModifiedDate value
     * @return string|null
     */
    public function getCarLastModifiedDate()
    {
        return $this->CarLastModifiedDate;
    }
    /**
     * Set CarLastModifiedDate value
     * @param string $carLastModifiedDate
     * @return \StructType\CarRequest
     */
    public function setCarLastModifiedDate($carLastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($carLastModifiedDate) && !is_string($carLastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carLastModifiedDate, true), gettype($carLastModifiedDate)), __LINE__);
        }
        $this->CarLastModifiedDate = $carLastModifiedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
